/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.reactor.ssl;

import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLBuffer;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLBufferManagementStrategy;
import com.icbc.api.internal.apache.http.util.Args;
import java.nio.ByteBuffer;

public class ReleasableSSLBufferManagementStrategy
implements SSLBufferManagementStrategy {
    @Override
    public SSLBuffer constructBuffer(int n) {
        return new InternalBuffer(n);
    }

    private static final class InternalBuffer
    implements SSLBuffer {
        private ByteBuffer wrapped;
        private final int length;

        public InternalBuffer(int n) {
            Args.positive(n, "size");
            this.length = n;
        }

        @Override
        public ByteBuffer acquire() {
            if (this.wrapped != null) {
                return this.wrapped;
            }
            this.wrapped = ByteBuffer.allocate(this.length);
            return this.wrapped;
        }

        @Override
        public void release() {
            this.wrapped = null;
        }

        @Override
        public boolean isAcquired() {
            return this.wrapped != null;
        }

        @Override
        public boolean hasData() {
            return this.wrapped != null && this.wrapped.position() > 0;
        }
    }
}

