/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.reactor.ssl;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.SessionBufferStatus;
import com.icbc.api.internal.apache.http.nio.reactor.SocketAccessor;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.PermanentSSLBufferManagementStrategy;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLBuffer;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLBufferManagementStrategy;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLMode;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SSLIOSession
implements IOSession,
SessionBufferStatus,
SocketAccessor {
    public static final String SESSION_KEY = "http.session.ssl";
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final IOSession session;
    private final SSLEngine sslEngine;
    private final SSLBuffer inEncrypted;
    private final SSLBuffer outEncrypted;
    private final SSLBuffer inPlain;
    private final SSLBuffer outPlain;
    private final InternalByteChannel channel;
    private final SSLSetupHandler handler;
    private int appEventMask;
    private SessionBufferStatus appBufferStatus;
    private boolean endOfStream;
    private volatile SSLMode sslMode;
    private volatile int status;
    private volatile boolean initialized;

    public SSLIOSession(IOSession iOSession, SSLMode sSLMode, HttpHost httpHost, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler) {
        this(iOSession, sSLMode, httpHost, sSLContext, sSLSetupHandler, new PermanentSSLBufferManagementStrategy());
    }

    public SSLIOSession(IOSession iOSession, SSLMode sSLMode, HttpHost httpHost, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, SSLBufferManagementStrategy sSLBufferManagementStrategy) {
        Args.notNull(iOSession, "IO session");
        Args.notNull(sSLContext, "SSL context");
        Args.notNull(sSLBufferManagementStrategy, "Buffer management strategy");
        this.session = iOSession;
        this.sslMode = sSLMode;
        this.appEventMask = iOSession.getEventMask();
        this.channel = new InternalByteChannel();
        this.handler = sSLSetupHandler;
        this.session.setBufferStatus(this);
        this.sslEngine = this.sslMode == SSLMode.CLIENT && httpHost != null ? sSLContext.createSSLEngine(httpHost.getHostName(), httpHost.getPort()) : sSLContext.createSSLEngine();
        int n = this.sslEngine.getSession().getPacketBufferSize();
        this.inEncrypted = sSLBufferManagementStrategy.constructBuffer(n);
        this.outEncrypted = sSLBufferManagementStrategy.constructBuffer(n);
        int n2 = this.sslEngine.getSession().getApplicationBufferSize();
        this.inPlain = sSLBufferManagementStrategy.constructBuffer(n2);
        this.outPlain = sSLBufferManagementStrategy.constructBuffer(n2);
    }

    public SSLIOSession(IOSession iOSession, SSLMode sSLMode, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler) {
        this(iOSession, sSLMode, null, sSLContext, sSLSetupHandler);
    }

    protected SSLSetupHandler getSSLSetupHandler() {
        return this.handler;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Deprecated
    public synchronized void initialize(SSLMode sSLMode) throws SSLException {
        this.sslMode = sSLMode;
        this.initialize();
    }

    public synchronized void initialize() throws SSLException {
        Asserts.check(!this.initialized, "SSL I/O session already initialized");
        if (this.status >= 1) {
            return;
        }
        switch (this.sslMode) {
            case CLIENT: {
                this.sslEngine.setUseClientMode(true);
                break;
            }
            case SERVER: {
                this.sslEngine.setUseClientMode(false);
            }
        }
        if (this.handler != null) {
            this.handler.initalize(this.sslEngine);
        }
        this.initialized = true;
        this.sslEngine.beginHandshake();
        this.inEncrypted.release();
        this.outEncrypted.release();
        this.inPlain.release();
        this.outPlain.release();
        this.doHandshake();
    }

    public synchronized SSLSession getSSLSession() {
        return this.sslEngine.getSession();
    }

    private SSLException convert(RuntimeException runtimeException) {
        Throwable throwable = runtimeException.getCause();
        if (throwable == null) {
            throwable = runtimeException;
        }
        return new SSLException(throwable);
    }

    private SSLEngineResult doWrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            return this.sslEngine.wrap(byteBuffer, byteBuffer2);
        }
        catch (RuntimeException runtimeException) {
            throw this.convert(runtimeException);
        }
    }

    private SSLEngineResult doUnwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            return this.sslEngine.unwrap(byteBuffer, byteBuffer2);
        }
        catch (RuntimeException runtimeException) {
            throw this.convert(runtimeException);
        }
    }

    private void doRunTask() throws SSLException {
        try {
            Runnable runnable = this.sslEngine.getDelegatedTask();
            if (runnable != null) {
                runnable.run();
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.convert(runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandshake() throws SSLException {
        boolean bl = true;
        SSLEngineResult sSLEngineResult = null;
        while (bl) {
            switch (this.sslEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    ByteBuffer byteBuffer = this.outPlain.acquire();
                    ByteBuffer byteBuffer2 = this.outEncrypted.acquire();
                    byteBuffer.flip();
                    sSLEngineResult = this.doWrap(byteBuffer, byteBuffer2);
                    byteBuffer.compact();
                    if (byteBuffer.position() == 0) {
                        this.outPlain.release();
                        byteBuffer = null;
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) break;
                    bl = false;
                    break;
                }
                case NEED_UNWRAP: {
                    ByteBuffer byteBuffer = this.inEncrypted.acquire();
                    ByteBuffer byteBuffer3 = this.inPlain.acquire();
                    byteBuffer.flip();
                    sSLEngineResult = this.doUnwrap(byteBuffer, byteBuffer3);
                    byteBuffer.compact();
                    try {
                        if (!byteBuffer.hasRemaining() && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            throw new SSLException("Input buffer is full");
                        }
                    }
                    finally {
                        if (byteBuffer.position() == 0) {
                            this.inEncrypted.release();
                            byteBuffer = null;
                        }
                    }
                    if (this.status >= 1) {
                        this.inPlain.release();
                        byteBuffer3 = null;
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) break;
                    bl = false;
                    break;
                }
                case NEED_TASK: {
                    this.doRunTask();
                    break;
                }
                case NOT_HANDSHAKING: {
                    bl = false;
                    break;
                }
            }
        }
        if (sSLEngineResult != null && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.handler != null) {
            this.handler.verify(this.session, this.sslEngine.getSession());
        }
    }

    private void updateEventMask() {
        int n;
        if (this.status == 1 && this.sslEngine.isOutboundDone() && (this.endOfStream || this.sslEngine.isInboundDone())) {
            this.status = Integer.MAX_VALUE;
        }
        if (this.status == 0 && this.endOfStream && this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.status = Integer.MAX_VALUE;
        }
        if (this.status == Integer.MAX_VALUE) {
            this.session.close();
            return;
        }
        int n2 = n = this.session.getEventMask();
        switch (this.sslEngine.getHandshakeStatus()) {
            case NEED_WRAP: {
                n2 = 5;
                break;
            }
            case NEED_UNWRAP: {
                n2 = 1;
                break;
            }
            case NOT_HANDSHAKING: {
                n2 = this.appEventMask;
                break;
            }
            case NEED_TASK: {
                break;
            }
        }
        if (this.outEncrypted.hasData()) {
            n2 |= 4;
        }
        if (n != n2) {
            this.session.setEventMask(n2);
        }
    }

    private int sendEncryptedData() throws IOException {
        if (!this.outEncrypted.hasData()) {
            return this.session.channel().write(EMPTY_BUFFER);
        }
        ByteBuffer byteBuffer = this.outEncrypted.acquire();
        byteBuffer.flip();
        int n = this.session.channel().write(byteBuffer);
        byteBuffer.compact();
        if (byteBuffer.position() == 0) {
            this.outEncrypted.release();
        }
        return n;
    }

    private int receiveEncryptedData() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        ByteBuffer byteBuffer = this.inEncrypted.acquire();
        int n = this.session.channel().read(byteBuffer);
        if (byteBuffer.position() == 0) {
            this.inEncrypted.release();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decryptData() throws SSLException {
        boolean bl = false;
        while (this.inEncrypted.hasData()) {
            ByteBuffer byteBuffer = this.inEncrypted.acquire();
            ByteBuffer byteBuffer2 = this.inPlain.acquire();
            byteBuffer.flip();
            SSLEngineResult sSLEngineResult = this.doUnwrap(byteBuffer, byteBuffer2);
            byteBuffer.compact();
            try {
                if (!byteBuffer.hasRemaining() && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException("Input buffer is full");
                }
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) break;
                bl = true;
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && !this.endOfStream) continue;
                break;
            }
            finally {
                if (this.inEncrypted.acquire().position() != 0) continue;
                this.inEncrypted.release();
            }
        }
        return bl;
    }

    public synchronized boolean isAppInputReady() throws IOException {
        do {
            int n;
            if ((n = this.receiveEncryptedData()) == -1) {
                this.endOfStream = true;
            }
            this.doHandshake();
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) continue;
            this.decryptData();
        } while (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK);
        return (this.appEventMask & 1) > 0 && (this.inPlain.hasData() || this.appBufferStatus != null && this.appBufferStatus.hasBufferedInput() || this.endOfStream && this.status == 0);
    }

    public synchronized boolean isAppOutputReady() throws IOException {
        return (this.appEventMask & 4) > 0 && this.status == 0 && this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public synchronized void inboundTransport() throws IOException {
        this.updateEventMask();
    }

    public synchronized void outboundTransport() throws IOException {
        this.sendEncryptedData();
        this.doHandshake();
        this.updateEventMask();
    }

    public synchronized boolean isInboundDone() {
        return this.sslEngine.isInboundDone();
    }

    public synchronized boolean isOutboundDone() {
        return this.sslEngine.isOutboundDone();
    }

    private synchronized int writePlain(ByteBuffer byteBuffer) throws IOException {
        Object object;
        ByteBuffer byteBuffer2;
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.status != 0) {
            throw new ClosedChannelException();
        }
        if (this.outPlain.hasData()) {
            byteBuffer2 = this.outPlain.acquire();
            object = this.outEncrypted.acquire();
            byteBuffer2.flip();
            this.doWrap(byteBuffer2, (ByteBuffer)object);
            byteBuffer2.compact();
            if (byteBuffer2.position() == 0) {
                this.outPlain.release();
                byteBuffer2 = null;
            }
        }
        if (!this.outPlain.hasData()) {
            byteBuffer2 = this.outEncrypted.acquire();
            object = this.doWrap(byteBuffer, byteBuffer2);
            if (((SSLEngineResult)object).getStatus() == SSLEngineResult.Status.CLOSED) {
                this.status = Integer.MAX_VALUE;
            }
            return ((SSLEngineResult)object).bytesConsumed();
        }
        return 0;
    }

    private synchronized int readPlain(ByteBuffer byteBuffer) {
        Args.notNull(byteBuffer, "Byte buffer");
        if (this.inPlain.hasData()) {
            ByteBuffer byteBuffer2 = this.inPlain.acquire();
            byteBuffer2.flip();
            int n = Math.min(byteBuffer2.remaining(), byteBuffer.remaining());
            for (int i = 0; i < n; ++i) {
                byteBuffer.put(byteBuffer2.get());
            }
            byteBuffer2.compact();
            if (byteBuffer2.position() == 0) {
                this.inPlain.release();
                byteBuffer2 = null;
            }
            return n;
        }
        if (this.endOfStream) {
            return -1;
        }
        return 0;
    }

    @Override
    public synchronized void close() {
        if (this.status >= 1) {
            return;
        }
        this.status = 1;
        this.sslEngine.closeOutbound();
        this.updateEventMask();
    }

    @Override
    public synchronized void shutdown() {
        if (this.status == Integer.MAX_VALUE) {
            return;
        }
        this.inEncrypted.release();
        this.outEncrypted.release();
        this.inPlain.release();
        this.outPlain.release();
        this.status = Integer.MAX_VALUE;
        this.session.shutdown();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isClosed() {
        return this.status >= 1 || this.session.isClosed();
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public synchronized int getEventMask() {
        return this.appEventMask;
    }

    @Override
    public synchronized void setEventMask(int n) {
        this.appEventMask = n;
        this.updateEventMask();
    }

    @Override
    public synchronized void setEvent(int n) {
        this.appEventMask |= n;
        this.updateEventMask();
    }

    @Override
    public synchronized void clearEvent(int n) {
        this.appEventMask &= ~n;
        this.updateEventMask();
    }

    @Override
    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(int n) {
        this.session.setSocketTimeout(n);
    }

    @Override
    public synchronized boolean hasBufferedInput() {
        return this.appBufferStatus != null && this.appBufferStatus.hasBufferedInput() || this.inEncrypted.hasData() || this.inPlain.hasData();
    }

    @Override
    public synchronized boolean hasBufferedOutput() {
        return this.appBufferStatus != null && this.appBufferStatus.hasBufferedOutput() || this.outEncrypted.hasData() || this.outPlain.hasData();
    }

    @Override
    public synchronized void setBufferStatus(SessionBufferStatus sessionBufferStatus) {
        this.appBufferStatus = sessionBufferStatus;
    }

    @Override
    public Object getAttribute(String string) {
        return this.session.getAttribute(string);
    }

    @Override
    public Object removeAttribute(String string) {
        return this.session.removeAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.session.setAttribute(string, object);
    }

    private static void formatOps(StringBuilder stringBuilder, int n) {
        if ((n & 1) > 0) {
            stringBuilder.append('r');
        }
        if ((n & 4) > 0) {
            stringBuilder.append('w');
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.session);
        stringBuilder.append("[");
        switch (this.status) {
            case 0: {
                stringBuilder.append("ACTIVE");
                break;
            }
            case 1: {
                stringBuilder.append("CLOSING");
                break;
            }
            case 0x7FFFFFFF: {
                stringBuilder.append("CLOSED");
            }
        }
        stringBuilder.append("][");
        SSLIOSession.formatOps(stringBuilder, this.appEventMask);
        stringBuilder.append("][");
        stringBuilder.append((Object)this.sslEngine.getHandshakeStatus());
        if (this.sslEngine.isInboundDone()) {
            stringBuilder.append("][inbound done][");
        }
        if (this.sslEngine.isOutboundDone()) {
            stringBuilder.append("][outbound done][");
        }
        if (this.endOfStream) {
            stringBuilder.append("][EOF][");
        }
        stringBuilder.append("][");
        stringBuilder.append(!this.inEncrypted.hasData() ? 0 : this.inEncrypted.acquire().position());
        stringBuilder.append("][");
        stringBuilder.append(!this.inPlain.hasData() ? 0 : this.inPlain.acquire().position());
        stringBuilder.append("][");
        stringBuilder.append(!this.outEncrypted.hasData() ? 0 : this.outEncrypted.acquire().position());
        stringBuilder.append("][");
        stringBuilder.append(!this.outPlain.hasData() ? 0 : this.outPlain.acquire().position());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public Socket getSocket() {
        if (this.session instanceof SocketAccessor) {
            return ((SocketAccessor)((Object)this.session)).getSocket();
        }
        return null;
    }

    private class InternalByteChannel
    implements ByteChannel {
        private InternalByteChannel() {
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            return SSLIOSession.this.writePlain(byteBuffer);
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            return SSLIOSession.this.readPlain(byteBuffer);
        }

        @Override
        public void close() throws IOException {
            SSLIOSession.this.close();
        }

        @Override
        public boolean isOpen() {
            return !SSLIOSession.this.isClosed();
        }
    }
}

