/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SharedInputBuffer
extends ExpandableBuffer
implements ContentInputBuffer {
    private final ReentrantLock lock;
    private final Condition condition;
    private volatile IOControl ioctrl;
    private volatile boolean shutdown = false;
    private volatile boolean endOfStream = false;

    @Deprecated
    public SharedInputBuffer(int n, IOControl iOControl, ByteBufferAllocator byteBufferAllocator) {
        super(n, byteBufferAllocator);
        this.ioctrl = iOControl;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedInputBuffer(int n, ByteBufferAllocator byteBufferAllocator) {
        super(n, byteBufferAllocator);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedInputBuffer(int n) {
        this(n, HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public void reset() {
        if (this.shutdown) {
            return;
        }
        this.lock.lock();
        try {
            this.clear();
            this.endOfStream = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Deprecated
    public int consumeContent(ContentDecoder contentDecoder) throws IOException {
        return this.consumeContent(contentDecoder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            int n;
            if (iOControl != null) {
                this.ioctrl = iOControl;
            }
            this.setInputMode();
            int n2 = 0;
            while ((n = contentDecoder.read(this.buffer)) > 0) {
                n2 += n;
            }
            if (n == -1 || contentDecoder.isCompleted()) {
                this.endOfStream = true;
            }
            if (!this.buffer.hasRemaining() && this.ioctrl != null) {
                this.ioctrl.suspendInput();
            }
            this.condition.signalAll();
            if (n2 > 0) {
                int n3 = n2;
                return n3;
            }
            if (this.endOfStream) {
                int n4 = -1;
                return n4;
            }
            int n5 = 0;
            return n5;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl = super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            int n = super.available();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        this.lock.lock();
        try {
            int n = super.capacity();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n = super.length();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void waitForData() throws IOException {
        this.lock.lock();
        try {
            try {
                while (!super.hasData() && !this.endOfStream) {
                    if (this.shutdown) {
                        throw new InterruptedIOException("Input operation aborted");
                    }
                    if (this.ioctrl != null) {
                        this.ioctrl.requestInput();
                    }
                    this.condition.await();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted while waiting for more data");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        if (this.shutdown) {
            return;
        }
        this.endOfStream = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    protected boolean isEndOfStream() {
        return this.shutdown || !this.hasData() && this.endOfStream;
    }

    @Override
    public int read() throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                int n = -1;
                return n;
            }
            int n = this.buffer.get() & 0xFF;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (byArray == null) {
            return 0;
        }
        this.lock.lock();
        try {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                int n3 = -1;
                return n3;
            }
            this.setOutputMode();
            int n4 = n2;
            if (n4 > this.buffer.remaining()) {
                n4 = this.buffer.remaining();
            }
            this.buffer.get(byArray, n, n4);
            int n5 = n4;
            return n5;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int read(byte[] byArray) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }
}

