/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SharedOutputBuffer
extends ExpandableBuffer
implements ContentOutputBuffer {
    private final ReentrantLock lock;
    private final Condition condition;
    private volatile IOControl ioctrl;
    private volatile boolean shutdown = false;
    private volatile boolean endOfStream = false;

    @Deprecated
    public SharedOutputBuffer(int n, IOControl iOControl, ByteBufferAllocator byteBufferAllocator) {
        super(n, byteBufferAllocator);
        Args.notNull(iOControl, "I/O content control");
        this.ioctrl = iOControl;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedOutputBuffer(int n, ByteBufferAllocator byteBufferAllocator) {
        super(n, byteBufferAllocator);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedOutputBuffer(int n) {
        this(n, HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public void reset() {
        if (this.shutdown) {
            return;
        }
        this.lock.lock();
        try {
            this.clear();
            this.endOfStream = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl = super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            int n = super.available();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        this.lock.lock();
        try {
            int n = super.capacity();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n = super.length();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Deprecated
    public int produceContent(ContentEncoder contentEncoder) throws IOException {
        return this.produceContent(contentEncoder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            if (iOControl != null) {
                this.ioctrl = iOControl;
            }
            this.setOutputMode();
            int n = 0;
            if (super.hasData()) {
                n = contentEncoder.write(this.buffer);
                if (contentEncoder.isCompleted()) {
                    this.endOfStream = true;
                }
            }
            if (!super.hasData()) {
                if (this.endOfStream && !contentEncoder.isCompleted()) {
                    contentEncoder.complete();
                }
                if (!this.endOfStream && this.ioctrl != null) {
                    this.ioctrl.suspendOutput();
                }
            }
            this.condition.signalAll();
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return;
        }
        int n3 = n;
        this.lock.lock();
        try {
            Asserts.check(!this.shutdown && !this.endOfStream, "Buffer already closed for writing");
            this.setInputMode();
            int n4 = n2;
            while (n4 > 0) {
                if (!this.buffer.hasRemaining()) {
                    this.flushContent();
                    this.setInputMode();
                }
                int n5 = Math.min(n4, this.buffer.remaining());
                this.buffer.put(byArray, n3, n5);
                n4 -= n5;
                n3 += n5;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        this.lock.lock();
        try {
            Asserts.check(!this.shutdown && !this.endOfStream, "Buffer already closed for writing");
            this.setInputMode();
            if (!this.buffer.hasRemaining()) {
                this.flushContent();
                this.setInputMode();
            }
            this.buffer.put((byte)n);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    private void flushContent() throws IOException {
        this.lock.lock();
        try {
            try {
                while (super.hasData()) {
                    if (this.shutdown) {
                        throw new InterruptedIOException("Output operation aborted");
                    }
                    if (this.ioctrl != null) {
                        this.ioctrl.requestOutput();
                    }
                    this.condition.await();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted while flushing the content buffer");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void writeCompleted() throws IOException {
        this.lock.lock();
        try {
            if (this.endOfStream) {
                return;
            }
            this.endOfStream = true;
            if (this.ioctrl != null) {
                this.ioctrl.requestOutput();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

