/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.protocol;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseInterceptor;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpDateGenerator;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpResponse, "HTTP response");
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n >= 200 && !httpResponse.containsHeader("Date")) {
            String string = DATE_GENERATOR.getCurrentDate();
            httpResponse.setHeader("Date", string);
        }
    }
}

