/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.asm;

import com.icbc.api.internal.util.fastjson.asm.MethodCollector;
import com.icbc.api.internal.util.fastjson.asm.TypeCollector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassReader {
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;
    private boolean readAnnotations;

    public ClassReader(InputStream inputStream, boolean bl) throws IOException {
        int n;
        this.readAnnotations = bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            if (n <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.b = byteArrayOutputStream.toByteArray();
        this.items = new int[this.readUnsignedShort(8)];
        int n2 = this.items.length;
        this.strings = new String[n2];
        int n3 = 0;
        n = 10;
        for (int i = 1; i < n2; ++i) {
            int n4;
            this.items[i] = n + 1;
            switch (this.b[n]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    n4 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    n4 = 9;
                    ++i;
                    break;
                }
                case 15: {
                    n4 = 4;
                    break;
                }
                case 1: {
                    n4 = 3 + this.readUnsignedShort(n + 1);
                    if (n4 <= n3) break;
                    n3 = n4;
                    break;
                }
                default: {
                    n4 = 3;
                }
            }
            n += n4;
        }
        this.maxStringLength = n3;
        this.header = n;
    }

    public void accept(TypeCollector typeCollector) {
        int n;
        int n2;
        int n3;
        char[] cArray = new char[this.maxStringLength];
        int n4 = 0;
        if (this.readAnnotations) {
            n3 = this.getAttributes();
            for (n2 = this.readUnsignedShort(n3); n2 > 0; --n2) {
                String string = this.readUTF8(n3 + 2, cArray);
                if ("RuntimeVisibleAnnotations".equals(string)) {
                    n4 = n3 + 8;
                    break;
                }
                n3 += 6 + this.readInt(n3 + 4);
            }
        }
        n3 = this.header;
        int n5 = this.items[this.readUnsignedShort(n3 + 4)];
        int n6 = this.readUnsignedShort(n3 + 6);
        n3 += 8;
        for (n2 = 0; n2 < n6; ++n2) {
            n3 += 2;
        }
        n5 = n3;
        n2 = this.readUnsignedShort(n5);
        n5 += 2;
        while (n2 > 0) {
            n = this.readUnsignedShort(n5 + 6);
            n5 += 8;
            while (n > 0) {
                n5 += 6 + this.readInt(n5 + 2);
                --n;
            }
            --n2;
        }
        n2 = this.readUnsignedShort(n5);
        n5 += 2;
        while (n2 > 0) {
            n = this.readUnsignedShort(n5 + 6);
            n5 += 8;
            while (n > 0) {
                n5 += 6 + this.readInt(n5 + 2);
                --n;
            }
            --n2;
        }
        n2 = this.readUnsignedShort(n5);
        n5 += 2;
        while (n2 > 0) {
            n5 += 6 + this.readInt(n5 + 2);
            --n2;
        }
        if (n4 != 0) {
            n5 = n4 + 2;
            for (n2 = this.readUnsignedShort(n4); n2 > 0; --n2) {
                String string = this.readUTF8(n5, cArray);
                typeCollector.visitAnnotation(string);
            }
        }
        n2 = this.readUnsignedShort(n3);
        n3 += 2;
        while (n2 > 0) {
            n = this.readUnsignedShort(n3 + 6);
            n3 += 8;
            while (n > 0) {
                n3 += 6 + this.readInt(n3 + 2);
                --n;
            }
            --n2;
        }
        n2 = this.readUnsignedShort(n3);
        n3 += 2;
        while (n2 > 0) {
            n3 = this.readMethod(typeCollector, cArray, n3);
            --n2;
        }
    }

    private int getAttributes() {
        int n;
        int n2;
        int n3 = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
        for (n2 = this.readUnsignedShort(n3); n2 > 0; --n2) {
            for (n = this.readUnsignedShort(n3 + 8); n > 0; --n) {
                n3 += 6 + this.readInt(n3 + 12);
            }
            n3 += 8;
        }
        for (n2 = this.readUnsignedShort(n3 += 2); n2 > 0; --n2) {
            for (n = this.readUnsignedShort(n3 + 8); n > 0; --n) {
                n3 += 6 + this.readInt(n3 + 12);
            }
            n3 += 8;
        }
        return n3 + 2;
    }

    private int readMethod(TypeCollector typeCollector, char[] cArray, int n) {
        String string;
        int n2 = this.readUnsignedShort(n);
        String string2 = this.readUTF8(n + 2, cArray);
        String string3 = this.readUTF8(n + 4, cArray);
        int n3 = 0;
        int n4 = 0;
        int n5 = this.readUnsignedShort(n + 6);
        n += 8;
        while (n5 > 0) {
            string = this.readUTF8(n, cArray);
            int n6 = this.readInt(n + 2);
            n += 6;
            if (string.equals("Code")) {
                n3 = n;
            }
            n += n6;
            --n5;
        }
        if (n4 != 0) {
            n4 += 2;
            for (n5 = 0; n5 < this.readUnsignedShort(n4); ++n5) {
                n4 += 2;
            }
        }
        MethodCollector methodCollector = typeCollector.visitMethod(n2, string2, string3);
        if (methodCollector != null && n3 != 0) {
            int n7;
            int n8 = this.readInt(n3 + 4);
            int n9 = n3 += 8;
            n3 = n7 = n3 + n8;
            n5 = this.readUnsignedShort(n3);
            n3 += 2;
            while (n5 > 0) {
                n3 += 8;
                --n5;
            }
            int n10 = 0;
            int n11 = 0;
            n5 = this.readUnsignedShort(n3);
            n3 += 2;
            while (n5 > 0) {
                string = this.readUTF8(n3, cArray);
                if (string.equals("LocalVariableTable")) {
                    n10 = n3 + 6;
                } else if (string.equals("LocalVariableTypeTable")) {
                    n11 = n3 + 6;
                }
                n3 += 6 + this.readInt(n3 + 2);
                --n5;
            }
            n3 = n9;
            if (n10 != 0) {
                int n12;
                if (n11 != 0) {
                    n12 = this.readUnsignedShort(n11) * 3;
                    n4 = n11 + 2;
                    int[] nArray = new int[n12];
                    while (n12 > 0) {
                        nArray[--n12] = n4 + 6;
                        nArray[--n12] = this.readUnsignedShort(n4 + 8);
                        nArray[--n12] = this.readUnsignedShort(n4);
                        n4 += 10;
                    }
                }
                n4 = n10 + 2;
                for (n12 = this.readUnsignedShort(n10); n12 > 0; --n12) {
                    int n13 = this.readUnsignedShort(n4 + 8);
                    methodCollector.visitLocalVariable(this.readUTF8(n4 + 4, cArray), n13);
                    n4 += 10;
                }
            }
        }
        return n;
    }

    private int readUnsignedShort(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private int readInt(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private String readUTF8(int n, char[] cArray) {
        int n2 = this.readUnsignedShort(n);
        String string = this.strings[n2];
        if (string != null) {
            return string;
        }
        n = this.items[n2];
        this.strings[n2] = this.readUTF(n + 2, this.readUnsignedShort(n), cArray);
        return this.strings[n2];
    }

    private String readUTF(int n, int n2, char[] cArray) {
        int n3 = n + n2;
        byte[] byArray = this.b;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n < n3) {
            int n7 = byArray[n++];
            switch (n5) {
                case 0: {
                    if ((n7 &= 0xFF) < 128) {
                        cArray[n4++] = (char)n7;
                        break;
                    }
                    if (n7 < 224 && n7 > 191) {
                        n6 = (char)(n7 & 0x1F);
                        n5 = 1;
                        break;
                    }
                    n6 = (char)(n7 & 0xF);
                    n5 = 2;
                    break;
                }
                case 1: {
                    cArray[n4++] = (char)(n6 << 6 | n7 & 0x3F);
                    n5 = 0;
                    break;
                }
                case 2: {
                    n6 = (char)(n6 << 6 | n7 & 0x3F);
                    n5 = 1;
                }
            }
        }
        return new String(cArray, 0, n4);
    }
}

