/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.asm;

import com.icbc.api.internal.util.fastjson.asm.ByteVector;
import com.icbc.api.internal.util.fastjson.asm.ClassWriter;
import com.icbc.api.internal.util.fastjson.asm.Item;
import com.icbc.api.internal.util.fastjson.asm.Label;
import com.icbc.api.internal.util.fastjson.asm.MethodVisitor;
import com.icbc.api.internal.util.fastjson.asm.Type;

public class MethodWriter
implements MethodVisitor {
    MethodWriter next;
    final ClassWriter cw;
    private int access;
    private final int name;
    private final int desc;
    int exceptionCount;
    int[] exceptions;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;

    public MethodWriter(ClassWriter classWriter, int n, String string, String string2, String string3, String[] stringArray) {
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
        } else {
            classWriter.lastMethod.next = this;
        }
        classWriter.lastMethod = this;
        this.cw = classWriter;
        this.access = n;
        this.name = classWriter.newUTF8(string);
        this.desc = classWriter.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.exceptionCount = stringArray.length;
            this.exceptions = new int[this.exceptionCount];
            for (int i = 0; i < this.exceptionCount; ++i) {
                this.exceptions[i] = classWriter.newClassItem((String)stringArray[i]).index;
            }
        }
    }

    @Override
    public void visitInsn(int n) {
        this.code.putByte(n);
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.code.put11(n, n2);
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        if (n2 < 4 && n != 169) {
            int n3 = n < 54 ? 26 + (n - 21 << 2) + n2 : 59 + (n - 54 << 2) + n2;
            this.code.putByte(n3);
        } else if (n2 >= 256) {
            this.code.putByte(196).put12(n, n2);
        } else {
            this.code.put11(n, n2);
        }
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        Item item = this.cw.newClassItem(string);
        this.code.put12(n, item.index);
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        Item item = this.cw.newFieldItem(string, string2, string3);
        this.code.put12(n, item.index);
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        boolean bl = n == 185;
        Item item = this.cw.newMethodItem(string, string2, string3, bl);
        int n2 = item.intVal;
        if (bl) {
            if (n2 == 0) {
                item.intVal = n2 = Type.getArgumentsAndReturnSizes(string3);
            }
            this.code.put12(185, item.index).put11(n2 >> 2, 0);
        } else {
            this.code.put12(n, item.index);
        }
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        if ((label.status & 2) != 0 && label.position - this.code.length < Short.MIN_VALUE) {
            throw new UnsupportedOperationException();
        }
        this.code.putByte(n);
        label.put(this, this.code, this.code.length - 1, n == 200);
    }

    @Override
    public void visitLabel(Label label) {
        label.resolve(this, this.code.length, this.code.data);
    }

    @Override
    public void visitLdcInsn(Object object) {
        Item item = this.cw.newConstItem(object);
        int n = item.index;
        if (item.type == 5 || item.type == 6) {
            this.code.put12(20, n);
        } else if (n >= 256) {
            this.code.put12(19, n);
        } else {
            this.code.put11(18, n);
        }
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.code.putByte(132).put11(n, n2);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    @Override
    public void visitEnd() {
    }

    final int getSize() {
        int n = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n += 18 + this.code.length + 0;
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            n += 8 + 2 * this.exceptionCount;
        }
        return n;
    }

    final void put(ByteVector byteVector) {
        int n;
        int n2 = 393216;
        byteVector.putShort(this.access & 0xFFF9FFFF).putShort(this.name).putShort(this.desc);
        int n3 = 0;
        if (this.code.length > 0) {
            ++n3;
        }
        if (this.exceptionCount > 0) {
            ++n3;
        }
        byteVector.putShort(n3);
        if (this.code.length > 0) {
            n = 12 + this.code.length + 0;
            byteVector.putShort(this.cw.newUTF8("Code")).putInt(n);
            byteVector.putShort(this.maxStack).putShort(this.maxLocals);
            byteVector.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            byteVector.putShort(0);
            n3 = 0;
            byteVector.putShort(n3);
        }
        if (this.exceptionCount > 0) {
            byteVector.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            byteVector.putShort(this.exceptionCount);
            for (n = 0; n < this.exceptionCount; ++n) {
                byteVector.putShort(this.exceptions[n]);
            }
        }
    }
}

