/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.asm;

import com.icbc.api.internal.util.fastjson.annotation.JSONType;
import com.icbc.api.internal.util.fastjson.asm.MethodCollector;
import com.icbc.api.internal.util.fastjson.asm.Type;
import com.icbc.api.internal.util.fastjson.util.ASMUtils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class TypeCollector {
    private static String JSONType = ASMUtils.desc(JSONType.class);
    private static final Map<String, String> primitives = new HashMap<String, String>(){
        {
            this.put("int", "I");
            this.put("boolean", "Z");
            this.put("byte", "B");
            this.put("char", "C");
            this.put("short", "S");
            this.put("float", "F");
            this.put("long", "J");
            this.put("double", "D");
        }
    };
    private final String methodName;
    private final Class<?>[] parameterTypes;
    protected MethodCollector collector;
    protected boolean jsonType;

    public TypeCollector(String string, Class<?>[] classArray) {
        this.methodName = string;
        this.parameterTypes = classArray;
        this.collector = null;
    }

    protected MethodCollector visitMethod(int n, String string, String string2) {
        if (this.collector != null) {
            return null;
        }
        if (!string.equals(this.methodName)) {
            return null;
        }
        Type[] typeArray = Type.getArgumentTypes(string2);
        int n2 = 0;
        for (Type type : typeArray) {
            String string3 = type.getClassName();
            if (!string3.equals("long") && !string3.equals("double")) continue;
            ++n2;
        }
        if (typeArray.length != this.parameterTypes.length) {
            return null;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            if (this.correctTypeName(typeArray[i], this.parameterTypes[i].getName())) continue;
            return null;
        }
        this.collector = new MethodCollector(Modifier.isStatic(n) ? 0 : 1, typeArray.length + n2);
        return this.collector;
    }

    public void visitAnnotation(String string) {
        if (JSONType.equals(string)) {
            this.jsonType = true;
        }
    }

    private boolean correctTypeName(Type type, String string) {
        String string2 = type.getClassName();
        StringBuilder stringBuilder = new StringBuilder();
        while (string2.endsWith("[]")) {
            stringBuilder.append('[');
            string2 = string2.substring(0, string2.length() - 2);
        }
        if (stringBuilder.length() != 0) {
            string2 = primitives.containsKey(string2) ? stringBuilder.append(primitives.get(string2)).toString() : stringBuilder.append('L').append(string2).append(';').toString();
        }
        return string2.equals(string);
    }

    public String[] getParameterNamesForMethod() {
        if (this.collector == null || !this.collector.debugInfoPresent) {
            return new String[0];
        }
        return this.collector.getResult().split(",");
    }

    public boolean matched() {
        return this.collector != null;
    }

    public boolean hasJsonType() {
        return this.jsonType;
    }
}

