/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser;

import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.JSONScanner;
import com.icbc.api.internal.util.fastjson.parser.JSONToken;
import com.icbc.api.internal.util.fastjson.parser.SymbolTable;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    protected int token;
    protected int pos;
    protected int features;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;
    public int matchStat = 0;
    private static final ThreadLocal<char[]> SBUF_LOCAL;
    protected String stringDefaultValue = null;
    protected int nanos = 0;
    protected static final char[] typeFieldName;
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int[] digits;

    protected void lexError(String string, Object ... objectArray) {
        this.token = 1;
    }

    public JSONLexerBase(int n) {
        this.features = n;
        if ((n & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
        this.sbuf = SBUF_LOCAL.get();
        if (this.sbuf == null) {
            this.sbuf = new char[512];
        }
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public void setToken(int n) {
        this.token = n;
    }

    @Override
    public final void nextToken() {
        block28: {
            this.sp = 0;
            block19: while (true) {
                this.pos = this.bp;
                if (this.ch == '/') {
                    this.skipComment();
                    continue;
                }
                if (this.ch == '\"') {
                    this.scanString();
                    return;
                }
                if (this.ch == ',') {
                    this.next();
                    this.token = 16;
                    return;
                }
                if (this.ch >= '0' && this.ch <= '9') {
                    this.scanNumber();
                    return;
                }
                if (this.ch == '-') {
                    this.scanNumber();
                    return;
                }
                switch (this.ch) {
                    case '\'': {
                        if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                            throw new JSONException("Feature.AllowSingleQuotes is false");
                        }
                        this.scanStringSingleQuote();
                        return;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.next();
                        continue block19;
                    }
                    case 't': {
                        this.scanTrue();
                        return;
                    }
                    case 'f': {
                        this.scanFalse();
                        return;
                    }
                    case 'n': {
                        this.scanNullOrNew();
                        return;
                    }
                    case 'N': 
                    case 'S': 
                    case 'T': 
                    case 'u': {
                        this.scanIdent();
                        return;
                    }
                    case '(': {
                        this.next();
                        this.token = 10;
                        return;
                    }
                    case ')': {
                        this.next();
                        this.token = 11;
                        return;
                    }
                    case '[': {
                        this.next();
                        this.token = 14;
                        return;
                    }
                    case ']': {
                        this.next();
                        this.token = 15;
                        return;
                    }
                    case '{': {
                        this.next();
                        this.token = 12;
                        return;
                    }
                    case '}': {
                        this.next();
                        this.token = 13;
                        return;
                    }
                    case ':': {
                        this.next();
                        this.token = 17;
                        return;
                    }
                    case ';': {
                        this.next();
                        this.token = 24;
                        return;
                    }
                    case '.': {
                        this.next();
                        this.token = 25;
                        return;
                    }
                    case '+': {
                        this.next();
                        this.scanNumber();
                        return;
                    }
                    case 'x': {
                        this.scanHex();
                        return;
                    }
                }
                if (this.isEOF()) {
                    if (this.token == 20) {
                        throw new JSONException("EOF error");
                    }
                    this.token = 20;
                    this.eofPos = this.pos = this.bp;
                    break block28;
                }
                if (this.ch > '\u001f' && this.ch != '\u007f') break;
                this.next();
            }
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.next();
        }
    }

    @Override
    public final void nextToken(int n) {
        this.sp = 0;
        while (true) {
            switch (n) {
                case 12: {
                    if (this.ch == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.next();
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        this.token = 16;
                        this.next();
                        return;
                    }
                    if (this.ch == '}') {
                        this.token = 13;
                        this.next();
                        return;
                    }
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                    if (this.ch == '\u001a') {
                        this.token = 20;
                        return;
                    }
                    if (this.ch != 'n') break;
                    this.scanNullOrNew(false);
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 4: {
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.ch)) {
            this.next();
        }
        if (this.ch == '_' || this.ch == '$' || Character.isLetter(this.ch)) {
            this.scanIdent();
        } else {
            this.nextToken();
        }
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c2) {
        this.sp = 0;
        while (true) {
            if (this.ch == c2) {
                this.next();
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + c2 + " - " + this.ch + ", info : " + this.info());
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    public final String stringDefaultValue() {
        return this.stringDefaultValue;
    }

    @Override
    public final Number integerValue() throws NumberFormatException {
        int n;
        long l;
        long l2 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int n2 = this.np;
        int n3 = this.np + this.sp;
        int n4 = 32;
        switch (this.charAt(n3 - 1)) {
            case 'L': {
                --n3;
                n4 = 76;
                break;
            }
            case 'S': {
                --n3;
                n4 = 83;
                break;
            }
            case 'B': {
                --n3;
                n4 = 66;
                break;
            }
        }
        if (this.charAt(this.np) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n2;
        } else {
            l = -9223372036854775807L;
        }
        long l3 = -922337203685477580L;
        if (n2 < n3) {
            n = this.charAt(n2++) - 48;
            l2 = -n;
        }
        while (n2 < n3) {
            n = this.charAt(n2++) - 48;
            if (l2 < l3) {
                return new BigInteger(this.numberString());
            }
            if ((l2 *= 10L) < l + (long)n) {
                return new BigInteger(this.numberString());
            }
            l2 -= (long)n;
        }
        if (bl) {
            if (n2 > this.np + 1) {
                if (l2 >= Integer.MIN_VALUE && n4 != 76) {
                    if (n4 == 83) {
                        return (short)l2;
                    }
                    if (n4 == 66) {
                        return (byte)l2;
                    }
                    return (int)l2;
                }
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l2 = -l2) <= Integer.MAX_VALUE && n4 != 76) {
            if (n4 == 83) {
                return (short)l2;
            }
            if (n4 == 66) {
                return (byte)l2;
            }
            return (int)l2;
        }
        return l2;
    }

    @Override
    public final void nextTokenWithColon(int n) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        char c2;
        String string = this.numberString();
        float f = Float.parseFloat(string);
        if ((f == 0.0f || f == Float.POSITIVE_INFINITY) && (c2 = string.charAt(0)) > '0' && c2 <= '9') {
            throw new JSONException("float overflow : " + string);
        }
        return f;
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void config(Feature feature, boolean bl) {
        this.features = Feature.config(this.features, feature, bl);
        if ((this.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.mask);
    }

    @Override
    public final boolean isEnabled(int n) {
        return (this.features & n) != 0;
    }

    public final boolean isEnabled(int n, int n2) {
        return (this.features & n2) != 0 || (n & n2) != 0;
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    protected void skipComment() {
        this.next();
        if (this.ch == '/') {
            do {
                this.next();
                if (this.ch != '\n') continue;
                this.next();
                return;
            } while (this.ch != '\u001a');
            return;
        }
        if (this.ch == '*') {
            this.next();
            while (this.ch != '\u001a') {
                if (this.ch == '*') {
                    this.next();
                    if (this.ch != '/') continue;
                    this.next();
                    return;
                }
                this.next();
            }
        } else {
            throw new JSONException("invalid comment");
        }
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    protected abstract void arrayCopy(int var1, char[] var2, int var3, int var4);

    @Override
    public final String scanSymbol(SymbolTable symbolTable, char c2) {
        String string;
        char c3;
        int n = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean bl = false;
        block22: while ((c3 = this.next()) != c2) {
            if (c3 == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (c3 == '\\') {
                int n2;
                if (!bl) {
                    bl = true;
                    if (this.sp >= this.sbuf.length) {
                        n2 = this.sbuf.length * 2;
                        if (this.sp > n2) {
                            n2 = this.sp;
                        }
                        char[] cArray = new char[n2];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    this.arrayCopy(this.np + 1, this.sbuf, 0, this.sp);
                }
                c3 = this.next();
                switch (c3) {
                    case '0': {
                        n = 31 * n + c3;
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        n = 31 * n + c3;
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        n = 31 * n + c3;
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        n = 31 * n + c3;
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        n = 31 * n + c3;
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        n = 31 * n + c3;
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        n = 31 * n + c3;
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        n = 31 * n + c3;
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        n = 31 * n + 8;
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        n = 31 * n + 9;
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        n = 31 * n + 10;
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        n = 31 * n + 11;
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        n = 31 * n + 12;
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        n = 31 * n + 13;
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        n = 31 * n + 34;
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        n = 31 * n + 39;
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        n = 31 * n + 47;
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        n = 31 * n + 92;
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        n2 = this.ch = this.next();
                        char c4 = this.ch = this.next();
                        int n3 = digits[n2] * 16 + digits[c4];
                        char c5 = (char)n3;
                        n = 31 * n + c5;
                        this.putChar(c5);
                        continue block22;
                    }
                    case 'u': {
                        char c6 = c3 = this.next();
                        char c7 = c3 = this.next();
                        char c8 = c3 = this.next();
                        char c9 = c3 = this.next();
                        int n4 = Integer.parseInt(new String(new char[]{c6, c7, c8, c9}), 16);
                        n = 31 * n + n4;
                        this.putChar((char)n4);
                        continue block22;
                    }
                }
                this.ch = c3;
                throw new JSONException("unclosed.str.lit");
            }
            n = 31 * n + c3;
            if (!bl) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c3);
                continue;
            }
            this.sbuf[this.sp++] = c3;
        }
        this.token = 4;
        if (!bl) {
            int n5 = this.np == -1 ? 0 : this.np + 1;
            string = this.addSymbol(n5, this.sp, n, symbolTable);
        } else {
            string = symbolTable.addSymbol(this.sbuf, 0, this.sp, n);
        }
        this.sp = 0;
        this.next();
        return string;
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char c2;
        boolean bl;
        if (this.token == 1 && this.pos == 0 && this.bp == 1) {
            this.bp = 0;
        }
        boolean[] blArray = IOUtils.firstIdentifierFlags;
        int n = this.ch;
        boolean bl2 = bl = this.ch >= blArray.length || blArray[n];
        if (!bl) {
            throw new JSONException("illegal identifier : " + this.ch + this.info());
        }
        boolean[] blArray2 = IOUtils.identifierFlags;
        int n2 = n;
        this.np = this.bp;
        this.sp = 1;
        while ((c2 = this.next()) >= blArray2.length || blArray2[c2]) {
            n2 = 31 * n2 + c2;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        int n3 = 3392903;
        if (this.sp == 4 && n2 == 3392903 && this.charAt(this.np) == 'n' && this.charAt(this.np + 1) == 'u' && this.charAt(this.np + 2) == 'l' && this.charAt(this.np + 3) == 'l') {
            return null;
        }
        if (symbolTable == null) {
            return this.subString(this.np, this.sp);
        }
        return this.addSymbol(this.np, this.sp, n2, symbolTable);
    }

    protected abstract void copyTo(int var1, int var2, char[] var3);

    @Override
    public final void scanString() {
        char c2;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((c2 = this.next()) != '\"') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.putChar('\u001a');
                    continue;
                }
                throw new JSONException("unclosed string : " + c2);
            }
            if (c2 == '\\') {
                char c3;
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        c3 = this.sbuf.length * 2;
                        if (this.sp > c3) {
                            c3 = this.sp;
                        }
                        char[] cArray = new char[c3];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    this.copyTo(this.np + 1, this.sp, this.sbuf);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        boolean bl;
                        c3 = this.next();
                        char c4 = this.next();
                        boolean bl2 = c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F';
                        boolean bl3 = bl = c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F';
                        if (!bl2 || !bl) {
                            throw new JSONException("invalid escape character \\x" + c3 + c4);
                        }
                        char c5 = (char)(digits[c3] * 16 + digits[c4]);
                        this.putChar(c5);
                        continue block22;
                    }
                    case 'u': {
                        char c6 = this.next();
                        char c7 = this.next();
                        char c8 = this.next();
                        char c9 = this.next();
                        int n = Integer.parseInt(new String(new char[]{c6, c7, c8, c9}), 16);
                        this.putChar((char)n);
                        continue block22;
                    }
                }
                this.ch = c2;
                throw new JSONException("unclosed string : " + c2);
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c2);
                continue;
            }
            this.sbuf[this.sp++] = c2;
        }
        this.token = 4;
        this.ch = this.next();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public final int intValue() {
        char c2;
        int n;
        int n2;
        if (this.np == -1) {
            this.np = 0;
        }
        int n3 = 0;
        boolean bl = false;
        int n4 = this.np;
        int n5 = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            bl = true;
            n2 = Integer.MIN_VALUE;
            ++n4;
        } else {
            n2 = -2147483647;
        }
        long l = -214748364L;
        if (n4 < n5) {
            n = this.charAt(n4++) - 48;
            n3 = -n;
        }
        while (n4 < n5 && (c2 = this.charAt(n4++)) != 'L' && c2 != 'S' && c2 != 'B') {
            n = c2 - 48;
            if ((long)n3 < l) {
                throw new NumberFormatException(this.numberString());
            }
            if ((n3 *= 10) < n2 + n) {
                throw new NumberFormatException(this.numberString());
            }
            n3 -= n;
        }
        if (bl) {
            if (n4 > this.np + 1) {
                return n3;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n3;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        if (this.sbuf.length <= 8192) {
            SBUF_LOCAL.set(this.sbuf);
        }
        this.sbuf = null;
    }

    @Override
    public final boolean isRef() {
        if (this.sp != 4) {
            return false;
        }
        return this.charAt(this.np + 1) == '$' && this.charAt(this.np + 2) == 'r' && this.charAt(this.np + 3) == 'e' && this.charAt(this.np + 4) == 'f';
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        return null;
    }

    public final int scanType(String string) {
        this.matchStat = 0;
        if (!this.charArrayCompare(typeFieldName)) {
            return -2;
        }
        int n = this.bp + typeFieldName.length;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == this.charAt(n + i)) continue;
            return -1;
        }
        if (this.charAt(n += n2) != '\"') {
            return -1;
        }
        this.ch = this.charAt(++n);
        if (this.ch == ',') {
            this.ch = this.charAt(++n);
            this.bp = n;
            this.token = 16;
            return 3;
        }
        if (this.ch == '}') {
            this.ch = this.charAt(++n);
            if (this.ch == ',') {
                this.token = 16;
                this.ch = this.charAt(++n);
            } else if (this.ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++n);
            } else if (this.ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++n);
            } else if (this.ch == '\u001a') {
                this.token = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.bp = n;
        return this.matchStat;
    }

    public final boolean matchField(char[] cArray) {
        while (!this.charArrayCompare(cArray)) {
            if (JSONLexerBase.isWhitespace(this.ch)) {
                this.next();
                continue;
            }
            return false;
        }
        this.bp += cArray.length;
        this.ch = this.charAt(this.bp);
        if (this.ch == '{') {
            this.next();
            this.token = 12;
        } else if (this.ch == '[') {
            this.next();
            this.token = 14;
        } else if (this.ch == 'S' && this.charAt(this.bp + 1) == 'e' && this.charAt(this.bp + 2) == 't' && this.charAt(this.bp + 3) == '[') {
            this.bp += 3;
            this.ch = this.charAt(this.bp);
            this.token = 21;
        } else {
            this.nextToken();
        }
        return true;
    }

    public int matchField(long l) {
        throw new UnsupportedOperationException();
    }

    public boolean seekArrayToItem(int n) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long l, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long[] lArray) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToFieldDeepScan(long l) {
        throw new UnsupportedOperationException();
    }

    public void skipObject() {
        throw new UnsupportedOperationException();
    }

    public void skipObject(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void skipArray() {
        throw new UnsupportedOperationException();
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] cArray) {
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int n = cArray.length;
        if ((c2 = this.charAt(this.bp + n++)) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        int n2 = this.bp + cArray.length + 1;
        int n3 = this.indexOf('\"', n2);
        if (n3 == -1) {
            throw new JSONException("unclosed str");
        }
        int n4 = this.bp + cArray.length + 1;
        String string = this.subString(n4, n3 - n4);
        if (string.indexOf(92) != -1) {
            while (true) {
                int n5 = 0;
                for (int i = n3 - 1; i >= 0 && this.charAt(i) == '\\'; ++n5, --i) {
                }
                if (n5 % 2 == 0) {
                    n5 = n3 - (this.bp + cArray.length + 1);
                    char[] cArray2 = this.sub_chars(this.bp + cArray.length + 1, n5);
                    string = JSONLexerBase.readString(cArray2, n5);
                    break;
                }
                n3 = this.indexOf('\"', n3 + 1);
            }
        }
        n += n3 - (this.bp + cArray.length + 1) + 1;
        c2 = this.charAt(this.bp + n++);
        String string2 = string;
        if (c2 == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return string2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return string2;
    }

    @Override
    public String scanString(char c2) {
        String string;
        char c3;
        int n;
        block13: {
            this.matchStat = 0;
            n = 0;
            if ((c3 = this.charAt(this.bp + n++)) == 'n') {
                if (this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                    n += 3;
                } else {
                    this.matchStat = -1;
                    return null;
                }
                c3 = this.charAt(this.bp + n++);
                if (c3 == c2) {
                    this.bp += n;
                    this.ch = this.charAt(this.bp);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            while (true) {
                if (c3 == '\"') {
                    int n2 = this.bp + n;
                    int n3 = this.indexOf('\"', n2);
                    if (n3 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    string = this.subString(this.bp + n, n3 - n2);
                    if (string.indexOf(92) != -1) {
                        int n4;
                        while (true) {
                            n4 = 0;
                            for (int i = n3 - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                                ++n4;
                            }
                            if (n4 % 2 == 0) break;
                            n3 = this.indexOf('\"', n3 + 1);
                        }
                        n4 = n3 - n2;
                        char[] cArray = this.sub_chars(this.bp + 1, n4);
                        string = JSONLexerBase.readString(cArray, n4);
                    }
                    n += n3 - n2 + 1;
                    break block13;
                }
                if (!JSONLexerBase.isWhitespace(c3)) break;
                c3 = this.charAt(this.bp + n++);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        c3 = this.charAt(this.bp + n++);
        String string2 = string;
        while (true) {
            if (c3 == c2) {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return string2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.bp + n++);
        }
        if (c3 == ']') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = -1;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldSymbol(char[] cArray) {
        long l;
        char c2;
        int n;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n = cArray.length;
                if ((c2 = this.charAt(this.bp + n++)) != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                l = -3750763034362895579L;
                do {
                    if ((c2 = this.charAt(this.bp + n++)) == '\"') {
                        if ((c2 = this.charAt(this.bp + n++)) != ',') break block12;
                        break block13;
                    }
                    l ^= (long)c2;
                    l *= 1099511628211L;
                } while (c2 != '\\');
                this.matchStat = -1;
                return 0L;
            }
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return l;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanEnumSymbol(char[] cArray) {
        long l;
        int n;
        int n2;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n2 = cArray.length;
                if ((n = this.charAt(this.bp + n2++)) != 34) {
                    this.matchStat = -1;
                    return 0L;
                }
                l = -3750763034362895579L;
                do {
                    if ((n = this.charAt(this.bp + n2++)) == 34) {
                        if ((n = this.charAt(this.bp + n2++)) != 44) break block12;
                        break block13;
                    }
                    l ^= (long)(n >= 65 && n <= 90 ? n + 32 : n);
                    l *= 1099511628211L;
                } while (n != 92);
                this.matchStat = -1;
                return 0L;
            }
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return l;
        }
        if (n != 125) {
            this.matchStat = -1;
            return 0L;
        }
        if ((n = (int)this.charAt(this.bp + n2++)) == 44) {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (n == 93) {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (n == 125) {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (n != 26) {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return l;
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable symbolTable, char c2) {
        String string = this.scanSymbolWithSeperator(symbolTable, c2);
        if (string == null) {
            return null;
        }
        return Enum.valueOf(clazz, string);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable symbolTable, char c2) {
        int n;
        char c3;
        int n2;
        block8: {
            this.matchStat = 0;
            n2 = 0;
            if ((c3 = this.charAt(this.bp + n2++)) == 'n') {
                if (this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                    n2 += 3;
                } else {
                    this.matchStat = -1;
                    return null;
                }
                c3 = this.charAt(this.bp + n2++);
                if (c3 == c2) {
                    this.bp += n2;
                    this.ch = this.charAt(this.bp);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            if (c3 != '\"') {
                this.matchStat = -1;
                return null;
            }
            n = 0;
            do {
                if ((c3 = this.charAt(this.bp + n2++)) == '\"') break block8;
                n = 31 * n + c3;
            } while (c3 != '\\');
            this.matchStat = -1;
            return null;
        }
        int n3 = this.bp + 0 + 1;
        int n4 = this.bp + n2 - n3 - 1;
        String string = this.addSymbol(n3, n4, n, symbolTable);
        c3 = this.charAt(this.bp + n2++);
        while (true) {
            if (c3 == c2) {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return string;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.bp + n2++);
        }
        this.matchStat = -1;
        return string;
    }

    public Collection<String> newCollectionByType(Class<?> clazz) {
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<String>();
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<String>();
        }
        if (clazz.isAssignableFrom(LinkedList.class)) {
            return new LinkedList<String>();
        }
        try {
            return (Collection)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<String> scanFieldStringArray(char[] cArray, Class<?> clazz) {
        char c2;
        int n;
        Collection<String> collection;
        block19: {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            collection = this.newCollectionByType(clazz);
            n = cArray.length;
            if ((c2 = this.charAt(this.bp + n++)) != '[') {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp + n++);
            while (true) {
                block23: {
                    String string;
                    int n2;
                    block21: {
                        block22: {
                            block20: {
                                if (c2 != '\"') break block20;
                                int n3 = this.bp + n;
                                n2 = this.indexOf('\"', n3);
                                if (n2 == -1) {
                                    throw new JSONException("unclosed str");
                                }
                                int n4 = this.bp + n;
                                string = this.subString(n4, n2 - n4);
                                if (string.indexOf(92) == -1) break block21;
                                break block22;
                            }
                            if (c2 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                                n += 3;
                                c2 = this.charAt(this.bp + n++);
                                collection.add(null);
                                break block23;
                            } else {
                                if (c2 != ']') throw new JSONException("illega str");
                                if (collection.size() != 0) throw new JSONException("illega str");
                                c2 = this.charAt(this.bp + n++);
                                break block19;
                            }
                        }
                        while (true) {
                            int n5 = 0;
                            for (int i = n2 - 1; i >= 0 && this.charAt(i) == '\\'; ++n5, --i) {
                            }
                            if (n5 % 2 == 0) {
                                n5 = n2 - (this.bp + n);
                                char[] cArray2 = this.sub_chars(this.bp + n, n5);
                                string = JSONLexerBase.readString(cArray2, n5);
                                break;
                            }
                            n2 = this.indexOf('\"', n2 + 1);
                        }
                    }
                    n += n2 - (this.bp + n) + 1;
                    c2 = this.charAt(this.bp + n++);
                    collection.add(string);
                }
                if (c2 != ',') break;
                c2 = this.charAt(this.bp + n++);
            }
            if (c2 != ']') {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp + n++);
        }
        if (c2 == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return collection;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return collection;
    }

    @Override
    public void scanStringArray(Collection<String> collection, char c2) {
        char c3;
        int n;
        block14: {
            this.matchStat = 0;
            n = 0;
            if ((c3 = this.charAt(this.bp + n++)) == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l' && this.charAt(this.bp + n + 3) == c2) {
                this.bp += 5;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                return;
            }
            if (c3 != '[') {
                this.matchStat = -1;
                return;
            }
            c3 = this.charAt(this.bp + n++);
            while (true) {
                if (c3 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                    n += 3;
                    c3 = this.charAt(this.bp + n++);
                    collection.add(null);
                } else {
                    if (c3 == ']' && collection.size() == 0) {
                        c3 = this.charAt(this.bp + n++);
                        break block14;
                    }
                    if (c3 != '\"') {
                        this.matchStat = -1;
                        return;
                    }
                    int n2 = this.bp + n;
                    int n3 = this.indexOf('\"', n2);
                    if (n3 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    String string = this.subString(this.bp + n, n3 - n2);
                    if (string.indexOf(92) != -1) {
                        int n4;
                        while (true) {
                            n4 = 0;
                            for (int i = n3 - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                                ++n4;
                            }
                            if (n4 % 2 == 0) break;
                            n3 = this.indexOf('\"', n3 + 1);
                        }
                        n4 = n3 - n2;
                        char[] cArray = this.sub_chars(this.bp + n, n4);
                        string = JSONLexerBase.readString(cArray, n4);
                    }
                    n += n3 - (this.bp + n) + 1;
                    c3 = this.charAt(this.bp + n++);
                    collection.add(string);
                }
                if (c3 != ',') break;
                c3 = this.charAt(this.bp + n++);
            }
            if (c3 == ']') {
                c3 = this.charAt(this.bp + n++);
            } else {
                this.matchStat = -1;
                return;
            }
        }
        if (c3 == c2) {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return;
        }
        this.matchStat = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] cArray) {
        int n;
        int n2;
        char c2;
        boolean bl;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0;
        }
        int n3 = cArray.length;
        boolean bl2 = bl = (c2 = this.charAt(this.bp + n3++)) == '-';
        if (bl) {
            c2 = this.charAt(this.bp + n3++);
        }
        if (c2 >= '0' && c2 <= '9') {
            n2 = c2 - 48;
            while ((c2 = this.charAt(this.bp + n3++)) >= '0' && c2 <= '9') {
                n2 = n2 * 10 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (!(n2 >= 0 && n3 <= 14 + cArray.length || n2 == Integer.MIN_VALUE && n3 == 17 && bl)) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (c2 == ',') {
            int n4;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                n4 = -n2;
                return n4;
            }
            n4 = n2;
            return n4;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0;
        }
        if ((c2 = this.charAt(this.bp + n3++)) == ',') {
            this.token = 16;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0;
            }
            this.token = 20;
            this.bp += n3 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            n = n2;
            return n;
        }
        n = -n2;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int[] scanFieldIntArray(char[] cArray) {
        int n;
        int[] nArray;
        char c2;
        int n2;
        block20: {
            block19: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return null;
                }
                n2 = cArray.length;
                if ((c2 = this.charAt(this.bp + n2++)) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                c2 = this.charAt(this.bp + n2++);
                nArray = new int[16];
                n = 0;
                if (c2 == ']') {
                    c2 = this.charAt(this.bp + n2++);
                } else {
                    while (true) {
                        boolean bl = false;
                        if (c2 == '-') {
                            c2 = this.charAt(this.bp + n2++);
                            bl = true;
                        }
                        if (c2 < '0' || c2 > '9') break block19;
                        int n3 = c2 - 48;
                        while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                            n3 = n3 * 10 + (c2 - 48);
                        }
                        if (n >= nArray.length) {
                            int[] nArray2 = new int[nArray.length * 3 / 2];
                            System.arraycopy(nArray, 0, nArray2, 0, n);
                            nArray = nArray2;
                        }
                        int n4 = nArray[n++] = bl ? -n3 : n3;
                        if (c2 == ',') {
                            c2 = this.charAt(this.bp + n2++);
                            continue;
                        }
                        if (c2 == ']') break;
                    }
                    c2 = this.charAt(this.bp + n2++);
                }
                break block20;
            }
            this.matchStat = -1;
            return null;
        }
        if (n != nArray.length) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            nArray = nArray3;
        }
        if (c2 == ',') {
            this.bp += n2 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return nArray;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2 - 1;
            this.next();
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2 - 1;
            this.next();
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n2 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean scanBoolean(char c2) {
        boolean bl;
        char c3;
        int n;
        block12: {
            this.matchStat = 0;
            n = 0;
            c3 = this.charAt(this.bp + n++);
            bl = false;
            if (c3 == 't') {
                if (this.charAt(this.bp + n) == 'r' && this.charAt(this.bp + n + 1) == 'u' && this.charAt(this.bp + n + 2) == 'e') {
                    n += 3;
                    c3 = this.charAt(this.bp + n++);
                    bl = true;
                    break block12;
                } else {
                    this.matchStat = -1;
                    return false;
                }
            }
            if (c3 == 'f') {
                if (this.charAt(this.bp + n) == 'a' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 's' && this.charAt(this.bp + n + 3) == 'e') {
                    n += 4;
                    c3 = this.charAt(this.bp + n++);
                    bl = false;
                    break block12;
                } else {
                    this.matchStat = -1;
                    return false;
                }
            }
            if (c3 == '1') {
                c3 = this.charAt(this.bp + n++);
                bl = true;
            } else if (c3 == '0') {
                c3 = this.charAt(this.bp + n++);
                bl = false;
            }
        }
        while (true) {
            if (c3 == c2) {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return bl;
            }
            if (!JSONLexerBase.isWhitespace(c3)) {
                this.matchStat = -1;
                return bl;
            }
            c3 = this.charAt(this.bp + n++);
        }
    }

    @Override
    public int scanInt(char c2) {
        int n;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.bp + n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.bp + n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.bp + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            n = c3 - 48;
            while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                n = n * 10 + (c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c3 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                this.matchStat = 5;
                int n3 = 0;
                n2 += 3;
                c3 = this.charAt(this.bp + n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.bp + n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp += n2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return n3;
                    }
                    if (c3 == ']') {
                        this.bp += n2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return n3;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.bp + n2++);
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c3 == c2) {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bl ? -n : n;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.bp + n2++);
        }
        this.matchStat = -1;
        return bl ? -n : n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] cArray) {
        boolean bl;
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n = cArray.length;
        if ((c2 = this.charAt(this.bp + n++)) == 't') {
            if (this.charAt(this.bp + n++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = true;
        } else {
            if (c2 != 'f') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n++) != 's') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = false;
        }
        c2 = this.charAt(this.bp + n++);
        if (c2 == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return bl;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return false;
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] cArray) {
        long l;
        long l2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        int n = cArray.length;
        char c2 = this.charAt(this.bp + n++);
        boolean bl = false;
        if (c2 == '-') {
            c2 = this.charAt(this.bp + n++);
            bl = true;
        }
        if (c2 >= '0' && c2 <= '9') {
            boolean bl2;
            l2 = c2 - 48;
            while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                l2 = l2 * 10L + (long)(c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            boolean bl3 = bl2 = n - cArray.length < 21 && (l2 >= 0L || l2 == Long.MIN_VALUE && bl);
            if (!bl2) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (c2 == ',') {
            long l3;
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                l3 = -l2;
                return l3;
            }
            l3 = l2;
            return l3;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            l = l2;
            return l;
        }
        l = -l2;
        return l;
    }

    @Override
    public long scanLong(char c2) {
        long l;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.bp + n++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.bp + n++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.bp + n++);
        }
        if (c3 >= '0' && c3 <= '9') {
            boolean bl5;
            l = c3 - 48;
            while ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                l = l * 10L + (long)(c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            boolean bl6 = bl5 = l >= 0L || l == Long.MIN_VALUE && bl;
            if (!bl5) {
                String string = this.subString(this.bp, n - 1);
                throw new NumberFormatException(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                this.matchStat = 5;
                long l2 = 0L;
                n += 3;
                c3 = this.charAt(this.bp + n++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.bp + n++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp += n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return l2;
                    }
                    if (c3 == ']') {
                        this.bp += n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return l2;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.bp + n++);
                }
                this.matchStat = -1;
                return 0L;
            }
            this.matchStat = -1;
            return 0L;
        }
        if (bl2) {
            if (c3 != '\"') {
                this.matchStat = -1;
                return 0L;
            }
            c3 = this.charAt(this.bp + n++);
        }
        while (true) {
            if (c3 == c2) {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bl ? -l : l;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.bp + n++);
        }
        this.matchStat = -1;
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float scanFieldFloat(char[] cArray) {
        float f;
        char c2;
        int n;
        block35: {
            float f2;
            block34: {
                boolean bl;
                block33: {
                    int n2;
                    int n3;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    n = cArray.length;
                    boolean bl5 = bl = (c2 = this.charAt(this.bp + n++)) == '\"';
                    if (bl) {
                        c2 = this.charAt(this.bp + n++);
                    }
                    boolean bl6 = bl4 = c2 == '-';
                    if (bl4) {
                        c2 = this.charAt(this.bp + n++);
                    }
                    if (c2 < '0' || c2 > '9') break block33;
                    long l = c2 - 48;
                    while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                        l = l * 10L + (long)(c2 - 48);
                    }
                    long l2 = 1L;
                    boolean bl7 = bl3 = c2 == '.';
                    if (bl3) {
                        if ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                            l = l * 10L + (long)(c2 - 48);
                            l2 = 10L;
                            while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                l = l * 10L + (long)(c2 - 48);
                                l2 *= 10L;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                    if (bl2) {
                        if ((c2 = this.charAt(this.bp + n++)) == '+' || c2 == '-') {
                            c2 = this.charAt(this.bp + n++);
                        }
                        while (c2 >= '0' && c2 <= '9') {
                            c2 = this.charAt(this.bp + n++);
                        }
                    }
                    if (bl) {
                        if (c2 != '\"') {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                        c2 = this.charAt(this.bp + n++);
                        n3 = this.bp + cArray.length + 1;
                        n2 = this.bp + n - n3 - 2;
                    } else {
                        n3 = this.bp + cArray.length;
                        n2 = this.bp + n - n3 - 1;
                    }
                    if (!bl2 && n2 < 17) {
                        f2 = (float)((double)l / (double)l2);
                        if (bl4) {
                            f2 = -f2;
                        }
                        break block34;
                    } else {
                        String string = this.subString(n3, n2);
                        f2 = Float.parseFloat(string);
                    }
                    break block34;
                }
                if (c2 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                    this.matchStat = 5;
                    f = 0.0f;
                    n += 3;
                    c2 = this.charAt(this.bp + n++);
                    if (bl && c2 == '\"') {
                        c2 = this.charAt(this.bp + n++);
                    }
                    break block35;
                } else {
                    this.matchStat = -1;
                    return 0.0f;
                }
            }
            if (c2 == ',') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return f2;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return 0.0f;
            }
            if ((c2 = this.charAt(this.bp + n++)) == ',') {
                this.token = 16;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c2 == ']') {
                this.token = 15;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c2 == '}') {
                this.token = 13;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return 0.0f;
                }
                this.bp += n - 1;
                this.token = 20;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return f2;
        }
        while (true) {
            if (c2 == ',') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return f;
            }
            if (c2 == '}') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return f;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return 0.0f;
            }
            c2 = this.charAt(this.bp + n++);
        }
    }

    @Override
    public final float scanFloat(char c2) {
        float f;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.bp + n++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.bp + n++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.bp + n++);
        }
        if (c3 >= '0' && c3 <= '9') {
            int n2;
            int n3;
            boolean bl5;
            boolean bl6;
            long l = c3 - 48;
            while ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                l = l * 10L + (long)(c3 - 48);
            }
            long l2 = 1L;
            boolean bl7 = bl6 = c3 == '.';
            if (bl6) {
                if ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                    l = l * 10L + (long)(c3 - 48);
                    l2 = 10L;
                    while ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                        l = l * 10L + (long)(c3 - 48);
                        l2 *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0f;
                }
            }
            boolean bl8 = bl5 = c3 == 'e' || c3 == 'E';
            if (bl5) {
                if ((c3 = this.charAt(this.bp + n++)) == '+' || c3 == '-') {
                    c3 = this.charAt(this.bp + n++);
                }
                while (c3 >= '0' && c3 <= '9') {
                    c3 = this.charAt(this.bp + n++);
                }
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0.0f;
                }
                c3 = this.charAt(this.bp + n++);
                n3 = this.bp + 1;
                n2 = this.bp + n - n3 - 2;
            } else {
                n3 = this.bp;
                n2 = this.bp + n - n3 - 1;
            }
            if (!bl5 && n2 < 17) {
                f = (float)((double)l / (double)l2);
                if (bl) {
                    f = -f;
                }
            } else {
                String string = this.subString(n3, n2);
                f = Float.parseFloat(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                this.matchStat = 5;
                float f2 = 0.0f;
                n += 3;
                c3 = this.charAt(this.bp + n++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.bp + n++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp += n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return f2;
                    }
                    if (c3 == ']') {
                        this.bp += n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return f2;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.bp + n++);
                }
                this.matchStat = -1;
                return 0.0f;
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (c3 == c2) {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return f;
        }
        this.matchStat = -1;
        return f;
    }

    @Override
    public double scanDouble(char c2) {
        double d2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.bp + n++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.bp + n++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.bp + n++);
        }
        if (c3 >= '0' && c3 <= '9') {
            int n2;
            int n3;
            boolean bl5;
            boolean bl6;
            long l = c3 - 48;
            while ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                l = l * 10L + (long)(c3 - 48);
            }
            long l2 = 1L;
            boolean bl7 = bl6 = c3 == '.';
            if (bl6) {
                if ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                    l = l * 10L + (long)(c3 - 48);
                    l2 = 10L;
                    while ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                        l = l * 10L + (long)(c3 - 48);
                        l2 *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            boolean bl8 = bl5 = c3 == 'e' || c3 == 'E';
            if (bl5) {
                if ((c3 = this.charAt(this.bp + n++)) == '+' || c3 == '-') {
                    c3 = this.charAt(this.bp + n++);
                }
                while (c3 >= '0' && c3 <= '9') {
                    c3 = this.charAt(this.bp + n++);
                }
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0.0;
                }
                c3 = this.charAt(this.bp + n++);
                n3 = this.bp + 1;
                n2 = this.bp + n - n3 - 2;
            } else {
                n3 = this.bp;
                n2 = this.bp + n - n3 - 1;
            }
            if (!bl5 && n2 < 17) {
                d2 = (double)l / (double)l2;
                if (bl) {
                    d2 = -d2;
                }
            } else {
                String string = this.subString(n3, n2);
                d2 = Double.parseDouble(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                this.matchStat = 5;
                double d3 = 0.0;
                n += 3;
                c3 = this.charAt(this.bp + n++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.bp + n++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp += n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return d3;
                    }
                    if (c3 == ']') {
                        this.bp += n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return d3;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.bp + n++);
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (c3 == c2) {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return d2;
        }
        this.matchStat = -1;
        return d2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BigDecimal scanDecimal(char c2) {
        BigDecimal bigDecimal;
        char c3;
        int n;
        block31: {
            BigDecimal bigDecimal2;
            block29: {
                block30: {
                    boolean bl;
                    block28: {
                        int n2;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        this.matchStat = 0;
                        n = 0;
                        boolean bl5 = bl = (c3 = this.charAt(this.bp + n++)) == '\"';
                        if (bl) {
                            c3 = this.charAt(this.bp + n++);
                        }
                        boolean bl6 = bl4 = c3 == '-';
                        if (bl4) {
                            c3 = this.charAt(this.bp + n++);
                        }
                        if (c3 < '0' || c3 > '9') break block28;
                        while ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                        }
                        boolean bl7 = bl3 = c3 == '.';
                        if (bl3) {
                            if ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                                while ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl8 = bl2 = c3 == 'e' || c3 == 'E';
                        if (bl2) {
                            if ((c3 = this.charAt(this.bp + n++)) == '+' || c3 == '-') {
                                c3 = this.charAt(this.bp + n++);
                            }
                            while (c3 >= '0' && c3 <= '9') {
                                c3 = this.charAt(this.bp + n++);
                            }
                        }
                        if (bl) {
                            if (c3 != '\"') {
                                this.matchStat = -1;
                                return null;
                            }
                            c3 = this.charAt(this.bp + n++);
                            n3 = this.bp + 1;
                            n2 = this.bp + n - n3 - 2;
                        } else {
                            n3 = this.bp;
                            n2 = this.bp + n - n3 - 1;
                        }
                        char[] cArray = this.sub_chars(n3, n2);
                        bigDecimal2 = new BigDecimal(cArray);
                        if (c3 != ',') break block29;
                        break block30;
                    }
                    if (c3 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                        this.matchStat = 5;
                        bigDecimal = null;
                        n += 3;
                        c3 = this.charAt(this.bp + n++);
                        if (bl && c3 == '\"') {
                            c3 = this.charAt(this.bp + n++);
                        }
                        break block31;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bigDecimal2;
            }
            if (c3 != ']') {
                this.matchStat = -1;
                return null;
            }
            if ((c3 = this.charAt(this.bp + n++)) == ',') {
                this.token = 16;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c3 == ']') {
                this.token = 15;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c3 == '}') {
                this.token = 13;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else {
                if (c3 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.token = 20;
                this.bp += n - 1;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return bigDecimal2;
        }
        while (true) {
            if (c3 == ',') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return bigDecimal;
            }
            if (c3 == '}') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return bigDecimal;
            }
            if (!JSONLexerBase.isWhitespace(c3)) {
                this.matchStat = -1;
                return null;
            }
            c3 = this.charAt(this.bp + n++);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final float[] scanFieldFloatArray(char[] cArray) {
        void var4_8;
        char c2;
        int n;
        block27: {
            void var4_5;
            int n2;
            block28: {
                block26: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    n = cArray.length;
                    if ((c2 = this.charAt(this.bp + n++)) != '[') {
                        this.matchStat = -2;
                        return null;
                    }
                    c2 = this.charAt(this.bp + n++);
                    float[] fArray = new float[16];
                    n2 = 0;
                    while (true) {
                        Object object;
                        float f;
                        boolean bl;
                        boolean bl2;
                        boolean bl3;
                        int n3 = this.bp + n - 1;
                        boolean bl4 = bl3 = c2 == '-';
                        if (bl3) {
                            c2 = this.charAt(this.bp + n++);
                        }
                        if (c2 < '0' || c2 > '9') break block26;
                        int n4 = c2 - 48;
                        while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                            n4 = n4 * 10 + (c2 - 48);
                        }
                        int n5 = 1;
                        boolean bl5 = bl2 = c2 == '.';
                        if (bl2) {
                            c2 = this.charAt(this.bp + n++);
                            n5 = 10;
                            if (c2 >= '0' && c2 <= '9') {
                                n4 = n4 * 10 + (c2 - 48);
                                while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                    n4 = n4 * 10 + (c2 - 48);
                                    n5 *= 10;
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl6 = bl = c2 == 'e' || c2 == 'E';
                        if (bl) {
                            if ((c2 = this.charAt(this.bp + n++)) == '+' || c2 == '-') {
                                c2 = this.charAt(this.bp + n++);
                            }
                            while (c2 >= '0' && c2 <= '9') {
                                c2 = this.charAt(this.bp + n++);
                            }
                        }
                        int n6 = this.bp + n - n3 - 1;
                        if (!bl && n6 < 10) {
                            f = (float)n4 / (float)n5;
                            if (bl3) {
                                f = -f;
                            }
                        } else {
                            object = this.subString(n3, n6);
                            f = Float.parseFloat((String)object);
                        }
                        if (n2 >= ((void)var4_5).length) {
                            object = new float[((void)var4_5).length * 3 / 2];
                            System.arraycopy(var4_5, 0, object, 0, n2);
                            Object object2 = object;
                        }
                        var4_5[n2++] = f;
                        if (c2 == ',') {
                            c2 = this.charAt(this.bp + n++);
                            continue;
                        }
                        if (c2 == ']') break;
                    }
                    c2 = this.charAt(this.bp + n++);
                    if (n2 == ((void)var4_5).length) break block27;
                    break block28;
                }
                this.matchStat = -1;
                return null;
            }
            float[] fArray = new float[n2];
            System.arraycopy(var4_5, 0, fArray, 0, n2);
            float[] fArray2 = fArray;
        }
        if (c2 == ',') {
            this.bp += n - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return var4_8;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n - 1;
            this.next();
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n - 1;
            this.next();
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return var4_8;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final float[][] scanFieldFloatArray2(char[] cArray) {
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return null;
        }
        int n = cArray.length;
        if ((c2 = this.charAt(this.bp + n++)) != '[') {
            this.matchStat = -2;
            return null;
        }
        c2 = this.charAt(this.bp + n++);
        float[][] fArrayArray = new float[16][];
        int n2 = 0;
        while (c2 == '[') {
            void var6_6;
            int n3;
            block31: {
                void var6_8;
                block32: {
                    block30: {
                        c2 = this.charAt(this.bp + n++);
                        float[] fArray = new float[16];
                        n3 = 0;
                        while (true) {
                            Object object;
                            float f;
                            boolean bl;
                            boolean bl2;
                            int n4 = this.bp + n - 1;
                            boolean bl3 = bl2 = c2 == '-';
                            if (bl2) {
                                c2 = this.charAt(this.bp + n++);
                            }
                            if (c2 < '0' || c2 > '9') break block30;
                            int n5 = c2 - 48;
                            while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                n5 = n5 * 10 + (c2 - 48);
                            }
                            int n6 = 1;
                            if (c2 == '.') {
                                if ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                    n5 = n5 * 10 + (c2 - 48);
                                    n6 = 10;
                                    while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                        n5 = n5 * 10 + (c2 - 48);
                                        n6 *= 10;
                                    }
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            boolean bl4 = bl = c2 == 'e' || c2 == 'E';
                            if (bl) {
                                if ((c2 = this.charAt(this.bp + n++)) == '+' || c2 == '-') {
                                    c2 = this.charAt(this.bp + n++);
                                }
                                while (c2 >= '0' && c2 <= '9') {
                                    c2 = this.charAt(this.bp + n++);
                                }
                            }
                            int n7 = this.bp + n - n4 - 1;
                            if (!bl && n7 < 10) {
                                f = (float)n5 / (float)n6;
                                if (bl2) {
                                    f = -f;
                                }
                            } else {
                                object = this.subString(n4, n7);
                                f = Float.parseFloat((String)object);
                            }
                            if (n3 >= ((void)var6_8).length) {
                                object = new float[((void)var6_8).length * 3 / 2];
                                System.arraycopy(var6_8, 0, object, 0, n3);
                                Object object2 = object;
                            }
                            var6_8[n3++] = f;
                            if (c2 == ',') {
                                c2 = this.charAt(this.bp + n++);
                                continue;
                            }
                            if (c2 == ']') break;
                        }
                        c2 = this.charAt(this.bp + n++);
                        if (n3 == ((void)var6_8).length) break block31;
                        break block32;
                    }
                    this.matchStat = -1;
                    return null;
                }
                float[] fArray = new float[n3];
                System.arraycopy(var6_8, 0, fArray, 0, n3);
                float[] fArray2 = fArray;
            }
            if (n2 >= fArrayArray.length) {
                float[][] fArrayArray2 = new float[fArrayArray.length * 3 / 2][];
                System.arraycopy(var6_6, 0, fArrayArray2, 0, n3);
                fArrayArray = fArrayArray2;
            }
            fArrayArray[n2++] = var6_6;
            if (c2 == ',') {
                c2 = this.charAt(this.bp + n++);
                continue;
            }
            if (c2 != ']') continue;
            c2 = this.charAt(this.bp + n++);
            break;
        }
        if (n2 != fArrayArray.length) {
            float[][] fArrayArray3 = new float[n2][];
            System.arraycopy(fArrayArray, 0, fArrayArray3, 0, n2);
            fArrayArray = fArrayArray3;
        }
        if (c2 == ',') {
            this.bp += n - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return fArrayArray;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n - 1;
            this.next();
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n - 1;
            this.next();
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return fArrayArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double scanFieldDouble(char[] cArray) {
        double d2;
        char c2;
        int n;
        block35: {
            double d3;
            block34: {
                boolean bl;
                block33: {
                    int n2;
                    int n3;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    n = cArray.length;
                    boolean bl5 = bl = (c2 = this.charAt(this.bp + n++)) == '\"';
                    if (bl) {
                        c2 = this.charAt(this.bp + n++);
                    }
                    boolean bl6 = bl4 = c2 == '-';
                    if (bl4) {
                        c2 = this.charAt(this.bp + n++);
                    }
                    if (c2 < '0' || c2 > '9') break block33;
                    long l = c2 - 48;
                    while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                        l = l * 10L + (long)(c2 - 48);
                    }
                    long l2 = 1L;
                    boolean bl7 = bl3 = c2 == '.';
                    if (bl3) {
                        if ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                            l = l * 10L + (long)(c2 - 48);
                            l2 = 10L;
                            while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                l = l * 10L + (long)(c2 - 48);
                                l2 *= 10L;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                    if (bl2) {
                        if ((c2 = this.charAt(this.bp + n++)) == '+' || c2 == '-') {
                            c2 = this.charAt(this.bp + n++);
                        }
                        while (c2 >= '0' && c2 <= '9') {
                            c2 = this.charAt(this.bp + n++);
                        }
                    }
                    if (bl) {
                        if (c2 != '\"') {
                            this.matchStat = -1;
                            return 0.0;
                        }
                        c2 = this.charAt(this.bp + n++);
                        n3 = this.bp + cArray.length + 1;
                        n2 = this.bp + n - n3 - 2;
                    } else {
                        n3 = this.bp + cArray.length;
                        n2 = this.bp + n - n3 - 1;
                    }
                    if (!bl2 && n2 < 17) {
                        d3 = (double)l / (double)l2;
                        if (bl4) {
                            d3 = -d3;
                        }
                        break block34;
                    } else {
                        String string = this.subString(n3, n2);
                        d3 = Double.parseDouble(string);
                    }
                    break block34;
                }
                if (c2 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                    this.matchStat = 5;
                    d2 = 0.0;
                    n += 3;
                    c2 = this.charAt(this.bp + n++);
                    if (bl && c2 == '\"') {
                        c2 = this.charAt(this.bp + n++);
                    }
                    break block35;
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            if (c2 == ',') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return d3;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return 0.0;
            }
            if ((c2 = this.charAt(this.bp + n++)) == ',') {
                this.token = 16;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c2 == ']') {
                this.token = 15;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c2 == '}') {
                this.token = 13;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return 0.0;
                }
                this.token = 20;
                this.bp += n - 1;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return d3;
        }
        while (true) {
            if (c2 == ',') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return d2;
            }
            if (c2 == '}') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return d2;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return 0.0;
            }
            c2 = this.charAt(this.bp + n++);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public BigDecimal scanFieldDecimal(char[] cArray) {
        BigDecimal bigDecimal;
        char c2;
        int n;
        block32: {
            BigDecimal bigDecimal2;
            block30: {
                block31: {
                    boolean bl;
                    block29: {
                        int n2;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        this.matchStat = 0;
                        if (!this.charArrayCompare(cArray)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n = cArray.length;
                        boolean bl5 = bl = (c2 = this.charAt(this.bp + n++)) == '\"';
                        if (bl) {
                            c2 = this.charAt(this.bp + n++);
                        }
                        boolean bl6 = bl4 = c2 == '-';
                        if (bl4) {
                            c2 = this.charAt(this.bp + n++);
                        }
                        if (c2 < '0' || c2 > '9') break block29;
                        while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                        }
                        boolean bl7 = bl3 = c2 == '.';
                        if (bl3) {
                            if ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                        if (bl2) {
                            if ((c2 = this.charAt(this.bp + n++)) == '+' || c2 == '-') {
                                c2 = this.charAt(this.bp + n++);
                            }
                            while (c2 >= '0' && c2 <= '9') {
                                c2 = this.charAt(this.bp + n++);
                            }
                        }
                        if (bl) {
                            if (c2 != '\"') {
                                this.matchStat = -1;
                                return null;
                            }
                            c2 = this.charAt(this.bp + n++);
                            n3 = this.bp + cArray.length + 1;
                            n2 = this.bp + n - n3 - 2;
                        } else {
                            n3 = this.bp + cArray.length;
                            n2 = this.bp + n - n3 - 1;
                        }
                        char[] cArray2 = this.sub_chars(n3, n2);
                        bigDecimal2 = new BigDecimal(cArray2);
                        if (c2 != ',') break block30;
                        break block31;
                    }
                    if (c2 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                        this.matchStat = 5;
                        bigDecimal = null;
                        n += 3;
                        c2 = this.charAt(this.bp + n++);
                        if (bl && c2 == '\"') {
                            c2 = this.charAt(this.bp + n++);
                        }
                        break block32;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bigDecimal2;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return null;
            }
            if ((c2 = this.charAt(this.bp + n++)) == ',') {
                this.token = 16;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c2 == ']') {
                this.token = 15;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c2 == '}') {
                this.token = 13;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.token = 20;
                this.bp += n - 1;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return bigDecimal2;
        }
        while (true) {
            if (c2 == ',') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return bigDecimal;
            }
            if (c2 == '}') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return bigDecimal;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp + n++);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public BigInteger scanFieldBigInteger(char[] cArray) {
        BigInteger bigInteger;
        char c2;
        int n;
        block28: {
            BigInteger bigInteger2;
            int n2;
            int n3;
            boolean bl;
            long l;
            boolean bl2;
            boolean bl3;
            block27: {
                block26: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    n = cArray.length;
                    boolean bl4 = bl3 = (c2 = this.charAt(this.bp + n++)) == '\"';
                    if (bl3) {
                        c2 = this.charAt(this.bp + n++);
                    }
                    boolean bl5 = bl2 = c2 == '-';
                    if (bl2) {
                        c2 = this.charAt(this.bp + n++);
                    }
                    if (c2 < '0' || c2 > '9') break block26;
                    l = c2 - 48;
                    bl = false;
                    break block27;
                }
                if (c2 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                    this.matchStat = 5;
                    bigInteger = null;
                    n += 3;
                    c2 = this.charAt(this.bp + n++);
                    if (bl3 && c2 == '\"') {
                        c2 = this.charAt(this.bp + n++);
                    }
                    break block28;
                } else {
                    this.matchStat = -1;
                    return null;
                }
            }
            while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                long l2 = l * 10L + (long)(c2 - 48);
                if (l2 < l) {
                    bl = true;
                    break;
                }
                l = l2;
            }
            if (bl3) {
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                c2 = this.charAt(this.bp + n++);
                n3 = this.bp + cArray.length + 1;
                n2 = this.bp + n - n3 - 2;
            } else {
                n3 = this.bp + cArray.length;
                n2 = this.bp + n - n3 - 1;
            }
            if (!bl && (n2 < 20 || bl2 && n2 < 21)) {
                bigInteger2 = BigInteger.valueOf(bl2 ? -l : l);
            } else {
                String string = this.subString(n3, n2);
                bigInteger2 = new BigInteger(string);
            }
            if (c2 == ',') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bigInteger2;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return null;
            }
            if ((c2 = this.charAt(this.bp + n++)) == ',') {
                this.token = 16;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c2 == ']') {
                this.token = 15;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else if (c2 == '}') {
                this.token = 13;
                this.bp += n;
                this.ch = this.charAt(this.bp);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.token = 20;
                this.bp += n - 1;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return bigInteger2;
        }
        while (true) {
            if (c2 == ',') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return bigInteger;
            }
            if (c2 == '}') {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return bigInteger;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp + n++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanFieldDate(char[] cArray) {
        Date date;
        char c2;
        int n;
        block25: {
            Object object;
            String string;
            int n2;
            block27: {
                block28: {
                    block26: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare(cArray)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n = cArray.length;
                        if ((c2 = this.charAt(this.bp + n++)) != '\"') break block26;
                        int n3 = this.bp + cArray.length + 1;
                        n2 = this.indexOf('\"', n3);
                        if (n2 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n4 = this.bp + cArray.length + 1;
                        string = this.subString(n4, n2 - n4);
                        if (string.indexOf(92) == -1) break block27;
                        break block28;
                    }
                    if (c2 == '-' || c2 >= '0' && c2 <= '9') {
                        long l = 0L;
                        boolean bl = false;
                        if (c2 == '-') {
                            c2 = this.charAt(this.bp + n++);
                            bl = true;
                        }
                        if (c2 >= '0' && c2 <= '9') {
                            l = c2 - 48;
                            while ((c2 = this.charAt(this.bp + n++)) >= '0' && c2 <= '9') {
                                l = l * 10L + (long)(c2 - 48);
                            }
                        }
                        if (l < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l = -l;
                        }
                        date = new Date(l);
                        break block25;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    int n5 = 0;
                    for (int i = n2 - 1; i >= 0 && this.charAt(i) == '\\'; ++n5, --i) {
                    }
                    if (n5 % 2 == 0) {
                        n5 = n2 - (this.bp + cArray.length + 1);
                        object = this.sub_chars(this.bp + cArray.length + 1, n5);
                        string = JSONLexerBase.readString((char[])object, n5);
                        break;
                    }
                    n2 = this.indexOf('\"', n2 + 1);
                }
            }
            n += n2 - (this.bp + cArray.length + 1) + 1;
            c2 = this.charAt(this.bp + n++);
            try (JSONScanner jSONScanner = new JSONScanner(string);){
                if (!jSONScanner.scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    object = null;
                    return object;
                }
                object = jSONScanner.getCalendar();
                date = ((Calendar)object).getTime();
            }
        }
        if (c2 == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return date;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanDate(char c2) {
        Date date;
        char c3;
        int n;
        block26: {
            Object object;
            String string;
            int n2;
            block28: {
                block29: {
                    block27: {
                        this.matchStat = 0;
                        n = 0;
                        if ((c3 = this.charAt(this.bp + n++)) != '\"') break block27;
                        int n3 = this.bp + 1;
                        n2 = this.indexOf('\"', n3);
                        if (n2 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n4 = this.bp + 1;
                        string = this.subString(n4, n2 - n4);
                        if (string.indexOf(92) == -1) break block28;
                        break block29;
                    }
                    if (c3 == '-' || c3 >= '0' && c3 <= '9') {
                        long l = 0L;
                        boolean bl = false;
                        if (c3 == '-') {
                            c3 = this.charAt(this.bp + n++);
                            bl = true;
                        }
                        if (c3 >= '0' && c3 <= '9') {
                            l = c3 - 48;
                            while ((c3 = this.charAt(this.bp + n++)) >= '0' && c3 <= '9') {
                                l = l * 10L + (long)(c3 - 48);
                            }
                        }
                        if (l < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l = -l;
                        }
                        date = new Date(l);
                        break block26;
                    } else if (c3 == 'n' && this.charAt(this.bp + n) == 'u' && this.charAt(this.bp + n + 1) == 'l' && this.charAt(this.bp + n + 2) == 'l') {
                        this.matchStat = 5;
                        date = null;
                        n += 3;
                        c3 = this.charAt(this.bp + n++);
                        break block26;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    int n5 = 0;
                    for (int i = n2 - 1; i >= 0 && this.charAt(i) == '\\'; ++n5, --i) {
                    }
                    if (n5 % 2 == 0) {
                        n5 = n2 - (this.bp + 1);
                        object = this.sub_chars(this.bp + 1, n5);
                        string = JSONLexerBase.readString((char[])object, n5);
                        break;
                    }
                    n2 = this.indexOf('\"', n2 + 1);
                }
            }
            n += n2 - (this.bp + 1) + 1;
            c3 = this.charAt(this.bp + n++);
            try (JSONScanner jSONScanner = new JSONScanner(string);){
                if (!jSONScanner.scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    object = null;
                    return object;
                }
                object = jSONScanner.getCalendar();
                date = ((Calendar)object).getTime();
            }
        }
        if (c3 == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return date;
        }
        if (c3 != ']') {
            this.matchStat = -1;
            return null;
        }
        if ((c3 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c3 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c3 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c3 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return date;
    }

    /*
     * Enabled aggressive block sorting
     */
    public UUID scanFieldUUID(char[] cArray) {
        UUID uUID;
        char c2;
        int n;
        block63: {
            char c3;
            int n2;
            int n3;
            long l;
            long l2;
            int n4;
            int n5;
            block67: {
                char c4;
                int n6;
                int n7;
                long l3;
                long l4;
                block66: {
                    block64: {
                        int n8;
                        block65: {
                            this.matchStat = 0;
                            if (!this.charArrayCompare(cArray)) {
                                this.matchStat = -2;
                                return null;
                            }
                            n = cArray.length;
                            if ((c2 = this.charAt(this.bp + n++)) != '\"') break block64;
                            int n9 = this.bp + cArray.length + 1;
                            n5 = this.indexOf('\"', n9);
                            if (n5 == -1) {
                                throw new JSONException("unclosed str");
                            }
                            n4 = this.bp + cArray.length + 1;
                            n8 = n5 - n4;
                            if (n8 != 36) break block65;
                            l4 = 0L;
                            l3 = 0L;
                            break block66;
                        }
                        if (n8 != 32) {
                            this.matchStat = -1;
                            return null;
                        }
                        l2 = 0L;
                        l = 0L;
                        break block67;
                    }
                    if (c2 == 'n' && this.charAt(this.bp + n++) == 'u' && this.charAt(this.bp + n++) == 'l' && this.charAt(this.bp + n++) == 'l') {
                        uUID = null;
                        c2 = this.charAt(this.bp + n++);
                        break block63;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                for (n6 = 0; n6 < 8; l4 |= (long)n7, ++n6) {
                    c4 = this.charAt(n4 + n6);
                    if (c4 >= '0' && c4 <= '9') {
                        n7 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n7 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n7 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n6 = 9; n6 < 13; l4 |= (long)n7, ++n6) {
                    c4 = this.charAt(n4 + n6);
                    if (c4 >= '0' && c4 <= '9') {
                        n7 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n7 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n7 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n6 = 14; n6 < 18; l4 |= (long)n7, ++n6) {
                    c4 = this.charAt(n4 + n6);
                    if (c4 >= '0' && c4 <= '9') {
                        n7 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n7 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n7 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n6 = 19; n6 < 23; l3 |= (long)n7, ++n6) {
                    c4 = this.charAt(n4 + n6);
                    if (c4 >= '0' && c4 <= '9') {
                        n7 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n7 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n7 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l3 <<= 4;
                }
                for (n6 = 24; n6 < 36; l3 |= (long)n7, ++n6) {
                    c4 = this.charAt(n4 + n6);
                    if (c4 >= '0' && c4 <= '9') {
                        n7 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n7 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n7 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l3 <<= 4;
                }
                uUID = new UUID(l4, l3);
                n += n5 - (this.bp + cArray.length + 1) + 1;
                c2 = this.charAt(this.bp + n++);
                break block63;
            }
            for (n2 = 0; n2 < 16; l2 |= (long)n3, ++n2) {
                c3 = this.charAt(n4 + n2);
                if (c3 >= '0' && c3 <= '9') {
                    n3 = c3 - 48;
                } else if (c3 >= 'a' && c3 <= 'f') {
                    n3 = 10 + (c3 - 97);
                } else if (c3 >= 'A' && c3 <= 'F') {
                    n3 = 10 + (c3 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l2 <<= 4;
            }
            for (n2 = 16; n2 < 32; l |= (long)n3, ++n2) {
                c3 = this.charAt(n4 + n2);
                if (c3 >= '0' && c3 <= '9') {
                    n3 = c3 - 48;
                } else if (c3 >= 'a' && c3 <= 'f') {
                    n3 = 10 + (c3 - 97);
                } else if (c3 >= 'A' && c3 <= 'F') {
                    n3 = 10 + (c3 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l <<= 4;
            }
            uUID = new UUID(l2, l);
            n += n5 - (this.bp + cArray.length + 1) + 1;
            c2 = this.charAt(this.bp + n++);
        }
        if (c2 == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return uUID;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return uUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    public UUID scanUUID(char c2) {
        UUID uUID;
        char c3;
        int n;
        block62: {
            char c4;
            int n2;
            int n3;
            long l;
            long l2;
            int n4;
            int n5;
            block66: {
                char c5;
                int n6;
                int n7;
                long l3;
                long l4;
                block65: {
                    block63: {
                        int n8;
                        block64: {
                            this.matchStat = 0;
                            n = 0;
                            if ((c3 = this.charAt(this.bp + n++)) != '\"') break block63;
                            int n9 = this.bp + 1;
                            n5 = this.indexOf('\"', n9);
                            if (n5 == -1) {
                                throw new JSONException("unclosed str");
                            }
                            n4 = this.bp + 1;
                            n8 = n5 - n4;
                            if (n8 != 36) break block64;
                            l4 = 0L;
                            l3 = 0L;
                            break block65;
                        }
                        if (n8 != 32) {
                            this.matchStat = -1;
                            return null;
                        }
                        l2 = 0L;
                        l = 0L;
                        break block66;
                    }
                    if (c3 == 'n' && this.charAt(this.bp + n++) == 'u' && this.charAt(this.bp + n++) == 'l' && this.charAt(this.bp + n++) == 'l') {
                        uUID = null;
                        c3 = this.charAt(this.bp + n++);
                        break block62;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                for (n6 = 0; n6 < 8; l4 |= (long)n7, ++n6) {
                    c5 = this.charAt(n4 + n6);
                    if (c5 >= '0' && c5 <= '9') {
                        n7 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n7 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n7 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n6 = 9; n6 < 13; l4 |= (long)n7, ++n6) {
                    c5 = this.charAt(n4 + n6);
                    if (c5 >= '0' && c5 <= '9') {
                        n7 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n7 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n7 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n6 = 14; n6 < 18; l4 |= (long)n7, ++n6) {
                    c5 = this.charAt(n4 + n6);
                    if (c5 >= '0' && c5 <= '9') {
                        n7 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n7 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n7 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n6 = 19; n6 < 23; l3 |= (long)n7, ++n6) {
                    c5 = this.charAt(n4 + n6);
                    if (c5 >= '0' && c5 <= '9') {
                        n7 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n7 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n7 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l3 <<= 4;
                }
                for (n6 = 24; n6 < 36; l3 |= (long)n7, ++n6) {
                    c5 = this.charAt(n4 + n6);
                    if (c5 >= '0' && c5 <= '9') {
                        n7 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n7 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n7 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l3 <<= 4;
                }
                uUID = new UUID(l4, l3);
                n += n5 - (this.bp + 1) + 1;
                c3 = this.charAt(this.bp + n++);
                break block62;
            }
            for (n2 = 0; n2 < 16; l2 |= (long)n3, ++n2) {
                c4 = this.charAt(n4 + n2);
                if (c4 >= '0' && c4 <= '9') {
                    n3 = c4 - 48;
                } else if (c4 >= 'a' && c4 <= 'f') {
                    n3 = 10 + (c4 - 97);
                } else if (c4 >= 'A' && c4 <= 'F') {
                    n3 = 10 + (c4 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l2 <<= 4;
            }
            for (n2 = 16; n2 < 32; l |= (long)n3, ++n2) {
                c4 = this.charAt(n4 + n2);
                if (c4 >= '0' && c4 <= '9') {
                    n3 = c4 - 48;
                } else if (c4 >= 'a' && c4 <= 'f') {
                    n3 = 10 + (c4 - 97);
                } else if (c4 >= 'A' && c4 <= 'F') {
                    n3 = 10 + (c4 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l <<= 4;
            }
            uUID = new UUID(l2, l);
            n += n5 - (this.bp + 1) + 1;
            c3 = this.charAt(this.bp + n++);
        }
        if (c3 == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return uUID;
        }
        if (c3 != ']') {
            this.matchStat = -1;
            return null;
        }
        if ((c3 = this.charAt(this.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c3 == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c3 == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c3 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return uUID;
    }

    public final void scanTrue() {
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'u') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b' && this.ch != ':' && this.ch != '/') {
            throw new JSONException("scan true error");
        }
        this.token = 6;
    }

    public final void scanNullOrNew() {
        this.scanNullOrNew(true);
    }

    public final void scanNullOrNew(boolean bl) {
        if (this.ch != 'n') {
            throw new JSONException("error parse null or new");
        }
        this.next();
        if (this.ch == 'u') {
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (!(this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == ':' && bl || this.ch == '\f' || this.ch == '\b')) {
                throw new JSONException("scan null error");
            }
            this.token = 8;
            return;
        }
        if (this.ch != 'e') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.ch != 'w') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan new error");
        }
        this.token = 9;
    }

    public final void scanFalse() {
        if (this.ch != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'a') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'l') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 's') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b' && this.ch != ':' && this.ch != '/') {
            throw new JSONException("scan false error");
        }
        this.token = 7;
    }

    public final void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String string = this.stringVal();
        this.token = "null".equalsIgnoreCase(string) ? 8 : ("new".equals(string) ? 9 : ("true".equals(string) ? 6 : ("false".equals(string) ? 7 : ("undefined".equals(string) ? 23 : ("Set".equals(string) ? 21 : ("TreeSet".equals(string) ? 22 : 18))))));
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    protected abstract char[] sub_chars(int var1, int var2);

    public static String readString(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        int n2 = 0;
        block22: for (int i = 0; i < n; ++i) {
            char c2 = cArray[i];
            if (c2 != '\\') {
                cArray2[n2++] = c2;
                continue;
            }
            c2 = cArray[++i];
            switch (c2) {
                case '0': {
                    cArray2[n2++] = '\u0000';
                    continue block22;
                }
                case '1': {
                    cArray2[n2++] = '\u0001';
                    continue block22;
                }
                case '2': {
                    cArray2[n2++] = 2;
                    continue block22;
                }
                case '3': {
                    cArray2[n2++] = 3;
                    continue block22;
                }
                case '4': {
                    cArray2[n2++] = 4;
                    continue block22;
                }
                case '5': {
                    cArray2[n2++] = 5;
                    continue block22;
                }
                case '6': {
                    cArray2[n2++] = 6;
                    continue block22;
                }
                case '7': {
                    cArray2[n2++] = 7;
                    continue block22;
                }
                case 'b': {
                    cArray2[n2++] = 8;
                    continue block22;
                }
                case 't': {
                    cArray2[n2++] = 9;
                    continue block22;
                }
                case 'n': {
                    cArray2[n2++] = 10;
                    continue block22;
                }
                case 'v': {
                    cArray2[n2++] = 11;
                    continue block22;
                }
                case 'F': 
                case 'f': {
                    cArray2[n2++] = 12;
                    continue block22;
                }
                case 'r': {
                    cArray2[n2++] = 13;
                    continue block22;
                }
                case '\"': {
                    cArray2[n2++] = 34;
                    continue block22;
                }
                case '\'': {
                    cArray2[n2++] = 39;
                    continue block22;
                }
                case '/': {
                    cArray2[n2++] = 47;
                    continue block22;
                }
                case '\\': {
                    cArray2[n2++] = 92;
                    continue block22;
                }
                case 'x': {
                    cArray2[n2++] = (char)(digits[cArray[++i]] * 16 + digits[cArray[++i]]);
                    continue block22;
                }
                case 'u': {
                    cArray2[n2++] = (char)Integer.parseInt(new String(new char[]{cArray[++i], cArray[++i], cArray[++i], cArray[++i]}), 16);
                    continue block22;
                }
                default: {
                    throw new JSONException("unclosed.str.lit");
                }
            }
        }
        return new String(cArray2, 0, n2);
    }

    protected abstract boolean charArrayCompare(char[] var1);

    @Override
    public boolean isBlankInput() {
        int n = 0;
        while (true) {
            char c2;
            if ((c2 = this.charAt(n)) == '\u001a') break;
            if (!JSONLexerBase.isWhitespace(c2)) {
                return false;
            }
            ++n;
        }
        this.token = 20;
        return true;
    }

    @Override
    public final void skipWhitespace() {
        while (this.ch <= '/') {
            if (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b') {
                this.next();
                continue;
            }
            if (this.ch != '/') break;
            this.skipComment();
        }
    }

    private void scanStringSingleQuote() {
        char c2;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((c2 = this.next()) != '\'') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.putChar('\u001a');
                    continue;
                }
                throw new JSONException("unclosed single-quote string");
            }
            if (c2 == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] cArray = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    this.copyTo(this.np + 1, this.sp, this.sbuf);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        boolean bl;
                        char c3 = this.next();
                        char c4 = this.next();
                        boolean bl2 = c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F';
                        boolean bl3 = bl = c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F';
                        if (!bl2 || !bl) {
                            throw new JSONException("invalid escape character \\x" + c3 + c4);
                        }
                        this.putChar((char)(digits[c3] * 16 + digits[c4]));
                        continue block22;
                    }
                    case 'u': {
                        this.putChar((char)Integer.parseInt(new String(new char[]{this.next(), this.next(), this.next(), this.next()}), 16));
                        continue block22;
                    }
                }
                this.ch = c2;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c2);
                continue;
            }
            this.sbuf[this.sp++] = c2;
        }
        this.token = 4;
        this.next();
    }

    protected final void putChar(char c2) {
        if (this.sp == this.sbuf.length) {
            char[] cArray = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
            this.sbuf = cArray;
        }
        this.sbuf[this.sp++] = c2;
    }

    public final void scanHex() {
        if (this.ch != 'x') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.next();
        if (this.ch != '\'') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.np = this.bp;
        this.next();
        if (this.ch == '\'') {
            this.next();
            this.token = 26;
            return;
        }
        int n = 0;
        while (true) {
            char c2;
            if ((c2 = this.next()) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F') {
                ++this.sp;
            } else {
                if (c2 == '\'') {
                    ++this.sp;
                    break;
                }
                throw new JSONException("illegal state. " + c2);
            }
            ++n;
        }
        this.next();
        this.token = 26;
    }

    @Override
    public final void scanNumber() {
        this.np = this.bp;
        if (this.ch == '-') {
            ++this.sp;
            this.next();
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.next();
        }
        boolean bl = false;
        if (this.ch == '.') {
            ++this.sp;
            this.next();
            bl = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.next();
            }
        }
        if (this.ch == 'L') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'S') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'B') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'F') {
            ++this.sp;
            this.next();
            bl = true;
        } else if (this.ch == 'D') {
            ++this.sp;
            this.next();
            bl = true;
        } else if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.next();
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.next();
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.next();
            }
            if (this.ch == 'D' || this.ch == 'F') {
                ++this.sp;
                this.next();
            }
            bl = true;
        }
        this.token = bl ? 3 : 2;
    }

    @Override
    public final long longValue() throws NumberFormatException {
        char c2;
        int n;
        long l;
        long l2 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int n2 = this.np;
        int n3 = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n2;
        } else {
            l = -9223372036854775807L;
        }
        long l3 = -922337203685477580L;
        if (n2 < n3) {
            n = this.charAt(n2++) - 48;
            l2 = -n;
        }
        while (n2 < n3 && (c2 = this.charAt(n2++)) != 'L' && c2 != 'S' && c2 != 'B') {
            n = c2 - 48;
            if (l2 < l3) {
                throw new NumberFormatException(this.numberString());
            }
            if ((l2 *= 10L) < l + (long)n) {
                throw new NumberFormatException(this.numberString());
            }
            l2 -= (long)n;
        }
        if (bl) {
            if (n2 > this.np + 1) {
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l2;
    }

    @Override
    public final Number decimalValue(boolean bl) {
        char c2 = this.charAt(this.np + this.sp - 1);
        try {
            if (c2 == 'F') {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            if (c2 == 'D') {
                return Double.parseDouble(this.numberString());
            }
            if (bl) {
                return this.decimalValue();
            }
            return this.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONException(numberFormatException.getMessage() + ", " + this.info());
        }
    }

    @Override
    public abstract BigDecimal decimalValue();

    public static boolean isWhitespace(char c2) {
        return c2 <= ' ' && (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\f' || c2 == '\b');
    }

    public String[] scanFieldStringArray(char[] cArray, int n, SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    public boolean matchField2(char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFeatures() {
        return this.features;
    }

    static {
        int n;
        SBUF_LOCAL = new ThreadLocal();
        typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
        digits = new int[103];
        for (n = 48; n <= 57; ++n) {
            JSONLexerBase.digits[n] = n - 48;
        }
        for (n = 97; n <= 102; ++n) {
            JSONLexerBase.digits[n] = n - 97 + 10;
        }
        for (n = 65; n <= 70; ++n) {
            JSONLexerBase.digits[n] = n - 65 + 10;
        }
    }
}

