/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser;

import com.icbc.api.internal.util.fastjson.parser.JSONLexerBase;
import com.icbc.api.internal.util.fastjson.parser.JSONToken;
import com.icbc.api.internal.util.fastjson.parser.SymbolTable;
import com.icbc.api.internal.util.fastjson.util.ASMUtils;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class JSONScanner
extends JSONLexerBase {
    private final String text;
    private final int len;

    public JSONScanner(String string) {
        this(string, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(String string, int n) {
        super(n);
        this.text = string;
        this.len = this.text.length();
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    @Override
    public final char charAt(int n) {
        if (n >= this.len) {
            return '\u001a';
        }
        return this.text.charAt(n);
    }

    @Override
    public final char next() {
        int n;
        char c2 = (n = ++this.bp) >= this.len ? (char)'\u001a' : (char)this.text.charAt(n);
        this.ch = c2;
        return c2;
    }

    public JSONScanner(char[] cArray, int n) {
        this(cArray, n, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(char[] cArray, int n, int n2) {
        this(new String(cArray, 0, n), n2);
    }

    @Override
    protected final void copyTo(int n, int n2, char[] cArray) {
        this.text.getChars(n, n + n2, cArray, 0);
    }

    static boolean charArrayCompare(String string, int n, char[] cArray) {
        int n2 = cArray.length;
        if (n2 + n > string.length()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] == string.charAt(n + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean charArrayCompare(char[] cArray) {
        return JSONScanner.charArrayCompare(this.text, this.bp, cArray);
    }

    @Override
    public final int indexOf(char c2, int n) {
        return this.text.indexOf(c2, n);
    }

    @Override
    public final String addSymbol(int n, int n2, int n3, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.text, n, n2, n3);
    }

    @Override
    public byte[] bytesValue() {
        if (this.token == 26) {
            int n = this.np + 1;
            int n2 = this.sp;
            if (n2 % 2 != 0) {
                throw new JSONException("illegal state. " + n2);
            }
            byte[] byArray = new byte[n2 / 2];
            for (int i = 0; i < byArray.length; ++i) {
                char c2 = this.text.charAt(n + i * 2);
                char c3 = this.text.charAt(n + i * 2 + 1);
                int n3 = c2 - (c2 <= '9' ? 48 : 55);
                int n4 = c3 - (c3 <= '9' ? 48 : 55);
                byArray[i] = (byte)(n3 << 4 | n4);
            }
            return byArray;
        }
        if (!this.hasSpecial) {
            return IOUtils.decodeBase64(this.text, this.np + 1, this.sp);
        }
        String string = new String(this.sbuf, 0, this.sp);
        return IOUtils.decodeBase64(string);
    }

    @Override
    public final String stringVal() {
        if (!this.hasSpecial) {
            return this.subString(this.np + 1, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    @Override
    public final String subString(int n, int n2) {
        if (ASMUtils.IS_ANDROID) {
            if (n2 < this.sbuf.length) {
                this.text.getChars(n, n + n2, this.sbuf, 0);
                return new String(this.sbuf, 0, n2);
            }
            char[] cArray = new char[n2];
            this.text.getChars(n, n + n2, cArray, 0);
            return new String(cArray);
        }
        return this.text.substring(n, n + n2);
    }

    @Override
    public final char[] sub_chars(int n, int n2) {
        if (ASMUtils.IS_ANDROID && n2 < this.sbuf.length) {
            this.text.getChars(n, n + n2, this.sbuf, 0);
            return this.sbuf;
        }
        char[] cArray = new char[n2];
        this.text.getChars(n, n + n2, cArray, 0);
        return cArray;
    }

    @Override
    public final String numberString() {
        char c2 = this.charAt(this.np + this.sp - 1);
        int n = this.sp;
        if (c2 == 'L' || c2 == 'S' || c2 == 'B' || c2 == 'F' || c2 == 'D') {
            --n;
        }
        return this.subString(this.np, n);
    }

    @Override
    public final BigDecimal decimalValue() {
        char c2 = this.charAt(this.np + this.sp - 1);
        int n = this.sp;
        if (c2 == 'L' || c2 == 'S' || c2 == 'B' || c2 == 'F' || c2 == 'D') {
            --n;
        }
        int n2 = this.np;
        int n3 = n;
        if (n3 < this.sbuf.length) {
            this.text.getChars(n2, n2 + n3, this.sbuf, 0);
            return new BigDecimal(this.sbuf, 0, n3);
        }
        char[] cArray = new char[n3];
        this.text.getChars(n2, n2 + n3, cArray, 0);
        return new BigDecimal(cArray);
    }

    public boolean scanISO8601DateIfMatch() {
        return this.scanISO8601DateIfMatch(true);
    }

    public boolean scanISO8601DateIfMatch(boolean bl) {
        int n = this.len - this.bp;
        return this.scanISO8601DateIfMatch(bl, n);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanISO8601DateIfMatch(boolean bl, int n) {
        char c2;
        int n2;
        char c3;
        char c4;
        char c5;
        char c6;
        char c7;
        char c8;
        int n3;
        char c9;
        char c10;
        char c11;
        char c12;
        char c13;
        char c14;
        char c15;
        if (n < 8) {
            return false;
        }
        char c16 = this.charAt(this.bp);
        char c17 = this.charAt(this.bp + 1);
        char c18 = this.charAt(this.bp + 2);
        char c19 = this.charAt(this.bp + 3);
        char c20 = this.charAt(this.bp + 4);
        char c21 = this.charAt(this.bp + 5);
        char c22 = this.charAt(this.bp + 6);
        char c23 = this.charAt(this.bp + 7);
        if (!bl && n > 13) {
            c15 = this.charAt(this.bp + n - 1);
            char c24 = this.charAt(this.bp + n - 2);
            if (c16 == '/' && c17 == 'D' && c18 == 'a' && c19 == 't' && c20 == 'e' && c21 == '(' && c15 == '/' && c24 == ')') {
                int n4;
                int n5 = -1;
                for (n4 = 6; n4 < n; ++n4) {
                    char c25 = this.charAt(this.bp + n4);
                    if (c25 == '+') {
                        n5 = n4;
                        continue;
                    }
                    if (c25 < '0' || c25 > '9') break;
                }
                if (n5 == -1) {
                    return false;
                }
                n4 = this.bp + 6;
                String string = this.subString(n4, this.bp + n5 - n4);
                long l = Long.parseLong(string);
                this.calendar = Calendar.getInstance(this.timeZone, this.locale);
                this.calendar.setTimeInMillis(l);
                this.token = 5;
                return true;
            }
        }
        if (n == 8 || n == 14 || n == 16 && ((c15 = this.charAt(this.bp + 10)) == 'T' || c15 == ' ') || n == 17 && this.charAt(this.bp + 6) != '-') {
            int n6;
            int n7;
            int n8;
            int n9;
            void var12_16;
            char c26;
            char c27;
            char c28;
            char c29;
            char c30;
            char c31;
            char c32;
            boolean bl2;
            if (bl) {
                return false;
            }
            char c33 = this.charAt(this.bp + 8);
            boolean bl3 = c20 == '-' && c23 == '-';
            boolean bl4 = bl3 && n == 16;
            boolean bl5 = bl2 = bl3 && n == 17;
            if (bl2 || bl4) {
                char c34 = c16;
                c32 = c17;
                c31 = c18;
                c30 = c19;
                c29 = c21;
                c28 = c22;
                c27 = c33;
                c26 = this.charAt(this.bp + 9);
            } else if (c20 == '-' && c22 == '-') {
                char c35 = c16;
                c32 = c17;
                c31 = c18;
                c30 = c19;
                c29 = '0';
                c28 = c21;
                c27 = '0';
                c26 = c23;
            } else {
                char c36 = c16;
                c32 = c17;
                c31 = c18;
                c30 = c19;
                c29 = c20;
                c28 = c21;
                c27 = c22;
                c26 = c23;
            }
            if (!JSONScanner.checkDate((char)var12_16, c32, c31, c30, c29, c28, c27, c26)) {
                return false;
            }
            this.setCalendar((char)var12_16, c32, c31, c30, c29, c28, c27, c26);
            if (n != 8) {
                int n10;
                int n11;
                char c37;
                char c38;
                int n12;
                char c39;
                int n13 = this.charAt(this.bp + 9);
                c15 = this.charAt(this.bp + 10);
                char c40 = this.charAt(this.bp + 11);
                int n14 = this.charAt(this.bp + 12);
                int n15 = this.charAt(this.bp + 13);
                if (bl2 && c15 == 'T' && n15 == 58 && this.charAt(this.bp + 16) == 'Z' || bl4 && (c15 == ' ' || c15 == 'T') && n15 == 58) {
                    c39 = c40;
                    n12 = n14;
                    c38 = this.charAt(this.bp + 14);
                    c37 = this.charAt(this.bp + 15);
                    n11 = 48;
                    n10 = 48;
                } else {
                    c39 = c33;
                    n12 = n13;
                    c38 = c15;
                    c37 = c40;
                    n11 = n14;
                    n10 = n15;
                }
                if (!this.checkTime(c39, (char)n12, c38, c37, (char)n11, (char)n10)) {
                    return false;
                }
                if (n == 17 && !bl2) {
                    char c41 = this.charAt(this.bp + 14);
                    char c42 = this.charAt(this.bp + 15);
                    char c43 = this.charAt(this.bp + 16);
                    if (c41 < '0' || c41 > '9') {
                        return false;
                    }
                    if (c42 < '0' || c42 > '9') {
                        return false;
                    }
                    if (c43 < '0' || c43 > '9') {
                        return false;
                    }
                    n9 = (c41 - 48) * 100 + (c42 - 48) * 10 + (c43 - 48);
                } else {
                    n9 = 0;
                }
                n8 = (c39 - 48) * 10 + (n12 - 48);
                n7 = (c38 - 48) * 10 + (c37 - 48);
                n6 = (n11 - 48) * 10 + (n10 - 48);
            } else {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n9 = 0;
            }
            this.calendar.set(11, n8);
            this.calendar.set(12, n7);
            this.calendar.set(13, n6);
            this.calendar.set(14, n9);
            this.token = 5;
            return true;
        }
        if (n < 9) {
            return false;
        }
        char c44 = this.charAt(this.bp + 8);
        char c45 = this.charAt(this.bp + 9);
        int n16 = 10;
        if (c20 == '-' && c23 == '-' || c20 == '/' && c23 == '/') {
            c14 = c16;
            c13 = c17;
            c12 = c18;
            c11 = c19;
            c10 = c21;
            c9 = c22;
            if (c45 == ' ') {
                n3 = 48;
                c8 = c44;
                n16 = 9;
            } else {
                n3 = c44;
                c8 = c45;
            }
        } else if (c20 == '-' && c22 == '-') {
            c14 = c16;
            c13 = c17;
            c12 = c18;
            c11 = c19;
            c10 = '0';
            c9 = c21;
            if (c44 == ' ') {
                n3 = 48;
                c8 = c23;
                n16 = 8;
            } else {
                n3 = c23;
                c8 = c44;
                n16 = 9;
            }
        } else if (c18 == '.' && c21 == '.' || c18 == '-' && c21 == '-') {
            n3 = c16;
            c8 = c17;
            c10 = c19;
            c9 = c20;
            c14 = c22;
            c13 = c23;
            c12 = c44;
            c11 = c45;
        } else if (c44 == 'T') {
            c14 = c16;
            c13 = c17;
            c12 = c18;
            c11 = c19;
            c10 = c20;
            c9 = c21;
            n3 = c22;
            c8 = c23;
            n16 = 8;
        } else {
            if (c20 != '\u5e74' && c20 != 45380) return false;
            c14 = c16;
            c13 = c17;
            c12 = c18;
            c11 = c19;
            if (c23 == '\u6708' || c23 == '\uc6d4') {
                c10 = c21;
                c9 = c22;
                if (c45 == '\u65e5' || c45 == '\uc77c') {
                    n3 = 48;
                    c8 = c44;
                } else {
                    if (this.charAt(this.bp + 10) != '\u65e5' && this.charAt(this.bp + 10) != '\uc77c') return false;
                    n3 = c44;
                    c8 = c45;
                    n16 = 11;
                }
            } else {
                if (c22 != '\u6708' && c22 != 50900) return false;
                c10 = '0';
                c9 = c21;
                if (c44 == '\u65e5' || c44 == '\uc77c') {
                    n3 = 48;
                    c8 = c23;
                } else {
                    if (c45 != '\u65e5' && c45 != '\uc77c') return false;
                    n3 = c23;
                    c8 = c44;
                }
            }
        }
        if (!JSONScanner.checkDate(c14, c13, c12, c11, c10, c9, n3, c8)) {
            return false;
        }
        this.setCalendar(c14, c13, c12, c11, c10, c9, (char)n3, c8);
        char c46 = this.charAt(this.bp + n16);
        if (c46 == 'T' && n == 16 && n16 == 8 && this.charAt(this.bp + 15) == 'Z') {
            String[] stringArray;
            char c47;
            char c48;
            char c49;
            char c50;
            char c51;
            char c52 = this.charAt(this.bp + n16 + 1);
            if (!this.checkTime(c52, c51 = this.charAt(this.bp + n16 + 2), c50 = this.charAt(this.bp + n16 + 3), c49 = this.charAt(this.bp + n16 + 4), c48 = this.charAt(this.bp + n16 + 5), c47 = this.charAt(this.bp + n16 + 6))) {
                return false;
            }
            this.setTime(c52, c51, c50, c49, c48, c47);
            this.calendar.set(14, 0);
            if (this.calendar.getTimeZone().getRawOffset() != 0 && (stringArray = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(stringArray[0]);
                this.calendar.setTimeZone(timeZone);
            }
            this.token = 5;
            return true;
        }
        if (c46 == 'T' || c46 == ' ' && !bl) {
            if (n < n16 + 9) {
                return false;
            }
        } else {
            if (c46 == '\"' || c46 == '\u001a' || c46 == '\u65e5' || c46 == '\uc77c') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.charAt(this.bp += n16);
                this.token = 5;
                return true;
            }
            if (c46 != '+' && c46 != '-') return false;
            if (this.len != n16 + 6) return false;
            if (this.charAt(this.bp + n16 + 3) != ':' || this.charAt(this.bp + n16 + 4) != '0' || this.charAt(this.bp + n16 + 5) != '0') {
                return false;
            }
            this.setTime('0', '0', '0', '0', '0', '0');
            this.calendar.set(14, 0);
            this.setTimeZone(c46, this.charAt(this.bp + n16 + 1), this.charAt(this.bp + n16 + 2));
            return true;
        }
        if (this.charAt(this.bp + n16 + 3) != ':') {
            return false;
        }
        if (this.charAt(this.bp + n16 + 6) != ':') {
            return false;
        }
        char c53 = this.charAt(this.bp + n16 + 1);
        if (!this.checkTime(c53, c7 = this.charAt(this.bp + n16 + 2), c6 = this.charAt(this.bp + n16 + 4), c5 = this.charAt(this.bp + n16 + 5), c4 = this.charAt(this.bp + n16 + 7), c3 = this.charAt(this.bp + n16 + 8))) {
            return false;
        }
        this.setTime(c53, c7, c6, c5, c4, c3);
        char c54 = this.charAt(this.bp + n16 + 9);
        int n17 = -1;
        int n18 = 0;
        if (c54 == '.') {
            if (n < n16 + 11) {
                return false;
            }
            n2 = this.charAt(this.bp + n16 + 10);
            if (n2 < 48 || n2 > 57) {
                return false;
            }
            n18 = n2 - 48;
            n17 = 1;
            if (n > n16 + 11 && (c2 = this.charAt(this.bp + n16 + 11)) >= '0' && c2 <= '9') {
                n18 = n18 * 10 + (c2 - 48);
                n17 = 2;
            }
            if (n17 == 2 && (c2 = this.charAt(this.bp + n16 + 12)) >= '0' && c2 <= '9') {
                n18 = n18 * 10 + (c2 - 48);
                n17 = 3;
            }
        }
        this.calendar.set(14, n18);
        n2 = 0;
        c2 = this.charAt(this.bp + n16 + 10 + n17);
        if (c2 == ' ') {
            c2 = this.charAt(this.bp + n16 + 10 + ++n17);
        }
        if (c2 == '+' || c2 == '-') {
            char c55 = this.charAt(this.bp + n16 + 10 + n17 + 1);
            if (c55 < '0' || c55 > '1') {
                return false;
            }
            char c56 = this.charAt(this.bp + n16 + 10 + n17 + 2);
            if (c56 < '0' || c56 > '9') {
                return false;
            }
            char c57 = this.charAt(this.bp + n16 + 10 + n17 + 3);
            int n19 = 48;
            int n20 = 48;
            if (c57 == ':') {
                n19 = this.charAt(this.bp + n16 + 10 + n17 + 4);
                n20 = this.charAt(this.bp + n16 + 10 + n17 + 5);
                if (n19 == 52 && n20 == 53) {
                    if ((c55 != '1' || c56 != '2' && c56 != '3') && (c55 != '0' || c56 != '5' && c56 != '8')) {
                        return false;
                    }
                } else {
                    if (n19 != 48 && n19 != 51) {
                        return false;
                    }
                    if (n20 != 48) {
                        return false;
                    }
                }
                n2 = 6;
            } else if (c57 == '0') {
                n19 = this.charAt(this.bp + n16 + 10 + n17 + 4);
                if (n19 != 48 && n19 != 51) {
                    return false;
                }
                n2 = 5;
            } else if (c57 == '3' && this.charAt(this.bp + n16 + 10 + n17 + 4) == '0') {
                n19 = 51;
                n20 = 48;
                n2 = 5;
            } else if (c57 == '4' && this.charAt(this.bp + n16 + 10 + n17 + 4) == '5') {
                n19 = 52;
                n20 = 53;
                n2 = 5;
            } else {
                n2 = 3;
            }
            this.setTimeZone(c2, c55, c56, (char)n19, (char)n20);
        } else if (c2 == 'Z') {
            String[] stringArray;
            n2 = 1;
            if (this.calendar.getTimeZone().getRawOffset() != 0 && (stringArray = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(stringArray[0]);
                this.calendar.setTimeZone(timeZone);
            }
        }
        char c58 = this.charAt(this.bp + (n16 + 10 + n17 + n2));
        if (c58 != '\u001a' && c58 != '\"') {
            return false;
        }
        this.ch = this.charAt(this.bp += n16 + 10 + n17 + n2);
        this.token = 5;
        return true;
    }

    protected void setTime(char c2, char c3, char c4, char c5, char c6, char c7) {
        int n = (c2 - 48) * 10 + (c3 - 48);
        int n2 = (c4 - 48) * 10 + (c5 - 48);
        int n3 = (c6 - 48) * 10 + (c7 - 48);
        this.calendar.set(11, n);
        this.calendar.set(12, n2);
        this.calendar.set(13, n3);
    }

    protected void setTimeZone(char c2, char c3, char c4) {
        this.setTimeZone(c2, c3, c4, '0', '0');
    }

    protected void setTimeZone(char c2, char c3, char c4, char c5, char c6) {
        int n = ((c3 - 48) * 10 + (c4 - 48)) * 3600 * 1000;
        n += ((c5 - 48) * 10 + (c6 - 48)) * 60 * 1000;
        if (c2 == '-') {
            n = -n;
        }
        if (this.calendar.getTimeZone().getRawOffset() != n) {
            this.calendar.setTimeZone(new SimpleTimeZone(n, Integer.toString(n)));
        }
    }

    private boolean checkTime(char c2, char c3, char c4, char c5, char c6, char c7) {
        if (c2 == '0') {
            if (c3 < '0' || c3 > '9') {
                return false;
            }
        } else if (c2 == '1') {
            if (c3 < '0' || c3 > '9') {
                return false;
            }
        } else if (c2 == '2') {
            if (c3 < '0' || c3 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (c4 >= '0' && c4 <= '5') {
            if (c5 < '0' || c5 > '9') {
                return false;
            }
        } else if (c4 == '6') {
            if (c5 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (c6 >= '0' && c6 <= '5') {
            if (c7 < '0' || c7 > '9') {
                return false;
            }
        } else if (c6 == '6') {
            if (c7 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setCalendar(char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9) {
        this.calendar = Calendar.getInstance(this.timeZone, this.locale);
        int n = (c2 - 48) * 1000 + (c3 - 48) * 100 + (c4 - 48) * 10 + (c5 - 48);
        int n2 = (c6 - 48) * 10 + (c7 - 48) - 1;
        int n3 = (c8 - 48) * 10 + (c9 - 48);
        this.calendar.set(1, n);
        this.calendar.set(2, n2);
        this.calendar.set(5, n3);
    }

    static boolean checkDate(char c2, char c3, char c4, char c5, char c6, char c7, int n, int n2) {
        if (c2 < '0' || c2 > '9') {
            return false;
        }
        if (c3 < '0' || c3 > '9') {
            return false;
        }
        if (c4 < '0' || c4 > '9') {
            return false;
        }
        if (c5 < '0' || c5 > '9') {
            return false;
        }
        if (c6 == '0') {
            if (c7 < '1' || c7 > '9') {
                return false;
            }
        } else if (c6 == '1') {
            if (c7 != '0' && c7 != '1' && c7 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (n == 48) {
            if (n2 < 49 || n2 > 57) {
                return false;
            }
        } else if (n == 49 || n == 50) {
            if (n2 < 48 || n2 > 57) {
                return false;
            }
        } else if (n == 51) {
            if (n2 != 48 && n2 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEOF() {
        return this.bp == this.len || this.ch == '\u001a' && this.bp + 1 >= this.len;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int scanFieldInt(char[] cArray) {
        int n;
        int n2;
        boolean bl;
        char c2;
        int n3;
        char c3;
        int n4;
        block24: {
            int n5;
            boolean bl2;
            this.matchStat = 0;
            n4 = this.bp;
            c3 = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                this.matchStat = -2;
                return 0;
            }
            n3 = this.bp + cArray.length;
            boolean bl3 = bl2 = (c2 = this.charAt(n3++)) == '\"';
            if (bl2) {
                c2 = this.charAt(n3++);
            }
            boolean bl4 = bl = c2 == '-';
            if (bl) {
                c2 = this.charAt(n3++);
            }
            if (c2 >= '0' && c2 <= '9') {
                n2 = c2 - 48;
            } else {
                this.matchStat = -1;
                return 0;
            }
            while ((c2 = this.charAt(n3++)) >= '0' && c2 <= '9') {
                int n6 = n2 * 10;
                if (n6 < n2) {
                    this.matchStat = -1;
                    return 0;
                }
                n2 = n6 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n2 < 0) {
                this.matchStat = -1;
                return 0;
            }
            if (bl2) {
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return 0;
                }
                c2 = this.charAt(n3++);
            }
            while (true) {
                if (c2 == ',' || c2 == '}') {
                    this.bp = n3 - 1;
                    if (c2 == ',') {
                        break;
                    }
                    break block24;
                }
                if (!JSONScanner.isWhitespace(c2)) {
                    this.matchStat = -1;
                    return 0;
                }
                c2 = this.charAt(n3++);
            }
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                n5 = -n2;
                return n5;
            }
            n5 = n2;
            return n5;
        }
        if (c2 == '}') {
            this.bp = n3 - 1;
            c2 = this.charAt(++this.bp);
            while (true) {
                if (c2 == ',') {
                    this.token = 16;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (c2 == ']') {
                    this.token = 15;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (c2 == '}') {
                    this.token = 13;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (c2 == '\u001a') {
                    this.token = 20;
                    break;
                }
                if (!JSONScanner.isWhitespace(c2)) {
                    this.bp = n4;
                    this.ch = c3;
                    this.matchStat = -1;
                    return 0;
                }
                c2 = this.charAt(++this.bp);
            }
            this.matchStat = 4;
        }
        if (bl) {
            n = -n2;
            return n;
        }
        n = n2;
        return n;
    }

    @Override
    public String scanFieldString(char[] cArray) {
        String string;
        int n;
        char c2;
        char c3;
        int n2;
        block20: {
            int n3;
            this.matchStat = 0;
            n2 = this.bp;
            c3 = this.ch;
            while (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                if (JSONScanner.isWhitespace(this.ch)) {
                    this.next();
                    while (JSONScanner.isWhitespace(this.ch)) {
                        this.next();
                    }
                    continue;
                }
                this.matchStat = -2;
                return this.stringDefaultValue();
            }
            int n4 = this.bp + cArray.length;
            int n5 = 0;
            if ((c2 = this.charAt(n4++)) != '\"') {
                while (JSONScanner.isWhitespace(c2)) {
                    ++n5;
                    c2 = this.charAt(n4++);
                }
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return this.stringDefaultValue();
                }
            }
            if ((n = this.indexOf('\"', n3 = n4)) == -1) {
                throw new JSONException("unclosed str");
            }
            string = this.subString(n3, n - n3);
            if (string.indexOf(92) != -1) {
                int n6;
                while (true) {
                    n6 = 0;
                    for (int i = n - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                        ++n6;
                    }
                    if (n6 % 2 == 0) break;
                    n = this.indexOf('\"', n + 1);
                }
                n6 = n - (this.bp + cArray.length + 1 + n5);
                char[] cArray2 = this.sub_chars(this.bp + cArray.length + 1 + n5, n6);
                string = JSONScanner.readString(cArray2, n6);
            }
            c2 = this.charAt(n + 1);
            while (true) {
                if (c2 == ',' || c2 == '}') break block20;
                if (!JSONScanner.isWhitespace(c2)) break;
                c2 = this.charAt(++n + 1);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.bp = n + 1;
        this.ch = c2;
        String string2 = string;
        if (c2 == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return string2;
        }
        if ((c2 = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == '\u001a') {
            this.token = 20;
        } else {
            this.bp = n2;
            this.ch = c3;
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.matchStat = 4;
        return string2;
    }

    @Override
    public Date scanFieldDate(char[] cArray) {
        Date date;
        char c2;
        char c3;
        int n;
        block23: {
            this.matchStat = 0;
            n = this.bp;
            c3 = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                this.matchStat = -2;
                return null;
            }
            int n2 = this.bp + cArray.length;
            if ((c2 = this.charAt(n2++)) == '\"') {
                int n3 = n2;
                int n4 = this.indexOf('\"', n3);
                if (n4 == -1) {
                    throw new JSONException("unclosed str");
                }
                int n5 = n4 - n3;
                this.bp = n2;
                if (!this.scanISO8601DateIfMatch(false, n5)) {
                    this.bp = n;
                    this.matchStat = -1;
                    return null;
                }
                date = this.calendar.getTime();
                c2 = this.charAt(n4 + 1);
                this.bp = n;
                while (true) {
                    if (c2 == ',' || c2 == '}') {
                        this.bp = n4 + 1;
                        this.ch = c2;
                        break block23;
                    }
                    if (!JSONScanner.isWhitespace(c2)) break;
                    c2 = this.charAt(++n4 + 1);
                }
                this.matchStat = -1;
                return null;
            }
            if (c2 == '-' || c2 >= '0' && c2 <= '9') {
                long l = 0L;
                boolean bl = false;
                if (c2 == '-') {
                    c2 = this.charAt(n2++);
                    bl = true;
                }
                if (c2 >= '0' && c2 <= '9') {
                    l = c2 - 48;
                    while ((c2 = this.charAt(n2++)) >= '0' && c2 <= '9') {
                        l = l * 10L + (long)(c2 - 48);
                    }
                    if (c2 == ',' || c2 == '}') {
                        this.bp = n2 - 1;
                    }
                }
                if (l < 0L) {
                    this.matchStat = -1;
                    return null;
                }
                if (bl) {
                    l = -l;
                }
                date = new Date(l);
            } else {
                this.matchStat = -1;
                return null;
            }
        }
        if (c2 == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return date;
        }
        if ((c2 = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == '\u001a') {
            this.token = 20;
        } else {
            this.bp = n;
            this.ch = c3;
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return date;
    }

    @Override
    public long scanFieldSymbol(char[] cArray) {
        long l;
        block15: {
            char c2;
            this.matchStat = 0;
            while (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                if (JSONScanner.isWhitespace(this.ch)) {
                    this.next();
                    while (JSONScanner.isWhitespace(this.ch)) {
                        this.next();
                    }
                    continue;
                }
                this.matchStat = -2;
                return 0L;
            }
            int n = this.bp + cArray.length;
            int n2 = 0;
            if ((c2 = this.charAt(n++)) != '\"') {
                while (JSONScanner.isWhitespace(c2)) {
                    c2 = this.charAt(n++);
                    ++n2;
                }
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
            }
            l = -3750763034362895579L;
            while (true) {
                if ((c2 = this.charAt(n++)) == '\"') break;
                if (n > this.len) {
                    this.matchStat = -1;
                    return 0L;
                }
                l ^= (long)c2;
                l *= 1099511628211L;
            }
            this.bp = n;
            this.ch = c2 = this.charAt(this.bp);
            while (true) {
                if (c2 == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    return l;
                }
                if (c2 == '}') {
                    this.next();
                    this.skipWhitespace();
                    c2 = this.getCurrent();
                    if (c2 == ',') {
                        this.token = 16;
                        this.ch = this.charAt(++this.bp);
                        break block15;
                    }
                    if (c2 == ']') {
                        this.token = 15;
                        this.ch = this.charAt(++this.bp);
                        break block15;
                    }
                    if (c2 == '}') {
                        this.token = 13;
                        this.ch = this.charAt(++this.bp);
                        break block15;
                    }
                    if (c2 == '\u001a') {
                        this.token = 20;
                        break block15;
                    }
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(c2)) break;
                c2 = this.charAt(++this.bp);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Collection<String> scanFieldStringArray(char[] cArray, Class<?> clazz) {
        Collection<String> collection;
        block23: {
            int n;
            char c2;
            int n2;
            char c3;
            int n3;
            block22: {
                block24: {
                    this.matchStat = 0;
                    while (this.ch == '\n' || this.ch == ' ') {
                        int n4;
                        this.ch = (char)((n4 = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(n4));
                    }
                    if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    collection = this.newCollectionByType(clazz);
                    n3 = this.bp;
                    c3 = this.ch;
                    n2 = this.bp + cArray.length;
                    if ((c2 = this.charAt(n2++)) == '[') break block24;
                    if (!this.text.startsWith("ull", n2)) {
                        this.matchStat = -1;
                        return null;
                    }
                    n2 += 3;
                    c2 = this.charAt(n2++);
                    collection = null;
                    break block22;
                }
                c2 = this.charAt(n2++);
                while (true) {
                    block28: {
                        String string;
                        int n5;
                        block26: {
                            block27: {
                                block25: {
                                    if (c2 != '\"') break block25;
                                    n = n2;
                                    n5 = this.indexOf('\"', n);
                                    if (n5 == -1) {
                                        throw new JSONException("unclosed str");
                                    }
                                    string = this.subString(n, n5 - n);
                                    if (string.indexOf(92) == -1) break block26;
                                    break block27;
                                }
                                if (c2 == 'n' && this.text.startsWith("ull", n2)) {
                                    n2 += 3;
                                    c2 = this.charAt(n2++);
                                    collection.add(null);
                                    break block28;
                                } else if (c2 == ']' && collection.size() == 0) {
                                    c2 = this.charAt(n2++);
                                    break block22;
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            while (true) {
                                int n6 = 0;
                                for (int i = n5 - 1; i >= 0 && this.charAt(i) == '\\'; ++n6, --i) {
                                }
                                if (n6 % 2 == 0) {
                                    n6 = n5 - n;
                                    char[] cArray2 = this.sub_chars(n, n6);
                                    string = JSONScanner.readString(cArray2, n6);
                                    break;
                                }
                                n5 = this.indexOf('\"', n5 + 1);
                            }
                        }
                        n2 = n5 + 1;
                        c2 = this.charAt(n2++);
                        collection.add(string);
                    }
                    if (c2 != ',') break;
                    c2 = this.charAt(n2++);
                }
                if (c2 != ']') {
                    this.matchStat = -1;
                    return null;
                }
                c2 = this.charAt(n2++);
                while (JSONScanner.isWhitespace(c2)) {
                    c2 = this.charAt(n2++);
                }
            }
            this.bp = n2;
            if (c2 == ',') {
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return collection;
            }
            if (c2 != '}') {
                this.ch = c3;
                this.bp = n3;
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp);
            do {
                if (c2 == ',') {
                    this.token = 16;
                    this.ch = this.charAt(++this.bp);
                    break block23;
                }
                if (c2 == ']') {
                    this.token = 15;
                    this.ch = this.charAt(++this.bp);
                    break block23;
                }
                if (c2 == '}') {
                    this.token = 13;
                    this.ch = this.charAt(++this.bp);
                    break block23;
                }
                if (c2 == '\u001a') {
                    this.token = 20;
                    this.ch = c2;
                    break block23;
                }
                n = 0;
                while (JSONScanner.isWhitespace(c2)) {
                    c2 = this.charAt(n2++);
                    this.bp = n2;
                    n = 1;
                }
            } while (n != 0);
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return collection;
    }

    @Override
    public long scanFieldLong(char[] cArray) {
        long l;
        boolean bl;
        block19: {
            char c2;
            boolean bl2;
            this.matchStat = 0;
            int n = this.bp;
            char c3 = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                this.matchStat = -2;
                return 0L;
            }
            int n2 = this.bp + cArray.length;
            boolean bl3 = bl2 = (c2 = this.charAt(n2++)) == '\"';
            if (bl2) {
                c2 = this.charAt(n2++);
            }
            bl = false;
            if (c2 == '-') {
                c2 = this.charAt(n2++);
                bl = true;
            }
            if (c2 >= '0' && c2 <= '9') {
                boolean bl4;
                l = c2 - 48;
                while ((c2 = this.charAt(n2++)) >= '0' && c2 <= '9') {
                    l = l * 10L + (long)(c2 - 48);
                }
                if (c2 == '.') {
                    this.matchStat = -1;
                    return 0L;
                }
                if (bl2) {
                    if (c2 != '\"') {
                        this.matchStat = -1;
                        return 0L;
                    }
                    c2 = this.charAt(n2++);
                }
                if (c2 == ',' || c2 == '}') {
                    this.bp = n2 - 1;
                }
                boolean bl5 = bl4 = l >= 0L || l == Long.MIN_VALUE && bl;
                if (!bl4) {
                    this.bp = n;
                    this.ch = c3;
                    this.matchStat = -1;
                    return 0L;
                }
            } else {
                this.bp = n;
                this.ch = c3;
                this.matchStat = -1;
                return 0L;
            }
            while (true) {
                if (c2 == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    this.token = 16;
                    return bl ? -l : l;
                }
                if (c2 == '}') {
                    c2 = this.charAt(++this.bp);
                    while (true) {
                        if (c2 == ',') {
                            this.token = 16;
                            this.ch = this.charAt(++this.bp);
                            break block19;
                        }
                        if (c2 == ']') {
                            this.token = 15;
                            this.ch = this.charAt(++this.bp);
                            break block19;
                        }
                        if (c2 == '}') {
                            this.token = 13;
                            this.ch = this.charAt(++this.bp);
                            break block19;
                        }
                        if (c2 == '\u001a') {
                            this.token = 20;
                            break block19;
                        }
                        if (!JSONScanner.isWhitespace(c2)) break;
                        c2 = this.charAt(++this.bp);
                    }
                    this.bp = n;
                    this.ch = c3;
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(c2)) break;
                this.bp = n2;
                c2 = this.charAt(n2++);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        return bl ? -l : l;
    }

    @Override
    public boolean scanFieldBoolean(char[] cArray) {
        boolean bl;
        block29: {
            char c2;
            boolean bl2;
            this.matchStat = 0;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                this.matchStat = -2;
                return false;
            }
            int n = this.bp;
            int n2 = this.bp + cArray.length;
            boolean bl3 = bl2 = (c2 = this.charAt(n2++)) == '\"';
            if (bl2) {
                c2 = this.charAt(n2++);
            }
            if (c2 == 't') {
                if (this.charAt(n2++) != 'r') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n2++) != 'u') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n2++) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                if (bl2 && this.charAt(n2++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = n2;
                c2 = this.charAt(this.bp);
                bl = true;
            } else if (c2 == 'f') {
                if (this.charAt(n2++) != 'a') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n2++) != 'l') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n2++) != 's') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n2++) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                if (bl2 && this.charAt(n2++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = n2;
                c2 = this.charAt(this.bp);
                bl = false;
            } else if (c2 == '1') {
                if (bl2 && this.charAt(n2++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = n2;
                c2 = this.charAt(this.bp);
                bl = true;
            } else if (c2 == '0') {
                if (bl2 && this.charAt(n2++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = n2;
                c2 = this.charAt(this.bp);
                bl = false;
            } else {
                this.matchStat = -1;
                return false;
            }
            while (true) {
                if (c2 == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    this.token = 16;
                    break block29;
                }
                if (c2 == '}') {
                    block30: {
                        c2 = this.charAt(++this.bp);
                        while (true) {
                            if (c2 == ',') {
                                this.token = 16;
                                this.ch = this.charAt(++this.bp);
                                break block30;
                            }
                            if (c2 == ']') {
                                this.token = 15;
                                this.ch = this.charAt(++this.bp);
                                break block30;
                            }
                            if (c2 == '}') {
                                this.token = 13;
                                this.ch = this.charAt(++this.bp);
                                break block30;
                            }
                            if (c2 == '\u001a') {
                                this.token = 20;
                                break block30;
                            }
                            if (!JSONScanner.isWhitespace(c2)) break;
                            c2 = this.charAt(++this.bp);
                        }
                        this.matchStat = -1;
                        return false;
                    }
                    this.matchStat = 4;
                    break block29;
                }
                if (!JSONScanner.isWhitespace(c2)) break;
                c2 = this.charAt(++this.bp);
            }
            this.bp = n;
            c2 = this.charAt(this.bp);
            this.matchStat = -1;
            return false;
        }
        return bl;
    }

    @Override
    public final int scanInt(char c2) {
        int n;
        boolean bl;
        boolean bl2;
        this.matchStat = 0;
        int n2 = this.bp;
        int n3 = this.bp;
        char c3 = this.charAt(n3++);
        while (JSONScanner.isWhitespace(c3)) {
            c3 = this.charAt(n3++);
        }
        boolean bl3 = bl2 = c3 == '\"';
        if (bl2) {
            c3 = this.charAt(n3++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(n3++);
        }
        if (c3 >= '0' && c3 <= '9') {
            n = c3 - 48;
            while ((c3 = this.charAt(n3++)) >= '0' && c3 <= '9') {
                int n4 = n * 10;
                if (n4 < n) {
                    throw new JSONException("parseInt error : " + this.subString(n2, n3 - 1));
                }
                n = n4 + (c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0;
                }
                c3 = this.charAt(n3++);
            }
            if (n < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c3 == 'n' && this.charAt(n3++) == 'u' && this.charAt(n3++) == 'l' && this.charAt(n3++) == 'l') {
                this.matchStat = 5;
                int n5 = 0;
                c3 = this.charAt(n3++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(n3++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp = n3;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return n5;
                    }
                    if (c3 == ']') {
                        this.bp = n3;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return n5;
                    }
                    if (!JSONScanner.isWhitespace(c3)) break;
                    c3 = this.charAt(n3++);
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c3 == c2) {
                this.bp = n3;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bl ? -n : n;
            }
            if (!JSONScanner.isWhitespace(c3)) break;
            c3 = this.charAt(n3++);
        }
        this.matchStat = -1;
        return bl ? -n : n;
    }

    @Override
    public double scanDouble(char c2) {
        double d2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n = this.bp;
        boolean bl3 = bl2 = (c3 = this.charAt(n++)) == '\"';
        if (bl2) {
            c3 = this.charAt(n++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(n++);
        }
        if (c3 >= '0' && c3 <= '9') {
            int n2;
            int n3;
            boolean bl5;
            boolean bl6;
            long l = c3 - 48;
            while ((c3 = this.charAt(n++)) >= '0' && c3 <= '9') {
                l = l * 10L + (long)(c3 - 48);
            }
            long l2 = 1L;
            boolean bl7 = bl6 = c3 == '.';
            if (bl6) {
                if ((c3 = this.charAt(n++)) >= '0' && c3 <= '9') {
                    l = l * 10L + (long)(c3 - 48);
                    l2 = 10L;
                    while ((c3 = this.charAt(n++)) >= '0' && c3 <= '9') {
                        l = l * 10L + (long)(c3 - 48);
                        l2 *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            boolean bl8 = bl5 = c3 == 'e' || c3 == 'E';
            if (bl5) {
                if ((c3 = this.charAt(n++)) == '+' || c3 == '-') {
                    c3 = this.charAt(n++);
                }
                while (c3 >= '0' && c3 <= '9') {
                    c3 = this.charAt(n++);
                }
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0.0;
                }
                c3 = this.charAt(n++);
                n3 = this.bp + 1;
                n2 = n - n3 - 2;
            } else {
                n3 = this.bp;
                n2 = n - n3 - 1;
            }
            if (!bl5 && n2 < 18) {
                d2 = (double)l / (double)l2;
                if (bl) {
                    d2 = -d2;
                }
            } else {
                String string = this.subString(n3, n2);
                d2 = Double.parseDouble(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(n++) == 'u' && this.charAt(n++) == 'l' && this.charAt(n++) == 'l') {
                this.matchStat = 5;
                double d3 = 0.0;
                c3 = this.charAt(n++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(n++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp = n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return d3;
                    }
                    if (c3 == ']') {
                        this.bp = n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return d3;
                    }
                    if (!JSONScanner.isWhitespace(c3)) break;
                    c3 = this.charAt(n++);
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (c3 == c2) {
            this.bp = n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return d2;
        }
        this.matchStat = -1;
        return d2;
    }

    @Override
    public long scanLong(char c2) {
        long l;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n = this.bp;
        boolean bl3 = bl2 = (c3 = this.charAt(n++)) == '\"';
        if (bl2) {
            c3 = this.charAt(n++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(n++);
        }
        if (c3 >= '0' && c3 <= '9') {
            boolean bl5;
            l = c3 - 48;
            while ((c3 = this.charAt(n++)) >= '0' && c3 <= '9') {
                l = l * 10L + (long)(c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                c3 = this.charAt(n++);
            }
            boolean bl6 = bl5 = l >= 0L || l == Long.MIN_VALUE && bl;
            if (!bl5) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            if (c3 == 'n' && this.charAt(n++) == 'u' && this.charAt(n++) == 'l' && this.charAt(n++) == 'l') {
                this.matchStat = 5;
                long l2 = 0L;
                c3 = this.charAt(n++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(n++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp = n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return l2;
                    }
                    if (c3 == ']') {
                        this.bp = n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return l2;
                    }
                    if (!JSONScanner.isWhitespace(c3)) break;
                    c3 = this.charAt(n++);
                }
                this.matchStat = -1;
                return 0L;
            }
            this.matchStat = -1;
            return 0L;
        }
        while (true) {
            if (c3 == c2) {
                this.bp = n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bl ? -l : l;
            }
            if (!JSONScanner.isWhitespace(c3)) break;
            c3 = this.charAt(n++);
        }
        this.matchStat = -1;
        return l;
    }

    @Override
    public Date scanDate(char c2) {
        Date date;
        char c3;
        char c4;
        int n;
        block24: {
            this.matchStat = 0;
            n = this.bp;
            c4 = this.ch;
            int n2 = this.bp;
            if ((c3 = this.charAt(n2++)) == '\"') {
                int n3 = n2;
                int n4 = this.indexOf('\"', n3);
                if (n4 == -1) {
                    throw new JSONException("unclosed str");
                }
                int n5 = n4 - n3;
                this.bp = n2;
                if (!this.scanISO8601DateIfMatch(false, n5)) {
                    this.bp = n;
                    this.ch = c4;
                    this.matchStat = -1;
                    return null;
                }
                date = this.calendar.getTime();
                c3 = this.charAt(n4 + 1);
                this.bp = n;
                while (true) {
                    if (c3 == ',' || c3 == ']') {
                        this.bp = n4 + 1;
                        this.ch = c3;
                        break block24;
                    }
                    if (!JSONScanner.isWhitespace(c3)) break;
                    c3 = this.charAt(++n4 + 1);
                }
                this.bp = n;
                this.ch = c4;
                this.matchStat = -1;
                return null;
            }
            if (c3 == '-' || c3 >= '0' && c3 <= '9') {
                long l = 0L;
                boolean bl = false;
                if (c3 == '-') {
                    c3 = this.charAt(n2++);
                    bl = true;
                }
                if (c3 >= '0' && c3 <= '9') {
                    l = c3 - 48;
                    while ((c3 = this.charAt(n2++)) >= '0' && c3 <= '9') {
                        l = l * 10L + (long)(c3 - 48);
                    }
                    if (c3 == ',' || c3 == ']') {
                        this.bp = n2 - 1;
                    }
                }
                if (l < 0L) {
                    this.bp = n;
                    this.ch = c4;
                    this.matchStat = -1;
                    return null;
                }
                if (bl) {
                    l = -l;
                }
                date = new Date(l);
            } else if (c3 == 'n' && this.charAt(n2++) == 'u' && this.charAt(n2++) == 'l' && this.charAt(n2++) == 'l') {
                date = null;
                c3 = this.charAt(n2);
                this.bp = n2;
            } else {
                this.bp = n;
                this.ch = c4;
                this.matchStat = -1;
                return null;
            }
        }
        if (c3 == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return date;
        }
        if ((c3 = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (c3 == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (c3 == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else if (c3 == '\u001a') {
            this.ch = (char)26;
            this.token = 20;
        } else {
            this.bp = n;
            this.ch = c4;
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return date;
    }

    @Override
    protected final void arrayCopy(int n, char[] cArray, int n2, int n3) {
        this.text.getChars(n, n + n3, cArray, n2);
    }

    @Override
    public String info() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.bp) {
            char c2 = this.text.charAt(n3);
            if (c2 == '\n') {
                n2 = 1;
                ++n;
            }
            ++n3;
            ++n2;
        }
        stringBuilder.append("pos ").append(this.bp).append(", line ").append(n).append(", column ").append(n2);
        if (this.text.length() < 65535) {
            stringBuilder.append(this.text);
        } else {
            stringBuilder.append(this.text.substring(0, 65535));
        }
        return stringBuilder.toString();
    }

    @Override
    public String[] scanFieldStringArray(char[] cArray, int n, SymbolTable symbolTable) {
        String[] stringArray;
        char c2;
        int n2;
        int n3 = this.bp;
        char c3 = this.ch;
        while (JSONScanner.isWhitespace(this.ch)) {
            this.next();
        }
        if (cArray != null) {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            n2 = this.bp + cArray.length;
            c2 = this.text.charAt(n2++);
            while (JSONScanner.isWhitespace(c2)) {
                c2 = this.text.charAt(n2++);
            }
            if (c2 == ':') {
                c2 = this.text.charAt(n2++);
            } else {
                this.matchStat = -1;
                return null;
            }
            while (JSONScanner.isWhitespace(c2)) {
                c2 = this.text.charAt(n2++);
            }
        } else {
            n2 = this.bp + 1;
            c2 = this.ch;
        }
        if (c2 != '[') {
            if (c2 == 'n' && this.text.startsWith("ull", this.bp + 1)) {
                this.bp += 4;
                this.ch = this.text.charAt(this.bp);
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        this.bp = n2;
        this.ch = this.text.charAt(this.bp);
        String[] stringArray2 = n >= 0 ? new String[n] : new String[4];
        int n4 = 0;
        while (true) {
            if (JSONScanner.isWhitespace(this.ch)) {
                this.next();
                continue;
            }
            if (this.ch != '\"') {
                this.bp = n3;
                this.ch = c3;
                this.matchStat = -1;
                return null;
            }
            stringArray = this.scanSymbol(symbolTable, '\"');
            if (n4 == stringArray2.length) {
                int n5 = stringArray2.length + (stringArray2.length >> 1) + 1;
                String[] stringArray3 = new String[n5];
                System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                stringArray2 = stringArray3;
            }
            stringArray2[n4++] = stringArray;
            while (JSONScanner.isWhitespace(this.ch)) {
                this.next();
            }
            if (this.ch != ',') break;
            this.next();
        }
        if (stringArray2.length != n4) {
            stringArray = new String[n4];
            System.arraycopy(stringArray2, 0, stringArray, 0, n4);
            stringArray2 = stringArray;
        }
        while (JSONScanner.isWhitespace(this.ch)) {
            this.next();
        }
        if (this.ch != ']') {
            this.bp = n3;
            this.ch = c3;
            this.matchStat = -1;
            return null;
        }
        this.next();
        return stringArray2;
    }

    @Override
    public boolean matchField2(char[] cArray) {
        while (JSONScanner.isWhitespace(this.ch)) {
            this.next();
        }
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n = this.bp + cArray.length;
        char c2 = this.text.charAt(n++);
        while (JSONScanner.isWhitespace(c2)) {
            c2 = this.text.charAt(n++);
        }
        if (c2 == ':') {
            this.bp = n;
            this.ch = this.charAt(this.bp);
            return true;
        }
        this.matchStat = -2;
        return false;
    }

    @Override
    public final void skipObject() {
        this.skipObject(false);
    }

    @Override
    public final void skipObject(boolean bl) {
        int n;
        int n2;
        boolean bl2 = false;
        int n3 = 0;
        for (n2 = this.bp; n2 < this.text.length(); ++n2) {
            n = this.text.charAt(n2);
            if (n == 92) {
                if (n2 < this.len - 1) {
                    ++n2;
                    continue;
                }
                this.ch = (char)n;
                this.bp = n2;
                throw new JSONException("illegal str, " + this.info());
            }
            if (n == 34) {
                bl2 = !bl2;
                continue;
            }
            if (n == 123) {
                if (bl2) continue;
                ++n3;
                continue;
            }
            if (n != 125 || bl2 || --n3 != -1) continue;
            this.bp = n2 + 1;
            if (this.bp == this.text.length()) {
                this.ch = (char)26;
                this.token = 20;
                return;
            }
            this.ch = this.text.charAt(this.bp);
            if (this.ch == ',') {
                int n4;
                this.token = 16;
                this.ch = (char)((n4 = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n4));
                return;
            }
            if (this.ch == '}') {
                this.token = 13;
                this.next();
                return;
            }
            if (this.ch == ']') {
                this.token = 15;
                this.next();
                return;
            }
            this.nextToken(16);
            return;
        }
        for (n = 0; n < this.bp; ++n) {
            if (n >= this.text.length() || this.text.charAt(n) != ' ') continue;
            ++n2;
        }
        if (n2 == this.text.length()) {
            throw new JSONException("illegal str, " + this.info());
        }
    }

    @Override
    public final void skipArray() {
        this.skipArray(false);
    }

    public final void skipArray(boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = 0;
        for (n = this.bp; n < this.text.length(); ++n) {
            char c2 = this.text.charAt(n);
            if (c2 == '\\') {
                if (n < this.len - 1) {
                    ++n;
                    continue;
                }
                this.ch = c2;
                this.bp = n;
                throw new JSONException("illegal str, " + this.info());
            }
            if (c2 == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (c2 == '[') {
                if (bl2) continue;
                ++n2;
                continue;
            }
            if (c2 == '{' && bl) {
                int n3;
                this.ch = (char)((n3 = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n3));
                this.skipObject(bl);
                continue;
            }
            if (c2 != ']' || bl2 || --n2 != -1) continue;
            this.bp = n + 1;
            if (this.bp == this.text.length()) {
                this.ch = (char)26;
                this.token = 20;
                return;
            }
            this.ch = this.text.charAt(this.bp);
            this.nextToken(16);
            return;
        }
        if (n == this.text.length()) {
            throw new JSONException("illegal str, " + this.info());
        }
    }

    public final void skipString() {
        if (this.ch == '\"') {
            for (int i = this.bp + 1; i < this.text.length(); ++i) {
                char c2 = this.text.charAt(i);
                if (c2 == '\\') {
                    if (i >= this.len - 1) continue;
                    ++i;
                    continue;
                }
                if (c2 != '\"') continue;
                this.bp = i + 1;
                this.ch = this.text.charAt(this.bp);
                return;
            }
            throw new JSONException("unclosed str");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean seekArrayToItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index must > 0, but " + n);
        }
        if (this.token == 20) {
            return false;
        }
        if (this.token != 14) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < n; ++i) {
            this.skipWhitespace();
            if (this.ch == '\"' || this.ch == '\'') {
                this.skipString();
                if (this.ch == ',') {
                    this.next();
                    continue;
                }
                if (this.ch == ']') {
                    this.next();
                    this.nextToken(16);
                    return false;
                }
                throw new JSONException("illegal json.");
            }
            if (this.ch == '{') {
                this.next();
                this.token = 12;
                this.skipObject(false);
            } else if (this.ch == '[') {
                this.next();
                this.token = 14;
                this.skipArray(false);
            } else {
                boolean bl = false;
                for (int j = this.bp + 1; j < this.text.length(); ++j) {
                    char c2 = this.text.charAt(j);
                    if (c2 == ',') {
                        bl = true;
                        this.bp = j + 1;
                        this.ch = this.charAt(this.bp);
                        break;
                    }
                    if (c2 != ']') continue;
                    this.bp = j + 1;
                    this.ch = this.charAt(this.bp);
                    this.nextToken();
                    return false;
                }
                if (bl) continue;
                throw new JSONException("illegal json.");
            }
            if (this.token == 16) continue;
            if (this.token == 15) {
                return false;
            }
            throw new UnsupportedOperationException();
        }
        this.nextToken();
        return true;
    }

    @Override
    public int seekObjectToField(long l, boolean bl) {
        block57: {
            if (this.token == 20) {
                return -1;
            }
            if (this.token == 13 || this.token == 15) {
                this.nextToken();
                return -1;
            }
            if (this.token != 12 && this.token != 16) {
                throw new UnsupportedOperationException(JSONToken.name(this.token));
            }
            while (true) {
                int n;
                long l2;
                if (this.ch == '}') {
                    this.next();
                    this.nextToken();
                    return -1;
                }
                if (this.ch == '\u001a') {
                    return -1;
                }
                if (this.ch != '\"') {
                    this.skipWhitespace();
                }
                if (this.ch == '\"') {
                    l2 = -3750763034362895579L;
                    for (n = this.bp + 1; n < this.text.length(); ++n) {
                        char c2 = this.text.charAt(n);
                        if (c2 == '\\') {
                            if (++n == this.text.length()) {
                                throw new JSONException("unclosed str, " + this.info());
                            }
                            c2 = this.text.charAt(n);
                        }
                        if (c2 == '\"') {
                            this.bp = n + 1;
                            this.ch = (char)(this.bp >= this.text.length() ? 26 : (int)this.text.charAt(this.bp));
                            break;
                        }
                        l2 ^= (long)c2;
                        l2 *= 1099511628211L;
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                if (l2 == l) {
                    if (this.ch != ':') {
                        this.skipWhitespace();
                    }
                    if (this.ch == ':') {
                        this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                        if (this.ch == ',') {
                            this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                            this.token = 16;
                        } else if (this.ch == ']') {
                            this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                            this.token = 15;
                        } else if (this.ch == '}') {
                            this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                            this.token = 13;
                        } else if (this.ch >= '0' && this.ch <= '9') {
                            this.sp = 0;
                            this.pos = this.bp;
                            this.scanNumber();
                        } else {
                            this.nextToken(2);
                        }
                    }
                    return 3;
                }
                if (this.ch != ':') {
                    this.skipWhitespace();
                }
                if (this.ch != ':') {
                    throw new JSONException("illegal json, " + this.info());
                }
                this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                if (this.ch != '\"' && this.ch != '\'' && this.ch != '{' && this.ch != '[' && this.ch != '0' && this.ch != '1' && this.ch != '2' && this.ch != '3' && this.ch != '4' && this.ch != '5' && this.ch != '6' && this.ch != '7' && this.ch != '8' && this.ch != '9' && this.ch != '+' && this.ch != '-') {
                    this.skipWhitespace();
                }
                if (this.ch == '-' || this.ch == '+' || this.ch >= '0' && this.ch <= '9') {
                    this.next();
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                    if (this.ch == '.') {
                        this.next();
                        while (this.ch >= '0' && this.ch <= '9') {
                            this.next();
                        }
                    }
                    if (this.ch == 'E' || this.ch == 'e') {
                        this.next();
                        if (this.ch == '-' || this.ch == '+') {
                            this.next();
                        }
                        while (this.ch >= '0' && this.ch <= '9') {
                            this.next();
                        }
                    }
                    if (this.ch != ',') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == '\"') {
                    this.skipString();
                    if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == 't') {
                    this.next();
                    if (this.ch == 'r') {
                        this.next();
                        if (this.ch == 'u') {
                            this.next();
                            if (this.ch == 'e') {
                                this.next();
                            }
                        }
                    }
                    if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == 'n') {
                    this.next();
                    if (this.ch == 'u') {
                        this.next();
                        if (this.ch == 'l') {
                            this.next();
                            if (this.ch == 'l') {
                                this.next();
                            }
                        }
                    }
                    if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == 'f') {
                    this.next();
                    if (this.ch == 'a') {
                        this.next();
                        if (this.ch == 'l') {
                            this.next();
                            if (this.ch == 's') {
                                this.next();
                                if (this.ch == 'e') {
                                    this.next();
                                }
                            }
                        }
                    }
                    if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == '{') {
                    this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                    if (bl) {
                        this.token = 12;
                        return 1;
                    }
                    this.skipObject(false);
                    if (this.token != 13) continue;
                    return -1;
                }
                if (this.ch != '[') break block57;
                this.next();
                if (bl) {
                    this.token = 14;
                    return 2;
                }
                this.skipArray(false);
                if (this.token == 13) break;
            }
            return -1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int seekObjectToField(long[] lArray) {
        if (this.token != 12 && this.token != 16) {
            throw new UnsupportedOperationException();
        }
        while (true) {
            int n;
            int n2;
            long l;
            if (this.ch == '}') {
                this.next();
                this.nextToken();
                this.matchStat = -1;
                return -1;
            }
            if (this.ch == '\u001a') {
                this.matchStat = -1;
                return -1;
            }
            if (this.ch != '\"') {
                this.skipWhitespace();
            }
            if (this.ch == '\"') {
                l = -3750763034362895579L;
                for (n2 = this.bp + 1; n2 < this.text.length(); ++n2) {
                    n = this.text.charAt(n2);
                    if (n == 92) {
                        if (++n2 == this.text.length()) {
                            throw new JSONException("unclosed str, " + this.info());
                        }
                        n = this.text.charAt(n2);
                    }
                    if (n == 34) {
                        this.bp = n2 + 1;
                        this.ch = (char)(this.bp >= this.text.length() ? 26 : (int)this.text.charAt(this.bp));
                        break;
                    }
                    l ^= (long)n;
                    l *= 1099511628211L;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            n2 = -1;
            for (n = 0; n < lArray.length; ++n) {
                if (l != lArray[n]) continue;
                n2 = n;
                break;
            }
            if (n2 != -1) {
                if (this.ch != ':') {
                    this.skipWhitespace();
                }
                if (this.ch == ':') {
                    this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                    if (this.ch == ',') {
                        this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                        this.token = 16;
                    } else if (this.ch == ']') {
                        this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                        this.token = 15;
                    } else if (this.ch == '}') {
                        this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                        this.token = 13;
                    } else if (this.ch >= '0' && this.ch <= '9') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanNumber();
                    } else {
                        this.nextToken(2);
                    }
                }
                this.matchStat = 3;
                return n2;
            }
            if (this.ch != ':') {
                this.skipWhitespace();
            }
            if (this.ch != ':') {
                throw new JSONException("illegal json, " + this.info());
            }
            this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
            if (this.ch != '\"' && this.ch != '\'' && this.ch != '{' && this.ch != '[' && this.ch != '0' && this.ch != '1' && this.ch != '2' && this.ch != '3' && this.ch != '4' && this.ch != '5' && this.ch != '6' && this.ch != '7' && this.ch != '8' && this.ch != '9' && this.ch != '+' && this.ch != '-') {
                this.skipWhitespace();
            }
            if (this.ch == '-' || this.ch == '+' || this.ch >= '0' && this.ch <= '9') {
                this.next();
                while (this.ch >= '0' && this.ch <= '9') {
                    this.next();
                }
                if (this.ch == '.') {
                    this.next();
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                }
                if (this.ch == 'E' || this.ch == 'e') {
                    this.next();
                    if (this.ch == '-' || this.ch == '+') {
                        this.next();
                    }
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                }
                if (this.ch != ',') {
                    this.skipWhitespace();
                }
                if (this.ch != ',') continue;
                this.next();
                continue;
            }
            if (this.ch == '\"') {
                this.skipString();
                if (this.ch != ',' && this.ch != '}') {
                    this.skipWhitespace();
                }
                if (this.ch != ',') continue;
                this.next();
                continue;
            }
            if (this.ch == '{') {
                this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                this.skipObject(false);
                continue;
            }
            if (this.ch != '[') break;
            this.next();
            this.skipArray(false);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        int n;
        if (this.text.startsWith("\"@type\":\"", this.bp) && (n = this.text.indexOf(34, this.bp + 9)) != -1) {
            this.bp += 9;
            int n2 = 0;
            for (int i = this.bp; i < n; ++i) {
                n2 = 31 * n2 + this.text.charAt(i);
            }
            String string = this.addSymbol(this.bp, n - this.bp, n2, symbolTable);
            char c2 = this.text.charAt(n + 1);
            if (c2 != ',' && c2 != ']') {
                return null;
            }
            this.bp = n + 2;
            this.ch = this.text.charAt(this.bp);
            return string;
        }
        return null;
    }
}

