/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.annotation.JSONType;
import com.icbc.api.internal.util.fastjson.asm.ClassReader;
import com.icbc.api.internal.util.fastjson.asm.TypeCollector;
import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.SymbolTable;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ASMDeserializerFactory;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.AutowiredObjectDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.EnumDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.FieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.JSONPDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.JavaObjectDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.Jdk8DateCodec;
import com.icbc.api.internal.util.fastjson.parser.deserializer.MapDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.NumberDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.OptionalCodec;
import com.icbc.api.internal.util.fastjson.parser.deserializer.PropertyProcessable;
import com.icbc.api.internal.util.fastjson.parser.deserializer.PropertyProcessableDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.SqlDateDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.StackTraceElementDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ThrowableDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.TimeDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.AtomicCodec;
import com.icbc.api.internal.util.fastjson.serializer.AwtCodec;
import com.icbc.api.internal.util.fastjson.serializer.BigDecimalCodec;
import com.icbc.api.internal.util.fastjson.serializer.BigIntegerCodec;
import com.icbc.api.internal.util.fastjson.serializer.BooleanCodec;
import com.icbc.api.internal.util.fastjson.serializer.ByteBufferCodec;
import com.icbc.api.internal.util.fastjson.serializer.CalendarCodec;
import com.icbc.api.internal.util.fastjson.serializer.CharArrayCodec;
import com.icbc.api.internal.util.fastjson.serializer.CharacterCodec;
import com.icbc.api.internal.util.fastjson.serializer.CollectionCodec;
import com.icbc.api.internal.util.fastjson.serializer.DateCodec;
import com.icbc.api.internal.util.fastjson.serializer.FloatCodec;
import com.icbc.api.internal.util.fastjson.serializer.IntegerCodec;
import com.icbc.api.internal.util.fastjson.serializer.LongCodec;
import com.icbc.api.internal.util.fastjson.serializer.MiscCodec;
import com.icbc.api.internal.util.fastjson.serializer.ObjectArrayCodec;
import com.icbc.api.internal.util.fastjson.serializer.ReferenceCodec;
import com.icbc.api.internal.util.fastjson.serializer.StringCodec;
import com.icbc.api.internal.util.fastjson.spi.Module;
import com.icbc.api.internal.util.fastjson.util.ASMClassLoader;
import com.icbc.api.internal.util.fastjson.util.ASMUtils;
import com.icbc.api.internal.util.fastjson.util.FieldInfo;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.fastjson.util.IdentityHashMap;
import com.icbc.api.internal.util.fastjson.util.JavaBeanInfo;
import com.icbc.api.internal.util.fastjson.util.ServiceLoader;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import com.icbc.api.internal.util.internal.util.fastjson.JSONPObject;
import com.icbc.api.internal.util.internal.util.fastjson.JSONPath;
import com.icbc.api.internal.util.internal.util.fastjson.PropertyNamingStrategy;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.xml.datatype.XMLGregorianCalendar;

public class ParserConfig {
    public static final String DENY_PROPERTY_INTERNAL = "fastjson.parser.deny.internal";
    public static final String DENY_PROPERTY = "fastjson.parser.deny";
    public static final String AUTOTYPE_ACCEPT = "fastjson.parser.autoTypeAccept";
    public static final String AUTOTYPE_SUPPORT_PROPERTY = "fastjson.parser.autoTypeSupport";
    public static final String SAFE_MODE_PROPERTY = "fastjson.parser.safeMode";
    public static final String[] DENYS_INTERNAL;
    public static final String[] DENYS;
    private static final String[] AUTO_TYPE_ACCEPT_LIST;
    public static final boolean AUTO_SUPPORT;
    public static final boolean SAFE_MODE;
    private static final long[] INTERNAL_WHITELIST_HASHCODES;
    public static ParserConfig global;
    private final IdentityHashMap<Type, ObjectDeserializer> deserializers = new IdentityHashMap();
    private final IdentityHashMap<Type, IdentityHashMap<Type, ObjectDeserializer>> mixInDeserializers = new IdentityHashMap(16);
    private final ConcurrentMap<String, Class<?>> typeMapping = new ConcurrentHashMap(16, 0.75f, 1);
    private boolean asmEnable = !ASMUtils.IS_ANDROID;
    public final SymbolTable symbolTable = new SymbolTable(4096);
    public PropertyNamingStrategy propertyNamingStrategy;
    protected ClassLoader defaultClassLoader;
    protected ASMDeserializerFactory asmFactory;
    private static boolean awtError;
    private static boolean jdk8Error;
    private static boolean jodaError;
    private static boolean guavaError;
    private boolean autoTypeSupport = AUTO_SUPPORT;
    private long[] internalDenyHashCodes;
    private long[] denyHashCodes;
    private long[] acceptHashCodes;
    public final boolean fieldBased;
    private boolean jacksonCompatible = false;
    public boolean compatibleWithJavaBean = TypeUtils.compatibleWithJavaBean;
    private List<Module> modules = new ArrayList<Module>();
    private volatile List<AutoTypeCheckHandler> autoTypeCheckHandlers;
    private boolean safeMode = SAFE_MODE;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this(false);
    }

    public ParserConfig(boolean bl) {
        this(null, null, bl);
    }

    public ParserConfig(ClassLoader classLoader) {
        this(null, classLoader, false);
    }

    public ParserConfig(ASMDeserializerFactory aSMDeserializerFactory) {
        this(aSMDeserializerFactory, null, false);
    }

    private ParserConfig(ASMDeserializerFactory aSMDeserializerFactory, ClassLoader classLoader, boolean bl) {
        this.denyHashCodes = new long[]{-9164606388214699518L, -8720046426850100497L, -8649961213709896794L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4703320437989596122L, -4608341446948126581L, -4438775680185074100L, -4314457471973557243L, -4082057040235125754L, -3975378478825053783L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -905177026366752536L, -831789045734283466L, -582813228520337988L, -254670111376247151L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3794316665763266033L, 4046190361520671643L, 4147696707147271408L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5944107969236155580L, 6007332606592876737L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6734240326434096246L, 6742705432718011780L, 6854854816081053523L, 7123326897294507060L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8389032537095247355L, 8409640769019589119L, 8488266005336625107L, 8537233257283452655L, 8838294710098435315L, 9140390920032557669L, 9140416208800006522L};
        long[] lArray = new long[AUTO_TYPE_ACCEPT_LIST.length];
        for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
            lArray[i] = TypeUtils.fnv1a_64(AUTO_TYPE_ACCEPT_LIST[i]);
        }
        Arrays.sort(lArray);
        this.acceptHashCodes = lArray;
        this.fieldBased = bl;
        if (aSMDeserializerFactory == null && !ASMUtils.IS_ANDROID) {
            try {
                aSMDeserializerFactory = classLoader == null ? new ASMDeserializerFactory(new ASMClassLoader()) : new ASMDeserializerFactory(classLoader);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (AccessControlException accessControlException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        this.asmFactory = aSMDeserializerFactory;
        if (aSMDeserializerFactory == null) {
            this.asmEnable = false;
        }
        this.initDeserializers();
        this.addItemsToDeny(DENYS);
        this.addItemsToDeny0(DENYS_INTERNAL);
        this.addItemsToAccept(AUTO_TYPE_ACCEPT_LIST);
    }

    private void initDeserializers() {
        this.deserializers.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Timestamp.class), SqlDateDeserializer.instance_timestamp);
        this.deserializers.put((Type)((Object)java.sql.Date.class), SqlDateDeserializer.instance);
        this.deserializers.put((Type)((Object)Time.class), TimeDeserializer.instance);
        this.deserializers.put((Type)((Object)Date.class), DateCodec.instance);
        this.deserializers.put((Type)((Object)Calendar.class), CalendarCodec.instance);
        this.deserializers.put((Type)((Object)XMLGregorianCalendar.class), CalendarCodec.instance);
        this.deserializers.put((Type)((Object)JSONObject.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)JSONArray.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)Collection.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)List.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)ArrayList.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)String.class), StringCodec.instance);
        this.deserializers.put((Type)((Object)StringBuffer.class), StringCodec.instance);
        this.deserializers.put((Type)((Object)StringBuilder.class), StringCodec.instance);
        this.deserializers.put(Character.TYPE, CharacterCodec.instance);
        this.deserializers.put((Type)((Object)Character.class), CharacterCodec.instance);
        this.deserializers.put(Byte.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Byte.class), NumberDeserializer.instance);
        this.deserializers.put(Short.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Short.class), NumberDeserializer.instance);
        this.deserializers.put(Integer.TYPE, IntegerCodec.instance);
        this.deserializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.deserializers.put(Long.TYPE, LongCodec.instance);
        this.deserializers.put((Type)((Object)Long.class), LongCodec.instance);
        this.deserializers.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.deserializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.deserializers.put(Float.TYPE, FloatCodec.instance);
        this.deserializers.put((Type)((Object)Float.class), FloatCodec.instance);
        this.deserializers.put(Double.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Double.class), NumberDeserializer.instance);
        this.deserializers.put(Boolean.TYPE, BooleanCodec.instance);
        this.deserializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.deserializers.put((Type)((Object)Class.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)char[].class), new CharArrayCodec());
        this.deserializers.put((Type)((Object)AtomicBoolean.class), BooleanCodec.instance);
        this.deserializers.put((Type)((Object)AtomicInteger.class), IntegerCodec.instance);
        this.deserializers.put((Type)((Object)AtomicLong.class), LongCodec.instance);
        this.deserializers.put((Type)((Object)AtomicReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)WeakReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)SoftReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Inet4Address.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Inet6Address.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)InetSocketAddress.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)File.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)URI.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)URL.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Charset.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)JSONPath.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Number.class), NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)AtomicIntegerArray.class), AtomicCodec.instance);
        this.deserializers.put((Type)((Object)AtomicLongArray.class), AtomicCodec.instance);
        this.deserializers.put((Type)((Object)StackTraceElement.class), StackTraceElementDeserializer.instance);
        this.deserializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)JSONPObject.class), new JSONPDeserializer());
    }

    private static String[] splitItemsFormProperty(String string) {
        if (string != null && string.length() > 0) {
            return string.split(",");
        }
        return null;
    }

    public void configFromPropety(Properties properties) {
        String string = properties.getProperty(DENY_PROPERTY);
        String[] stringArray = ParserConfig.splitItemsFormProperty(string);
        this.addItemsToDeny(stringArray);
        string = properties.getProperty(AUTOTYPE_ACCEPT);
        stringArray = ParserConfig.splitItemsFormProperty(string);
        this.addItemsToAccept(stringArray);
        string = properties.getProperty(AUTOTYPE_SUPPORT_PROPERTY);
        if ("true".equals(string)) {
            this.autoTypeSupport = true;
        } else if ("false".equals(string)) {
            this.autoTypeSupport = false;
        }
    }

    private void addItemsToDeny0(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.addDenyInternal(string);
        }
    }

    private void addItemsToDeny(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.addDeny(string);
        }
    }

    private void addItemsToAccept(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.addAccept(string);
        }
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean bl) {
        this.safeMode = bl;
    }

    public boolean isAutoTypeSupport() {
        return this.autoTypeSupport;
    }

    public void setAutoTypeSupport(boolean bl) {
        this.autoTypeSupport = bl;
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean bl) {
        this.asmEnable = bl;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDerializers() {
        return this.deserializers;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        WildcardType wildcardType;
        Type[] typeArray;
        ObjectDeserializer objectDeserializer = this.get(type);
        if (objectDeserializer != null) {
            return objectDeserializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)type).getRawType();
            if (type2 instanceof Class) {
                return this.getDeserializer((Class)type2, type);
            }
            return this.getDeserializer(type2);
        }
        if (type instanceof WildcardType && (typeArray = (wildcardType = (WildcardType)type).getUpperBounds()).length == 1) {
            Type type3 = typeArray[0];
            return this.getDeserializer(type3);
        }
        return JavaObjectDeserializer.instance;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectDeserializer getDeserializer(Class<?> clazz, Type clazz2) {
        Class<?> object3;
        ObjectDeserializer objectDeserializer = this.get(clazz2);
        if (objectDeserializer != null) {
            return objectDeserializer;
        }
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        if ((objectDeserializer = this.get(clazz2)) != null) {
            return objectDeserializer;
        }
        Object object2 = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (object2 != null && (object3 = object2.mappingTo()) != Void.class) {
            return this.getDeserializer(object3, object3);
        }
        if (clazz2 instanceof WildcardType || clazz2 instanceof TypeVariable || clazz2 instanceof ParameterizedType) {
            objectDeserializer = this.get(clazz);
        }
        if (objectDeserializer != null) {
            return objectDeserializer;
        }
        for (Module module : this.modules) {
            objectDeserializer = module.createDeserializer(this, clazz);
            if (objectDeserializer == null) continue;
            this.putDeserializer(clazz2, objectDeserializer);
            return objectDeserializer;
        }
        object2 = clazz.getName();
        if (((String)(object2 = ((String)object2).replace('$', '.'))).startsWith("java.awt.") && AwtCodec.support(clazz) && !awtError) {
            String[] stringArray = new String[]{"java.awt.Point", "java.awt.Font", "java.awt.Rectangle", "java.awt.Color"};
            try {
                for (String string : stringArray) {
                    if (!string.equals(object2)) continue;
                    objectDeserializer = AwtCodec.instance;
                    this.putDeserializer(Class.forName(string), objectDeserializer);
                    return objectDeserializer;
                }
            }
            catch (Throwable throwable) {
                awtError = true;
            }
            objectDeserializer = AwtCodec.instance;
        }
        if (!jdk8Error) {
            try {
                if (((String)object2).startsWith("java.time.")) {
                    String[] stringArray = new String[]{"java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.ZoneOffset", "java.time.ZoneRegion", "java.time.ZoneId", "java.time.Period", "java.time.Duration", "java.time.Instant"};
                    for (String string : stringArray) {
                        if (!string.equals(object2)) continue;
                        objectDeserializer = Jdk8DateCodec.instance;
                        this.putDeserializer(Class.forName(string), objectDeserializer);
                        return objectDeserializer;
                    }
                } else if (((String)object2).startsWith("java.util.Optional")) {
                    String[] stringArray = new String[]{"java.util.Optional", "java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong"};
                    for (String string : stringArray) {
                        if (!string.equals(object2)) continue;
                        objectDeserializer = OptionalCodec.instance;
                        this.putDeserializer(Class.forName(string), objectDeserializer);
                        return objectDeserializer;
                    }
                }
            }
            catch (Throwable throwable) {
                jdk8Error = true;
            }
        }
        if (((String)object2).equals("java.nio.ByteBuffer")) {
            objectDeserializer = ByteBufferCodec.instance;
            this.putDeserializer(clazz, objectDeserializer);
        }
        if (((String)object2).equals("java.nio.file.Path")) {
            objectDeserializer = MiscCodec.instance;
            this.putDeserializer(clazz, objectDeserializer);
        }
        if (clazz == Map.Entry.class) {
            objectDeserializer = MiscCodec.instance;
            this.putDeserializer(clazz, objectDeserializer);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AutowiredObjectDeserializer autowiredObjectDeserializer : ServiceLoader.load(AutowiredObjectDeserializer.class, classLoader)) {
                for (Type type : autowiredObjectDeserializer.getAutowiredFor()) {
                    this.putDeserializer(type, autowiredObjectDeserializer);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectDeserializer == null) {
            objectDeserializer = this.get(clazz2);
        }
        if (objectDeserializer != null) {
            return objectDeserializer;
        }
        if (clazz.isEnum()) {
            Object object;
            if (this.jacksonCompatible) {
                void var9_35;
                object = clazz.getMethods();
                Object[] objectArray = object;
                int n = objectArray.length;
                boolean bl = false;
                while (var9_35 < n) {
                    Object object4 = objectArray[var9_35];
                    if (TypeUtils.isJacksonCreator((Method)object4)) {
                        objectDeserializer = this.createJavaBeanDeserializer(clazz, clazz2);
                        this.putDeserializer(clazz2, objectDeserializer);
                        return objectDeserializer;
                    }
                    ++var9_35;
                }
            }
            object = null;
            JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
            if (jSONType != null) {
                object = jSONType.deserializer();
                try {
                    objectDeserializer = (ObjectDeserializer)((Class)object).newInstance();
                    this.putDeserializer(clazz, objectDeserializer);
                    return objectDeserializer;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            objectDeserializer = this.getEnumDeserializer(clazz);
        } else {
            objectDeserializer = clazz.isArray() ? ObjectArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : (PropertyProcessable.class.isAssignableFrom(clazz) ? new PropertyProcessableDeserializer(clazz) : (clazz == InetAddress.class ? MiscCodec.instance : this.createJavaBeanDeserializer(clazz, clazz2)))))));
        }
        this.putDeserializer(clazz2, objectDeserializer);
        return objectDeserializer;
    }

    protected ObjectDeserializer getEnumDeserializer(Class<?> clazz) {
        return new EnumDeserializer(clazz);
    }

    public void initJavaBeanDeserializers(Class<?> ... classArray) {
        if (classArray == null) {
            return;
        }
        for (Class<?> clazz : classArray) {
            if (clazz == null) continue;
            ObjectDeserializer objectDeserializer = this.createJavaBeanDeserializer(clazz, clazz);
            this.putDeserializer(clazz, objectDeserializer);
        }
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        GenericDeclaration genericDeclaration;
        Object object;
        boolean bl = this.asmEnable & !this.fieldBased;
        if (bl) {
            object = TypeUtils.getAnnotation(clazz, JSONType.class);
            if (object != null) {
                genericDeclaration = object.deserializer();
                if (genericDeclaration != Void.class) {
                    try {
                        Object object2 = genericDeclaration.newInstance();
                        if (object2 instanceof ObjectDeserializer) {
                            return (ObjectDeserializer)object2;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                bl = object.asm();
            }
            if (bl) {
                genericDeclaration = JavaBeanInfo.getBuilderClass(clazz, (JSONType)object);
                if (genericDeclaration == null) {
                    genericDeclaration = clazz;
                }
                do {
                    if (Modifier.isPublic(genericDeclaration.getModifiers())) continue;
                    bl = false;
                    break;
                } while ((genericDeclaration = genericDeclaration.getSuperclass()) != Object.class && genericDeclaration != null);
            }
        }
        if (clazz.getTypeParameters().length != 0) {
            bl = false;
        }
        if (bl && this.asmFactory != null && this.asmFactory.classLoader.isExternalClass(clazz)) {
            bl = false;
        }
        if (bl) {
            bl = ASMUtils.checkName(clazz.getSimpleName());
        }
        if (bl) {
            if (clazz.isInterface()) {
                bl = false;
            }
            object = JavaBeanInfo.build(clazz, type, this.propertyNamingStrategy, false, TypeUtils.compatibleWithJavaBean, this.jacksonCompatible);
            if (bl && ((JavaBeanInfo)object).fields.length > 200) {
                bl = false;
            }
            genericDeclaration = ((JavaBeanInfo)object).defaultConstructor;
            if (bl && genericDeclaration == null && !clazz.isInterface()) {
                bl = false;
            }
            for (FieldInfo fieldInfo : ((JavaBeanInfo)object).fields) {
                ObjectDeserializer objectDeserializer;
                if (fieldInfo.getOnly) {
                    bl = false;
                    break;
                }
                Class<?> clazz2 = fieldInfo.fieldClass;
                if (!Modifier.isPublic(clazz2.getModifiers())) {
                    bl = false;
                    break;
                }
                if (clazz2.isMemberClass() && !Modifier.isStatic(clazz2.getModifiers())) {
                    bl = false;
                    break;
                }
                if (fieldInfo.getMember() != null && !ASMUtils.checkName(fieldInfo.getMember().getName())) {
                    bl = false;
                    break;
                }
                JSONField jSONField = fieldInfo.getAnnotation();
                if (jSONField != null && (!ASMUtils.checkName(jSONField.name()) || jSONField.format().length() != 0 || jSONField.deserializeUsing() != Void.class || jSONField.parseFeatures().length != 0 || jSONField.unwrapped()) || fieldInfo.method != null && fieldInfo.method.getParameterTypes().length > 1) {
                    bl = false;
                    break;
                }
                if (!clazz2.isEnum() || (objectDeserializer = this.getDeserializer(clazz2)) instanceof EnumDeserializer) continue;
                bl = false;
                break;
            }
        }
        if (bl && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            bl = false;
        }
        if (bl && TypeUtils.isXmlField(clazz)) {
            bl = false;
        }
        if (!bl) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        object = JavaBeanInfo.build(clazz, type, this.propertyNamingStrategy);
        try {
            return this.asmFactory.createJavaBeanDeserializer(this, (JavaBeanInfo)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        catch (JSONException jSONException) {
            return new JavaBeanDeserializer(this, (JavaBeanInfo)object);
        }
        catch (Exception exception) {
            throw new JSONException("create asm deserializer error, " + clazz.getName(), exception);
        }
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig parserConfig, JavaBeanInfo javaBeanInfo, FieldInfo fieldInfo) {
        Class<?> clazz = javaBeanInfo.clazz;
        Class<?> clazz2 = fieldInfo.fieldClass;
        Class<?> clazz3 = null;
        JSONField jSONField = fieldInfo.getAnnotation();
        if (jSONField != null && (clazz3 = jSONField.deserializeUsing()) == Void.class) {
            clazz3 = null;
        }
        if (clazz3 == null && (clazz2 == List.class || clazz2 == ArrayList.class)) {
            return new ArrayListTypeFieldDeserializer(parserConfig, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(parserConfig, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer objectDeserializer) {
        Type type2 = JSON.getMixInAnnotations(type);
        if (type2 != null) {
            IdentityHashMap<Type, ObjectDeserializer> identityHashMap = this.mixInDeserializers.get(type);
            if (identityHashMap == null) {
                identityHashMap = new IdentityHashMap(4);
                this.mixInDeserializers.put(type, identityHashMap);
            }
            identityHashMap.put(type2, objectDeserializer);
        } else {
            this.deserializers.put(type, objectDeserializer);
        }
    }

    public ObjectDeserializer get(Type type) {
        Type type2 = JSON.getMixInAnnotations(type);
        if (null == type2) {
            return this.deserializers.get(type);
        }
        IdentityHashMap<Type, ObjectDeserializer> identityHashMap = this.mixInDeserializers.get(type);
        if (identityHashMap == null) {
            return null;
        }
        return identityHashMap.get(type2);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        return this.getDeserializer(fieldInfo.fieldClass, fieldInfo.fieldType);
    }

    public boolean isPrimitive(Class<?> clazz) {
        return ParserConfig.isPrimitive2(clazz);
    }

    public static boolean isPrimitive2(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == Date.class || clazz == java.sql.Date.class || clazz == Time.class || clazz == Timestamp.class || clazz.isEnum();
    }

    public static void parserAllFieldToCache(Class<?> clazz, Map<String, Field> map) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            String string = field.getName();
            if (map.containsKey(string)) continue;
            map.put(string, field);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            ParserConfig.parserAllFieldToCache(clazz.getSuperclass(), map);
        }
    }

    public static Field getFieldFromCache(String string, Map<String, Field> map) {
        Field field = map.get(string);
        if (field == null) {
            field = map.get("_" + string);
        }
        if (field == null) {
            field = map.get("m_" + string);
        }
        if (field == null) {
            char c2 = string.charAt(0);
            if (c2 >= 'a' && c2 <= 'z') {
                char[] cArray = string.toCharArray();
                cArray[0] = (char)(cArray[0] - 32);
                String string2 = new String(cArray);
                field = map.get(string2);
            }
            if (string.length() > 2) {
                char c3 = string.charAt(1);
                if (string.length() > 2 && c2 >= 'a' && c2 <= 'z' && c3 >= 'A' && c3 <= 'Z') {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!string.equalsIgnoreCase((String)entry.getKey())) continue;
                        field = (Field)entry.getValue();
                        break;
                    }
                }
            }
        }
        return field;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader classLoader) {
        this.defaultClassLoader = classLoader;
    }

    public void addDenyInternal(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        long l = TypeUtils.fnv1a_64(string);
        if (this.internalDenyHashCodes == null) {
            this.internalDenyHashCodes = new long[]{l};
            return;
        }
        if (Arrays.binarySearch(this.internalDenyHashCodes, l) >= 0) {
            return;
        }
        long[] lArray = new long[this.internalDenyHashCodes.length + 1];
        lArray[lArray.length - 1] = l;
        System.arraycopy(this.internalDenyHashCodes, 0, lArray, 0, this.internalDenyHashCodes.length);
        Arrays.sort(lArray);
        this.internalDenyHashCodes = lArray;
    }

    public void addDeny(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        long l = TypeUtils.fnv1a_64(string);
        if (Arrays.binarySearch(this.denyHashCodes, l) >= 0) {
            return;
        }
        long[] lArray = new long[this.denyHashCodes.length + 1];
        lArray[lArray.length - 1] = l;
        System.arraycopy(this.denyHashCodes, 0, lArray, 0, this.denyHashCodes.length);
        Arrays.sort(lArray);
        this.denyHashCodes = lArray;
    }

    public void addAccept(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        long l = TypeUtils.fnv1a_64(string);
        if (Arrays.binarySearch(this.acceptHashCodes, l) >= 0) {
            return;
        }
        long[] lArray = new long[this.acceptHashCodes.length + 1];
        lArray[lArray.length - 1] = l;
        System.arraycopy(this.acceptHashCodes, 0, lArray, 0, this.acceptHashCodes.length);
        Arrays.sort(lArray);
        this.acceptHashCodes = lArray;
    }

    public Class<?> checkAutoType(Class clazz) {
        if (this.get(clazz) != null) {
            return clazz;
        }
        return this.checkAutoType(clazz.getName(), null, JSON.DEFAULT_PARSER_FEATURE);
    }

    public Class<?> checkAutoType(String string, Class<?> clazz) {
        return this.checkAutoType(string, clazz, JSON.DEFAULT_PARSER_FEATURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Class<?> checkAutoType(String string, Class<?> clazz, int n) {
        boolean bl;
        Object object;
        InputStream inputStream;
        boolean bl2;
        Class<?> clazz2;
        boolean bl3;
        block35: {
            int n2;
            long l;
            boolean bl4;
            long l2;
            boolean bl5;
            if (string == null) {
                return null;
            }
            if (this.autoTypeCheckHandlers != null) {
                for (AutoTypeCheckHandler autoTypeCheckHandler : this.autoTypeCheckHandlers) {
                    Class<?> clazz3 = autoTypeCheckHandler.handler(string, clazz, n);
                    if (clazz3 == null) continue;
                    return clazz3;
                }
            }
            int n3 = Feature.SafeMode.mask;
            boolean bl6 = bl5 = this.safeMode || (n & n3) != 0 || (JSON.DEFAULT_PARSER_FEATURE & n3) != 0;
            if (bl5) {
                throw new JSONException("safeMode not support autoType : " + string);
            }
            if (string.length() >= 192 || string.length() < 3) {
                throw new JSONException("autoType is not support. " + string);
            }
            bl3 = clazz == null ? false : (l2 = TypeUtils.fnv1a_64(clazz.getName())) != -8024746738719829346L && l2 != 3247277300971823414L && l2 != -5811778396720452501L && l2 != -1368967840069965882L && l2 != 2980334044947851925L && l2 != 5183404141909004468L && l2 != 7222019943667248779L && l2 != -2027296626235911549L && l2 != -2114196234051346931L && l2 != -2939497380989775398L;
            String string2 = string.replace('$', '.');
            long l3 = -3750763034362895579L;
            long l4 = 1099511628211L;
            long l5 = (0xCBF29CE484222325L ^ (long)string2.charAt(0)) * 1099511628211L;
            if (l5 == -5808493101479473382L) {
                throw new JSONException("autoType is not support. " + string);
            }
            if ((l5 ^ (long)string2.charAt(string2.length() - 1)) * 1099511628211L == 655701488918567152L) {
                throw new JSONException("autoType is not support. " + string);
            }
            long l6 = (((0xCBF29CE484222325L ^ (long)string2.charAt(0)) * 1099511628211L ^ (long)string2.charAt(1)) * 1099511628211L ^ (long)string2.charAt(2)) * 1099511628211L;
            long l7 = TypeUtils.fnv1a_64(string2);
            boolean bl7 = bl4 = Arrays.binarySearch(INTERNAL_WHITELIST_HASHCODES, l7) >= 0;
            if (this.internalDenyHashCodes != null) {
                l = l6;
                for (n2 = 3; n2 < string2.length(); ++n2) {
                    l ^= (long)string2.charAt(n2);
                    if (Arrays.binarySearch(this.internalDenyHashCodes, l *= 1099511628211L) < 0) continue;
                    throw new JSONException("autoType is not support. " + string);
                }
            }
            if (!bl4 && (this.autoTypeSupport || bl3)) {
                l = l6;
                for (n2 = 3; n2 < string2.length(); ++n2) {
                    l ^= (long)string2.charAt(n2);
                    if (Arrays.binarySearch(this.acceptHashCodes, l *= 1099511628211L) >= 0 && (clazz2 = TypeUtils.loadClass(string, this.defaultClassLoader, true)) != null) {
                        return clazz2;
                    }
                    if (Arrays.binarySearch(this.denyHashCodes, l) < 0 || TypeUtils.getClassFromMapping(string) != null || Arrays.binarySearch(this.acceptHashCodes, l7) >= 0) continue;
                    throw new JSONException("autoType is not support. " + string);
                }
            }
            if ((clazz2 = TypeUtils.getClassFromMapping(string)) == null) {
                clazz2 = this.deserializers.findClass(string);
            }
            if (clazz2 == null) {
                clazz2 = (Class)this.typeMapping.get(string);
            }
            if (bl4) {
                clazz2 = TypeUtils.loadClass(string, this.defaultClassLoader, true);
            }
            if (clazz2 != null) {
                if (clazz != null && clazz2 != HashMap.class && !clazz.isAssignableFrom(clazz2)) {
                    throw new JSONException("type not match. " + string + " -> " + clazz.getName());
                }
                return clazz2;
            }
            if (!this.autoTypeSupport) {
                l = l6;
                for (n2 = 3; n2 < string2.length(); ++n2) {
                    char c2 = string2.charAt(n2);
                    l ^= (long)c2;
                    if (Arrays.binarySearch(this.denyHashCodes, l *= 1099511628211L) >= 0) {
                        throw new JSONException("autoType is not support. " + string);
                    }
                    if (Arrays.binarySearch(this.acceptHashCodes, l) < 0) continue;
                    clazz2 = TypeUtils.loadClass(string, this.defaultClassLoader, true);
                    if (clazz2 == null) {
                        return clazz;
                    }
                    if (clazz != null && clazz.isAssignableFrom(clazz2)) {
                        throw new JSONException("type not match. " + string + " -> " + clazz.getName());
                    }
                    return clazz2;
                }
            }
            bl2 = false;
            inputStream = null;
            try {
                String string3 = string.replace('.', '/') + ".class";
                inputStream = this.defaultClassLoader != null ? this.defaultClassLoader.getResourceAsStream(string3) : ParserConfig.class.getClassLoader().getResourceAsStream(string3);
                if (inputStream == null) break block35;
                ClassReader classReader = new ClassReader(inputStream, true);
                object = new TypeCollector("<clinit>", new Class[0]);
                classReader.accept((TypeCollector)object);
                bl2 = ((TypeCollector)object).hasJsonType();
            }
            catch (Exception exception) {
                IOUtils.close(inputStream);
                catch (Throwable throwable) {
                    IOUtils.close(inputStream);
                    throw throwable;
                }
            }
        }
        IOUtils.close(inputStream);
        int n4 = Feature.SupportAutoType.mask;
        boolean bl8 = bl = this.autoTypeSupport || (n & n4) != 0 || (JSON.DEFAULT_PARSER_FEATURE & n4) != 0;
        if (bl || bl2 || bl3) {
            boolean bl9 = bl || bl2;
            clazz2 = TypeUtils.loadClass(string, this.defaultClassLoader, bl9);
        }
        if (clazz2 != null) {
            if (bl2) {
                TypeUtils.addMapping(string, clazz2);
                return clazz2;
            }
            if (ClassLoader.class.isAssignableFrom(clazz2) || DataSource.class.isAssignableFrom(clazz2) || RowSet.class.isAssignableFrom(clazz2)) {
                throw new JSONException("autoType is not support. " + string);
            }
            if (clazz != null) {
                if (clazz.isAssignableFrom(clazz2)) {
                    TypeUtils.addMapping(string, clazz2);
                    return clazz2;
                }
                throw new JSONException("type not match. " + string + " -> " + clazz.getName());
            }
            object = JavaBeanInfo.build(clazz2, clazz2, this.propertyNamingStrategy);
            if (((JavaBeanInfo)object).creatorConstructor != null && bl) {
                throw new JSONException("autoType is not support. " + string);
            }
        }
        if (!bl) {
            throw new JSONException("autoType is not support. " + string);
        }
        if (clazz2 != null) {
            TypeUtils.addMapping(string, clazz2);
        }
        return clazz2;
    }

    public void clearDeserializers() {
        this.deserializers.clear();
        this.initDeserializers();
    }

    public boolean isJacksonCompatible() {
        return this.jacksonCompatible;
    }

    public void setJacksonCompatible(boolean bl) {
        this.jacksonCompatible = bl;
    }

    public void register(String string, Class clazz) {
        this.typeMapping.putIfAbsent(string, clazz);
    }

    public void register(Module module) {
        this.modules.add(module);
    }

    public void addAutoTypeCheckHandler(AutoTypeCheckHandler autoTypeCheckHandler) {
        List<AutoTypeCheckHandler> list = this.autoTypeCheckHandlers;
        if (list == null) {
            this.autoTypeCheckHandlers = list = new CopyOnWriteArrayList<AutoTypeCheckHandler>();
        }
        list.add(autoTypeCheckHandler);
    }

    static {
        String string = IOUtils.getStringProperty(DENY_PROPERTY_INTERNAL);
        DENYS_INTERNAL = ParserConfig.splitItemsFormProperty(string);
        string = IOUtils.getStringProperty(DENY_PROPERTY);
        DENYS = ParserConfig.splitItemsFormProperty(string);
        string = IOUtils.getStringProperty(AUTOTYPE_SUPPORT_PROPERTY);
        AUTO_SUPPORT = "true".equals(string);
        string = IOUtils.getStringProperty(SAFE_MODE_PROPERTY);
        SAFE_MODE = "true".equals(string);
        string = IOUtils.getStringProperty(AUTOTYPE_ACCEPT);
        String[] stringArray = ParserConfig.splitItemsFormProperty(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        AUTO_TYPE_ACCEPT_LIST = stringArray;
        INTERNAL_WHITELIST_HASHCODES = new long[]{-9013707057526259810L, -8773806119481270567L, -8421588593326113468L, -8070393259084821111L, -7858127399773263546L, -7043543676283957292L, -6976602508726000783L, -6293031534589903644L, -6081111809668363619L, -5779433778261875721L, -5399450433995651784L, -4540135604787511831L, -4207865850564917696L, -3950343444501679205L, -3714900953609113456L, -3393714734093696063L, -3378497329992063044L, -2631228350337215662L, -2551988546877734201L, -2473987886800209058L, -2265617974881722705L, -1759511109484434299L, -1477946458560579955L, -816725787720647462L, -520183782617964618L, 59775428743665658L, 484499585846206473L, 532945107123976213L, 711449177569584898L, 829148494126372070L, 956883420092542580L, 1233162291719202522L, 1696465274354442213L, 1863557081881630420L, 2238472697200138595L, 2380202963256720577L, 2643099543618286743L, 2793877891138577121L, 3804572268889088203L, 4567982875926242015L, 4784070066737926537L, 4960004821520561233L, 5348524593377618456L, 5454920836284873808L, 5695987590363189151L, 6073645722991901167L, 6114875255374330593L, 6137737446243999215L, 6160752908990493848L, 6939315124833099497L, 7048426940343117278L, 7267793227937552092L, 8331868837379820532L, 8357451534615459155L, 8890227807433646566L, 9166532985682478006L, 9215131087512669423L};
        global = new ParserConfig();
        awtError = false;
        jdk8Error = false;
        jodaError = false;
        guavaError = false;
    }

    public static interface AutoTypeCheckHandler {
        public Class<?> handler(String var1, Class<?> var2, int var3);
    }
}

