/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser;

import com.icbc.api.internal.util.internal.util.fastjson.JSON;

public class SymbolTable {
    private final String[] symbols;
    private final int indexMask;

    public SymbolTable(int n) {
        this.indexMask = n - 1;
        this.symbols = new String[n];
        this.addSymbol("$ref", 0, 4, "$ref".hashCode());
        this.addSymbol(JSON.DEFAULT_TYPE_KEY, 0, JSON.DEFAULT_TYPE_KEY.length(), JSON.DEFAULT_TYPE_KEY.hashCode());
    }

    public String addSymbol(char[] cArray, int n, int n2) {
        int n3 = SymbolTable.hash(cArray, n, n2);
        return this.addSymbol(cArray, n, n2, n3);
    }

    public String addSymbol(char[] cArray, int n, int n2, int n3) {
        int n4 = n3 & this.indexMask;
        String string = this.symbols[n4];
        if (string != null) {
            boolean bl = true;
            if (n3 == string.hashCode() && n2 == string.length()) {
                for (int i = 0; i < n2; ++i) {
                    if (cArray[n + i] == string.charAt(i)) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
            if (bl) {
                return string;
            }
            return new String(cArray, n, n2);
        }
        this.symbols[n4] = string = new String(cArray, n, n2).intern();
        return string;
    }

    public String addSymbol(String string, int n, int n2, int n3) {
        return this.addSymbol(string, n, n2, n3, false);
    }

    public String addSymbol(String string, int n, int n2, int n3, boolean bl) {
        int n4 = n3 & this.indexMask;
        String string2 = this.symbols[n4];
        if (string2 != null) {
            if (n3 == string2.hashCode() && n2 == string2.length() && string.startsWith(string2, n)) {
                return string2;
            }
            String string3 = SymbolTable.subString(string, n, n2);
            if (bl) {
                this.symbols[n4] = string3;
            }
            return string3;
        }
        string2 = n2 == string.length() ? string : SymbolTable.subString(string, n, n2);
        this.symbols[n4] = string2 = string2.intern();
        return string2;
    }

    private static String subString(String string, int n, int n2) {
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        return new String(cArray);
    }

    public static int hash(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        for (int i = 0; i < n2; ++i) {
            n3 = 31 * n3 + cArray[n4++];
        }
        return n3;
    }
}

