/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser.deserializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.ParseContext;
import com.icbc.api.internal.util.fastjson.parser.ParserConfig;
import com.icbc.api.internal.util.fastjson.parser.deserializer.FieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.util.FieldInfo;
import com.icbc.api.internal.util.fastjson.util.ParameterizedTypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ArrayListTypeFieldDeserializer
extends FieldDeserializer {
    private final Type itemType;
    private int itemFastMatchToken;
    private ObjectDeserializer deserializer;

    public ArrayListTypeFieldDeserializer(ParserConfig parserConfig, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
        Type type = fieldInfo.fieldType;
        if (type instanceof ParameterizedType) {
            WildcardType wildcardType;
            Type[] typeArray;
            Type type2 = ((ParameterizedType)fieldInfo.fieldType).getActualTypeArguments()[0];
            if (type2 instanceof WildcardType && (typeArray = (wildcardType = (WildcardType)type2).getUpperBounds()).length == 1) {
                type2 = typeArray[0];
            }
            this.itemType = type2;
        } else {
            this.itemType = Object.class;
        }
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }

    @Override
    public void parseField(DefaultJSONParser defaultJSONParser, Object object, Type type, Map<String, Object> map) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n = jSONLexer.token();
        if (n == 8 || n == 4 && jSONLexer.stringVal().length() == 0) {
            if (object == null) {
                map.put(this.fieldInfo.name, null);
            } else {
                this.setValue(object, null);
            }
            return;
        }
        ArrayList arrayList = new ArrayList();
        ParseContext parseContext = defaultJSONParser.getContext();
        defaultJSONParser.setContext(parseContext, object, this.fieldInfo.name);
        this.parseArray(defaultJSONParser, type, arrayList);
        defaultJSONParser.setContext(parseContext);
        if (object == null) {
            map.put(this.fieldInfo.name, arrayList);
        } else {
            this.setValue(object, arrayList);
        }
    }

    public final void parseArray(DefaultJSONParser defaultJSONParser, Type type, Collection collection) {
        Object object;
        ObjectDeserializer objectDeserializer;
        Type type2;
        block19: {
            Object object2;
            block17: {
                block18: {
                    type2 = this.itemType;
                    objectDeserializer = this.deserializer;
                    if (!(type instanceof ParameterizedType)) break block17;
                    if (!(type2 instanceof TypeVariable)) break block18;
                    object = (TypeVariable)type2;
                    object2 = (Type[])type;
                    Class clazz = null;
                    if (object2.getRawType() instanceof Class) {
                        clazz = (Class)object2.getRawType();
                    }
                    int n = -1;
                    if (clazz != null) {
                        int n2 = clazz.getTypeParameters().length;
                        for (int i = 0; i < n2; ++i) {
                            TypeVariable typeVariable = clazz.getTypeParameters()[i];
                            if (!typeVariable.getName().equals(object.getName())) continue;
                            n = i;
                            break;
                        }
                    }
                    if (n == -1 || (type2 = object2.getActualTypeArguments()[n]).equals(this.itemType)) break block19;
                    objectDeserializer = defaultJSONParser.getConfig().getDeserializer(type2);
                    break block19;
                }
                if (!(type2 instanceof ParameterizedType) || ((Type[])(object2 = (object = (ParameterizedType)type2).getActualTypeArguments())).length != 1 || !(object2[0] instanceof TypeVariable)) break block19;
                TypeVariable typeVariable = (TypeVariable)object2[0];
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class clazz = null;
                if (parameterizedType.getRawType() instanceof Class) {
                    clazz = (Class)parameterizedType.getRawType();
                }
                int n = -1;
                if (clazz != null) {
                    int n3 = clazz.getTypeParameters().length;
                    for (int i = 0; i < n3; ++i) {
                        TypeVariable typeVariable2 = clazz.getTypeParameters()[i];
                        if (!typeVariable2.getName().equals(typeVariable.getName())) continue;
                        n = i;
                        break;
                    }
                }
                if (n != -1) {
                    object2[0] = parameterizedType.getActualTypeArguments()[n];
                    type2 = new ParameterizedTypeImpl((Type[])object2, object.getOwnerType(), object.getRawType());
                }
                break block19;
            }
            if (type2 instanceof TypeVariable && type instanceof Class) {
                object = (Class)type;
                object2 = (TypeVariable)type2;
                ((Class)object).getTypeParameters();
                int n = ((Class)object).getTypeParameters().length;
                for (int i = 0; i < n; ++i) {
                    TypeVariable typeVariable = ((Class)object).getTypeParameters()[i];
                    if (!typeVariable.getName().equals(object2.getName())) continue;
                    Type[] typeArray = typeVariable.getBounds();
                    if (typeArray.length != 1) break;
                    type2 = typeArray[0];
                    break;
                }
            }
        }
        object = defaultJSONParser.lexer;
        int n = object.token();
        if (n == 14) {
            if (objectDeserializer == null) {
                objectDeserializer = this.deserializer = defaultJSONParser.getConfig().getDeserializer(type2);
                this.itemFastMatchToken = this.deserializer.getFastMatchToken();
            }
            object.nextToken(this.itemFastMatchToken);
            int n4 = 0;
            while (true) {
                if (object.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (object.token() == 16) {
                        object.nextToken();
                    }
                }
                if (object.token() == 15) break;
                Object t = objectDeserializer.deserialze(defaultJSONParser, type2, n4);
                collection.add(t);
                defaultJSONParser.checkListResolve(collection);
                if (object.token() == 16) {
                    object.nextToken(this.itemFastMatchToken);
                }
                ++n4;
            }
            object.nextToken(16);
        } else {
            if (objectDeserializer == null) {
                objectDeserializer = this.deserializer = defaultJSONParser.getConfig().getDeserializer(type2);
            }
            Object t = objectDeserializer.deserialze(defaultJSONParser, type2, 0);
            collection.add(t);
            defaultJSONParser.checkListResolve(collection);
        }
    }
}

