/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser.deserializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.JSONLexerBase;
import com.icbc.api.internal.util.fastjson.parser.JSONScanner;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ContextObjectDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.BeanContext;
import com.icbc.api.internal.util.fastjson.serializer.ContextObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Jdk8DateCodec
extends ContextObjectDeserializer
implements ObjectDeserializer,
ContextObjectSerializer,
ObjectSerializer {
    public static final Jdk8DateCodec instance = new Jdk8DateCodec();
    private static final String defaultPatttern = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter defaultFormatter_23 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter formatter_dt19_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_cn_1 = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2");
    private static final DateTimeFormatter formatter_dt19_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_us = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_de = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_in = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_d8 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter formatter_d10_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter formatter_d10_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5");
    private static final DateTimeFormatter formatter_d10_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c");
    private static final DateTimeFormatter formatter_d10_us = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter formatter_d10_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter formatter_d10_de = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter formatter_d10_in = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private static final DateTimeFormatter ISO_FIXED_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final String formatter_iso8601_pattern = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String formatter_iso8601_pattern_23 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String formatter_iso8601_pattern_29 = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS";
    private static final DateTimeFormatter formatter_iso8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object, String string, int n) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 8) {
            jSONLexer.nextToken();
            return null;
        }
        if (jSONLexer.token() == 4) {
            String string2 = jSONLexer.stringVal();
            jSONLexer.nextToken();
            DateTimeFormatter dateTimeFormatter = null;
            if (string != null) {
                dateTimeFormatter = defaultPatttern.equals(string) ? defaultFormatter : DateTimeFormatter.ofPattern(string);
            }
            if ("".equals(string2)) {
                return null;
            }
            if (type == LocalDateTime.class) {
                LocalDateTime localDateTime;
                if (string2.length() == 10 || string2.length() == 8) {
                    LocalDate localDate = this.parseLocalDate(string2, string, dateTimeFormatter);
                    localDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
                } else {
                    localDateTime = this.parseDateTime(string2, dateTimeFormatter);
                }
                return (T)localDateTime;
            }
            if (type == LocalDate.class) {
                LocalDate localDate;
                if (string2.length() == 23) {
                    LocalDateTime localDateTime = LocalDateTime.parse(string2);
                    localDate = LocalDate.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth());
                } else {
                    localDate = this.parseLocalDate(string2, string, dateTimeFormatter);
                }
                return (T)localDate;
            }
            if (type == LocalTime.class) {
                LocalTime localTime;
                if (string2.length() == 23) {
                    LocalDateTime localDateTime = LocalDateTime.parse(string2);
                    localTime = LocalTime.of(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano());
                } else {
                    boolean bl = true;
                    for (int i = 0; i < string2.length(); ++i) {
                        char c2 = string2.charAt(i);
                        if (c2 >= '0' && c2 <= '9') continue;
                        bl = false;
                        break;
                    }
                    if (bl && string2.length() > 8 && string2.length() < 19) {
                        long l = Long.parseLong(string2);
                        localTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId()).toLocalTime();
                    } else {
                        localTime = LocalTime.parse(string2);
                    }
                }
                return (T)localTime;
            }
            if (type == ZonedDateTime.class) {
                Object object2;
                if (dateTimeFormatter == defaultFormatter) {
                    dateTimeFormatter = ISO_FIXED_FORMAT;
                }
                if (dateTimeFormatter == null && string2.length() <= 19) {
                    object2 = new JSONScanner(string2);
                    TimeZone timeZone = defaultJSONParser.lexer.getTimeZone();
                    ((JSONLexerBase)object2).setTimeZone(timeZone);
                    boolean bl = ((JSONScanner)object2).scanISO8601DateIfMatch(false);
                    if (bl) {
                        Date date = ((JSONLexerBase)object2).getCalendar().getTime();
                        return (T)ZonedDateTime.ofInstant(date.toInstant(), timeZone.toZoneId());
                    }
                }
                object2 = this.parseZonedDateTime(string2, dateTimeFormatter);
                return (T)object2;
            }
            if (type == OffsetDateTime.class) {
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(string2);
                return (T)offsetDateTime;
            }
            if (type == OffsetTime.class) {
                OffsetTime offsetTime = OffsetTime.parse(string2);
                return (T)offsetTime;
            }
            if (type == ZoneId.class) {
                ZoneId zoneId = ZoneId.of(string2);
                return (T)zoneId;
            }
            if (type == Period.class) {
                Period period = Period.parse(string2);
                return (T)period;
            }
            if (type == Duration.class) {
                Duration duration = Duration.parse(string2);
                return (T)duration;
            }
            if (type == Instant.class) {
                boolean bl = true;
                for (int i = 0; i < string2.length(); ++i) {
                    char c3 = string2.charAt(i);
                    if (c3 >= '0' && c3 <= '9') continue;
                    bl = false;
                    break;
                }
                if (bl && string2.length() > 8 && string2.length() < 19) {
                    long l = Long.parseLong(string2);
                    return (T)Instant.ofEpochMilli(l);
                }
                Instant instant = Instant.parse(string2);
                return (T)instant;
            }
        } else {
            if (jSONLexer.token() == 2) {
                long l = jSONLexer.longValue();
                jSONLexer.nextToken();
                if ("unixtime".equals(string)) {
                    l *= 1000L;
                } else if ("yyyyMMddHHmmss".equals(string)) {
                    int n2 = (int)(l / 10000000000L);
                    int n3 = (int)(l / 100000000L % 100L);
                    int n4 = (int)(l / 1000000L % 100L);
                    int n5 = (int)(l / 10000L % 100L);
                    int n6 = (int)(l / 100L % 100L);
                    int n7 = (int)(l % 100L);
                    if (type == LocalDateTime.class) {
                        return (T)LocalDateTime.of(n2, n3, n4, n5, n6, n7);
                    }
                }
                if (type == LocalDateTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId());
                }
                if (type == LocalDate.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId()).toLocalDate();
                }
                if (type == LocalTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId()).toLocalTime();
                }
                if (type == ZonedDateTime.class) {
                    return (T)ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId());
                }
                if (type == Instant.class) {
                    return (T)Instant.ofEpochMilli(l);
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    protected LocalDateTime parseDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        char c2;
        int n;
        char c3;
        if (dateTimeFormatter == null) {
            char c4;
            char c5;
            char c6;
            if (string.length() == 19) {
                c6 = string.charAt(4);
                c3 = string.charAt(7);
                n = string.charAt(10);
                c2 = string.charAt(13);
                c5 = string.charAt(16);
                if (c2 == ':' && c5 == ':') {
                    if (c6 == '-' && c3 == '-') {
                        if (n == 84) {
                            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                        } else if (n == 32) {
                            dateTimeFormatter = defaultFormatter;
                        }
                    } else if (c6 == '/' && c3 == '/') {
                        dateTimeFormatter = formatter_dt19_tw;
                    } else {
                        c4 = string.charAt(0);
                        char c7 = string.charAt(1);
                        char c8 = string.charAt(2);
                        char c9 = string.charAt(3);
                        char c10 = string.charAt(5);
                        if (c8 == '/' && c10 == '/') {
                            int n2 = (c4 - 48) * 10 + (c7 - 48);
                            int n3 = (c9 - 48) * 10 + (c6 - 48);
                            if (n2 > 12) {
                                dateTimeFormatter = formatter_dt19_eur;
                            } else if (n3 > 12) {
                                dateTimeFormatter = formatter_dt19_us;
                            } else {
                                String string2 = Locale.getDefault().getCountry();
                                if (string2.equals("US")) {
                                    dateTimeFormatter = formatter_dt19_us;
                                } else if (string2.equals("BR") || string2.equals("AU")) {
                                    dateTimeFormatter = formatter_dt19_eur;
                                }
                            }
                        } else if (c8 == '.' && c10 == '.') {
                            dateTimeFormatter = formatter_dt19_de;
                        } else if (c8 == '-' && c10 == '-') {
                            dateTimeFormatter = formatter_dt19_in;
                        }
                    }
                }
            } else if (string.length() == 23) {
                c6 = string.charAt(4);
                c3 = string.charAt(7);
                n = string.charAt(10);
                c2 = string.charAt(13);
                c5 = string.charAt(16);
                c4 = string.charAt(19);
                if (c2 == ':' && c5 == ':' && c6 == '-' && c3 == '-' && n == 32 && c4 == '.') {
                    dateTimeFormatter = defaultFormatter_23;
                }
            }
            if (string.length() >= 17) {
                c6 = string.charAt(4);
                if (c6 == '\u5e74') {
                    dateTimeFormatter = string.charAt(string.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (c6 == '\ub144') {
                    dateTimeFormatter = formatter_dt19_kr;
                }
            }
        }
        if (dateTimeFormatter == null) {
            JSONScanner jSONScanner = new JSONScanner(string);
            if (jSONScanner.scanISO8601DateIfMatch(false)) {
                Instant instant = jSONScanner.getCalendar().toInstant();
                return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            }
            c3 = '\u0001';
            for (n = 0; n < string.length(); ++n) {
                c2 = string.charAt(n);
                if (c2 >= '0' && c2 <= '9') continue;
                c3 = '\u0000';
                break;
            }
            if (c3 != '\u0000' && string.length() > 8 && string.length() < 19) {
                long l = Long.parseLong(string);
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId());
            }
        }
        return dateTimeFormatter == null ? LocalDateTime.parse(string) : LocalDateTime.parse(string, dateTimeFormatter);
    }

    protected LocalDate parseLocalDate(String string, String string2, DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            char c2;
            int n;
            char c3;
            if (string.length() == 8) {
                dateTimeFormatter = formatter_d8;
            }
            if (string.length() == 10) {
                c3 = string.charAt(4);
                n = string.charAt(7);
                if (c3 == '/' && n == 47) {
                    dateTimeFormatter = formatter_d10_tw;
                }
                c2 = string.charAt(0);
                char c4 = string.charAt(1);
                char c5 = string.charAt(2);
                char c6 = string.charAt(3);
                char c7 = string.charAt(5);
                if (c5 == '/' && c7 == '/') {
                    int n2 = (c2 - 48) * 10 + (c4 - 48);
                    int n3 = (c6 - 48) * 10 + (c3 - 48);
                    if (n2 > 12) {
                        dateTimeFormatter = formatter_d10_eur;
                    } else if (n3 > 12) {
                        dateTimeFormatter = formatter_d10_us;
                    } else {
                        String string3 = Locale.getDefault().getCountry();
                        if (string3.equals("US")) {
                            dateTimeFormatter = formatter_d10_us;
                        } else if (string3.equals("BR") || string3.equals("AU")) {
                            dateTimeFormatter = formatter_d10_eur;
                        }
                    }
                } else if (c5 == '.' && c7 == '.') {
                    dateTimeFormatter = formatter_d10_de;
                } else if (c5 == '-' && c7 == '-') {
                    dateTimeFormatter = formatter_d10_in;
                }
            }
            if (string.length() >= 9) {
                c3 = string.charAt(4);
                if (c3 == '\u5e74') {
                    dateTimeFormatter = formatter_d10_cn;
                } else if (c3 == '\ub144') {
                    dateTimeFormatter = formatter_d10_kr;
                }
            }
            c3 = '\u0001';
            for (n = 0; n < string.length(); ++n) {
                c2 = string.charAt(n);
                if (c2 >= '0' && c2 <= '9') continue;
                c3 = '\u0000';
                break;
            }
            if (c3 != '\u0000' && string.length() > 8 && string.length() < 19) {
                long l = Long.parseLong(string);
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId()).toLocalDate();
            }
        }
        return dateTimeFormatter == null ? LocalDate.parse(string) : LocalDate.parse(string, dateTimeFormatter);
    }

    protected ZonedDateTime parseZonedDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            char c2;
            int n;
            char c3;
            if (string.length() == 19) {
                c3 = string.charAt(4);
                n = string.charAt(7);
                c2 = string.charAt(10);
                char c4 = string.charAt(13);
                char c5 = string.charAt(16);
                if (c4 == ':' && c5 == ':') {
                    if (c3 == '-' && n == 45) {
                        if (c2 == 'T') {
                            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                        } else if (c2 == ' ') {
                            dateTimeFormatter = defaultFormatter;
                        }
                    } else if (c3 == '/' && n == 47) {
                        dateTimeFormatter = formatter_dt19_tw;
                    } else {
                        char c6 = string.charAt(0);
                        char c7 = string.charAt(1);
                        char c8 = string.charAt(2);
                        char c9 = string.charAt(3);
                        char c10 = string.charAt(5);
                        if (c8 == '/' && c10 == '/') {
                            int n2 = (c6 - 48) * 10 + (c7 - 48);
                            int n3 = (c9 - 48) * 10 + (c3 - 48);
                            if (n2 > 12) {
                                dateTimeFormatter = formatter_dt19_eur;
                            } else if (n3 > 12) {
                                dateTimeFormatter = formatter_dt19_us;
                            } else {
                                String string2 = Locale.getDefault().getCountry();
                                if (string2.equals("US")) {
                                    dateTimeFormatter = formatter_dt19_us;
                                } else if (string2.equals("BR") || string2.equals("AU")) {
                                    dateTimeFormatter = formatter_dt19_eur;
                                }
                            }
                        } else if (c8 == '.' && c10 == '.') {
                            dateTimeFormatter = formatter_dt19_de;
                        } else if (c8 == '-' && c10 == '-') {
                            dateTimeFormatter = formatter_dt19_in;
                        }
                    }
                }
            }
            if (string.length() >= 17) {
                c3 = string.charAt(4);
                if (c3 == '\u5e74') {
                    dateTimeFormatter = string.charAt(string.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (c3 == '\ub144') {
                    dateTimeFormatter = formatter_dt19_kr;
                }
            }
            c3 = '\u0001';
            for (n = 0; n < string.length(); ++n) {
                c2 = string.charAt(n);
                if (c2 >= '0' && c2 <= '9') continue;
                c3 = '\u0000';
                break;
            }
            if (c3 != '\u0000' && string.length() > 8 && string.length() < 19) {
                long l = Long.parseLong(string);
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId());
            }
        }
        return dateTimeFormatter == null ? ZonedDateTime.parse(string) : ZonedDateTime.parse(string, dateTimeFormatter);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type clazz, int n) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
        } else {
            if (clazz == null) {
                clazz = object.getClass();
            }
            if (clazz == LocalDateTime.class) {
                int n2 = SerializerFeature.UseISO8601DateFormat.getMask();
                LocalDateTime localDateTime = (LocalDateTime)object;
                String string = jSONSerializer.getDateFormatPattern();
                if (string == null) {
                    int n3;
                    string = (n & n2) != 0 || jSONSerializer.isEnabled(SerializerFeature.UseISO8601DateFormat) ? formatter_iso8601_pattern : ((n3 = localDateTime.getNano()) == 0 ? formatter_iso8601_pattern : (n3 % 1000000 == 0 ? formatter_iso8601_pattern_23 : formatter_iso8601_pattern_29));
                }
                if (string != null) {
                    this.write(serializeWriter, localDateTime, string);
                } else if (serializeWriter.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
                    this.write(serializeWriter, localDateTime, JSON.DEFFAULT_DATE_FORMAT);
                } else {
                    serializeWriter.writeLong(localDateTime.atZone(JSON.defaultTimeZone.toZoneId()).toInstant().toEpochMilli());
                }
            } else {
                serializeWriter.writeString(object.toString());
            }
        }
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, BeanContext beanContext) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        String string = beanContext.getFormat();
        this.write(serializeWriter, (TemporalAccessor)object, string);
    }

    private void write(SerializeWriter serializeWriter, TemporalAccessor temporalAccessor, String string) {
        Object object;
        if ("unixtime".equals(string)) {
            object = null;
            if (temporalAccessor instanceof ChronoZonedDateTime) {
                long l = ((ChronoZonedDateTime)temporalAccessor).toEpochSecond();
                serializeWriter.writeInt((int)l);
                return;
            }
            if (temporalAccessor instanceof LocalDateTime) {
                long l = ((LocalDateTime)temporalAccessor).atZone(JSON.defaultTimeZone.toZoneId()).toEpochSecond();
                serializeWriter.writeInt((int)l);
                return;
            }
        }
        if ("millis".equals(string)) {
            object = null;
            if (temporalAccessor instanceof ChronoZonedDateTime) {
                object = ((ChronoZonedDateTime)temporalAccessor).toInstant();
            } else if (temporalAccessor instanceof LocalDateTime) {
                object = ((LocalDateTime)temporalAccessor).atZone(JSON.defaultTimeZone.toZoneId()).toInstant();
            }
            if (object != null) {
                long l = ((Instant)object).toEpochMilli();
                serializeWriter.writeLong(l);
                return;
            }
        }
        DateTimeFormatter dateTimeFormatter = string == formatter_iso8601_pattern ? formatter_iso8601 : DateTimeFormatter.ofPattern(string);
        object = dateTimeFormatter.format(temporalAccessor);
        serializeWriter.writeString((String)object);
    }
}

