/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser.deserializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class NumberDeserializer
implements ObjectDeserializer {
    public static final NumberDeserializer instance = new NumberDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            if (type == Double.TYPE || type == Double.class) {
                String string = jSONLexer.numberString();
                jSONLexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(string));
            }
            long l = jSONLexer.longValue();
            jSONLexer.nextToken(16);
            if (type == Short.TYPE || type == Short.class) {
                if (l > 32767L || l < -32768L) {
                    throw new JSONException("short overflow : " + l);
                }
                return (T)Short.valueOf((short)l);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                if (l > 127L || l < -128L) {
                    throw new JSONException("short overflow : " + l);
                }
                return (T)Byte.valueOf((byte)l);
            }
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (T)Integer.valueOf((int)l);
            }
            return (T)Long.valueOf(l);
        }
        if (jSONLexer.token() == 3) {
            if (type == Double.TYPE || type == Double.class) {
                String string = jSONLexer.numberString();
                jSONLexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(string));
            }
            if (type == Short.TYPE || type == Short.class) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                jSONLexer.nextToken(16);
                short s = TypeUtils.shortValue(bigDecimal);
                return (T)Short.valueOf(s);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                jSONLexer.nextToken(16);
                byte by = TypeUtils.byteValue(bigDecimal);
                return (T)Byte.valueOf(by);
            }
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)bigDecimal;
        }
        if (jSONLexer.token() == 18 && "NaN".equals(jSONLexer.stringVal())) {
            jSONLexer.nextToken();
            Number number = null;
            if (type == Double.class) {
                number = Double.NaN;
            } else if (type == Float.class) {
                number = Float.valueOf(Float.NaN);
            }
            return (T)number;
        }
        Object object2 = defaultJSONParser.parse();
        if (object2 == null) {
            return null;
        }
        if (type == Double.TYPE || type == Double.class) {
            try {
                return (T)TypeUtils.castToDouble(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseDouble error, field : " + object, exception);
            }
        }
        if (type == Short.TYPE || type == Short.class) {
            try {
                return (T)TypeUtils.castToShort(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseShort error, field : " + object, exception);
            }
        }
        if (type == Byte.TYPE || type == Byte.class) {
            try {
                return (T)TypeUtils.castToByte(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseByte error, field : " + object, exception);
            }
        }
        return (T)TypeUtils.castToBigDecimal(object2);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

