/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser.deserializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class OptionalCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static OptionalCodec instance = new OptionalCodec();

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        if (type == OptionalInt.class) {
            Integer n = defaultJSONParser.parseObject(Integer.class);
            Integer n2 = TypeUtils.castToInt(n);
            if (n2 == null) {
                return (T)OptionalInt.empty();
            }
            return (T)OptionalInt.of(n2);
        }
        if (type == OptionalLong.class) {
            Long l = defaultJSONParser.parseObject(Long.class);
            Long l2 = TypeUtils.castToLong(l);
            if (l2 == null) {
                return (T)OptionalLong.empty();
            }
            return (T)OptionalLong.of(l2);
        }
        if (type == OptionalDouble.class) {
            Double d2 = defaultJSONParser.parseObject(Double.class);
            Double d3 = TypeUtils.castToDouble(d2);
            if (d3 == null) {
                return (T)OptionalDouble.empty();
            }
            return (T)OptionalDouble.of(d3);
        }
        Object t = defaultJSONParser.parseObject(type = TypeUtils.unwrapOptional(type));
        if (t == null) {
            return (T)Optional.empty();
        }
        return (T)Optional.of(t);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        if (object == null) {
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            Object var7_10 = optional.isPresent() ? optional.get() : null;
            jSONSerializer.write((Object)var7_10);
            return;
        }
        if (object instanceof OptionalDouble) {
            OptionalDouble optionalDouble = (OptionalDouble)object;
            if (optionalDouble.isPresent()) {
                double d2 = optionalDouble.getAsDouble();
                jSONSerializer.write(d2);
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        if (object instanceof OptionalInt) {
            OptionalInt optionalInt = (OptionalInt)object;
            if (optionalInt.isPresent()) {
                int n2 = optionalInt.getAsInt();
                jSONSerializer.out.writeInt(n2);
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        if (object instanceof OptionalLong) {
            OptionalLong optionalLong = (OptionalLong)object;
            if (optionalLong.isPresent()) {
                long l = optionalLong.getAsLong();
                jSONSerializer.out.writeLong(l);
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        throw new JSONException("not support optional : " + object.getClass());
    }
}

