/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser.deserializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONScanner;
import com.icbc.api.internal.util.fastjson.parser.deserializer.AbstractDateDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class SqlDateDeserializer
extends AbstractDateDeserializer
implements ObjectDeserializer {
    public static final SqlDateDeserializer instance = new SqlDateDeserializer();
    public static final SqlDateDeserializer instance_timestamp = new SqlDateDeserializer(true);
    private boolean timestamp = false;

    public SqlDateDeserializer() {
    }

    public SqlDateDeserializer(boolean bl) {
        this.timestamp = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T cast(DefaultJSONParser defaultJSONParser, Type type, Object object, Object object2) {
        if (this.timestamp) {
            return this.castTimestamp(defaultJSONParser, type, object, object2);
        }
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Date) {
            object2 = new java.sql.Date(((Date)object2).getTime());
        } else if (object2 instanceof BigDecimal) {
            object2 = new java.sql.Date(TypeUtils.longValue((BigDecimal)object2));
        } else if (object2 instanceof Number) {
            object2 = new java.sql.Date(((Number)object2).longValue());
        } else {
            if (object2 instanceof String) {
                long l;
                block17: {
                    String string = (String)object2;
                    if (string.length() == 0) {
                        return null;
                    }
                    try (JSONScanner jSONScanner = new JSONScanner(string);){
                        java.sql.Date date;
                        if (jSONScanner.scanISO8601DateIfMatch()) {
                            l = jSONScanner.getCalendar().getTimeInMillis();
                            break block17;
                        }
                        DateFormat dateFormat = defaultJSONParser.getDateFormat();
                        try {
                            java.sql.Date date2;
                            Date date3 = dateFormat.parse(string);
                            date = date2 = new java.sql.Date(date3.getTime());
                        }
                        catch (ParseException parseException) {
                            l = Long.parseLong(string);
                            break block17;
                        }
                        return (T)date;
                    }
                }
                return (T)new java.sql.Date(l);
            }
            throw new JSONException("parse error : " + object2);
        }
        return (T)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T castTimestamp(DefaultJSONParser defaultJSONParser, Type type, Object object, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Date) {
            return (T)new Timestamp(((Date)object2).getTime());
        }
        if (object2 instanceof BigDecimal) {
            return (T)new Timestamp(TypeUtils.longValue((BigDecimal)object2));
        }
        if (object2 instanceof Number) {
            return (T)new Timestamp(((Number)object2).longValue());
        }
        if (object2 instanceof String) {
            long l;
            block15: {
                String string = (String)object2;
                if (string.length() == 0) {
                    return null;
                }
                try (JSONScanner jSONScanner = new JSONScanner(string);){
                    Timestamp timestamp;
                    Object object3;
                    if (string.length() > 19 && string.charAt(4) == '-' && string.charAt(7) == '-' && string.charAt(10) == ' ' && string.charAt(13) == ':' && string.charAt(16) == ':' && string.charAt(19) == '.' && ((String)(object3 = defaultJSONParser.getDateFomartPattern())).length() != string.length() && object3 == JSON.DEFFAULT_DATE_FORMAT) {
                        Timestamp timestamp2 = Timestamp.valueOf(string);
                        return (T)timestamp2;
                    }
                    if (jSONScanner.scanISO8601DateIfMatch(false)) {
                        l = jSONScanner.getCalendar().getTimeInMillis();
                        break block15;
                    }
                    object3 = defaultJSONParser.getDateFormat();
                    try {
                        Timestamp timestamp3;
                        Date date = ((DateFormat)object3).parse(string);
                        timestamp = timestamp3 = new Timestamp(date.getTime());
                    }
                    catch (ParseException parseException) {
                        l = Long.parseLong(string);
                        break block15;
                    }
                    return (T)timestamp;
                }
            }
            return (T)new Timestamp(l);
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

