/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerialContext;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class ArraySerializer
implements ObjectSerializer {
    private final Class<?> componentType;
    private final ObjectSerializer compObjectSerializer;

    public ArraySerializer(Class<?> clazz, ObjectSerializer objectSerializer) {
        this.componentType = clazz;
        this.compObjectSerializer = objectSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        Object[] objectArray = (Object[])object;
        int n2 = objectArray.length;
        SerialContext serialContext = jSONSerializer.context;
        jSONSerializer.setContext(serialContext, object, object2, 0);
        try {
            serializeWriter.append('[');
            for (int i = 0; i < n2; ++i) {
                Object object3;
                if (i != 0) {
                    serializeWriter.append(',');
                }
                if ((object3 = objectArray[i]) == null) {
                    if (serializeWriter.isEnabled(SerializerFeature.WriteNullStringAsEmpty) && object instanceof String[]) {
                        serializeWriter.writeString("");
                        continue;
                    }
                    serializeWriter.append("null");
                    continue;
                }
                if (object3.getClass() == this.componentType) {
                    this.compObjectSerializer.write(jSONSerializer, object3, i, null, 0);
                    continue;
                }
                ObjectSerializer objectSerializer = jSONSerializer.getObjectWriter(object3.getClass());
                objectSerializer.write(jSONSerializer, object3, i, null, 0);
            }
            serializeWriter.append(']');
        }
        finally {
            jSONSerializer.context = serialContext;
        }
    }
}

