/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final AtomicCodec instance = new AtomicCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object instanceof AtomicInteger) {
            AtomicInteger atomicInteger = (AtomicInteger)object;
            serializeWriter.writeInt(atomicInteger.get());
            return;
        }
        if (object instanceof AtomicLong) {
            AtomicLong atomicLong = (AtomicLong)object;
            serializeWriter.writeLong(atomicLong.get());
            return;
        }
        if (object instanceof AtomicBoolean) {
            AtomicBoolean atomicBoolean = (AtomicBoolean)object;
            serializeWriter.append(atomicBoolean.get() ? "true" : "false");
            return;
        }
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        if (object instanceof AtomicIntegerArray) {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)object;
            int n2 = atomicIntegerArray.length();
            serializeWriter.write(91);
            for (int i = 0; i < n2; ++i) {
                int n3 = atomicIntegerArray.get(i);
                if (i != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.writeInt(n3);
            }
            serializeWriter.write(93);
            return;
        }
        AtomicLongArray atomicLongArray = (AtomicLongArray)object;
        int n4 = atomicLongArray.length();
        serializeWriter.write(91);
        for (int i = 0; i < n4; ++i) {
            long l = atomicLongArray.get(i);
            if (i != 0) {
                serializeWriter.write(44);
            }
            serializeWriter.writeLong(l);
        }
        serializeWriter.write(93);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        if (defaultJSONParser.lexer.token() == 8) {
            defaultJSONParser.lexer.nextToken(16);
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        defaultJSONParser.parseArray(jSONArray);
        if (type == AtomicIntegerArray.class) {
            AtomicIntegerArray atomicIntegerArray = new AtomicIntegerArray(jSONArray.size());
            for (int i = 0; i < jSONArray.size(); ++i) {
                atomicIntegerArray.set(i, jSONArray.getInteger(i));
            }
            return (T)atomicIntegerArray;
        }
        AtomicLongArray atomicLongArray = new AtomicLongArray(jSONArray.size());
        for (int i = 0; i < jSONArray.size(); ++i) {
            atomicLongArray.set(i, jSONArray.getLong(i));
        }
        return (T)atomicLongArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

