/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class BigDecimalCodec
implements ObjectDeserializer,
ObjectSerializer {
    static final BigDecimal LOW = BigDecimal.valueOf(-9007199254740991L);
    static final BigDecimal HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            BigDecimal bigDecimal = (BigDecimal)object;
            int n2 = bigDecimal.scale();
            String string = SerializerFeature.isEnabled(n, serializeWriter.features, SerializerFeature.WriteBigDecimalAsPlain) && n2 >= -100 && n2 < 100 ? bigDecimal.toPlainString() : bigDecimal.toString();
            if (n2 == 0 && string.length() >= 16 && SerializerFeature.isEnabled(n, serializeWriter.features, SerializerFeature.BrowserCompatible) && (bigDecimal.compareTo(LOW) < 0 || bigDecimal.compareTo(HIGH) > 0)) {
                serializeWriter.writeString(string);
                return;
            }
            serializeWriter.write(string);
            if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) && type != BigDecimal.class && bigDecimal.scale() == 0) {
                serializeWriter.write(46);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        try {
            return BigDecimalCodec.deserialze(defaultJSONParser);
        }
        catch (Exception exception) {
            throw new JSONException("parseDecimal error, field : " + object, exception);
        }
    }

    public static <T> T deserialze(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)bigDecimal;
        }
        if (jSONLexer.token() == 3) {
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)bigDecimal;
        }
        Object object = defaultJSONParser.parse();
        return (T)(object == null ? null : TypeUtils.castToBigDecimal(object));
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

