/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.annotation.JSONType;
import com.icbc.api.internal.util.fastjson.serializer.BeanContext;
import com.icbc.api.internal.util.fastjson.serializer.ContextObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.DoubleSerializer;
import com.icbc.api.internal.util.fastjson.serializer.FloatCodec;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JavaBeanSerializer;
import com.icbc.api.internal.util.fastjson.serializer.MapSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.FieldInfo;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collection;

public class FieldSerializer
implements Comparable<FieldSerializer> {
    public final FieldInfo fieldInfo;
    protected final boolean writeNull;
    protected int features;
    private final String double_quoted_fieldPrefix;
    private String single_quoted_fieldPrefix;
    private String un_quoted_fieldPrefix;
    protected BeanContext fieldContext;
    private String format;
    protected boolean writeEnumUsingToString = false;
    protected boolean writeEnumUsingName = false;
    protected boolean disableCircularReferenceDetect = false;
    protected boolean serializeUsing = false;
    protected boolean persistenceXToMany = false;
    protected boolean browserCompatible;
    private RuntimeSerializerInfo runtimeInfo;

    public FieldSerializer(Class<?> clazz, FieldInfo fieldInfo) {
        JSONType jSONType;
        this.fieldInfo = fieldInfo;
        this.fieldContext = new BeanContext(clazz, fieldInfo);
        if (clazz != null && (jSONType = TypeUtils.getAnnotation(clazz, JSONType.class)) != null) {
            for (SerializerFeature serializerFeature : jSONType.serialzeFeatures()) {
                if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                    this.writeEnumUsingToString = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                    this.writeEnumUsingName = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.DisableCircularReferenceDetect) {
                    this.disableCircularReferenceDetect = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.BrowserCompatible) {
                    this.features |= SerializerFeature.BrowserCompatible.mask;
                    this.browserCompatible = true;
                    continue;
                }
                if (serializerFeature != SerializerFeature.WriteMapNullValue) continue;
                this.features |= SerializerFeature.WriteMapNullValue.mask;
            }
        }
        fieldInfo.setAccessible();
        this.double_quoted_fieldPrefix = '\"' + fieldInfo.name + "\":";
        boolean bl = false;
        JSONField jSONField = fieldInfo.getAnnotation();
        if (jSONField != null) {
            for (SerializerFeature serializerFeature : jSONField.serialzeFeatures()) {
                if ((serializerFeature.getMask() & SerializerFeature.WRITE_MAP_NULL_FEATURES) == 0) continue;
                bl = true;
                break;
            }
            this.format = jSONField.format();
            if (this.format.trim().length() == 0) {
                this.format = null;
            }
            for (SerializerFeature serializerFeature : jSONField.serialzeFeatures()) {
                if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                    this.writeEnumUsingToString = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                    this.writeEnumUsingName = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.DisableCircularReferenceDetect) {
                    this.disableCircularReferenceDetect = true;
                    continue;
                }
                if (serializerFeature != SerializerFeature.BrowserCompatible) continue;
                this.browserCompatible = true;
            }
            this.features |= SerializerFeature.of(jSONField.serialzeFeatures());
        }
        this.writeNull = bl;
        this.persistenceXToMany = TypeUtils.isAnnotationPresentOneToMany(fieldInfo.method) || TypeUtils.isAnnotationPresentManyToMany(fieldInfo.method);
    }

    public void writePrefix(JSONSerializer jSONSerializer) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (serializeWriter.quoteFieldNames) {
            boolean bl = SerializerFeature.isEnabled(serializeWriter.features, this.fieldInfo.serialzeFeatures, SerializerFeature.UseSingleQuotes);
            if (bl) {
                if (this.single_quoted_fieldPrefix == null) {
                    this.single_quoted_fieldPrefix = '\'' + this.fieldInfo.name + "':";
                }
                serializeWriter.write(this.single_quoted_fieldPrefix);
            } else {
                serializeWriter.write(this.double_quoted_fieldPrefix);
            }
        } else {
            if (this.un_quoted_fieldPrefix == null) {
                this.un_quoted_fieldPrefix = this.fieldInfo.name + ":";
            }
            serializeWriter.write(this.un_quoted_fieldPrefix);
        }
    }

    public Object getPropertyValueDirect(Object object) throws InvocationTargetException, IllegalAccessException {
        Object object2 = this.fieldInfo.get(object);
        if (this.persistenceXToMany && !TypeUtils.isHibernateInitialized(object2)) {
            return null;
        }
        return object2;
    }

    public Object getPropertyValue(Object object) throws InvocationTargetException, IllegalAccessException {
        Object object2 = this.fieldInfo.get(object);
        if (this.format != null && object2 != null && (this.fieldInfo.fieldClass == java.util.Date.class || this.fieldInfo.fieldClass == Date.class)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format, JSON.defaultLocale);
            simpleDateFormat.setTimeZone(JSON.defaultTimeZone);
            return simpleDateFormat.format(object2);
        }
        return object2;
    }

    @Override
    public int compareTo(FieldSerializer fieldSerializer) {
        return this.fieldInfo.compareTo(fieldSerializer.fieldInfo);
    }

    public void writeValue(JSONSerializer jSONSerializer, Object object) throws Exception {
        long l;
        Class<?> clazz;
        Class<Object> clazz2;
        if (this.runtimeInfo == null) {
            if (object == null) {
                clazz2 = this.fieldInfo.fieldClass;
                if (clazz2 == Byte.TYPE) {
                    clazz2 = Byte.class;
                } else if (clazz2 == Short.TYPE) {
                    clazz2 = Short.class;
                } else if (clazz2 == Integer.TYPE) {
                    clazz2 = Integer.class;
                } else if (clazz2 == Long.TYPE) {
                    clazz2 = Long.class;
                } else if (clazz2 == Float.TYPE) {
                    clazz2 = Float.class;
                } else if (clazz2 == Double.TYPE) {
                    clazz2 = Double.class;
                } else if (clazz2 == Boolean.TYPE) {
                    clazz2 = Boolean.class;
                }
            } else {
                clazz2 = object.getClass();
            }
            ObjectSerializer objectSerializer = null;
            clazz = this.fieldInfo.getAnnotation();
            if (clazz != null && clazz.serializeUsing() != Void.class) {
                objectSerializer = (ObjectSerializer)clazz.serializeUsing().newInstance();
                this.serializeUsing = true;
            } else {
                if (this.format != null) {
                    if (clazz2 == Double.TYPE || clazz2 == Double.class) {
                        objectSerializer = new DoubleSerializer(this.format);
                    } else if (clazz2 == Float.TYPE || clazz2 == Float.class) {
                        objectSerializer = new FloatCodec(this.format);
                    }
                }
                if (objectSerializer == null) {
                    objectSerializer = jSONSerializer.getObjectWriter(clazz2);
                }
            }
            this.runtimeInfo = new RuntimeSerializerInfo(objectSerializer, clazz2);
        }
        clazz2 = this.runtimeInfo;
        int n = (this.disableCircularReferenceDetect ? this.fieldInfo.serialzeFeatures | SerializerFeature.DisableCircularReferenceDetect.mask : this.fieldInfo.serialzeFeatures) | this.features;
        if (object == null) {
            clazz = jSONSerializer.out;
            if (this.fieldInfo.fieldClass == Object.class && ((SerializeWriter)((Object)clazz)).isEnabled(SerializerFeature.WRITE_MAP_NULL_FEATURES)) {
                ((SerializeWriter)((Object)clazz)).writeNull();
                return;
            }
            Class<?> clazz3 = ((RuntimeSerializerInfo)((Object)clazz2)).runtimeFieldClass;
            if (Number.class.isAssignableFrom(clazz3)) {
                ((SerializeWriter)((Object)clazz)).writeNull(this.features, SerializerFeature.WriteNullNumberAsZero.mask);
                return;
            }
            if (String.class == clazz3) {
                ((SerializeWriter)((Object)clazz)).writeNull(this.features, SerializerFeature.WriteNullStringAsEmpty.mask);
                return;
            }
            if (Boolean.class == clazz3) {
                ((SerializeWriter)((Object)clazz)).writeNull(this.features, SerializerFeature.WriteNullBooleanAsFalse.mask);
                return;
            }
            if (Collection.class.isAssignableFrom(clazz3) || clazz3.isArray()) {
                ((SerializeWriter)((Object)clazz)).writeNull(this.features, SerializerFeature.WriteNullListAsEmpty.mask);
                return;
            }
            ObjectSerializer objectSerializer = ((RuntimeSerializerInfo)((Object)clazz2)).fieldSerializer;
            if (((SerializeWriter)((Object)clazz)).isEnabled(SerializerFeature.WRITE_MAP_NULL_FEATURES) && objectSerializer instanceof JavaBeanSerializer) {
                ((SerializeWriter)((Object)clazz)).writeNull();
                return;
            }
            objectSerializer.write(jSONSerializer, null, this.fieldInfo.name, this.fieldInfo.fieldType, n);
            return;
        }
        if (this.fieldInfo.isEnum) {
            if (this.writeEnumUsingName) {
                jSONSerializer.out.writeString(((Enum)object).name());
                return;
            }
            if (this.writeEnumUsingToString) {
                jSONSerializer.out.writeString(((Enum)object).toString());
                return;
            }
        }
        ObjectSerializer objectSerializer = (clazz = object.getClass()) == ((RuntimeSerializerInfo)((Object)clazz2)).runtimeFieldClass || this.serializeUsing ? ((RuntimeSerializerInfo)((Object)clazz2)).fieldSerializer : jSONSerializer.getObjectWriter(clazz);
        if (this.format != null && !(objectSerializer instanceof DoubleSerializer) && !(objectSerializer instanceof FloatCodec)) {
            if (objectSerializer instanceof ContextObjectSerializer) {
                ((ContextObjectSerializer)objectSerializer).write(jSONSerializer, object, this.fieldContext);
            } else {
                jSONSerializer.writeWithFormat(object, this.format);
            }
            return;
        }
        if (this.fieldInfo.unwrapped) {
            if (objectSerializer instanceof JavaBeanSerializer) {
                JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)objectSerializer;
                javaBeanSerializer.write(jSONSerializer, object, this.fieldInfo.name, this.fieldInfo.fieldType, n, true);
                return;
            }
            if (objectSerializer instanceof MapSerializer) {
                MapSerializer mapSerializer = (MapSerializer)objectSerializer;
                mapSerializer.write(jSONSerializer, object, this.fieldInfo.name, this.fieldInfo.fieldType, n, true);
                return;
            }
        }
        if ((this.features & SerializerFeature.WriteClassName.mask) != 0 && clazz != this.fieldInfo.fieldClass && objectSerializer instanceof JavaBeanSerializer) {
            ((JavaBeanSerializer)objectSerializer).write(jSONSerializer, object, this.fieldInfo.name, this.fieldInfo.fieldType, n, false);
            return;
        }
        if (!(!this.browserCompatible || this.fieldInfo.fieldClass != Long.TYPE && this.fieldInfo.fieldClass != Long.class || (l = ((Long)object).longValue()) <= 0x1FFFFFFFFFFFFFL && l >= -9007199254740991L)) {
            jSONSerializer.getWriter().writeString(Long.toString(l));
            return;
        }
        objectSerializer.write(jSONSerializer, object, this.fieldInfo.name, this.fieldInfo.fieldType, n);
    }

    static class RuntimeSerializerInfo {
        final ObjectSerializer fieldSerializer;
        final Class<?> runtimeFieldClass;

        public RuntimeSerializerInfo(ObjectSerializer objectSerializer, Class<?> clazz) {
            this.fieldSerializer = objectSerializer;
            this.runtimeFieldClass = clazz;
        }
    }
}

