/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;

public class IntegerCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static IntegerCodec instance = new IntegerCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        Number number = (Number)object;
        if (number == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        if (object instanceof Long) {
            serializeWriter.writeLong(number.longValue());
        } else {
            serializeWriter.writeInt(number.intValue());
        }
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName)) {
            Class<?> clazz = number.getClass();
            if (clazz == Byte.class) {
                serializeWriter.write(66);
            } else if (clazz == Short.class) {
                serializeWriter.write(83);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Integer n;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n2 = jSONLexer.token();
        if (n2 == 8) {
            jSONLexer.nextToken(16);
            return null;
        }
        try {
            if (n2 == 2) {
                int n3 = jSONLexer.intValue();
                jSONLexer.nextToken(16);
                n = n3;
            } else if (n2 == 3) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                n = TypeUtils.intValue(bigDecimal);
                jSONLexer.nextToken(16);
            } else if (n2 == 12) {
                JSONObject jSONObject = new JSONObject(true);
                defaultJSONParser.parseObject(jSONObject);
                n = TypeUtils.castToInt(jSONObject);
            } else {
                Object object2 = defaultJSONParser.parse();
                n = TypeUtils.castToInt(object2);
            }
        }
        catch (Exception exception) {
            String string = "parseInt error";
            if (object != null) {
                string = string + ", field : " + object;
            }
            throw new JSONException(string, exception);
        }
        if (type == AtomicInteger.class) {
            return (T)new AtomicInteger(n);
        }
        return (T)n;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

