/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerialContext;
import com.icbc.api.internal.util.fastjson.serializer.SerializeConfig;
import com.icbc.api.internal.util.fastjson.serializer.SerializeFilterable;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.serializer.StringCodec;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;

public class JSONSerializer
extends SerializeFilterable {
    protected final SerializeConfig config;
    public final SerializeWriter out;
    private int indentCount = 0;
    private String indent = "\t";
    private String dateFormatPattern;
    private DateFormat dateFormat;
    protected IdentityHashMap<Object, SerialContext> references = null;
    protected SerialContext context;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;

    public JSONSerializer() {
        this(new SerializeWriter(), SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter serializeWriter) {
        this(serializeWriter, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig serializeConfig) {
        this(new SerializeWriter(), serializeConfig);
    }

    public JSONSerializer(SerializeWriter serializeWriter, SerializeConfig serializeConfig) {
        this.out = serializeWriter;
        this.config = serializeConfig;
    }

    public String getDateFormatPattern() {
        if (this.dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.dateFormat).toPattern();
        }
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null && this.dateFormatPattern != null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPattern, this.locale);
            this.dateFormat.setTimeZone(this.timeZone);
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        if (this.dateFormatPattern != null) {
            this.dateFormatPattern = null;
        }
    }

    public void setDateFormat(String string) {
        this.dateFormatPattern = string;
        if (this.dateFormat != null) {
            this.dateFormat = null;
        }
    }

    public SerialContext getContext() {
        return this.context;
    }

    public void setContext(SerialContext serialContext) {
        this.context = serialContext;
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n) {
        this.setContext(serialContext, object, object2, n, 0);
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n, int n2) {
        if (this.out.disableCircularReferenceDetect) {
            return;
        }
        this.context = new SerialContext(serialContext, object, object2, n, n2);
        if (this.references == null) {
            this.references = new IdentityHashMap();
        }
        this.references.put(object, this.context);
    }

    public void setContext(Object object, Object object2) {
        this.setContext(this.context, object, object2, 0);
    }

    public void popContext() {
        if (this.context != null) {
            this.context = this.context.parent;
        }
    }

    public final boolean isWriteClassName(Type type, Object object) {
        return this.out.isEnabled(SerializerFeature.WriteClassName) && (type != null || !this.out.isEnabled(SerializerFeature.NotWriteRootClassName) || this.context != null && this.context.parent != null);
    }

    public boolean containsReference(Object object) {
        if (this.references == null) {
            return false;
        }
        SerialContext serialContext = this.references.get(object);
        if (serialContext == null) {
            return false;
        }
        if (object == Collections.emptyMap()) {
            return false;
        }
        Object object2 = serialContext.fieldName;
        return object2 == null || object2 instanceof Integer || object2 instanceof String;
    }

    public void writeReference(Object object) {
        SerialContext serialContext = this.context;
        Object object2 = serialContext.object;
        if (object == object2) {
            this.out.write("{\"$ref\":\"@\"}");
            return;
        }
        SerialContext serialContext2 = serialContext.parent;
        if (serialContext2 != null && object == serialContext2.object) {
            this.out.write("{\"$ref\":\"..\"}");
            return;
        }
        SerialContext serialContext3 = serialContext;
        while (serialContext3.parent != null) {
            serialContext3 = serialContext3.parent;
        }
        if (object == serialContext3.object) {
            this.out.write("{\"$ref\":\"$\"}");
        } else {
            this.out.write("{\"$ref\":\"");
            String string = this.references.get(object).toString();
            this.out.write(string);
            this.out.write("\"}");
        }
    }

    public boolean checkValue(SerializeFilterable serializeFilterable) {
        return this.valueFilters != null && this.valueFilters.size() > 0 || this.contextValueFilters != null && this.contextValueFilters.size() > 0 || serializeFilterable.valueFilters != null && serializeFilterable.valueFilters.size() > 0 || serializeFilterable.contextValueFilters != null && serializeFilterable.contextValueFilters.size() > 0 || this.out.writeNonStringValueAsString;
    }

    public boolean hasNameFilters(SerializeFilterable serializeFilterable) {
        return this.nameFilters != null && this.nameFilters.size() > 0 || serializeFilterable.nameFilters != null && serializeFilterable.nameFilters.size() > 0;
    }

    public boolean hasPropertyFilters(SerializeFilterable serializeFilterable) {
        return this.propertyFilters != null && this.propertyFilters.size() > 0 || serializeFilterable.propertyFilters != null && serializeFilterable.propertyFilters.size() > 0;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void decrementIdent() {
        --this.indentCount;
    }

    public void println() {
        this.out.write(10);
        for (int i = 0; i < this.indentCount; ++i) {
            this.out.write(this.indent);
        }
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public void config(SerializerFeature serializerFeature, boolean bl) {
        this.out.config(serializerFeature, bl);
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return this.out.isEnabled(serializerFeature);
    }

    public void writeNull() {
        this.out.writeNull();
    }

    public SerializeConfig getMapping() {
        return this.config;
    }

    public static void write(Writer writer, Object object) {
        try (SerializeWriter serializeWriter = new SerializeWriter();){
            JSONSerializer jSONSerializer = new JSONSerializer(serializeWriter);
            jSONSerializer.write(object);
            serializeWriter.writeTo(writer);
        }
    }

    public static void write(SerializeWriter serializeWriter, Object object) {
        JSONSerializer jSONSerializer = new JSONSerializer(serializeWriter);
        jSONSerializer.write(object);
    }

    public final void write(Object object) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        ObjectSerializer objectSerializer = this.getObjectWriter(clazz);
        try {
            objectSerializer.write(this, object, null, null, 0);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeAs(Object object, Class clazz) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        ObjectSerializer objectSerializer = this.getObjectWriter(clazz);
        try {
            objectSerializer.write(this, object, null, null, 0);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFieldName(Object object, Object object2) {
        this.writeWithFieldName(object, object2, null, 0);
    }

    protected final void writeKeyValue(char c2, String string, Object object) {
        if (c2 != '\u0000') {
            this.out.write(c2);
        }
        this.out.writeFieldName(string);
        this.write(object);
    }

    public final void writeWithFieldName(Object object, Object object2, Type type, int n) {
        try {
            if (object == null) {
                this.out.writeNull();
                return;
            }
            Class<?> clazz = object.getClass();
            ObjectSerializer objectSerializer = this.getObjectWriter(clazz);
            objectSerializer.write(this, object, object2, type, n);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFormat(Object object, String string) {
        block15: {
            block17: {
                byte[] byArray;
                block16: {
                    if (object instanceof Date) {
                        if ("unixtime".equals(string)) {
                            long l = ((Date)object).getTime() / 1000L;
                            this.out.writeInt((int)l);
                            return;
                        }
                        if ("millis".equals(string)) {
                            this.out.writeLong(((Date)object).getTime());
                            return;
                        }
                        DateFormat dateFormat = this.getDateFormat();
                        if (dateFormat == null) {
                            try {
                                dateFormat = new SimpleDateFormat(string, this.locale);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                String string2 = string.replaceAll("T", "'T'");
                                dateFormat = new SimpleDateFormat(string2, this.locale);
                            }
                            dateFormat.setTimeZone(this.timeZone);
                        }
                        String string3 = dateFormat.format((Date)object);
                        this.out.writeString(string3);
                        return;
                    }
                    if (!(object instanceof byte[])) break block15;
                    byArray = (byte[])object;
                    if (!"gzip".equals(string) && !"gzip,base64".equals(string)) break block16;
                    GZIPOutputStream gZIPOutputStream = null;
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        gZIPOutputStream = byArray.length < 512 ? new GZIPOutputStream((OutputStream)byteArrayOutputStream, byArray.length) : new GZIPOutputStream(byteArrayOutputStream);
                        gZIPOutputStream.write(byArray);
                        gZIPOutputStream.finish();
                        this.out.writeByteArray(byteArrayOutputStream.toByteArray());
                    }
                    catch (IOException iOException) {
                        try {
                            throw new JSONException("write gzipBytes error", iOException);
                        }
                        catch (Throwable throwable) {
                            IOUtils.close(gZIPOutputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.close(gZIPOutputStream);
                    break block17;
                }
                if ("hex".equals(string)) {
                    this.out.writeHex(byArray);
                } else {
                    this.out.writeByteArray(byArray);
                }
            }
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            this.out.write(91);
            for (int i = 0; i < collection.size(); ++i) {
                Object e = iterator.next();
                if (i != 0) {
                    this.out.write(44);
                }
                this.writeWithFormat(e, string);
            }
            this.out.write(93);
            return;
        }
        this.write(object);
    }

    public final void write(String string) {
        StringCodec.instance.write(this, string);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.config.getObjectWriter(clazz);
    }

    public void close() {
        this.out.close();
    }
}

