/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JavaBeanSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerialContext;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        boolean bl = jSONSerializer.out.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled(n, SerializerFeature.WriteClassName);
        SerializeWriter serializeWriter = jSONSerializer.out;
        Type type2 = null;
        if (bl) {
            type2 = TypeUtils.getCollectionItemType(type);
        }
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        List list = (List)object;
        if (list.size() == 0) {
            serializeWriter.append("[]");
            return;
        }
        SerialContext serialContext = jSONSerializer.context;
        jSONSerializer.setContext(serialContext, object, object2, 0);
        ObjectSerializer objectSerializer = null;
        try {
            if (serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                serializeWriter.append('[');
                jSONSerializer.incrementIndent();
                int n2 = 0;
                for (Object e : list) {
                    if (n2 != 0) {
                        serializeWriter.append(',');
                    }
                    jSONSerializer.println();
                    if (e != null) {
                        if (jSONSerializer.containsReference(e)) {
                            jSONSerializer.writeReference(e);
                        } else {
                            SerialContext serialContext2;
                            objectSerializer = jSONSerializer.getObjectWriter(e.getClass());
                            jSONSerializer.context = serialContext2 = new SerialContext(serialContext, object, object2, 0, 0);
                            objectSerializer.write(jSONSerializer, e, n2, type2, n);
                        }
                    } else {
                        jSONSerializer.out.writeNull();
                    }
                    ++n2;
                }
                jSONSerializer.decrementIdent();
                jSONSerializer.println();
                serializeWriter.append(']');
                return;
            }
            serializeWriter.append('[');
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                Object e = list.get(i);
                if (i != 0) {
                    serializeWriter.append(',');
                }
                if (e == null) {
                    serializeWriter.append("null");
                    continue;
                }
                Class<?> clazz = e.getClass();
                if (clazz == Integer.class) {
                    serializeWriter.writeInt((Integer)e);
                    continue;
                }
                if (clazz == Long.class) {
                    long l = (Long)e;
                    if (bl) {
                        serializeWriter.writeLong(l);
                        serializeWriter.write(76);
                        continue;
                    }
                    serializeWriter.writeLong(l);
                    continue;
                }
                if ((SerializerFeature.DisableCircularReferenceDetect.mask & n) != 0) {
                    objectSerializer = jSONSerializer.getObjectWriter(e.getClass());
                    objectSerializer.write(jSONSerializer, e, i, type2, n);
                    continue;
                }
                if (!serializeWriter.disableCircularReferenceDetect) {
                    SerialContext serialContext3;
                    jSONSerializer.context = serialContext3 = new SerialContext(serialContext, object, object2, 0, 0);
                }
                if (jSONSerializer.containsReference(e)) {
                    jSONSerializer.writeReference(e);
                    continue;
                }
                objectSerializer = jSONSerializer.getObjectWriter(e.getClass());
                if ((SerializerFeature.WriteClassName.mask & n) != 0 && objectSerializer instanceof JavaBeanSerializer) {
                    JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)objectSerializer;
                    javaBeanSerializer.writeNoneASM(jSONSerializer, e, i, type2, n);
                    continue;
                }
                objectSerializer.write(jSONSerializer, e, i, type2, n);
            }
            serializeWriter.append(']');
        }
        finally {
            jSONSerializer.context = serialContext;
        }
    }
}

