/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicLong;

public class LongCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static LongCodec instance = new LongCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            long l = (Long)object;
            serializeWriter.writeLong(l);
            if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE && type != Long.class && type != Long.TYPE) {
                serializeWriter.write(76);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Long l;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        try {
            int n = jSONLexer.token();
            if (n == 2) {
                long l2 = jSONLexer.longValue();
                jSONLexer.nextToken(16);
                l = l2;
            } else if (n == 3) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                l = TypeUtils.longValue(bigDecimal);
                jSONLexer.nextToken(16);
            } else {
                if (n == 12) {
                    JSONObject jSONObject = new JSONObject(true);
                    defaultJSONParser.parseObject(jSONObject);
                    l = TypeUtils.castToLong(jSONObject);
                } else {
                    Object object2 = defaultJSONParser.parse();
                    l = TypeUtils.castToLong(object2);
                }
                if (l == null) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            throw new JSONException("parseLong error, field : " + object, exception);
        }
        return (T)(type == AtomicLong.class ? new AtomicLong(l) : l);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

