/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import com.icbc.api.internal.util.internal.util.fastjson.JSONPath;
import com.icbc.api.internal.util.internal.util.fastjson.JSONStreamAware;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class MiscCodec
implements ObjectDeserializer,
ObjectSerializer {
    private static boolean FILE_RELATIVE_PATH_SUPPORT = false;
    public static final MiscCodec instance = new MiscCodec();
    private static Method method_paths_get;
    private static boolean method_paths_get_error;

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        String string;
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz == SimpleDateFormat.class) {
            String string2 = ((SimpleDateFormat)object).toPattern();
            if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) && object.getClass() != type) {
                serializeWriter.write(123);
                serializeWriter.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                jSONSerializer.write(object.getClass().getName());
                serializeWriter.writeFieldValue(',', "val", string2);
                serializeWriter.write(125);
                return;
            }
            string = string2;
        } else if (clazz == Class.class) {
            Class clazz2 = (Class)object;
            string = clazz2.getName();
        } else {
            if (clazz == InetSocketAddress.class) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
                InetAddress inetAddress = inetSocketAddress.getAddress();
                serializeWriter.write(123);
                if (inetAddress != null) {
                    serializeWriter.writeFieldName("address");
                    jSONSerializer.write(inetAddress);
                    serializeWriter.write(44);
                }
                serializeWriter.writeFieldName("port");
                serializeWriter.writeInt(inetSocketAddress.getPort());
                serializeWriter.write(125);
                return;
            }
            if (object instanceof File) {
                string = ((File)object).getPath();
            } else if (object instanceof InetAddress) {
                string = ((InetAddress)object).getHostAddress();
            } else if (object instanceof TimeZone) {
                TimeZone timeZone = (TimeZone)object;
                string = timeZone.getID();
            } else if (object instanceof Currency) {
                Currency currency = (Currency)object;
                string = currency.getCurrencyCode();
            } else {
                if (object instanceof JSONStreamAware) {
                    JSONStreamAware jSONStreamAware = (JSONStreamAware)object;
                    jSONStreamAware.writeJSONString(serializeWriter);
                    return;
                }
                if (object instanceof Iterator) {
                    Iterator iterator = (Iterator)object;
                    this.writeIterator(jSONSerializer, serializeWriter, iterator);
                    return;
                }
                if (object instanceof Iterable) {
                    Iterator iterator = ((Iterable)object).iterator();
                    this.writeIterator(jSONSerializer, serializeWriter, iterator);
                    return;
                }
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (k instanceof String) {
                        String string3 = (String)k;
                        if (v instanceof String) {
                            String string4 = (String)v;
                            serializeWriter.writeFieldValueStringWithDoubleQuoteCheck('{', string3, string4);
                        } else {
                            serializeWriter.write(123);
                            serializeWriter.writeFieldName(string3);
                            jSONSerializer.write(v);
                        }
                    } else {
                        serializeWriter.write(123);
                        jSONSerializer.write(k);
                        serializeWriter.write(58);
                        jSONSerializer.write(v);
                    }
                    serializeWriter.write(125);
                    return;
                }
                if (object.getClass().getName().equals("net.sf.json.JSONNull")) {
                    serializeWriter.writeNull();
                    return;
                }
                if (object instanceof Node) {
                    string = MiscCodec.toString((Node)object);
                } else {
                    throw new JSONException("not support class : " + clazz);
                }
            }
        }
        serializeWriter.writeString(string);
    }

    private static String toString(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            transformer.transform(dOMSource, new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new JSONException("xml node to string error", transformerException);
        }
    }

    protected void writeIterator(JSONSerializer jSONSerializer, SerializeWriter serializeWriter, Iterator<?> iterator) {
        int n = 0;
        serializeWriter.write(91);
        while (iterator.hasNext()) {
            if (n != 0) {
                serializeWriter.write(44);
            }
            Object obj = iterator.next();
            jSONSerializer.write(obj);
            ++n;
        }
        serializeWriter.write(93);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Object object2;
        String string;
        Object object3;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (type == InetSocketAddress.class) {
            if (jSONLexer.token() == 8) {
                jSONLexer.nextToken();
                return null;
            }
            defaultJSONParser.accept(12);
            InetAddress inetAddress = null;
            int n = 0;
            while (true) {
                String string2 = jSONLexer.stringVal();
                jSONLexer.nextToken(17);
                if (string2.equals("address")) {
                    defaultJSONParser.accept(17);
                    inetAddress = defaultJSONParser.parseObject(InetAddress.class);
                } else if (string2.equals("port")) {
                    defaultJSONParser.accept(17);
                    if (jSONLexer.token() != 2) {
                        throw new JSONException("port is not int");
                    }
                    n = jSONLexer.intValue();
                    jSONLexer.nextToken();
                } else {
                    defaultJSONParser.accept(17);
                    defaultJSONParser.parse();
                }
                if (jSONLexer.token() != 16) break;
                jSONLexer.nextToken();
            }
            defaultJSONParser.accept(13);
            return (T)new InetSocketAddress(inetAddress, n);
        }
        if (defaultJSONParser.resolveStatus == 2) {
            defaultJSONParser.resolveStatus = 0;
            defaultJSONParser.accept(16);
            if (jSONLexer.token() == 4) {
                if (!"val".equals(jSONLexer.stringVal())) {
                    throw new JSONException("syntax error");
                }
            } else {
                throw new JSONException("syntax error");
            }
            jSONLexer.nextToken();
            defaultJSONParser.accept(17);
            object3 = defaultJSONParser.parse();
            defaultJSONParser.accept(13);
        } else {
            object3 = defaultJSONParser.parse();
        }
        if (object3 == null) {
            string = null;
        } else if (object3 instanceof String) {
            string = (String)object3;
        } else {
            if (object3 instanceof JSONObject) {
                JSONObject jSONObject = (JSONObject)object3;
                if (type == Currency.class) {
                    String string3 = jSONObject.getString("currency");
                    if (string3 != null) {
                        return (T)Currency.getInstance(string3);
                    }
                    String string4 = jSONObject.getString("currencyCode");
                    if (string4 != null) {
                        return (T)Currency.getInstance(string4);
                    }
                }
                if (type == Map.Entry.class) {
                    return (T)jSONObject.entrySet().iterator().next();
                }
                return jSONObject.toJavaObject(type);
            }
            throw new JSONException("expect string");
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (type == UUID.class) {
            return (T)UUID.fromString(string);
        }
        if (type == URI.class) {
            return (T)URI.create(string);
        }
        if (type == URL.class) {
            try {
                return (T)new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new JSONException("create url error", malformedURLException);
            }
        }
        if (type == Pattern.class) {
            return (T)Pattern.compile(string);
        }
        if (type == Locale.class) {
            return (T)TypeUtils.toLocale(string);
        }
        if (type == SimpleDateFormat.class) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, jSONLexer.getLocale());
            simpleDateFormat.setTimeZone(jSONLexer.getTimeZone());
            return (T)simpleDateFormat;
        }
        if (type == InetAddress.class || type == Inet4Address.class || type == Inet6Address.class) {
            try {
                return (T)InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new JSONException("deserialize inet adress error", unknownHostException);
            }
        }
        if (type == File.class) {
            if (string.indexOf("..") >= 0 && !FILE_RELATIVE_PATH_SUPPORT) {
                throw new JSONException("file relative path not support.");
            }
            return (T)new File(string);
        }
        if (type == TimeZone.class) {
            return (T)TimeZone.getTimeZone(string);
        }
        if (type instanceof ParameterizedType) {
            object2 = (ParameterizedType)type;
            type = object2.getRawType();
        }
        if (type == Class.class) {
            return (T)TypeUtils.loadClass(string, defaultJSONParser.getConfig().getDefaultClassLoader(), false);
        }
        if (type == Charset.class) {
            return (T)Charset.forName(string);
        }
        if (type == Currency.class) {
            return (T)Currency.getInstance(string);
        }
        if (type == JSONPath.class) {
            return (T)new JSONPath(string);
        }
        if (type instanceof Class) {
            object2 = ((Class)type).getName();
            if (((String)object2).equals("java.nio.file.Path")) {
                try {
                    if (method_paths_get == null && !method_paths_get_error) {
                        Class<?> clazz = TypeUtils.loadClass("java.nio.file.Paths");
                        method_paths_get = clazz.getMethod("get", String.class, String[].class);
                    }
                    if (method_paths_get != null) {
                        return (T)method_paths_get.invoke(null, string, new String[0]);
                    }
                    throw new JSONException("Path deserialize erorr");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method_paths_get_error = true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JSONException("Path deserialize erorr", illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new JSONException("Path deserialize erorr", invocationTargetException);
                }
            }
            throw new JSONException("MiscCodec not support " + (String)object2);
        }
        throw new JSONException("MiscCodec not support " + type.toString());
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }

    static {
        method_paths_get_error = false;
        FILE_RELATIVE_PATH_SUPPORT = "true".equals(IOUtils.getStringProperty("fastjson.deserializer.fileRelativePathSupport"));
    }
}

