/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class PrimitiveArraySerializer
implements ObjectSerializer {
    public static PrimitiveArraySerializer instance = new PrimitiveArraySerializer();

    @Override
    public final void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            serializeWriter.write(91);
            for (int i = 0; i < nArray.length; ++i) {
                if (i != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.writeInt(nArray[i]);
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            serializeWriter.write(91);
            for (int i = 0; i < sArray.length; ++i) {
                if (i != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.writeInt(sArray[i]);
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof long[]) {
            long[] lArray = (long[])object;
            serializeWriter.write(91);
            for (int i = 0; i < lArray.length; ++i) {
                if (i != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.writeLong(lArray[i]);
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            serializeWriter.write(91);
            for (int i = 0; i < blArray.length; ++i) {
                if (i != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.write(blArray[i]);
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof float[]) {
            float[] fArray = (float[])object;
            serializeWriter.write(91);
            for (int i = 0; i < fArray.length; ++i) {
                float f;
                if (i != 0) {
                    serializeWriter.write(44);
                }
                if (Float.isNaN(f = fArray[i])) {
                    serializeWriter.writeNull();
                    continue;
                }
                serializeWriter.append(Float.toString(f));
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            serializeWriter.write(91);
            for (int i = 0; i < dArray.length; ++i) {
                double d2;
                if (i != 0) {
                    serializeWriter.write(44);
                }
                if (Double.isNaN(d2 = dArray[i])) {
                    serializeWriter.writeNull();
                    continue;
                }
                serializeWriter.append(Double.toString(d2));
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            serializeWriter.writeByteArray(byArray);
            return;
        }
        char[] cArray = (char[])object;
        serializeWriter.writeString(cArray);
    }
}

