/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.annotation.JSONType;
import com.icbc.api.internal.util.fastjson.parser.deserializer.Jdk8DateCodec;
import com.icbc.api.internal.util.fastjson.parser.deserializer.OptionalCodec;
import com.icbc.api.internal.util.fastjson.serializer.ASMSerializerFactory;
import com.icbc.api.internal.util.fastjson.serializer.AdderSerializer;
import com.icbc.api.internal.util.fastjson.serializer.AnnotationSerializer;
import com.icbc.api.internal.util.fastjson.serializer.AppendableSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ArraySerializer;
import com.icbc.api.internal.util.fastjson.serializer.AtomicCodec;
import com.icbc.api.internal.util.fastjson.serializer.AutowiredObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.AwtCodec;
import com.icbc.api.internal.util.fastjson.serializer.BigDecimalCodec;
import com.icbc.api.internal.util.fastjson.serializer.BigIntegerCodec;
import com.icbc.api.internal.util.fastjson.serializer.BooleanCodec;
import com.icbc.api.internal.util.fastjson.serializer.ByteBufferCodec;
import com.icbc.api.internal.util.fastjson.serializer.CalendarCodec;
import com.icbc.api.internal.util.fastjson.serializer.CharacterCodec;
import com.icbc.api.internal.util.fastjson.serializer.ClobSeriliazer;
import com.icbc.api.internal.util.fastjson.serializer.CollectionCodec;
import com.icbc.api.internal.util.fastjson.serializer.DateCodec;
import com.icbc.api.internal.util.fastjson.serializer.DoubleSerializer;
import com.icbc.api.internal.util.fastjson.serializer.EnumSerializer;
import com.icbc.api.internal.util.fastjson.serializer.EnumerationSerializer;
import com.icbc.api.internal.util.fastjson.serializer.FieldSerializer;
import com.icbc.api.internal.util.fastjson.serializer.FloatCodec;
import com.icbc.api.internal.util.fastjson.serializer.IntegerCodec;
import com.icbc.api.internal.util.fastjson.serializer.JSONAwareSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONObjectCodec;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializable;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializableSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JavaBeanSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ListSerializer;
import com.icbc.api.internal.util.fastjson.serializer.LongCodec;
import com.icbc.api.internal.util.fastjson.serializer.MapSerializer;
import com.icbc.api.internal.util.fastjson.serializer.MiscCodec;
import com.icbc.api.internal.util.fastjson.serializer.ObjectArrayCodec;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.PrimitiveArraySerializer;
import com.icbc.api.internal.util.fastjson.serializer.ReferenceCodec;
import com.icbc.api.internal.util.fastjson.serializer.SerializeBeanInfo;
import com.icbc.api.internal.util.fastjson.serializer.SerializeFilter;
import com.icbc.api.internal.util.fastjson.serializer.SerializeFilterable;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.serializer.StringCodec;
import com.icbc.api.internal.util.fastjson.serializer.ToStringSerializer;
import com.icbc.api.internal.util.fastjson.spi.Module;
import com.icbc.api.internal.util.fastjson.util.ASMUtils;
import com.icbc.api.internal.util.fastjson.util.FieldInfo;
import com.icbc.api.internal.util.fastjson.util.IdentityHashMap;
import com.icbc.api.internal.util.fastjson.util.ServiceLoader;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONAware;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONStreamAware;
import com.icbc.api.internal.util.internal.util.fastjson.PropertyNamingStrategy;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Node;

public class SerializeConfig {
    public static final SerializeConfig globalInstance = new SerializeConfig();
    private static boolean awtError = false;
    private static boolean jdk8Error = false;
    private static boolean oracleJdbcError = false;
    private static boolean springfoxError = false;
    private static boolean guavaError = false;
    private static boolean jsonnullError = false;
    private static boolean jsonobjectError = false;
    private static boolean jodaError = false;
    private boolean asm = !ASMUtils.IS_ANDROID;
    private ASMSerializerFactory asmFactory;
    protected String typeKey = JSON.DEFAULT_TYPE_KEY;
    public PropertyNamingStrategy propertyNamingStrategy;
    private final IdentityHashMap<Type, ObjectSerializer> serializers;
    private final IdentityHashMap<Type, IdentityHashMap<Type, ObjectSerializer>> mixInSerializers;
    private final boolean fieldBased;
    private long[] denyClasses = new long[]{4165360493669296979L, 4446674157046724083L};
    private List<Module> modules = new ArrayList<Module>();

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String string) {
        this.typeKey = string;
    }

    private final JavaBeanSerializer createASMSerializer(SerializeBeanInfo serializeBeanInfo) throws Exception {
        JavaBeanSerializer javaBeanSerializer = this.asmFactory.createJavaBeanSerializer(serializeBeanInfo);
        for (int i = 0; i < javaBeanSerializer.sortedGetters.length; ++i) {
            ObjectSerializer objectSerializer;
            FieldSerializer fieldSerializer = javaBeanSerializer.sortedGetters[i];
            Class<?> clazz = fieldSerializer.fieldInfo.fieldClass;
            if (!clazz.isEnum() || (objectSerializer = this.getObjectWriter(clazz)) instanceof EnumSerializer) continue;
            javaBeanSerializer.writeDirect = false;
        }
        return javaBeanSerializer;
    }

    public final ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        String string = clazz.getName();
        long l = TypeUtils.fnv1a_64(string);
        if (Arrays.binarySearch(this.denyClasses, l) >= 0) {
            throw new JSONException("not support class : " + string);
        }
        SerializeBeanInfo serializeBeanInfo = TypeUtils.buildBeanInfo(clazz, null, this.propertyNamingStrategy, this.fieldBased);
        if (serializeBeanInfo.fields.length == 0 && Iterable.class.isAssignableFrom(clazz)) {
            return MiscCodec.instance;
        }
        return this.createJavaBeanSerializer(serializeBeanInfo);
    }

    public ObjectSerializer createJavaBeanSerializer(SerializeBeanInfo serializeBeanInfo) {
        Class<?> clazz;
        boolean bl;
        JSONType jSONType = serializeBeanInfo.jsonType;
        boolean bl2 = bl = this.asm && !this.fieldBased;
        if (jSONType != null) {
            Class<? extends SerializeFilter>[] outOfMemoryError;
            clazz = jSONType.serializer();
            if (clazz != Void.class) {
                try {
                    Object object = clazz.newInstance();
                    if (object instanceof ObjectSerializer) {
                        return (ObjectSerializer)object;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!jSONType.asm()) {
                bl = false;
            }
            if (bl) {
                for (SerializerFeature serializerFeature : jSONType.serialzeFeatures()) {
                    if (SerializerFeature.WriteNonStringValueAsString != serializerFeature && SerializerFeature.WriteEnumUsingToString != serializerFeature && SerializerFeature.NotWriteDefaultValue != serializerFeature && SerializerFeature.BrowserCompatible != serializerFeature) continue;
                    bl = false;
                    break;
                }
            }
            if (bl && (outOfMemoryError = jSONType.serialzeFilters()).length != 0) {
                bl = false;
            }
        }
        clazz = serializeBeanInfo.beanType;
        if (!Modifier.isPublic(serializeBeanInfo.beanType.getModifiers())) {
            return new JavaBeanSerializer(serializeBeanInfo);
        }
        if (bl && this.asmFactory.classLoader.isExternalClass(clazz) || clazz == Serializable.class || clazz == Object.class) {
            bl = false;
        }
        if (bl && !ASMUtils.checkName(clazz.getSimpleName())) {
            bl = false;
        }
        if (bl && serializeBeanInfo.beanType.isInterface()) {
            bl = false;
        }
        if (bl) {
            for (FieldInfo fieldInfo : serializeBeanInfo.fields) {
                Field field = fieldInfo.field;
                if (field != null && !field.getType().equals(fieldInfo.fieldClass)) {
                    bl = false;
                    break;
                }
                Method method = fieldInfo.method;
                if (method != null && !method.getReturnType().equals(fieldInfo.fieldClass)) {
                    bl = false;
                    break;
                }
                JSONField jSONField = fieldInfo.getAnnotation();
                if (jSONField == null) continue;
                String string = jSONField.format();
                if (!(string.length() == 0 || fieldInfo.fieldClass == String.class && "trim".equals(string))) {
                    bl = false;
                    break;
                }
                if (!ASMUtils.checkName(jSONField.name()) || jSONField.jsonDirect() || jSONField.serializeUsing() != Void.class || jSONField.unwrapped()) {
                    bl = false;
                    break;
                }
                for (SerializerFeature serializerFeature : jSONField.serialzeFeatures()) {
                    if (SerializerFeature.WriteNonStringValueAsString != serializerFeature && SerializerFeature.WriteEnumUsingToString != serializerFeature && SerializerFeature.NotWriteDefaultValue != serializerFeature && SerializerFeature.BrowserCompatible != serializerFeature && SerializerFeature.WriteClassName != serializerFeature) continue;
                    bl = false;
                    break;
                }
                if (TypeUtils.isAnnotationPresentOneToMany(method) || TypeUtils.isAnnotationPresentManyToMany(method)) {
                    bl = false;
                    break;
                }
                if (jSONField.defaultValue() == null || "".equals(jSONField.defaultValue())) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            try {
                JavaBeanSerializer javaBeanSerializer = this.createASMSerializer(serializeBeanInfo);
                if (javaBeanSerializer != null) {
                    return javaBeanSerializer;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassFormatError classFormatError) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (outOfMemoryError.getMessage().indexOf("Metaspace") != -1) {
                    throw outOfMemoryError;
                }
            }
            catch (Throwable throwable) {
                throw new JSONException("create asm serializer error, verson 1.2.70, class " + clazz, throwable);
            }
        }
        return new JavaBeanSerializer(serializeBeanInfo);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean bl) {
        if (ASMUtils.IS_ANDROID) {
            return;
        }
        this.asm = bl;
    }

    public static SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(8192);
    }

    public SerializeConfig(boolean bl) {
        this(8192, bl);
    }

    public SerializeConfig(int n) {
        this(n, false);
    }

    public SerializeConfig(int n, boolean bl) {
        this.fieldBased = bl;
        this.serializers = new IdentityHashMap(n);
        this.mixInSerializers = new IdentityHashMap(16);
        try {
            if (this.asm) {
                this.asmFactory = new ASMSerializerFactory();
            }
        }
        catch (Throwable throwable) {
            this.asm = false;
        }
        this.initSerializers();
    }

    private void initSerializers() {
        this.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.put((Type)((Object)Character.class), CharacterCodec.instance);
        this.put((Type)((Object)Byte.class), IntegerCodec.instance);
        this.put((Type)((Object)Short.class), IntegerCodec.instance);
        this.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.put((Type)((Object)Long.class), LongCodec.instance);
        this.put((Type)((Object)Float.class), FloatCodec.instance);
        this.put((Type)((Object)Double.class), DoubleSerializer.instance);
        this.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.put((Type)((Object)String.class), StringCodec.instance);
        this.put((Type)((Object)byte[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)short[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)int[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)long[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)float[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)double[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)boolean[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)char[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)Object[].class), ObjectArrayCodec.instance);
        this.put((Type)((Object)Class.class), MiscCodec.instance);
        this.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.put((Type)((Object)Currency.class), new MiscCodec());
        this.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.put((Type)((Object)InetAddress.class), MiscCodec.instance);
        this.put((Type)((Object)Inet4Address.class), MiscCodec.instance);
        this.put((Type)((Object)Inet6Address.class), MiscCodec.instance);
        this.put((Type)((Object)InetSocketAddress.class), MiscCodec.instance);
        this.put((Type)((Object)File.class), MiscCodec.instance);
        this.put((Type)((Object)Appendable.class), AppendableSerializer.instance);
        this.put((Type)((Object)StringBuffer.class), AppendableSerializer.instance);
        this.put((Type)((Object)StringBuilder.class), AppendableSerializer.instance);
        this.put((Type)((Object)Charset.class), ToStringSerializer.instance);
        this.put((Type)((Object)Pattern.class), ToStringSerializer.instance);
        this.put((Type)((Object)Locale.class), ToStringSerializer.instance);
        this.put((Type)((Object)URI.class), ToStringSerializer.instance);
        this.put((Type)((Object)URL.class), ToStringSerializer.instance);
        this.put((Type)((Object)UUID.class), ToStringSerializer.instance);
        this.put((Type)((Object)AtomicBoolean.class), AtomicCodec.instance);
        this.put((Type)((Object)AtomicInteger.class), AtomicCodec.instance);
        this.put((Type)((Object)AtomicLong.class), AtomicCodec.instance);
        this.put((Type)((Object)AtomicReference.class), ReferenceCodec.instance);
        this.put((Type)((Object)AtomicIntegerArray.class), AtomicCodec.instance);
        this.put((Type)((Object)AtomicLongArray.class), AtomicCodec.instance);
        this.put((Type)((Object)WeakReference.class), ReferenceCodec.instance);
        this.put((Type)((Object)SoftReference.class), ReferenceCodec.instance);
        this.put((Type)((Object)LinkedList.class), CollectionCodec.instance);
    }

    public void addFilter(Class<?> clazz, SerializeFilter serializeFilter) {
        ObjectSerializer objectSerializer = this.getObjectWriter(clazz);
        if (objectSerializer instanceof SerializeFilterable) {
            SerializeFilterable serializeFilterable = (SerializeFilterable)((Object)objectSerializer);
            if (this != globalInstance && serializeFilterable == MapSerializer.instance) {
                MapSerializer mapSerializer = new MapSerializer();
                this.put(clazz, mapSerializer);
                mapSerializer.addFilter(serializeFilter);
                return;
            }
            serializeFilterable.addFilter(serializeFilter);
        }
    }

    public void config(Class<?> clazz, SerializerFeature serializerFeature, boolean bl) {
        ObjectSerializer objectSerializer = this.getObjectWriter(clazz, false);
        if (objectSerializer == null) {
            SerializeBeanInfo serializeBeanInfo = TypeUtils.buildBeanInfo(clazz, null, this.propertyNamingStrategy);
            serializeBeanInfo.features = bl ? (serializeBeanInfo.features |= serializerFeature.mask) : (serializeBeanInfo.features &= ~serializerFeature.mask);
            objectSerializer = this.createJavaBeanSerializer(serializeBeanInfo);
            this.put(clazz, objectSerializer);
            return;
        }
        if (objectSerializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)objectSerializer;
            SerializeBeanInfo serializeBeanInfo = javaBeanSerializer.beanInfo;
            int n = serializeBeanInfo.features;
            serializeBeanInfo.features = bl ? (serializeBeanInfo.features |= serializerFeature.mask) : (serializeBeanInfo.features &= ~serializerFeature.mask);
            if (n == serializeBeanInfo.features) {
                return;
            }
            Class<?> clazz2 = objectSerializer.getClass();
            if (clazz2 != JavaBeanSerializer.class) {
                ObjectSerializer objectSerializer2 = this.createJavaBeanSerializer(serializeBeanInfo);
                this.put(clazz, objectSerializer2);
            }
        }
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.getObjectWriter(clazz, true);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectSerializer getObjectWriter(Class<?> clazz, boolean bl) {
        Object object2;
        ObjectSerializer objectSerializer = this.get(clazz);
        if (objectSerializer != null) {
            return objectSerializer;
        }
        try {
            object2 = Thread.currentThread().getContextClassLoader();
            for (AutowiredObjectSerializer autowiredObjectSerializer : ServiceLoader.load(AutowiredObjectSerializer.class, (ClassLoader)object2)) {
                if (!(autowiredObjectSerializer instanceof AutowiredObjectSerializer)) continue;
                AutowiredObjectSerializer autowiredObjectSerializer2 = autowiredObjectSerializer;
                for (Type type : autowiredObjectSerializer2.getAutowiredFor()) {
                    this.put(type, autowiredObjectSerializer2);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if ((objectSerializer = this.get(clazz)) == null && (object2 = JSON.class.getClassLoader()) != Thread.currentThread().getContextClassLoader()) {
            try {
                for (AutowiredObjectSerializer autowiredObjectSerializer : ServiceLoader.load(AutowiredObjectSerializer.class, (ClassLoader)object2)) {
                    if (!(autowiredObjectSerializer instanceof AutowiredObjectSerializer)) continue;
                    AutowiredObjectSerializer autowiredObjectSerializer3 = autowiredObjectSerializer;
                    for (Type type : autowiredObjectSerializer3.getAutowiredFor()) {
                        this.put(type, autowiredObjectSerializer3);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            objectSerializer = this.get(clazz);
        }
        for (Module module : this.modules) {
            objectSerializer = module.createSerializer(this, clazz);
            if (objectSerializer == null) continue;
            this.put(clazz, objectSerializer);
            return objectSerializer;
        }
        if (objectSerializer == null) {
            object2 = clazz.getName();
            if (Map.class.isAssignableFrom(clazz)) {
                objectSerializer = MapSerializer.instance;
                this.put(clazz, objectSerializer);
            } else if (List.class.isAssignableFrom(clazz)) {
                objectSerializer = ListSerializer.instance;
                this.put(clazz, objectSerializer);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                objectSerializer = CollectionCodec.instance;
                this.put(clazz, objectSerializer);
            } else if (Date.class.isAssignableFrom(clazz)) {
                objectSerializer = DateCodec.instance;
                this.put(clazz, objectSerializer);
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
                objectSerializer = JSONAwareSerializer.instance;
                this.put(clazz, objectSerializer);
            } else if (JSONSerializable.class.isAssignableFrom(clazz)) {
                objectSerializer = JSONSerializableSerializer.instance;
                this.put(clazz, objectSerializer);
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
                objectSerializer = MiscCodec.instance;
                this.put(clazz, objectSerializer);
            } else if (clazz.isEnum()) {
                JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
                if (jSONType != null && jSONType.serializeEnumAsJavaBean()) {
                    objectSerializer = this.createJavaBeanSerializer(clazz);
                    this.put(clazz, objectSerializer);
                } else {
                    objectSerializer = this.getEnumSerializer();
                    this.put(clazz, objectSerializer);
                }
            } else {
                Class<?> clazz2 = clazz.getSuperclass();
                if (clazz2 != null && clazz2.isEnum()) {
                    JSONType jSONType = TypeUtils.getAnnotation(clazz2, JSONType.class);
                    if (jSONType != null && jSONType.serializeEnumAsJavaBean()) {
                        objectSerializer = this.createJavaBeanSerializer(clazz);
                        this.put(clazz, objectSerializer);
                    } else {
                        objectSerializer = this.getEnumSerializer();
                        this.put(clazz, objectSerializer);
                    }
                } else if (clazz.isArray()) {
                    Class<?> clazz3 = clazz.getComponentType();
                    ObjectSerializer objectSerializer2 = this.getObjectWriter(clazz3);
                    objectSerializer = new ArraySerializer(clazz3, objectSerializer2);
                    this.put(clazz, objectSerializer);
                } else if (Throwable.class.isAssignableFrom(clazz)) {
                    SerializeBeanInfo serializeBeanInfo = TypeUtils.buildBeanInfo(clazz, null, this.propertyNamingStrategy);
                    serializeBeanInfo.features |= SerializerFeature.WriteClassName.mask;
                    objectSerializer = new JavaBeanSerializer(serializeBeanInfo);
                    this.put(clazz, objectSerializer);
                } else if (TimeZone.class.isAssignableFrom(clazz) || Map.Entry.class.isAssignableFrom(clazz)) {
                    objectSerializer = MiscCodec.instance;
                    this.put(clazz, objectSerializer);
                } else if (Appendable.class.isAssignableFrom(clazz)) {
                    objectSerializer = AppendableSerializer.instance;
                    this.put(clazz, objectSerializer);
                } else if (Charset.class.isAssignableFrom(clazz)) {
                    objectSerializer = ToStringSerializer.instance;
                    this.put(clazz, objectSerializer);
                } else if (Enumeration.class.isAssignableFrom(clazz)) {
                    objectSerializer = EnumerationSerializer.instance;
                    this.put(clazz, objectSerializer);
                } else if (Calendar.class.isAssignableFrom(clazz) || XMLGregorianCalendar.class.isAssignableFrom(clazz)) {
                    objectSerializer = CalendarCodec.instance;
                    this.put(clazz, objectSerializer);
                } else if (TypeUtils.isClob(clazz)) {
                    objectSerializer = ClobSeriliazer.instance;
                    this.put(clazz, objectSerializer);
                } else if (TypeUtils.isPath(clazz)) {
                    objectSerializer = ToStringSerializer.instance;
                    this.put(clazz, objectSerializer);
                } else if (Iterator.class.isAssignableFrom(clazz)) {
                    objectSerializer = MiscCodec.instance;
                    this.put(clazz, objectSerializer);
                } else if (Node.class.isAssignableFrom(clazz)) {
                    objectSerializer = MiscCodec.instance;
                    this.put(clazz, objectSerializer);
                } else {
                    if (((String)object2).startsWith("java.awt.") && AwtCodec.support(clazz) && !awtError) {
                        try {
                            String[] stringArray;
                            for (String string : stringArray = new String[]{"java.awt.Color", "java.awt.Font", "java.awt.Point", "java.awt.Rectangle"}) {
                                if (!string.equals(object2)) continue;
                                objectSerializer = AwtCodec.instance;
                                this.put(Class.forName(string), objectSerializer);
                                return objectSerializer;
                            }
                        }
                        catch (Throwable throwable) {
                            awtError = true;
                        }
                    }
                    if (!jdk8Error && (((String)object2).startsWith("java.time.") || ((String)object2).startsWith("java.util.Optional") || ((String)object2).equals("java.util.concurrent.atomic.LongAdder") || ((String)object2).equals("java.util.concurrent.atomic.DoubleAdder"))) {
                        try {
                            String[] stringArray;
                            String[] stringArray2;
                            String[] stringArray3;
                            for (String string : stringArray3 = new String[]{"java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.ZoneOffset", "java.time.ZoneRegion", "java.time.Period", "java.time.Duration", "java.time.Instant"}) {
                                if (!string.equals(object2)) continue;
                                objectSerializer = Jdk8DateCodec.instance;
                                this.put(Class.forName(string), objectSerializer);
                                return objectSerializer;
                            }
                            for (String string : stringArray2 = new String[]{"java.util.Optional", "java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong"}) {
                                if (!string.equals(object2)) continue;
                                objectSerializer = OptionalCodec.instance;
                                this.put(Class.forName(string), objectSerializer);
                                return objectSerializer;
                            }
                            for (String string : stringArray = new String[]{"java.util.concurrent.atomic.LongAdder", "java.util.concurrent.atomic.DoubleAdder"}) {
                                if (!string.equals(object2)) continue;
                                objectSerializer = AdderSerializer.instance;
                                this.put(Class.forName(string), objectSerializer);
                                return objectSerializer;
                            }
                        }
                        catch (Throwable throwable) {
                            jdk8Error = true;
                        }
                    }
                    if (!oracleJdbcError && ((String)object2).startsWith("oracle.sql.")) {
                        try {
                            String[] stringArray;
                            for (String string : stringArray = new String[]{"oracle.sql.DATE", "oracle.sql.TIMESTAMP"}) {
                                if (!string.equals(object2)) continue;
                                objectSerializer = DateCodec.instance;
                                this.put(Class.forName(string), objectSerializer);
                                return objectSerializer;
                            }
                        }
                        catch (Throwable throwable) {
                            oracleJdbcError = true;
                        }
                    }
                    if (!jsonnullError && ((String)object2).equals("net.sf.json.JSONNull")) {
                        try {
                            objectSerializer = MiscCodec.instance;
                            this.put(Class.forName("net.sf.json.JSONNull"), objectSerializer);
                            return objectSerializer;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            jsonnullError = true;
                        }
                    }
                    if (!jsonobjectError && ((String)object2).equals("org.json.JSONObject")) {
                        try {
                            objectSerializer = JSONObjectCodec.instance;
                            this.put(Class.forName("org.json.JSONObject"), objectSerializer);
                            return objectSerializer;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            jsonobjectError = true;
                        }
                    }
                    if ("java.nio.HeapByteBuffer".equals(object2)) {
                        objectSerializer = ByteBufferCodec.instance;
                        this.put(clazz, objectSerializer);
                        return objectSerializer;
                    }
                    if ("com.google.protobuf.Descriptors$FieldDescriptor".equals(object2)) {
                        objectSerializer = ToStringSerializer.instance;
                        this.put(clazz, objectSerializer);
                        return objectSerializer;
                    }
                    Class<?>[] classArray = clazz.getInterfaces();
                    if (classArray.length == 1 && classArray[0].isAnnotation()) {
                        this.put(clazz, AnnotationSerializer.instance);
                        return AnnotationSerializer.instance;
                    }
                    if (TypeUtils.isProxy(clazz)) {
                        Class<?> clazz4 = clazz.getSuperclass();
                        ObjectSerializer objectSerializer3 = this.getObjectWriter(clazz4);
                        this.put(clazz, objectSerializer3);
                        return objectSerializer3;
                    }
                    if (Proxy.isProxyClass(clazz)) {
                        void var7_55;
                        Object var7_50 = null;
                        if (classArray.length == 2) {
                            Class<?> clazz5 = classArray[1];
                        } else {
                            for (Class<?> clazz6 : classArray) {
                                void var7_52;
                                if (clazz6.getName().startsWith("org.springframework.aop.")) continue;
                                if (var7_52 != null) {
                                    Object var7_53 = null;
                                    break;
                                }
                                Class<?> clazz7 = clazz6;
                            }
                        }
                        if (var7_55 != null) {
                            ObjectSerializer objectSerializer4 = this.getObjectWriter((Class<?>)var7_55);
                            this.put(clazz, objectSerializer4);
                            return objectSerializer4;
                        }
                    }
                    if (bl) {
                        objectSerializer = this.createJavaBeanSerializer(clazz);
                        this.put(clazz, objectSerializer);
                    }
                }
            }
            if (objectSerializer == null) {
                objectSerializer = this.get(clazz);
            }
        }
        return objectSerializer;
    }

    protected ObjectSerializer getEnumSerializer() {
        return EnumSerializer.instance;
    }

    public final ObjectSerializer get(Type type) {
        Type type2 = JSON.getMixInAnnotations(type);
        if (null == type2) {
            return this.serializers.get(type);
        }
        IdentityHashMap<Type, ObjectSerializer> identityHashMap = this.mixInSerializers.get(type);
        if (identityHashMap == null) {
            return null;
        }
        return identityHashMap.get(type2);
    }

    public boolean put(Object object, Object object2) {
        return this.put((Type)object, (ObjectSerializer)object2);
    }

    public boolean put(Type type, ObjectSerializer objectSerializer) {
        Type type2 = JSON.getMixInAnnotations(type);
        if (type2 != null) {
            IdentityHashMap<Type, ObjectSerializer> identityHashMap = this.mixInSerializers.get(type);
            if (identityHashMap == null) {
                identityHashMap = new IdentityHashMap(4);
                this.mixInSerializers.put(type, identityHashMap);
            }
            return identityHashMap.put(type2, objectSerializer);
        }
        return this.serializers.put(type, objectSerializer);
    }

    public void configEnumAsJavaBean(Class<? extends Enum> ... classArray) {
        for (Class<? extends Enum> clazz : classArray) {
            this.put(clazz, this.createJavaBeanSerializer(clazz));
        }
    }

    public void setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.propertyNamingStrategy = propertyNamingStrategy;
    }

    public void clearSerializers() {
        this.serializers.clear();
        this.initSerializers();
    }

    public void register(Module module) {
        this.modules.add(module);
    }
}

