/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.fastjson.util.RyuDouble;
import com.icbc.api.internal.util.fastjson.util.RyuFloat;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;

public final class SerializeWriter
extends Writer {
    private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
    private static final ThreadLocal<byte[]> bytesBufLocal = new ThreadLocal();
    private static final char[] VALUE_TRUE = ":true".toCharArray();
    private static final char[] VALUE_FALSE = ":false".toCharArray();
    private static int BUFFER_THRESHOLD = 131072;
    protected char[] buf;
    protected int count;
    protected int features;
    private final Writer writer;
    protected boolean useSingleQuotes;
    protected boolean quoteFieldNames;
    protected boolean sortField;
    protected boolean disableCircularReferenceDetect;
    protected boolean beanToArray;
    protected boolean writeNonStringValueAsString;
    protected boolean notWriteDefaultValue;
    protected boolean writeEnumUsingName;
    protected boolean writeEnumUsingToString;
    protected boolean writeDirect;
    protected char keySeperator;
    protected int maxBufSize = -1;
    protected boolean browserSecure;
    protected long sepcialBits;
    static final int nonDirectFeatures;

    public SerializeWriter() {
        this((Writer)null);
    }

    public SerializeWriter(Writer writer) {
        this(writer, JSON.DEFAULT_GENERATE_FEATURE, SerializerFeature.EMPTY);
    }

    public SerializeWriter(SerializerFeature ... serializerFeatureArray) {
        this((Writer)null, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, SerializerFeature ... serializerFeatureArray) {
        this(writer, 0, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, int n, SerializerFeature ... serializerFeatureArray) {
        this.writer = writer;
        this.buf = bufLocal.get();
        if (this.buf != null) {
            bufLocal.set(null);
        } else {
            this.buf = new char[2048];
        }
        int n2 = n;
        for (SerializerFeature serializerFeature : serializerFeatureArray) {
            n2 |= serializerFeature.getMask();
        }
        this.features = n2;
        this.computeFeatures();
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public void setMaxBufSize(int n) {
        if (n < this.buf.length) {
            throw new JSONException("must > " + this.buf.length);
        }
        this.maxBufSize = n;
    }

    public int getBufferLength() {
        return this.buf.length;
    }

    public SerializeWriter(int n) {
        this(null, n);
    }

    public SerializeWriter(Writer writer, int n) {
        this.writer = writer;
        if (n <= 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new char[n];
        this.computeFeatures();
    }

    public void config(SerializerFeature serializerFeature, boolean bl) {
        if (bl) {
            this.features |= serializerFeature.getMask();
            if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                this.features &= ~SerializerFeature.WriteEnumUsingName.getMask();
            } else if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                this.features &= ~SerializerFeature.WriteEnumUsingToString.getMask();
            }
        } else {
            this.features &= ~serializerFeature.getMask();
        }
        this.computeFeatures();
    }

    protected void computeFeatures() {
        this.quoteFieldNames = (this.features & SerializerFeature.QuoteFieldNames.mask) != 0;
        this.useSingleQuotes = (this.features & SerializerFeature.UseSingleQuotes.mask) != 0;
        this.sortField = (this.features & SerializerFeature.SortField.mask) != 0;
        this.disableCircularReferenceDetect = (this.features & SerializerFeature.DisableCircularReferenceDetect.mask) != 0;
        this.beanToArray = (this.features & SerializerFeature.BeanToArray.mask) != 0;
        this.writeNonStringValueAsString = (this.features & SerializerFeature.WriteNonStringValueAsString.mask) != 0;
        this.notWriteDefaultValue = (this.features & SerializerFeature.NotWriteDefaultValue.mask) != 0;
        this.writeEnumUsingName = (this.features & SerializerFeature.WriteEnumUsingName.mask) != 0;
        this.writeEnumUsingToString = (this.features & SerializerFeature.WriteEnumUsingToString.mask) != 0;
        this.writeDirect = this.quoteFieldNames && (this.features & nonDirectFeatures) == 0 && (this.beanToArray || this.writeEnumUsingName);
        this.keySeperator = (char)(this.useSingleQuotes ? 39 : 34);
        this.browserSecure = (this.features & SerializerFeature.BrowserSecure.mask) != 0;
        long l = 0x4FFFFFFFFL;
        long l2 = 140758963191807L;
        long l3 = 5764610843043954687L;
        this.sepcialBits = this.browserSecure ? 5764610843043954687L : ((this.features & SerializerFeature.WriteSlashAsSpecial.mask) != 0 ? 140758963191807L : 0x4FFFFFFFFL);
    }

    public boolean isSortField() {
        return this.sortField;
    }

    public boolean isNotWriteDefaultValue() {
        return this.notWriteDefaultValue;
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return (this.features & serializerFeature.mask) != 0;
    }

    public boolean isEnabled(int n) {
        return (this.features & n) != 0;
    }

    @Override
    public void write(int n) {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                this.flush();
                n2 = 1;
            }
        }
        this.buf[this.count] = (char)n;
        this.count = n2;
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                int n4;
                do {
                    n4 = this.buf.length - this.count;
                    System.arraycopy(cArray, n, this.buf, this.count, n4);
                    this.count = this.buf.length;
                    this.flush();
                    n += n4;
                } while ((n2 -= n4) > this.buf.length);
                n3 = n2;
            }
        }
        System.arraycopy(cArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public void expandCapacity(int n) {
        char[] cArray;
        if (this.maxBufSize != -1 && n >= this.maxBufSize) {
            throw new JSONException("serialize exceeded MAX_OUTPUT_LENGTH=" + this.maxBufSize + ", minimumCapacity=" + n);
        }
        int n2 = this.buf.length + (this.buf.length >> 1) + 1;
        if (n2 < n) {
            n2 = n;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(this.buf, 0, cArray2, 0, this.count);
        if (this.buf.length < BUFFER_THRESHOLD && ((cArray = bufLocal.get()) == null || cArray.length < this.buf.length)) {
            bufLocal.set(this.buf);
        }
        this.buf = cArray2;
    }

    @Override
    public SerializeWriter append(CharSequence charSequence) {
        String string = charSequence == null ? "null" : charSequence.toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public SerializeWriter append(CharSequence charSequence, int n, int n2) {
        String string = (charSequence == null ? "null" : charSequence).subSequence(n, n2).toString();
        this.write(string, 0, string.length());
        return this;
    }

    @Override
    public SerializeWriter append(char c2) {
        this.write(c2);
        return this;
    }

    @Override
    public void write(String string, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                int n4;
                do {
                    n4 = this.buf.length - this.count;
                    string.getChars(n, n + n4, this.buf, this.count);
                    this.count = this.buf.length;
                    this.flush();
                    n += n4;
                } while ((n2 -= n4) > this.buf.length);
                n3 = n2;
            }
        }
        string.getChars(n, n + n2, this.buf, this.count);
        this.count = n3;
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        writer.write(this.buf, 0, this.count);
    }

    public void writeTo(OutputStream outputStream, String string) throws IOException {
        this.writeTo(outputStream, Charset.forName(string));
    }

    public void writeTo(OutputStream outputStream, Charset charset) throws IOException {
        this.writeToEx(outputStream, charset);
    }

    public int writeToEx(OutputStream outputStream, Charset charset) throws IOException {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (charset == IOUtils.UTF8) {
            return this.encodeToUTF8(outputStream);
        }
        byte[] byArray = new String(this.buf, 0, this.count).getBytes(charset);
        outputStream.write(byArray);
        return byArray.length;
    }

    public char[] toCharArray() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] cArray = new char[this.count];
        System.arraycopy(this.buf, 0, cArray, 0, this.count);
        return cArray;
    }

    public char[] toCharArrayForSpringWebSocket() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] cArray = new char[this.count - 2];
        System.arraycopy(this.buf, 1, cArray, 0, this.count - 2);
        return cArray;
    }

    public byte[] toBytes(String string) {
        return this.toBytes(string == null || "UTF-8".equals(string) ? IOUtils.UTF8 : Charset.forName(string));
    }

    public byte[] toBytes(Charset charset) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (charset == IOUtils.UTF8) {
            return this.encodeToUTF8Bytes();
        }
        return new String(this.buf, 0, this.count).getBytes(charset);
    }

    private int encodeToUTF8(OutputStream outputStream) throws IOException {
        int n = (int)((double)this.count * 3.0);
        byte[] byArray = bytesBufLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            bytesBufLocal.set(byArray);
        }
        byte[] byArray2 = byArray;
        if (byArray.length < n) {
            byArray = new byte[n];
        }
        int n2 = IOUtils.encodeUTF8(this.buf, 0, this.count, byArray);
        outputStream.write(byArray, 0, n2);
        if (byArray != byArray2 && byArray.length <= BUFFER_THRESHOLD) {
            bytesBufLocal.set(byArray);
        }
        return n2;
    }

    private byte[] encodeToUTF8Bytes() {
        int n = (int)((double)this.count * 3.0);
        byte[] byArray = bytesBufLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            bytesBufLocal.set(byArray);
        }
        byte[] byArray2 = byArray;
        if (byArray.length < n) {
            byArray = new byte[n];
        }
        int n2 = IOUtils.encodeUTF8(this.buf, 0, this.count, byArray);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        if (byArray != byArray2 && byArray.length <= BUFFER_THRESHOLD) {
            bytesBufLocal.set(byArray);
        }
        return byArray3;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void close() {
        if (this.writer != null && this.count > 0) {
            this.flush();
        }
        if (this.buf.length <= BUFFER_THRESHOLD) {
            bufLocal.set(this.buf);
        }
        this.buf = null;
    }

    @Override
    public void write(String string) {
        if (string == null) {
            this.writeNull();
            return;
        }
        this.write(string, 0, string.length());
    }

    public void writeInt(int n) {
        if (n == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int n2 = n < 0 ? IOUtils.stringSize(-n) + 1 : IOUtils.stringSize(n);
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                char[] cArray = new char[n2];
                IOUtils.getChars(n, n2, cArray);
                this.write(cArray, 0, cArray.length);
                return;
            }
        }
        IOUtils.getChars(n, n3, this.buf);
        this.count = n3;
    }

    public void writeByteArray(byte[] byArray) {
        int n;
        if (this.isEnabled(SerializerFeature.WriteClassName.mask)) {
            this.writeHex(byArray);
            return;
        }
        int n2 = byArray.length;
        int n3 = n = this.useSingleQuotes ? 39 : 34;
        if (n2 == 0) {
            String string = this.useSingleQuotes ? "''" : "\"\"";
            this.write(string);
            return;
        }
        char[] cArray = IOUtils.CA;
        int n4 = n2 / 3 * 3;
        int n5 = (n2 - 1) / 3 + 1 << 2;
        int n6 = this.count;
        int n7 = this.count + n5 + 2;
        if (n7 > this.buf.length) {
            if (this.writer != null) {
                int n8;
                this.write(n);
                int n9 = 0;
                while (n9 < n4) {
                    n8 = (byArray[n9++] & 0xFF) << 16 | (byArray[n9++] & 0xFF) << 8 | byArray[n9++] & 0xFF;
                    this.write(cArray[n8 >>> 18 & 0x3F]);
                    this.write(cArray[n8 >>> 12 & 0x3F]);
                    this.write(cArray[n8 >>> 6 & 0x3F]);
                    this.write(cArray[n8 & 0x3F]);
                }
                n9 = n2 - n4;
                if (n9 > 0) {
                    n8 = (byArray[n4] & 0xFF) << 10 | (n9 == 2 ? (byArray[n2 - 1] & 0xFF) << 2 : 0);
                    this.write(cArray[n8 >> 12]);
                    this.write(cArray[n8 >>> 6 & 0x3F]);
                    this.write(n9 == 2 ? cArray[n8 & 0x3F] : 61);
                    this.write(61);
                }
                this.write(n);
                return;
            }
            this.expandCapacity(n7);
        }
        this.count = n7;
        this.buf[n6++] = n;
        int n10 = 0;
        int n11 = n6;
        while (n10 < n4) {
            int n12 = (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF;
            this.buf[n11++] = cArray[n12 >>> 18 & 0x3F];
            this.buf[n11++] = cArray[n12 >>> 12 & 0x3F];
            this.buf[n11++] = cArray[n12 >>> 6 & 0x3F];
            this.buf[n11++] = cArray[n12 & 0x3F];
        }
        n10 = n2 - n4;
        if (n10 > 0) {
            n11 = (byArray[n4] & 0xFF) << 10 | (n10 == 2 ? (byArray[n2 - 1] & 0xFF) << 2 : 0);
            this.buf[n7 - 5] = cArray[n11 >> 12];
            this.buf[n7 - 4] = cArray[n11 >>> 6 & 0x3F];
            this.buf[n7 - 3] = n10 == 2 ? cArray[n11 & 0x3F] : 61;
            this.buf[n7 - 2] = 61;
        }
        this.buf[n7 - 1] = n;
    }

    public void writeHex(byte[] byArray) {
        int n = this.count + byArray.length * 2 + 3;
        if (n > this.buf.length) {
            this.expandCapacity(n);
        }
        this.buf[this.count++] = 120;
        this.buf[this.count++] = 39;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n2 = by & 0xFF;
            int n3 = n2 >> 4;
            int n4 = n2 & 0xF;
            this.buf[this.count++] = (char)(n3 + (n3 < 10 ? 48 : 55));
            this.buf[this.count++] = (char)(n4 + (n4 < 10 ? 48 : 55));
        }
        this.buf[this.count++] = 39;
    }

    public void writeFloat(float f, boolean bl) {
        if (f != f || f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
            this.writeNull();
        } else {
            int n = this.count + 15;
            if (n > this.buf.length) {
                if (this.writer == null) {
                    this.expandCapacity(n);
                } else {
                    String string = RyuFloat.toString(f);
                    this.write(string, 0, string.length());
                    if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                        this.write(70);
                    }
                    return;
                }
            }
            int n2 = RyuFloat.toString(f, this.buf, this.count);
            this.count += n2;
            if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                this.write(70);
            }
        }
    }

    public void writeDouble(double d2, boolean bl) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            this.writeNull();
            return;
        }
        int n = this.count + 24;
        if (n > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n);
            } else {
                String string = RyuDouble.toString(d2);
                this.write(string, 0, string.length());
                if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                    this.write(68);
                }
                return;
            }
        }
        int n2 = RyuDouble.toString(d2, this.buf, this.count);
        this.count += n2;
        if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
            this.write(68);
        }
    }

    public void writeEnum(Enum<?> enum_) {
        if (enum_ == null) {
            this.writeNull();
            return;
        }
        String string = null;
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            string = enum_.name();
        } else if (this.writeEnumUsingToString) {
            string = enum_.toString();
        }
        if (string != null) {
            int n = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            this.write(n);
            this.write(string);
            this.write(n);
        } else {
            this.writeInt(enum_.ordinal());
        }
    }

    public void writeLongAndChar(long l, char c2) throws IOException {
        this.writeLong(l);
        this.write(c2);
    }

    public void writeLong(long l) {
        boolean bl;
        boolean bl2 = bl = this.isEnabled(SerializerFeature.BrowserCompatible) && !this.isEnabled(SerializerFeature.WriteClassName) && (l > 0x1FFFFFFFFFFFFFL || l < -9007199254740991L);
        if (l == Long.MIN_VALUE) {
            if (bl) {
                this.write("\"-9223372036854775808\"");
            } else {
                this.write("-9223372036854775808");
            }
            return;
        }
        int n = l < 0L ? IOUtils.stringSize(-l) + 1 : IOUtils.stringSize(l);
        int n2 = this.count + n;
        if (bl) {
            n2 += 2;
        }
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                char[] cArray = new char[n];
                IOUtils.getChars(l, n, cArray);
                if (bl) {
                    this.write(34);
                    this.write(cArray, 0, cArray.length);
                    this.write(34);
                } else {
                    this.write(cArray, 0, cArray.length);
                }
                return;
            }
        }
        if (bl) {
            this.buf[this.count] = 34;
            IOUtils.getChars(l, n2 - 1, this.buf);
            this.buf[n2 - 1] = 34;
        } else {
            IOUtils.getChars(l, n2, this.buf);
        }
        this.count = n2;
    }

    public void writeNull() {
        this.write("null");
    }

    public void writeNull(SerializerFeature serializerFeature) {
        this.writeNull(0, serializerFeature.mask);
    }

    public void writeNull(int n, int n2) {
        if ((n & n2) == 0 && (this.features & n2) == 0) {
            this.writeNull();
            return;
        }
        if ((n & SerializerFeature.WriteMapNullValue.mask) != 0 && (n & ~SerializerFeature.WriteMapNullValue.mask & SerializerFeature.WRITE_MAP_NULL_FEATURES) == 0) {
            this.writeNull();
            return;
        }
        if (n2 == SerializerFeature.WriteNullListAsEmpty.mask) {
            this.write("[]");
        } else if (n2 == SerializerFeature.WriteNullStringAsEmpty.mask) {
            this.writeString("");
        } else if (n2 == SerializerFeature.WriteNullBooleanAsFalse.mask) {
            this.write("false");
        } else if (n2 == SerializerFeature.WriteNullNumberAsZero.mask) {
            this.write(48);
        } else {
            this.writeNull();
        }
    }

    public void writeStringWithDoubleQuote(String string, char c2) {
        int n;
        int n2;
        int n3;
        if (string == null) {
            this.writeNull();
            if (c2 != '\u0000') {
                this.write(c2);
            }
            return;
        }
        int n4 = string.length();
        int n5 = this.count + n4 + 2;
        if (c2 != '\u0000') {
            ++n5;
        }
        if (n5 > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i = 0; i < string.length(); ++i) {
                    char c3 = string.charAt(i);
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (c3 == '(' || c3 == ')' || c3 == '<' || c3 == '>')) {
                        this.write(92);
                        this.write(117);
                        this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 & 0xF]);
                        continue;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t' || c3 == '\"' || c3 == '/' || c3 == '\\') {
                            this.write(92);
                            this.write(IOUtils.replaceChars[c3]);
                            continue;
                        }
                        if (c3 < ' ') {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(IOUtils.ASCII_CHARS[c3 * 2]);
                            this.write(IOUtils.ASCII_CHARS[c3 * 2 + 1]);
                            continue;
                        }
                        if (c3 >= '\u007f') {
                            this.write(92);
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                    } else if (c3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c3] != 0 || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        if (IOUtils.specicalFlags_doubleQuotes[c3] == 4) {
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(34);
                if (c2 != '\u0000') {
                    this.write(c2);
                }
                return;
            }
            this.expandCapacity(n5);
        }
        int n6 = this.count + 1;
        int n7 = n6 + n4;
        this.buf[this.count] = 34;
        string.getChars(0, n4, this.buf, n6);
        this.count = n5;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char c4;
            int n8;
            int n9 = -1;
            for (n8 = n6; n8 < n7; ++n8) {
                c4 = this.buf[n8];
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    n9 = n8;
                    ++n5;
                    continue;
                }
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    n9 = n8;
                    ++n5;
                    continue;
                }
                if (c4 < ' ') {
                    n9 = n8;
                    n5 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                n9 = n8;
                n5 += 5;
            }
            if (n5 > this.buf.length) {
                this.expandCapacity(n5);
            }
            this.count = n5;
            for (n8 = n9; n8 >= n6; --n8) {
                c4 = this.buf[n8];
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n7 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = IOUtils.replaceChars[c4];
                    ++n7;
                    continue;
                }
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n7 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = c4;
                    ++n7;
                    continue;
                }
                if (c4 < ' ') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 6, n7 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = 117;
                    this.buf[n8 + 2] = 48;
                    this.buf[n8 + 3] = 48;
                    this.buf[n8 + 4] = IOUtils.ASCII_CHARS[c4 * 2];
                    this.buf[n8 + 5] = IOUtils.ASCII_CHARS[c4 * 2 + 1];
                    n7 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 6, n7 - n8 - 1);
                this.buf[n8] = 92;
                this.buf[n8 + 1] = 117;
                this.buf[n8 + 2] = IOUtils.DIGITS[c4 >>> 12 & 0xF];
                this.buf[n8 + 3] = IOUtils.DIGITS[c4 >>> 8 & 0xF];
                this.buf[n8 + 4] = IOUtils.DIGITS[c4 >>> 4 & 0xF];
                this.buf[n8 + 5] = IOUtils.DIGITS[c4 & 0xF];
                n7 += 5;
            }
            if (c2 != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = c2;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        for (n3 = n6; n3 < n7; ++n3) {
            n2 = this.buf[n3];
            if (n2 >= 93) {
                if (n2 < 127 || n2 != 8232 && n2 != 8233 && n2 >= 160) continue;
                if (n12 == -1) {
                    n12 = n3;
                }
                ++n10;
                n11 = n3;
                n13 = n2;
                n5 += 4;
                continue;
            }
            int n14 = n = n2 < 64 && (this.sepcialBits & 1L << n2) != 0L || n2 == 92 ? 1 : 0;
            if (n == 0) continue;
            ++n10;
            n11 = n3;
            n13 = n2;
            if (n2 == 40 || n2 == 41 || n2 == 60 || n2 == 62 || n2 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n2] == 4) {
                n5 += 4;
            }
            if (n12 != -1) continue;
            n12 = n3;
        }
        if (n10 > 0) {
            if ((n5 += n10) > this.buf.length) {
                this.expandCapacity(n5);
            }
            this.count = n5;
            if (n10 == 1) {
                if (n13 == 8232) {
                    n3 = n11 + 1;
                    n2 = n11 + 6;
                    n = n7 - n11 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 48;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 56;
                } else if (n13 == 8233) {
                    n3 = n11 + 1;
                    n2 = n11 + 6;
                    n = n7 - n11 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 48;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 57;
                } else if (n13 == 40 || n13 == 41 || n13 == 60 || n13 == 62) {
                    n3 = n11 + 1;
                    n2 = n11 + 6;
                    n = n7 - n11 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    int n15 = n13;
                    this.buf[++n11] = IOUtils.DIGITS[n15 >>> 12 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n15 >>> 8 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n15 >>> 4 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n15 & 0xF];
                } else {
                    n3 = n13;
                    if (n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                        n2 = n11 + 1;
                        n = n11 + 6;
                        int n16 = n7 - n11 - 1;
                        System.arraycopy(this.buf, n2, this.buf, n, n16);
                        int n17 = n11;
                        this.buf[n17++] = 92;
                        this.buf[n17++] = 117;
                        this.buf[n17++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                        this.buf[n17++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                        this.buf[n17++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                        this.buf[n17++] = IOUtils.DIGITS[n3 & 0xF];
                    } else {
                        n2 = n11 + 1;
                        n = n11 + 2;
                        int n18 = n7 - n11 - 1;
                        System.arraycopy(this.buf, n2, this.buf, n, n18);
                        this.buf[n11] = 92;
                        this.buf[++n11] = IOUtils.replaceChars[n3];
                    }
                }
            } else if (n10 > 1) {
                n3 = n12 - n6;
                n2 = n12;
                for (n = n3; n < string.length(); ++n) {
                    char c5 = string.charAt(n);
                    if (this.browserSecure && (c5 == '(' || c5 == ')' || c5 == '<' || c5 == '>')) {
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 & 0xF];
                        n7 += 5;
                        continue;
                    }
                    if (c5 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c5] != 0 || c5 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n2++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[c5] == 4) {
                            this.buf[n2++] = 117;
                            this.buf[n2++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c5 & 0xF];
                            n7 += 5;
                            continue;
                        }
                        this.buf[n2++] = IOUtils.replaceChars[c5];
                        ++n7;
                        continue;
                    }
                    if (c5 == '\u2028' || c5 == '\u2029') {
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 & 0xF];
                        n7 += 5;
                        continue;
                    }
                    this.buf[n2++] = c5;
                }
            }
        }
        if (c2 != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = c2;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    public void writeStringWithDoubleQuote(char[] cArray, char c2) {
        int n;
        int n2;
        int n3;
        if (cArray == null) {
            this.writeNull();
            if (c2 != '\u0000') {
                this.write(c2);
            }
            return;
        }
        int n4 = cArray.length;
        int n5 = this.count + n4 + 2;
        if (c2 != '\u0000') {
            ++n5;
        }
        if (n5 > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i = 0; i < cArray.length; ++i) {
                    char c3 = cArray[i];
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (c3 == '(' || c3 == ')' || c3 == '<' || c3 == '>')) {
                        this.write(92);
                        this.write(117);
                        this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 & 0xF]);
                        continue;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t' || c3 == '\"' || c3 == '/' || c3 == '\\') {
                            this.write(92);
                            this.write(IOUtils.replaceChars[c3]);
                            continue;
                        }
                        if (c3 < ' ') {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(IOUtils.ASCII_CHARS[c3 * 2]);
                            this.write(IOUtils.ASCII_CHARS[c3 * 2 + 1]);
                            continue;
                        }
                        if (c3 >= '\u007f') {
                            this.write(92);
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                    } else if (c3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c3] != 0 || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        if (IOUtils.specicalFlags_doubleQuotes[c3] == 4) {
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(34);
                if (c2 != '\u0000') {
                    this.write(c2);
                }
                return;
            }
            this.expandCapacity(n5);
        }
        int n6 = this.count + 1;
        int n7 = n6 + n4;
        this.buf[this.count] = 34;
        System.arraycopy(cArray, 0, this.buf, n6, cArray.length);
        this.count = n5;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char c4;
            int n8;
            int n9 = -1;
            for (n8 = n6; n8 < n7; ++n8) {
                c4 = this.buf[n8];
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    n9 = n8;
                    ++n5;
                    continue;
                }
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    n9 = n8;
                    ++n5;
                    continue;
                }
                if (c4 < ' ') {
                    n9 = n8;
                    n5 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                n9 = n8;
                n5 += 5;
            }
            if (n5 > this.buf.length) {
                this.expandCapacity(n5);
            }
            this.count = n5;
            for (n8 = n9; n8 >= n6; --n8) {
                c4 = this.buf[n8];
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n7 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = IOUtils.replaceChars[c4];
                    ++n7;
                    continue;
                }
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n7 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = c4;
                    ++n7;
                    continue;
                }
                if (c4 < ' ') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 6, n7 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = 117;
                    this.buf[n8 + 2] = 48;
                    this.buf[n8 + 3] = 48;
                    this.buf[n8 + 4] = IOUtils.ASCII_CHARS[c4 * 2];
                    this.buf[n8 + 5] = IOUtils.ASCII_CHARS[c4 * 2 + 1];
                    n7 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 6, n7 - n8 - 1);
                this.buf[n8] = 92;
                this.buf[n8 + 1] = 117;
                this.buf[n8 + 2] = IOUtils.DIGITS[c4 >>> 12 & 0xF];
                this.buf[n8 + 3] = IOUtils.DIGITS[c4 >>> 8 & 0xF];
                this.buf[n8 + 4] = IOUtils.DIGITS[c4 >>> 4 & 0xF];
                this.buf[n8 + 5] = IOUtils.DIGITS[c4 & 0xF];
                n7 += 5;
            }
            if (c2 != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = c2;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        for (n3 = n6; n3 < n7; ++n3) {
            n2 = this.buf[n3];
            if (n2 >= 93) {
                if (n2 < 127 || n2 != 8232 && n2 != 8233 && n2 >= 160) continue;
                if (n12 == -1) {
                    n12 = n3;
                }
                ++n10;
                n11 = n3;
                n13 = n2;
                n5 += 4;
                continue;
            }
            int n14 = n = n2 < 64 && (this.sepcialBits & 1L << n2) != 0L || n2 == 92 ? 1 : 0;
            if (n == 0) continue;
            ++n10;
            n11 = n3;
            n13 = n2;
            if (n2 == 40 || n2 == 41 || n2 == 60 || n2 == 62 || n2 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n2] == 4) {
                n5 += 4;
            }
            if (n12 != -1) continue;
            n12 = n3;
        }
        if (n10 > 0) {
            if ((n5 += n10) > this.buf.length) {
                this.expandCapacity(n5);
            }
            this.count = n5;
            if (n10 == 1) {
                if (n13 == 8232) {
                    n3 = n11 + 1;
                    n2 = n11 + 6;
                    n = n7 - n11 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 48;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 56;
                } else if (n13 == 8233) {
                    n3 = n11 + 1;
                    n2 = n11 + 6;
                    n = n7 - n11 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 48;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 57;
                } else if (n13 == 40 || n13 == 41 || n13 == 60 || n13 == 62) {
                    n3 = n11 + 1;
                    n2 = n11 + 6;
                    n = n7 - n11 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    int n15 = n13;
                    this.buf[++n11] = IOUtils.DIGITS[n15 >>> 12 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n15 >>> 8 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n15 >>> 4 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n15 & 0xF];
                } else {
                    n3 = n13;
                    if (n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                        n2 = n11 + 1;
                        n = n11 + 6;
                        int n16 = n7 - n11 - 1;
                        System.arraycopy(this.buf, n2, this.buf, n, n16);
                        int n17 = n11;
                        this.buf[n17++] = 92;
                        this.buf[n17++] = 117;
                        this.buf[n17++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                        this.buf[n17++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                        this.buf[n17++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                        this.buf[n17++] = IOUtils.DIGITS[n3 & 0xF];
                    } else {
                        n2 = n11 + 1;
                        n = n11 + 2;
                        int n18 = n7 - n11 - 1;
                        System.arraycopy(this.buf, n2, this.buf, n, n18);
                        this.buf[n11] = 92;
                        this.buf[++n11] = IOUtils.replaceChars[n3];
                    }
                }
            } else if (n10 > 1) {
                n3 = n12 - n6;
                n2 = n12;
                for (n = n3; n < cArray.length; ++n) {
                    char c5 = cArray[n];
                    if (this.browserSecure && (c5 == '(' || c5 == ')' || c5 == '<' || c5 == '>')) {
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 & 0xF];
                        n7 += 5;
                        continue;
                    }
                    if (c5 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c5] != 0 || c5 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n2++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[c5] == 4) {
                            this.buf[n2++] = 117;
                            this.buf[n2++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c5 & 0xF];
                            n7 += 5;
                            continue;
                        }
                        this.buf[n2++] = IOUtils.replaceChars[c5];
                        ++n7;
                        continue;
                    }
                    if (c5 == '\u2028' || c5 == '\u2029') {
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 >>> 4 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c5 & 0xF];
                        n7 += 5;
                        continue;
                    }
                    this.buf[n2++] = c5;
                }
            }
        }
        if (c2 != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = c2;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    public void writeFieldNameDirect(String string) {
        int n = string.length();
        int n2 = this.count + n + 3;
        if (n2 > this.buf.length) {
            this.expandCapacity(n2);
        }
        int n3 = this.count + 1;
        this.buf[this.count] = 34;
        string.getChars(0, n, this.buf, n3);
        this.count = n2;
        this.buf[this.count - 2] = 34;
        this.buf[this.count - 1] = 58;
    }

    public void write(List<String> list) {
        int n;
        if (list.isEmpty()) {
            this.write("[]");
            return;
        }
        int n2 = n = this.count;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            int n4;
            String string = list.get(i);
            boolean bl = false;
            if (string == null) {
                bl = true;
            } else {
                char c2;
                int n5 = string.length();
                for (n4 = 0; n4 < n5 && !(bl = (c2 = string.charAt(n4)) < ' ' || c2 > '~' || c2 == '\"' || c2 == '\\'); ++n4) {
                }
            }
            if (bl) {
                this.count = n2;
                this.write(91);
                for (n4 = 0; n4 < list.size(); ++n4) {
                    string = list.get(n4);
                    if (n4 != 0) {
                        this.write(44);
                    }
                    if (string == null) {
                        this.write("null");
                        continue;
                    }
                    this.writeStringWithDoubleQuote(string, '\u0000');
                }
                this.write(93);
                return;
            }
            n4 = n + string.length() + 3;
            if (i == list.size() - 1) {
                ++n4;
            }
            if (n4 > this.buf.length) {
                this.count = n;
                this.expandCapacity(n4);
            }
            this.buf[n++] = i == 0 ? 91 : 44;
            this.buf[n++] = 34;
            string.getChars(0, string.length(), this.buf, n);
            n += string.length();
            this.buf[n++] = 34;
        }
        this.buf[n++] = 93;
        this.count = n;
    }

    public void writeFieldValue(char c2, String string, char c3) {
        this.write(c2);
        this.writeFieldName(string);
        if (c3 == '\u0000') {
            this.writeString("\u0000");
        } else {
            this.writeString(Character.toString(c3));
        }
    }

    public void writeFieldValue(char c2, String string, boolean bl) {
        if (!this.quoteFieldNames) {
            this.write(c2);
            this.writeFieldName(string);
            this.write(bl);
            return;
        }
        int n = bl ? 4 : 5;
        int n2 = string.length();
        int n3 = this.count + n2 + 4 + n;
        if (n3 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeString(string);
                this.write(58);
                this.write(bl);
                return;
            }
            this.expandCapacity(n3);
        }
        int n4 = this.count;
        this.count = n3;
        this.buf[n4] = c2;
        int n5 = n4 + n2 + 1;
        this.buf[n4 + 1] = this.keySeperator;
        string.getChars(0, n2, this.buf, n4 + 2);
        this.buf[n5 + 1] = this.keySeperator;
        if (bl) {
            System.arraycopy(VALUE_TRUE, 0, this.buf, n5 + 2, 5);
        } else {
            System.arraycopy(VALUE_FALSE, 0, this.buf, n5 + 2, 6);
        }
    }

    public void write(boolean bl) {
        if (bl) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void writeFieldValue(char c2, String string, int n) {
        if (n == Integer.MIN_VALUE || !this.quoteFieldNames) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeInt(n);
            return;
        }
        int n2 = n < 0 ? IOUtils.stringSize(-n) + 1 : IOUtils.stringSize(n);
        int n3 = string.length();
        int n4 = this.count + n3 + 4 + n2;
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeFieldName(string);
                this.writeInt(n);
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count;
        this.count = n4;
        this.buf[n5] = c2;
        int n6 = n5 + n3 + 1;
        this.buf[n5 + 1] = this.keySeperator;
        string.getChars(0, n3, this.buf, n5 + 2);
        this.buf[n6 + 1] = this.keySeperator;
        this.buf[n6 + 2] = 58;
        IOUtils.getChars(n, this.count, this.buf);
    }

    public void writeFieldValue(char c2, String string, long l) {
        if (l == Long.MIN_VALUE || !this.quoteFieldNames || this.isEnabled(SerializerFeature.BrowserCompatible.mask)) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeLong(l);
            return;
        }
        int n = l < 0L ? IOUtils.stringSize(-l) + 1 : IOUtils.stringSize(l);
        int n2 = string.length();
        int n3 = this.count + n2 + 4 + n;
        if (n3 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeFieldName(string);
                this.writeLong(l);
                return;
            }
            this.expandCapacity(n3);
        }
        int n4 = this.count;
        this.count = n3;
        this.buf[n4] = c2;
        int n5 = n4 + n2 + 1;
        this.buf[n4 + 1] = this.keySeperator;
        string.getChars(0, n2, this.buf, n4 + 2);
        this.buf[n5 + 1] = this.keySeperator;
        this.buf[n5 + 2] = 58;
        IOUtils.getChars(l, this.count, this.buf);
    }

    public void writeFieldValue(char c2, String string, float f) {
        this.write(c2);
        this.writeFieldName(string);
        this.writeFloat(f, false);
    }

    public void writeFieldValue(char c2, String string, double d2) {
        this.write(c2);
        this.writeFieldName(string);
        this.writeDouble(d2, false);
    }

    public void writeFieldValue(char c2, String string, String string2) {
        if (this.quoteFieldNames) {
            if (this.useSingleQuotes) {
                this.write(c2);
                this.writeFieldName(string);
                if (string2 == null) {
                    this.writeNull();
                } else {
                    this.writeString(string2);
                }
            } else if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                this.write(c2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
            } else {
                this.writeFieldValueStringWithDoubleQuoteCheck(c2, string, string2);
            }
        } else {
            this.write(c2);
            this.writeFieldName(string);
            if (string2 == null) {
                this.writeNull();
            } else {
                this.writeString(string2);
            }
        }
    }

    public void writeFieldValueStringWithDoubleQuoteCheck(char c2, String string, String string2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        int n6 = this.count;
        if (string2 == null) {
            n4 = 4;
            n6 += n5 + 8;
        } else {
            n4 = string2.length();
            n6 += n5 + n4 + 6;
        }
        if (n6 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.expandCapacity(n6);
        }
        this.buf[this.count] = c2;
        int n7 = this.count + 2;
        int n8 = n7 + n5;
        this.buf[this.count + 1] = 34;
        string.getChars(0, n5, this.buf, n7);
        this.count = n6;
        this.buf[n8] = 34;
        int n9 = n8 + 1;
        this.buf[n9++] = 58;
        if (string2 == null) {
            this.buf[n9++] = 110;
            this.buf[n9++] = 117;
            this.buf[n9++] = 108;
            this.buf[n9++] = 108;
            return;
        }
        this.buf[n9++] = 34;
        int n10 = n9;
        int n11 = n10 + n4;
        string2.getChars(0, n4, this.buf, n10);
        int n12 = 0;
        int n13 = -1;
        int n14 = -1;
        int n15 = 0;
        for (n3 = n10; n3 < n11; ++n3) {
            n2 = this.buf[n3];
            if (n2 >= 93) {
                if (n2 < 127 || n2 != 8232 && n2 != 8233 && n2 >= 160) continue;
                if (n14 == -1) {
                    n14 = n3;
                }
                ++n12;
                n13 = n3;
                n15 = n2;
                n6 += 4;
                continue;
            }
            int n16 = n = n2 < 64 && (this.sepcialBits & 1L << n2) != 0L || n2 == 92 ? 1 : 0;
            if (n == 0) continue;
            ++n12;
            n13 = n3;
            n15 = n2;
            if (n2 == 40 || n2 == 41 || n2 == 60 || n2 == 62 || n2 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n2] == 4) {
                n6 += 4;
            }
            if (n14 != -1) continue;
            n14 = n3;
        }
        if (n12 > 0) {
            if ((n6 += n12) > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            if (n12 == 1) {
                if (n15 == 8232) {
                    n3 = n13 + 1;
                    n2 = n13 + 6;
                    n = n11 - n13 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n);
                    this.buf[n13] = 92;
                    this.buf[++n13] = 117;
                    this.buf[++n13] = 50;
                    this.buf[++n13] = 48;
                    this.buf[++n13] = 50;
                    this.buf[++n13] = 56;
                } else if (n15 == 8233) {
                    n3 = n13 + 1;
                    n2 = n13 + 6;
                    n = n11 - n13 - 1;
                    System.arraycopy(this.buf, n3, this.buf, n2, n);
                    this.buf[n13] = 92;
                    this.buf[++n13] = 117;
                    this.buf[++n13] = 50;
                    this.buf[++n13] = 48;
                    this.buf[++n13] = 50;
                    this.buf[++n13] = 57;
                } else if (n15 == 40 || n15 == 41 || n15 == 60 || n15 == 62) {
                    n3 = n15;
                    n2 = n13 + 1;
                    n = n13 + 6;
                    int n17 = n11 - n13 - 1;
                    System.arraycopy(this.buf, n2, this.buf, n, n17);
                    int n18 = n13;
                    this.buf[n18++] = 92;
                    this.buf[n18++] = 117;
                    this.buf[n18++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                    this.buf[n18++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                    this.buf[n18++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                    this.buf[n18++] = IOUtils.DIGITS[n3 & 0xF];
                } else {
                    n3 = n15;
                    if (n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                        n2 = n13 + 1;
                        n = n13 + 6;
                        int n19 = n11 - n13 - 1;
                        System.arraycopy(this.buf, n2, this.buf, n, n19);
                        int n20 = n13;
                        this.buf[n20++] = 92;
                        this.buf[n20++] = 117;
                        this.buf[n20++] = IOUtils.DIGITS[n3 >>> 12 & 0xF];
                        this.buf[n20++] = IOUtils.DIGITS[n3 >>> 8 & 0xF];
                        this.buf[n20++] = IOUtils.DIGITS[n3 >>> 4 & 0xF];
                        this.buf[n20++] = IOUtils.DIGITS[n3 & 0xF];
                    } else {
                        n2 = n13 + 1;
                        n = n13 + 2;
                        int n21 = n11 - n13 - 1;
                        System.arraycopy(this.buf, n2, this.buf, n, n21);
                        this.buf[n13] = 92;
                        this.buf[++n13] = IOUtils.replaceChars[n3];
                    }
                }
            } else if (n12 > 1) {
                n3 = n14 - n10;
                n2 = n14;
                for (n = n3; n < string2.length(); ++n) {
                    char c3 = string2.charAt(n);
                    if (this.browserSecure && (c3 == '(' || c3 == ')' || c3 == '<' || c3 == '>')) {
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[c3 >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c3 >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c3 >>> 4 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c3 & 0xF];
                        n11 += 5;
                        continue;
                    }
                    if (c3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c3] != 0 || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n2++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[c3] == 4) {
                            this.buf[n2++] = 117;
                            this.buf[n2++] = IOUtils.DIGITS[c3 >>> 12 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c3 >>> 8 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c3 >>> 4 & 0xF];
                            this.buf[n2++] = IOUtils.DIGITS[c3 & 0xF];
                            n11 += 5;
                            continue;
                        }
                        this.buf[n2++] = IOUtils.replaceChars[c3];
                        ++n11;
                        continue;
                    }
                    if (c3 == '\u2028' || c3 == '\u2029') {
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[c3 >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c3 >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c3 >>> 4 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[c3 & 0xF];
                        n11 += 5;
                        continue;
                    }
                    this.buf[n2++] = c3;
                }
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public void writeFieldValueStringWithDoubleQuote(char c2, String string, String string2) {
        int n = string.length();
        int n2 = this.count;
        int n3 = string2.length();
        if ((n2 += n + n3 + 6) > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.expandCapacity(n2);
        }
        this.buf[this.count] = c2;
        int n4 = this.count + 2;
        int n5 = n4 + n;
        this.buf[this.count + 1] = 34;
        string.getChars(0, n, this.buf, n4);
        this.count = n2;
        this.buf[n5] = 34;
        int n6 = n5 + 1;
        this.buf[n6++] = 58;
        this.buf[n6++] = 34;
        int n7 = n6;
        string2.getChars(0, n3, this.buf, n7);
        this.buf[this.count - 1] = 34;
    }

    public void writeFieldValue(char c2, String string, Enum<?> enum_) {
        if (enum_ == null) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeNull();
            return;
        }
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            this.writeEnumFieldValue(c2, string, enum_.name());
        } else if (this.writeEnumUsingToString) {
            this.writeEnumFieldValue(c2, string, enum_.toString());
        } else {
            this.writeFieldValue(c2, string, enum_.ordinal());
        }
    }

    private void writeEnumFieldValue(char c2, String string, String string2) {
        if (this.useSingleQuotes) {
            this.writeFieldValue(c2, string, string2);
        } else {
            this.writeFieldValueStringWithDoubleQuote(c2, string, string2);
        }
    }

    public void writeFieldValue(char c2, String string, BigDecimal bigDecimal) {
        this.write(c2);
        this.writeFieldName(string);
        if (bigDecimal == null) {
            this.writeNull();
        } else {
            int n = bigDecimal.scale();
            this.write(this.isEnabled(SerializerFeature.WriteBigDecimalAsPlain) && n >= -100 && n < 100 ? bigDecimal.toPlainString() : bigDecimal.toString());
        }
    }

    public void writeString(String string, char c2) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
            this.write(c2);
        } else {
            this.writeStringWithDoubleQuote(string, c2);
        }
    }

    public void writeString(String string) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
        } else {
            this.writeStringWithDoubleQuote(string, '\u0000');
        }
    }

    public void writeString(char[] cArray) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(cArray);
        } else {
            String string = new String(cArray);
            this.writeStringWithDoubleQuote(string, '\u0000');
        }
    }

    protected void writeStringWithSingleQuote(String string) {
        char c2;
        int n;
        if (string == null) {
            int n2 = this.count + 4;
            if (n2 > this.buf.length) {
                this.expandCapacity(n2);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = n2;
            return;
        }
        int n3 = string.length();
        int n4 = this.count + n3 + 2;
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i = 0; i < string.length(); ++i) {
                    char c3 = string.charAt(i);
                    if (c3 <= '\r' || c3 == '\\' || c3 == '\'' || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count + 1;
        int n6 = n5 + n3;
        this.buf[this.count] = 39;
        string.getChars(0, n3, this.buf, n5);
        this.count = n4;
        int n7 = 0;
        int n8 = -1;
        char c4 = '\u0000';
        for (n = n5; n < n6; ++n) {
            c2 = this.buf[n];
            if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n7;
            n8 = n;
            c4 = c2;
        }
        if ((n4 += n7) > this.buf.length) {
            this.expandCapacity(n4);
        }
        this.count = n4;
        if (n7 == 1) {
            System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n6 - n8 - 1);
            this.buf[n8] = 92;
            this.buf[++n8] = IOUtils.replaceChars[c4];
        } else if (n7 > 1) {
            System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n6 - n8 - 1);
            this.buf[n8] = 92;
            this.buf[++n8] = IOUtils.replaceChars[c4];
            ++n6;
            for (n = n8 - 2; n >= n5; --n) {
                c2 = this.buf[n];
                if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, n + 1, this.buf, n + 2, n6 - n - 1);
                this.buf[n] = 92;
                this.buf[n + 1] = IOUtils.replaceChars[c2];
                ++n6;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    protected void writeStringWithSingleQuote(char[] cArray) {
        char c2;
        int n;
        if (cArray == null) {
            int n2 = this.count + 4;
            if (n2 > this.buf.length) {
                this.expandCapacity(n2);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = n2;
            return;
        }
        int n3 = cArray.length;
        int n4 = this.count + n3 + 2;
        if (n4 > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i = 0; i < cArray.length; ++i) {
                    char c3 = cArray[i];
                    if (c3 <= '\r' || c3 == '\\' || c3 == '\'' || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(n4);
        }
        int n5 = this.count + 1;
        int n6 = n5 + n3;
        this.buf[this.count] = 39;
        System.arraycopy(cArray, 0, this.buf, n5, cArray.length);
        this.count = n4;
        int n7 = 0;
        int n8 = -1;
        char c4 = '\u0000';
        for (n = n5; n < n6; ++n) {
            c2 = this.buf[n];
            if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n7;
            n8 = n;
            c4 = c2;
        }
        if ((n4 += n7) > this.buf.length) {
            this.expandCapacity(n4);
        }
        this.count = n4;
        if (n7 == 1) {
            System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n6 - n8 - 1);
            this.buf[n8] = 92;
            this.buf[++n8] = IOUtils.replaceChars[c4];
        } else if (n7 > 1) {
            System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n6 - n8 - 1);
            this.buf[n8] = 92;
            this.buf[++n8] = IOUtils.replaceChars[c4];
            ++n6;
            for (n = n8 - 2; n >= n5; --n) {
                c2 = this.buf[n];
                if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, n + 1, this.buf, n + 2, n6 - n - 1);
                this.buf[n] = 92;
                this.buf[n + 1] = IOUtils.replaceChars[c2];
                ++n6;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public void writeFieldName(String string) {
        this.writeFieldName(string, false);
    }

    public void writeFieldName(String string, boolean bl) {
        if (string == null) {
            this.write("null:");
            return;
        }
        if (this.useSingleQuotes) {
            if (this.quoteFieldNames) {
                this.writeStringWithSingleQuote(string);
                this.write(58);
            } else {
                this.writeKeyWithSingleQuoteIfHasSpecial(string);
            }
        } else if (this.quoteFieldNames) {
            this.writeStringWithDoubleQuote(string, ':');
        } else {
            boolean bl2 = string.length() == 0;
            for (int i = 0; i < string.length(); ++i) {
                boolean bl3;
                char c2 = string.charAt(i);
                boolean bl4 = bl3 = c2 < '@' && (this.sepcialBits & 1L << c2) != 0L || c2 == '\\';
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                this.writeStringWithDoubleQuote(string, ':');
            } else {
                this.write(string);
                this.write(58);
            }
        }
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String string) {
        byte[] byArray = IOUtils.specicalFlags_singleQuotes;
        int n = string.length();
        int n2 = this.count + n + 1;
        if (n2 > this.buf.length) {
            if (this.writer != null) {
                char c2;
                int n3;
                if (n == 0) {
                    this.write(39);
                    this.write(39);
                    this.write(58);
                    return;
                }
                boolean bl = false;
                for (n3 = 0; n3 < n; ++n3) {
                    c2 = string.charAt(n3);
                    if (c2 >= byArray.length || byArray[c2] == 0) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.write(39);
                }
                for (n3 = 0; n3 < n; ++n3) {
                    c2 = string.charAt(n3);
                    if (c2 < byArray.length && byArray[c2] != 0) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c2]);
                        continue;
                    }
                    this.write(c2);
                }
                if (bl) {
                    this.write(39);
                }
                this.write(58);
                return;
            }
            this.expandCapacity(n2);
        }
        if (n == 0) {
            int n4 = this.count + 3;
            if (n4 > this.buf.length) {
                this.expandCapacity(this.count + 3);
            }
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 58;
            return;
        }
        int n5 = this.count;
        int n6 = n5 + n;
        string.getChars(0, n, this.buf, n5);
        this.count = n2;
        boolean bl = false;
        for (int i = n5; i < n6; ++i) {
            char c3 = this.buf[i];
            if (c3 >= byArray.length || byArray[c3] == 0) continue;
            if (!bl) {
                if ((n2 += 3) > this.buf.length) {
                    this.expandCapacity(n2);
                }
                this.count = n2;
                System.arraycopy(this.buf, i + 1, this.buf, i + 3, n6 - i - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i);
                this.buf[n5] = 39;
                this.buf[++i] = 92;
                this.buf[++i] = IOUtils.replaceChars[c3];
                n6 += 2;
                this.buf[this.count - 2] = 39;
                bl = true;
                continue;
            }
            if (++n2 > this.buf.length) {
                this.expandCapacity(n2);
            }
            this.count = n2;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, n6 - i);
            this.buf[i] = 92;
            this.buf[++i] = IOUtils.replaceChars[c3];
            ++n6;
        }
        this.buf[n2 - 1] = 58;
    }

    @Override
    public void flush() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(this.buf, 0, this.count);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        this.count = 0;
    }

    public void reset() {
        this.count = 0;
    }

    static {
        try {
            int n;
            String string = IOUtils.getStringProperty("fastjson.serializer_buffer_threshold");
            if (string != null && string.length() > 0 && (n = Integer.parseInt(string)) >= 64 && n <= 65536) {
                BUFFER_THRESHOLD = n * 1024;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        nonDirectFeatures = 0 | SerializerFeature.UseSingleQuotes.mask | SerializerFeature.BrowserCompatible.mask | SerializerFeature.PrettyFormat.mask | SerializerFeature.WriteEnumUsingToString.mask | SerializerFeature.WriteNonStringValueAsString.mask | SerializerFeature.WriteSlashAsSpecial.mask | SerializerFeature.IgnoreErrorGetter.mask | SerializerFeature.WriteClassName.mask | SerializerFeature.NotWriteDefaultValue.mask;
    }
}

