/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.PropertyPreFilter;
import com.icbc.api.internal.util.fastjson.serializer.SerialContext;
import java.util.HashSet;
import java.util.Set;

public class SimplePropertyPreFilter
implements PropertyPreFilter {
    private final Class<?> clazz;
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();
    private int maxLevel = 0;

    public SimplePropertyPreFilter(String ... stringArray) {
        this((Class<?>)null, stringArray);
    }

    public SimplePropertyPreFilter(Class<?> clazz, String ... stringArray) {
        this.clazz = clazz;
        for (String string : stringArray) {
            if (string == null) continue;
            this.includes.add(string);
        }
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean apply(JSONSerializer jSONSerializer, Object object, String string) {
        if (object == null) {
            return true;
        }
        if (this.clazz != null && !this.clazz.isInstance(object)) {
            return true;
        }
        if (this.excludes.contains(string)) {
            return false;
        }
        if (this.maxLevel > 0) {
            int n = 0;
            SerialContext serialContext = jSONSerializer.context;
            while (serialContext != null) {
                if (++n > this.maxLevel) {
                    return false;
                }
                serialContext = serialContext.parent;
            }
        }
        return this.includes.size() == 0 || this.includes.contains(string);
    }
}

