/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class StringCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static StringCodec instance = new StringCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) throws IOException {
        this.write(jSONSerializer, (String)object);
    }

    public void write(JSONSerializer jSONSerializer, String string) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (string == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullStringAsEmpty);
            return;
        }
        serializeWriter.writeString(string);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        if (type == StringBuffer.class) {
            JSONLexer jSONLexer = defaultJSONParser.lexer;
            if (jSONLexer.token() == 4) {
                String string = jSONLexer.stringVal();
                jSONLexer.nextToken(16);
                return (T)new StringBuffer(string);
            }
            Object object2 = defaultJSONParser.parse();
            if (object2 == null) {
                return null;
            }
            return (T)new StringBuffer(object2.toString());
        }
        if (type == StringBuilder.class) {
            JSONLexer jSONLexer = defaultJSONParser.lexer;
            if (jSONLexer.token() == 4) {
                String string = jSONLexer.stringVal();
                jSONLexer.nextToken(16);
                return (T)new StringBuilder(string);
            }
            Object object3 = defaultJSONParser.parse();
            if (object3 == null) {
                return null;
            }
            return (T)new StringBuilder(object3.toString());
        }
        return StringCodec.deserialze(defaultJSONParser);
    }

    public static <T> T deserialze(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.getLexer();
        if (jSONLexer.token() == 4) {
            String string = jSONLexer.stringVal();
            jSONLexer.nextToken(16);
            return (T)string;
        }
        if (jSONLexer.token() == 2) {
            String string = jSONLexer.numberString();
            jSONLexer.nextToken(16);
            return (T)string;
        }
        Object object = defaultJSONParser.parse();
        if (object == null) {
            return null;
        }
        return (T)object.toString();
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

