/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.asm.ClassReader;
import com.icbc.api.internal.util.fastjson.asm.TypeCollector;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class ASMUtils {
    public static final String JAVA_VM_NAME = System.getProperty("java.vm.name");
    public static final boolean IS_ANDROID = ASMUtils.isAndroid(JAVA_VM_NAME);

    public static boolean isAndroid(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        return string2.contains("dalvik") || string2.contains("lemur");
    }

    public static String desc(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuilder stringBuilder = new StringBuilder(classArray.length + 1 << 4);
        stringBuilder.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(ASMUtils.desc(classArray[i]));
        }
        stringBuilder.append(')');
        stringBuilder.append(ASMUtils.desc(method.getReturnType()));
        return stringBuilder.toString();
    }

    public static String desc(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ASMUtils.getPrimitiveLetter(clazz);
        }
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        return "L" + ASMUtils.type(clazz) + ";";
    }

    public static String type(Class<?> clazz) {
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        if (!clazz.isPrimitive()) {
            String string = clazz.getName();
            return string.replace('.', '/');
        }
        return ASMUtils.getPrimitiveLetter(clazz);
    }

    public static String getPrimitiveLetter(Class<?> clazz) {
        if (Integer.TYPE == clazz) {
            return "I";
        }
        if (Void.TYPE == clazz) {
            return "V";
        }
        if (Boolean.TYPE == clazz) {
            return "Z";
        }
        if (Character.TYPE == clazz) {
            return "C";
        }
        if (Byte.TYPE == clazz) {
            return "B";
        }
        if (Short.TYPE == clazz) {
            return "S";
        }
        if (Float.TYPE == clazz) {
            return "F";
        }
        if (Long.TYPE == clazz) {
            return "J";
        }
        if (Double.TYPE == clazz) {
            return "D";
        }
        throw new IllegalStateException("Type: " + clazz.getCanonicalName() + " is not a primitive type");
    }

    public static Type getMethodType(Class<?> clazz, String string) {
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            return method.getGenericReturnType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean checkName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 >= '\u0001' && c2 <= '\u007f' && c2 != '.') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] lookupParameterNames(AccessibleObject accessibleObject) {
        String string;
        String string2;
        InputStream inputStream;
        Annotation[][] annotationArray;
        Class<Object> clazz;
        String string3;
        Class<?>[] classArray;
        Object object;
        if (IS_ANDROID) {
            return new String[0];
        }
        if (accessibleObject instanceof Method) {
            object = (Method)accessibleObject;
            classArray = ((Method)object).getParameterTypes();
            string3 = ((Method)object).getName();
            clazz = ((Method)object).getDeclaringClass();
            annotationArray = TypeUtils.getParameterAnnotations((Method)object);
        } else {
            object = (Constructor)accessibleObject;
            classArray = ((Constructor)object).getParameterTypes();
            clazz = ((Constructor)object).getDeclaringClass();
            string3 = "<init>";
            annotationArray = TypeUtils.getParameterAnnotations((Constructor)object);
        }
        if (classArray.length == 0) {
            return new String[0];
        }
        object = clazz.getClassLoader();
        if (object == null) {
            object = ClassLoader.getSystemClassLoader();
        }
        if ((inputStream = ((ClassLoader)object).getResourceAsStream(string2 = (string = clazz.getName()).replace('.', '/') + ".class")) == null) {
            return new String[0];
        }
        try {
            ClassReader classReader = new ClassReader(inputStream, false);
            TypeCollector typeCollector = new TypeCollector(string3, classArray);
            classReader.accept(typeCollector);
            String[] stringArray = typeCollector.getParameterNamesForMethod();
            for (int i = 0; i < stringArray.length; ++i) {
                Annotation[] annotationArray2 = annotationArray[i];
                if (annotationArray2 == null) continue;
                for (int j = 0; j < annotationArray2.length; ++j) {
                    JSONField jSONField;
                    String string4;
                    if (!(annotationArray2[j] instanceof JSONField) || (string4 = (jSONField = (JSONField)annotationArray2[j]).name()) == null || string4.length() <= 0) continue;
                    stringArray[i] = string4;
                }
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        catch (IOException iOException) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            IOUtils.close(inputStream);
        }
    }
}

