/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.util.ParameterizedTypeImpl;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public class FieldInfo
implements Comparable<FieldInfo> {
    public final String name;
    public final Method method;
    public final Field field;
    private int ordinal = 0;
    public final Class<?> fieldClass;
    public final Type fieldType;
    public final Class<?> declaringClass;
    public final boolean getOnly;
    public final int serialzeFeatures;
    public final int parserFeatures;
    public final String label;
    private final JSONField fieldAnnotation;
    private final JSONField methodAnnotation;
    public final boolean fieldAccess;
    public final boolean fieldTransient;
    public final char[] name_chars;
    public final boolean isEnum;
    public final boolean jsonDirect;
    public final boolean unwrapped;
    public final String format;
    public final String[] alternateNames;

    public FieldInfo(String string, Class<?> clazz, Class<?> clazz2, Type type, Field field, int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        this.name = string;
        this.declaringClass = clazz;
        this.fieldClass = clazz2;
        this.fieldType = type;
        this.method = null;
        this.field = field;
        this.ordinal = n;
        this.serialzeFeatures = n2;
        this.parserFeatures = n3;
        this.isEnum = clazz2.isEnum();
        if (field != null) {
            int n4 = field.getModifiers();
            this.fieldAccess = (n4 & 1) != 0 || this.method == null;
            this.fieldTransient = Modifier.isTransient(n4);
        } else {
            this.fieldTransient = false;
            this.fieldAccess = false;
        }
        this.name_chars = this.genFieldNameChars();
        if (field != null) {
            TypeUtils.setAccessible(field);
        }
        this.label = "";
        this.fieldAnnotation = field == null ? null : TypeUtils.getAnnotation(field, JSONField.class);
        this.methodAnnotation = null;
        this.getOnly = false;
        this.jsonDirect = false;
        this.unwrapped = false;
        this.format = null;
        this.alternateNames = new String[0];
    }

    public FieldInfo(String string, Method method, Field field, Class<?> clazz, Type type, int n, int n2, int n3, JSONField jSONField, JSONField jSONField2, String string2) {
        this(string, method, field, clazz, type, n, n2, n3, jSONField, jSONField2, string2, null);
    }

    public FieldInfo(String string, Method method, Field field, Class<?> clazz, Type clazz2, int n, int n2, int n3, JSONField jSONField, JSONField jSONField2, String string2, Map<TypeVariable, Type> map) {
        Type type;
        Class<?> clazz3;
        Class<?> clazz4;
        Object object;
        String string3;
        if (field != null && (string3 = field.getName()).equals(string)) {
            string = string3;
        }
        if (n < 0) {
            n = 0;
        }
        this.name = string;
        this.method = method;
        this.field = field;
        this.ordinal = n;
        this.serialzeFeatures = n2;
        this.parserFeatures = n3;
        this.fieldAnnotation = jSONField;
        this.methodAnnotation = jSONField2;
        if (field != null) {
            int n4 = field.getModifiers();
            this.fieldAccess = (n4 & 1) != 0 || method == null;
            this.fieldTransient = Modifier.isTransient(n4) || TypeUtils.isTransient(method);
        } else {
            this.fieldAccess = false;
            this.fieldTransient = TypeUtils.isTransient(method);
        }
        this.label = string2 != null && string2.length() > 0 ? string2 : "";
        String string4 = null;
        JSONField jSONField3 = this.getAnnotation();
        boolean bl = false;
        if (jSONField3 != null) {
            string4 = jSONField3.format();
            if (string4.trim().length() == 0) {
                string4 = null;
            }
            bl = jSONField3.jsonDirect();
            this.unwrapped = jSONField3.unwrapped();
            this.alternateNames = jSONField3.alternateNames();
        } else {
            bl = false;
            this.unwrapped = false;
            this.alternateNames = new String[0];
        }
        this.format = string4;
        this.name_chars = this.genFieldNameChars();
        if (method != null) {
            TypeUtils.setAccessible(method);
        }
        if (field != null) {
            TypeUtils.setAccessible(field);
        }
        boolean bl2 = false;
        if (method != null) {
            object = method.getParameterTypes();
            if (((Class<?>[])object).length == 1) {
                clazz4 = object[0];
                clazz3 = method.getGenericParameterTypes()[0];
            } else if (((Class<?>[])object).length == 2 && object[0] == String.class && object[1] == Object.class) {
                clazz4 = object[0];
                clazz3 = clazz4;
            } else {
                clazz4 = method.getReturnType();
                clazz3 = method.getGenericReturnType();
                bl2 = true;
            }
            this.declaringClass = method.getDeclaringClass();
        } else {
            clazz4 = field.getType();
            clazz3 = field.getGenericType();
            this.declaringClass = field.getDeclaringClass();
            bl2 = Modifier.isFinal(field.getModifiers());
        }
        this.getOnly = bl2;
        boolean bl3 = this.jsonDirect = bl && clazz4 == String.class;
        if (clazz != null && clazz4 == Object.class && clazz3 instanceof TypeVariable && (type = FieldInfo.getInheritGenericType(clazz, clazz2, object = (TypeVariable)((Object)clazz3))) != null) {
            this.fieldClass = TypeUtils.getClass(type);
            this.fieldType = type;
            this.isEnum = clazz4.isEnum();
            return;
        }
        object = clazz3;
        if (!(clazz3 instanceof Class) && (object = FieldInfo.getFieldType(clazz, clazz2 != null ? clazz2 : clazz, clazz3, map)) != clazz3) {
            if (object instanceof ParameterizedType) {
                clazz4 = TypeUtils.getClass(object);
            } else if (object instanceof Class) {
                clazz4 = TypeUtils.getClass(object);
            }
        }
        this.fieldType = object;
        this.fieldClass = clazz4;
        this.isEnum = clazz4.isEnum();
    }

    protected char[] genFieldNameChars() {
        int n = this.name.length();
        char[] cArray = new char[n + 3];
        this.name.getChars(0, this.name.length(), cArray, 1);
        cArray[0] = 34;
        cArray[n + 1] = 34;
        cArray[n + 2] = 58;
        return cArray;
    }

    public <T extends Annotation> T getAnnation(Class<T> clazz) {
        if (clazz == JSONField.class) {
            return (T)this.getAnnotation();
        }
        T t = null;
        if (this.method != null) {
            t = TypeUtils.getAnnotation(this.method, clazz);
        }
        if (t == null && this.field != null) {
            t = TypeUtils.getAnnotation(this.field, clazz);
        }
        return t;
    }

    public static Type getFieldType(Class<?> clazz, Type type, Type type2) {
        return FieldInfo.getFieldType(clazz, type, type2, null);
    }

    public static Type getFieldType(Class<?> clazz, Type type, Type type2, Map<TypeVariable, Type> map) {
        int n;
        Object object;
        TypeVariable[] typeVariableArray;
        Type[] typeArray;
        ParameterizedType parameterizedType;
        if (clazz == null || type == null) {
            return type2;
        }
        if (type2 instanceof GenericArrayType) {
            Type type3;
            GenericArrayType genericArrayType = (GenericArrayType)type2;
            Type type4 = genericArrayType.getGenericComponentType();
            if (type4 != (type3 = FieldInfo.getFieldType(clazz, type, type4, map))) {
                Class<?> clazz2 = Array.newInstance(TypeUtils.getClass(type3), 0).getClass();
                return clazz2;
            }
            return type2;
        }
        if (!TypeUtils.isGenericParamType(type)) {
            return type2;
        }
        if (type2 instanceof TypeVariable) {
            parameterizedType = (ParameterizedType)TypeUtils.getGenericParamType(type);
            typeArray = TypeUtils.getClass(parameterizedType);
            typeVariableArray = (TypeVariable[])type2;
            object = typeArray.getTypeParameters();
            for (n = 0; n < ((TypeVariable<Class<T>>[])object).length; ++n) {
                if (!object[n].getName().equals(typeVariableArray.getName())) continue;
                type2 = parameterizedType.getActualTypeArguments()[n];
                return type2;
            }
        }
        if (type2 instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)type2;
            typeArray = parameterizedType.getActualTypeArguments();
            n = FieldInfo.getArgument(typeArray, map);
            if (n == 0) {
                if (type instanceof ParameterizedType) {
                    object = (ParameterizedType)type;
                    typeVariableArray = clazz.getTypeParameters();
                } else if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
                    object = (ParameterizedType)clazz.getGenericSuperclass();
                    typeVariableArray = clazz.getSuperclass().getTypeParameters();
                } else {
                    object = parameterizedType;
                    typeVariableArray = type.getClass().getTypeParameters();
                }
                n = FieldInfo.getArgument(typeArray, typeVariableArray, object.getActualTypeArguments()) ? 1 : 0;
            }
            if (n != 0) {
                type2 = new ParameterizedTypeImpl(typeArray, parameterizedType.getOwnerType(), parameterizedType.getRawType());
                return type2;
            }
        }
        return type2;
    }

    private static boolean getArgument(Type[] typeArray, Map<TypeVariable, Type> map) {
        if (map == null || map.size() == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray2 = parameterizedType.getActualTypeArguments();
                boolean bl2 = FieldInfo.getArgument(typeArray2, map);
                if (!bl2) continue;
                typeArray[i] = new ParameterizedTypeImpl(typeArray2, parameterizedType.getOwnerType(), parameterizedType.getRawType());
                bl = true;
                continue;
            }
            if (!(type instanceof TypeVariable) || !map.containsKey(type)) continue;
            typeArray[i] = map.get(type);
            bl = true;
        }
        return bl;
    }

    private static boolean getArgument(Type[] typeArray, TypeVariable[] typeVariableArray, Type[] typeArray2) {
        if (typeArray2 == null || typeVariableArray.length == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray3 = parameterizedType.getActualTypeArguments();
                boolean bl2 = FieldInfo.getArgument(typeArray3, typeVariableArray, typeArray2);
                if (!bl2) continue;
                typeArray[i] = new ParameterizedTypeImpl(typeArray3, parameterizedType.getOwnerType(), parameterizedType.getRawType());
                bl = true;
                continue;
            }
            if (!(type instanceof TypeVariable)) continue;
            for (int j = 0; j < typeVariableArray.length; ++j) {
                if (!type.equals(typeVariableArray[j])) continue;
                typeArray[i] = typeArray2[j];
                bl = true;
            }
        }
        return bl;
    }

    private static Type getInheritGenericType(Class<?> clazz, Type type, TypeVariable<?> typeVariable) {
        Object object;
        Type type2;
        Object obj = typeVariable.getGenericDeclaration();
        Class clazz2 = null;
        if (obj instanceof Class) {
            clazz2 = (Class)typeVariable.getGenericDeclaration();
        }
        Type[] typeArray = null;
        if (clazz2 == clazz) {
            if (type instanceof ParameterizedType) {
                type2 = (ParameterizedType)type;
                typeArray = type2.getActualTypeArguments();
            }
        } else {
            for (type2 = clazz; type2 != null && type2 != Object.class && type2 != clazz2; type2 = ((Class)type2).getSuperclass()) {
                object = ((Class)type2).getGenericSuperclass();
                if (!(object instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)object;
                Type[] typeArray2 = parameterizedType.getActualTypeArguments();
                FieldInfo.getArgument(typeArray2, ((Class)type2).getTypeParameters(), typeArray);
                typeArray = typeArray2;
            }
        }
        if (typeArray == null || clazz2 == null) {
            return null;
        }
        type2 = null;
        object = clazz2.getTypeParameters();
        for (int i = 0; i < ((TypeVariable<Class<T>>[])object).length; ++i) {
            if (!typeVariable.equals(object[i])) continue;
            type2 = typeArray[i];
            break;
        }
        return type2;
    }

    public String toString() {
        return this.name;
    }

    public Member getMember() {
        if (this.method != null) {
            return this.method;
        }
        return this.field;
    }

    protected Class<?> getDeclaredClass() {
        if (this.method != null) {
            return this.method.getDeclaringClass();
        }
        if (this.field != null) {
            return this.field.getDeclaringClass();
        }
        return null;
    }

    @Override
    public int compareTo(FieldInfo fieldInfo) {
        boolean bl;
        if (this.ordinal < fieldInfo.ordinal) {
            return -1;
        }
        if (this.ordinal > fieldInfo.ordinal) {
            return 1;
        }
        int n = this.name.compareTo(fieldInfo.name);
        if (n != 0) {
            return n;
        }
        Class<?> clazz = this.getDeclaredClass();
        Class<?> clazz2 = fieldInfo.getDeclaredClass();
        if (clazz != null && clazz2 != null && clazz != clazz2) {
            if (clazz.isAssignableFrom(clazz2)) {
                return -1;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return 1;
            }
        }
        boolean bl2 = this.field != null && this.field.getType() == this.fieldClass;
        boolean bl3 = bl = fieldInfo.field != null && fieldInfo.field.getType() == fieldInfo.fieldClass;
        if (bl2 && !bl) {
            return 1;
        }
        if (bl && !bl2) {
            return -1;
        }
        if (fieldInfo.fieldClass.isPrimitive() && !this.fieldClass.isPrimitive()) {
            return 1;
        }
        if (this.fieldClass.isPrimitive() && !fieldInfo.fieldClass.isPrimitive()) {
            return -1;
        }
        if (fieldInfo.fieldClass.getName().startsWith("java.") && !this.fieldClass.getName().startsWith("java.")) {
            return 1;
        }
        if (this.fieldClass.getName().startsWith("java.") && !fieldInfo.fieldClass.getName().startsWith("java.")) {
            return -1;
        }
        return this.fieldClass.getName().compareTo(fieldInfo.fieldClass.getName());
    }

    public JSONField getAnnotation() {
        if (this.fieldAnnotation != null) {
            return this.fieldAnnotation;
        }
        return this.methodAnnotation;
    }

    public String getFormat() {
        return this.format;
    }

    public Object get(Object object) throws IllegalAccessException, InvocationTargetException {
        return this.method != null ? this.method.invoke(object, new Object[0]) : this.field.get(object);
    }

    public void set(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
        if (this.method != null) {
            this.method.invoke(object, object2);
            return;
        }
        this.field.set(object, object2);
    }

    public void setAccessible() throws SecurityException {
        if (this.method != null) {
            TypeUtils.setAccessible(this.method);
            return;
        }
        TypeUtils.setAccessible(this.field);
    }
}

