/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;

public class IOUtils {
    public static final String FASTJSON_PROPERTIES = "fastjson.properties";
    public static final String FASTJSON_COMPATIBLEWITHJAVABEAN = "fastjson.compatibleWithJavaBean";
    public static final String FASTJSON_COMPATIBLEWITHFIELDNAME = "fastjson.compatibleWithFieldName";
    public static final Properties DEFAULT_PROPERTIES;
    public static final Charset UTF8;
    public static final char[] DIGITS;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;
    public static final byte[] specicalFlags_doubleQuotes;
    public static final byte[] specicalFlags_singleQuotes;
    public static final boolean[] specicalFlags_doubleQuotesFlags;
    public static final boolean[] specicalFlags_singleQuotesFlags;
    public static final char[] replaceChars;
    public static final char[] ASCII_CHARS;
    static final char[] digits;
    static final char[] DigitTens;
    static final char[] DigitOnes;
    static final int[] sizeTable;
    public static final char[] CA;
    public static final int[] IA;

    public static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2 == null ? DEFAULT_PROPERTIES.getProperty(string) : string2;
    }

    public static void loadPropertiesFromFile() {
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
                }
                return ClassLoader.getSystemResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
            }
        });
        if (null != inputStream) {
            try {
                DEFAULT_PROPERTIES.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int stringSize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 = 10L * l2;
        }
        return 19;
    }

    public static void getChars(long l, int n, char[] cArray) {
        int n2;
        int n3;
        int n4 = n;
        int n5 = 0;
        if (l < 0L) {
            n5 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n3 = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            l = l2;
            cArray[--n4] = DigitOnes[n3];
            cArray[--n4] = DigitTens[n3];
        }
        int n6 = (int)l;
        while (n6 >= 65536) {
            n2 = n6 / 100;
            n3 = n6 - ((n2 << 6) + (n2 << 5) + (n2 << 2));
            n6 = n2;
            cArray[--n4] = DigitOnes[n3];
            cArray[--n4] = DigitTens[n3];
        }
        do {
            n2 = n6 * 52429 >>> 19;
            n3 = n6 - ((n2 << 3) + (n2 << 1));
            cArray[--n4] = digits[n3];
        } while ((n6 = n2) != 0);
        if (n5 != 0) {
            cArray[--n4] = n5;
        }
    }

    public static void getChars(int n, int n2, char[] cArray) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = 0;
        if (n < 0) {
            n6 = 45;
            n = -n;
        }
        while (n >= 65536) {
            n4 = n / 100;
            n3 = n - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n = n4;
            cArray[--n5] = DigitOnes[n3];
            cArray[--n5] = DigitTens[n3];
        }
        do {
            n4 = n * 52429 >>> 19;
            n3 = n - ((n4 << 3) + (n4 << 1));
            cArray[--n5] = digits[n3];
        } while ((n = n4) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    public static void getChars(byte n, int n2, char[] cArray) {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        if (n4 < 0) {
            n6 = 45;
            n4 = -n4;
        }
        do {
            n3 = n4 * 52429 >>> 19;
            int n7 = n4 - ((n3 << 3) + (n3 << 1));
            cArray[--n5] = digits[n7];
        } while ((n4 = n3) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    public static int stringSize(int n) {
        int n2 = 0;
        while (n > sizeTable[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    public static void decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer) {
        try {
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new JSONException("utf8 decode error, " + characterCodingException.getMessage(), characterCodingException);
        }
    }

    public static boolean firstIdentifier(char c2) {
        return c2 < firstIdentifierFlags.length && firstIdentifierFlags[c2];
    }

    public static boolean isIdent(char c2) {
        return c2 < identifierFlags.length && identifierFlags[c2];
    }

    public static byte[] decodeBase64(char[] cArray, int n, int n2) {
        int n3;
        if (n2 == 0) {
            return new byte[0];
        }
        int n4 = n + n2 - 1;
        for (n3 = n; n3 < n4 && IA[cArray[n3]] < 0; ++n3) {
        }
        while (n4 > 0 && IA[cArray[n4]] < 0) {
            --n4;
        }
        int n5 = cArray[n4] == '=' ? (cArray[n4 - 1] == '=' ? 2 : 1) : 0;
        int n6 = n4 - n3 + 1;
        int n7 = n2 > 76 ? (cArray[76] == '\r' ? n6 / 78 : 0) << 1 : 0;
        int n8 = ((n6 - n7) * 6 >> 3) - n5;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = n8 / 3 * 3;
        while (n9 < n11) {
            int n12 = IA[cArray[n3++]] << 18 | IA[cArray[n3++]] << 12 | IA[cArray[n3++]] << 6 | IA[cArray[n3++]];
            byArray[n9++] = (byte)(n12 >> 16);
            byArray[n9++] = (byte)(n12 >> 8);
            byArray[n9++] = (byte)n12;
            if (n7 <= 0 || ++n10 != 19) continue;
            n3 += 2;
            n10 = 0;
        }
        if (n9 < n8) {
            n10 = 0;
            n11 = 0;
            while (n3 <= n4 - n5) {
                n10 |= IA[cArray[n3++]] << 18 - n11 * 6;
                ++n11;
            }
            n11 = 16;
            while (n9 < n8) {
                byArray[n9++] = (byte)(n10 >> n11);
                n11 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] decodeBase64(String string, int n, int n2) {
        int n3;
        if (n2 == 0) {
            return new byte[0];
        }
        int n4 = n + n2 - 1;
        for (n3 = n; n3 < n4 && IA[string.charAt(n3)] < 0; ++n3) {
        }
        while (n4 > 0 && IA[string.charAt(n4)] < 0) {
            --n4;
        }
        int n5 = string.charAt(n4) == '=' ? (string.charAt(n4 - 1) == '=' ? 2 : 1) : 0;
        int n6 = n4 - n3 + 1;
        int n7 = n2 > 76 ? (string.charAt(76) == '\r' ? n6 / 78 : 0) << 1 : 0;
        int n8 = ((n6 - n7) * 6 >> 3) - n5;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = n8 / 3 * 3;
        while (n9 < n11) {
            int n12 = IA[string.charAt(n3++)] << 18 | IA[string.charAt(n3++)] << 12 | IA[string.charAt(n3++)] << 6 | IA[string.charAt(n3++)];
            byArray[n9++] = (byte)(n12 >> 16);
            byArray[n9++] = (byte)(n12 >> 8);
            byArray[n9++] = (byte)n12;
            if (n7 <= 0 || ++n10 != 19) continue;
            n3 += 2;
            n10 = 0;
        }
        if (n9 < n8) {
            n10 = 0;
            n11 = 0;
            while (n3 <= n4 - n5) {
                n10 |= IA[string.charAt(n3++)] << 18 - n11 * 6;
                ++n11;
            }
            n11 = 16;
            while (n9 < n8) {
                byArray[n9++] = (byte)(n10 >> n11);
                n11 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] decodeBase64(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = n2 - 1;
        for (n = 0; n < n3 && IA[string.charAt(n) & 0xFF] < 0; ++n) {
        }
        while (n3 > 0 && IA[string.charAt(n3) & 0xFF] < 0) {
            --n3;
        }
        int n4 = string.charAt(n3) == '=' ? (string.charAt(n3 - 1) == '=' ? 2 : 1) : 0;
        int n5 = n3 - n + 1;
        int n6 = n2 > 76 ? (string.charAt(76) == '\r' ? n5 / 78 : 0) << 1 : 0;
        int n7 = ((n5 - n6) * 6 >> 3) - n4;
        byte[] byArray = new byte[n7];
        int n8 = 0;
        int n9 = 0;
        int n10 = n7 / 3 * 3;
        while (n8 < n10) {
            int n11 = IA[string.charAt(n++)] << 18 | IA[string.charAt(n++)] << 12 | IA[string.charAt(n++)] << 6 | IA[string.charAt(n++)];
            byArray[n8++] = (byte)(n11 >> 16);
            byArray[n8++] = (byte)(n11 >> 8);
            byArray[n8++] = (byte)n11;
            if (n6 <= 0 || ++n9 != 19) continue;
            n += 2;
            n9 = 0;
        }
        if (n8 < n7) {
            n9 = 0;
            n10 = 0;
            while (n <= n3 - n4) {
                n9 |= IA[string.charAt(n++)] << 18 - n10 * 6;
                ++n10;
            }
            n10 = 16;
            while (n8 < n7) {
                byArray[n8++] = (byte)(n9 >> n10);
                n10 -= 8;
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int encodeUTF8(char[] cArray, int n, int n2, byte[] byArray) {
        int n3 = n + n2;
        int n4 = 0;
        int n5 = n4 + Math.min(n2, byArray.length);
        while (n4 < n5 && cArray[n] < '\u0080') {
            byArray[n4++] = (byte)cArray[n++];
        }
        while (true) {
            int n6;
            block12: {
                int n7;
                block11: {
                    block13: {
                        if (n >= n3) {
                            return n4;
                        }
                        if ((n6 = cArray[n++]) < 128) {
                            byArray[n4++] = (byte)n6;
                            continue;
                        }
                        if (n6 < 2048) {
                            byArray[n4++] = (byte)(0xC0 | n6 >> 6);
                            byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                            continue;
                        }
                        if (n6 < 55296 || n6 >= 57344) break block12;
                        int n8 = n - 1;
                        if (n6 < 55296 || n6 >= 56320) break block13;
                        if (n3 - n8 < 2) {
                            n7 = -1;
                            break block11;
                        } else {
                            char c2 = cArray[n8 + 1];
                            if (c2 >= '\udc00' && c2 < '\ue000') {
                                n7 = (n6 << 10) + c2 + -56613888;
                                break block11;
                            } else {
                                byArray[n4++] = 63;
                                continue;
                            }
                        }
                    }
                    if (n6 >= 56320 && n6 < 57344) {
                        byArray[n4++] = 63;
                        continue;
                    }
                    n7 = n6;
                }
                if (n7 < 0) {
                    byArray[n4++] = 63;
                    continue;
                }
                byArray[n4++] = (byte)(0xF0 | n7 >> 18);
                byArray[n4++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n7 & 0x3F);
                ++n;
                continue;
            }
            byArray[n4++] = (byte)(0xE0 | n6 >> 12);
            byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
        }
    }

    public static int decodeUTF8(byte[] byArray, int n, int n2, char[] cArray) {
        int n3 = n + n2;
        int n4 = 0;
        int n5 = Math.min(n2, cArray.length);
        while (n4 < n5 && byArray[n] >= 0) {
            cArray[n4++] = (char)byArray[n++];
        }
        while (n < n3) {
            int n6;
            char c2;
            byte by;
            byte by2;
            byte by3;
            if ((by3 = byArray[n++]) >= 0) {
                cArray[n4++] = (char)by3;
                continue;
            }
            if (by3 >> 5 == -2 && (by3 & 0x1E) != 0) {
                if (n < n3) {
                    if (((by2 = byArray[n++]) & 0xC0) != 128) {
                        return -1;
                    }
                    cArray[n4++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (by3 >> 4 == -2) {
                if (n + 1 < n3) {
                    by2 = byArray[n++];
                    by = byArray[n++];
                    if (by3 == -32 && (by2 & 0xE0) == 128 || (by2 & 0xC0) != 128 || (by & 0xC0) != 128) {
                        return -1;
                    }
                    c2 = (char)(by3 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    int n7 = n6 = c2 >= '\ud800' && c2 < '\ue000' ? 1 : 0;
                    if (n6 != 0) {
                        return -1;
                    }
                    cArray[n4++] = c2;
                    continue;
                }
                return -1;
            }
            if (by3 >> 3 == -2) {
                if (n + 2 < n3) {
                    by2 = byArray[n++];
                    by = byArray[n++];
                    c2 = byArray[n++];
                    n6 = by3 << 18 ^ by2 << 12 ^ by << 6 ^ (c2 ^ 0x381F80);
                    if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128 || (c2 & 0xC0) != 128 || n6 < 65536 || n6 >= 0x110000) {
                        return -1;
                    }
                    cArray[n4++] = (char)((n6 >>> 10) + 55232);
                    cArray[n4++] = (char)((n6 & 0x3FF) + 56320);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return n4;
    }

    public static String readAll(Reader reader) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            char[] cArray = new char[2048];
            while ((n = reader.read(cArray, 0, cArray.length)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (Exception exception) {
            throw new JSONException("read string from reader error", exception);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidJsonpQueryParam(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '.' || IOUtils.isIdent(c2)) continue;
            return false;
        }
        return true;
    }

    static {
        int n;
        int n2;
        DEFAULT_PROPERTIES = new Properties();
        UTF8 = Charset.forName("UTF-8");
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        firstIdentifierFlags = new boolean[256];
        identifierFlags = new boolean[256];
        for (n2 = 0; n2 < firstIdentifierFlags.length; n2 = (int)((char)(n2 + 1))) {
            if (n2 >= 65 && n2 <= 90) {
                IOUtils.firstIdentifierFlags[n2] = true;
                continue;
            }
            if (n2 >= 97 && n2 <= 122) {
                IOUtils.firstIdentifierFlags[n2] = true;
                continue;
            }
            if (n2 != 95 && n2 != 36) continue;
            IOUtils.firstIdentifierFlags[n2] = true;
        }
        for (n2 = 0; n2 < identifierFlags.length; n2 = (int)((char)(n2 + 1))) {
            if (n2 >= 65 && n2 <= 90) {
                IOUtils.identifierFlags[n2] = true;
                continue;
            }
            if (n2 >= 97 && n2 <= 122) {
                IOUtils.identifierFlags[n2] = true;
                continue;
            }
            if (n2 == 95) {
                IOUtils.identifierFlags[n2] = true;
                continue;
            }
            if (n2 < 48 || n2 > 57) continue;
            IOUtils.identifierFlags[n2] = true;
        }
        try {
            IOUtils.loadPropertiesFromFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        specicalFlags_doubleQuotes = new byte[161];
        specicalFlags_singleQuotes = new byte[161];
        specicalFlags_doubleQuotesFlags = new boolean[161];
        specicalFlags_singleQuotesFlags = new boolean[161];
        replaceChars = new char[93];
        IOUtils.specicalFlags_doubleQuotes[0] = 4;
        IOUtils.specicalFlags_doubleQuotes[1] = 4;
        IOUtils.specicalFlags_doubleQuotes[2] = 4;
        IOUtils.specicalFlags_doubleQuotes[3] = 4;
        IOUtils.specicalFlags_doubleQuotes[4] = 4;
        IOUtils.specicalFlags_doubleQuotes[5] = 4;
        IOUtils.specicalFlags_doubleQuotes[6] = 4;
        IOUtils.specicalFlags_doubleQuotes[7] = 4;
        IOUtils.specicalFlags_doubleQuotes[8] = 1;
        IOUtils.specicalFlags_doubleQuotes[9] = 1;
        IOUtils.specicalFlags_doubleQuotes[10] = 1;
        IOUtils.specicalFlags_doubleQuotes[11] = 4;
        IOUtils.specicalFlags_doubleQuotes[12] = 1;
        IOUtils.specicalFlags_doubleQuotes[13] = 1;
        IOUtils.specicalFlags_doubleQuotes[34] = 1;
        IOUtils.specicalFlags_doubleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[0] = 4;
        IOUtils.specicalFlags_singleQuotes[1] = 4;
        IOUtils.specicalFlags_singleQuotes[2] = 4;
        IOUtils.specicalFlags_singleQuotes[3] = 4;
        IOUtils.specicalFlags_singleQuotes[4] = 4;
        IOUtils.specicalFlags_singleQuotes[5] = 4;
        IOUtils.specicalFlags_singleQuotes[6] = 4;
        IOUtils.specicalFlags_singleQuotes[7] = 4;
        IOUtils.specicalFlags_singleQuotes[8] = 1;
        IOUtils.specicalFlags_singleQuotes[9] = 1;
        IOUtils.specicalFlags_singleQuotes[10] = 1;
        IOUtils.specicalFlags_singleQuotes[11] = 4;
        IOUtils.specicalFlags_singleQuotes[12] = 1;
        IOUtils.specicalFlags_singleQuotes[13] = 1;
        IOUtils.specicalFlags_singleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[39] = 1;
        for (n = 14; n <= 31; ++n) {
            IOUtils.specicalFlags_doubleQuotes[n] = 4;
            IOUtils.specicalFlags_singleQuotes[n] = 4;
        }
        for (n = 127; n < 160; ++n) {
            IOUtils.specicalFlags_doubleQuotes[n] = 4;
            IOUtils.specicalFlags_singleQuotes[n] = 4;
        }
        for (n = 0; n < 161; ++n) {
            IOUtils.specicalFlags_doubleQuotesFlags[n] = specicalFlags_doubleQuotes[n] != 0;
            IOUtils.specicalFlags_singleQuotesFlags[n] = specicalFlags_singleQuotes[n] != 0;
        }
        IOUtils.replaceChars[0] = 48;
        IOUtils.replaceChars[1] = 49;
        IOUtils.replaceChars[2] = 50;
        IOUtils.replaceChars[3] = 51;
        IOUtils.replaceChars[4] = 52;
        IOUtils.replaceChars[5] = 53;
        IOUtils.replaceChars[6] = 54;
        IOUtils.replaceChars[7] = 55;
        IOUtils.replaceChars[8] = 98;
        IOUtils.replaceChars[9] = 116;
        IOUtils.replaceChars[10] = 110;
        IOUtils.replaceChars[11] = 118;
        IOUtils.replaceChars[12] = 102;
        IOUtils.replaceChars[13] = 114;
        IOUtils.replaceChars[34] = 34;
        IOUtils.replaceChars[39] = 39;
        IOUtils.replaceChars[47] = 47;
        IOUtils.replaceChars[92] = 92;
        ASCII_CHARS = new char[]{'0', '0', '0', '1', '0', '2', '0', '3', '0', '4', '0', '5', '0', '6', '0', '7', '0', '8', '0', '9', '0', 'A', '0', 'B', '0', 'C', '0', 'D', '0', 'E', '0', 'F', '1', '0', '1', '1', '1', '2', '1', '3', '1', '4', '1', '5', '1', '6', '1', '7', '1', '8', '1', '9', '1', 'A', '1', 'B', '1', 'C', '1', 'D', '1', 'E', '1', 'F', '2', '0', '2', '1', '2', '2', '2', '3', '2', '4', '2', '5', '2', '6', '2', '7', '2', '8', '2', '9', '2', 'A', '2', 'B', '2', 'C', '2', 'D', '2', 'E', '2', 'F'};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int n3 = CA.length;
        for (n = 0; n < n3; ++n) {
            IOUtils.IA[IOUtils.CA[n]] = n;
        }
        IOUtils.IA[61] = 0;
    }
}

