/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import java.util.Arrays;

public class IdentityHashMap<K, V> {
    private final Entry<K, V>[] buckets;
    private final int indexMask;
    public static final int DEFAULT_SIZE = 8192;

    public IdentityHashMap() {
        this(8192);
    }

    public IdentityHashMap(int n) {
        this.indexMask = n - 1;
        this.buckets = new Entry[n];
    }

    public final V get(K k) {
        int n = System.identityHashCode(k);
        int n2 = n & this.indexMask;
        Entry<K, V> entry = this.buckets[n2];
        while (entry != null) {
            if (k == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Class findClass(String string) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry<K, V> entry = this.buckets[i];
            if (entry == null) continue;
            Entry<K, V> entry2 = entry;
            while (entry2 != null) {
                Class clazz;
                String string2;
                Object k = entry.key;
                if (k instanceof Class && (string2 = (clazz = (Class)k).getName()).equals(string)) {
                    return clazz;
                }
                entry2 = entry2.next;
            }
        }
        return null;
    }

    public boolean put(K k, V v) {
        int n = System.identityHashCode(k);
        int n2 = n & this.indexMask;
        Entry<K, V> entry = this.buckets[n2];
        while (entry != null) {
            if (k == entry.key) {
                entry.value = v;
                return true;
            }
            entry = entry.next;
        }
        this.buckets[n2] = entry = new Entry<K, V>(k, v, n, this.buckets[n2]);
        return false;
    }

    public void clear() {
        Arrays.fill(this.buckets, null);
    }

    protected static final class Entry<K, V> {
        public final int hashCode;
        public final K key;
        public V value;
        public final Entry<K, V> next;

        public Entry(K k, V v, int n, Entry<K, V> entry) {
            this.key = k;
            this.value = v;
            this.next = entry;
            this.hashCode = n;
        }
    }
}

