/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import com.icbc.api.internal.util.fastjson.util.UTF8Decoder;
import java.lang.ref.SoftReference;
import java.nio.charset.CharsetDecoder;

public class ThreadLocalCache {
    public static final int CHARS_CACH_INIT_SIZE = 1024;
    public static final int CHARS_CACH_INIT_SIZE_EXP = 10;
    public static final int CHARS_CACH_MAX_SIZE = 131072;
    public static final int CHARS_CACH_MAX_SIZE_EXP = 17;
    private static final ThreadLocal<SoftReference<char[]>> charsBufLocal = new ThreadLocal();
    private static final ThreadLocal<CharsetDecoder> decoderLocal = new ThreadLocal();
    public static final int BYTES_CACH_INIT_SIZE = 1024;
    public static final int BYTES_CACH_INIT_SIZE_EXP = 10;
    public static final int BYTES_CACH_MAX_SIZE = 131072;
    public static final int BYTES_CACH_MAX_SIZE_EXP = 17;
    private static final ThreadLocal<SoftReference<byte[]>> bytesBufLocal = new ThreadLocal();

    public static CharsetDecoder getUTF8Decoder() {
        CharsetDecoder charsetDecoder = decoderLocal.get();
        if (charsetDecoder == null) {
            charsetDecoder = new UTF8Decoder();
            decoderLocal.set(charsetDecoder);
        }
        return charsetDecoder;
    }

    public static void clearChars() {
        charsBufLocal.set(null);
    }

    public static char[] getChars(int n) {
        SoftReference<char[]> softReference = charsBufLocal.get();
        if (softReference == null) {
            return ThreadLocalCache.allocate(n);
        }
        char[] cArray = softReference.get();
        if (cArray == null) {
            return ThreadLocalCache.allocate(n);
        }
        if (cArray.length < n) {
            cArray = ThreadLocalCache.allocate(n);
        }
        return cArray;
    }

    private static char[] allocate(int n) {
        if (n > 131072) {
            return new char[n];
        }
        int n2 = ThreadLocalCache.getAllocateLengthExp(10, 17, n);
        char[] cArray = new char[n2];
        charsBufLocal.set(new SoftReference<char[]>(cArray));
        return cArray;
    }

    private static int getAllocateLengthExp(int n, int n2, int n3) {
        assert (1 << n2 >= n3);
        int n4 = n3 >>> n;
        if (n4 <= 0) {
            return 1 << n;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n3 - 1);
    }

    public static void clearBytes() {
        bytesBufLocal.set(null);
    }

    public static byte[] getBytes(int n) {
        SoftReference<byte[]> softReference = bytesBufLocal.get();
        if (softReference == null) {
            return ThreadLocalCache.allocateBytes(n);
        }
        byte[] byArray = softReference.get();
        if (byArray == null) {
            return ThreadLocalCache.allocateBytes(n);
        }
        if (byArray.length < n) {
            byArray = ThreadLocalCache.allocateBytes(n);
        }
        return byArray;
    }

    private static byte[] allocateBytes(int n) {
        if (n > 131072) {
            return new byte[n];
        }
        int n2 = ThreadLocalCache.getAllocateLengthExp(10, 17, n);
        byte[] byArray = new byte[n2];
        bytesBufLocal.set(new SoftReference<byte[]>(byArray));
        return byArray;
    }
}

