/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class UTF8Decoder
extends CharsetDecoder {
    private static final Charset charset = Charset.forName("UTF-8");

    public UTF8Decoder() {
        super(charset, 1.0f, 1.0f);
    }

    private static boolean isNotContinuation(int n) {
        return (n & 0xC0) != 128;
    }

    private static boolean isMalformed2(int n, int n2) {
        return (n & 0x1E) == 0 || (n2 & 0xC0) != 128;
    }

    private static boolean isMalformed3(int n, int n2, int n3) {
        return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
    }

    private static boolean isMalformed4(int n, int n2, int n3) {
        return (n & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
    }

    private static CoderResult lookupN(ByteBuffer byteBuffer, int n) {
        for (int i = 1; i < n; ++i) {
            if (!UTF8Decoder.isNotContinuation(byteBuffer.get())) continue;
            return CoderResult.malformedForLength(i);
        }
        return CoderResult.malformedForLength(n);
    }

    public static CoderResult malformedN(ByteBuffer byteBuffer, int n) {
        switch (n) {
            case 1: {
                byte by = byteBuffer.get();
                if (by >> 2 == -2) {
                    if (byteBuffer.remaining() < 4) {
                        return CoderResult.UNDERFLOW;
                    }
                    return UTF8Decoder.lookupN(byteBuffer, 5);
                }
                if (by >> 1 == -2) {
                    if (byteBuffer.remaining() < 5) {
                        return CoderResult.UNDERFLOW;
                    }
                    return UTF8Decoder.lookupN(byteBuffer, 6);
                }
                return CoderResult.malformedForLength(1);
            }
            case 2: {
                return CoderResult.malformedForLength(1);
            }
            case 3: {
                byte by = byteBuffer.get();
                byte by2 = byteBuffer.get();
                return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || UTF8Decoder.isNotContinuation(by2) ? 1 : 2);
            }
            case 4: {
                int n2 = byteBuffer.get() & 0xFF;
                int n3 = byteBuffer.get() & 0xFF;
                if (n2 > 244 || n2 == 240 && (n3 < 144 || n3 > 191) || n2 == 244 && (n3 & 0xF0) != 128 || UTF8Decoder.isNotContinuation(n3)) {
                    return CoderResult.malformedForLength(1);
                }
                if (UTF8Decoder.isNotContinuation(byteBuffer.get())) {
                    return CoderResult.malformedForLength(2);
                }
                return CoderResult.malformedForLength(3);
            }
        }
        throw new IllegalStateException();
    }

    private static CoderResult malformed(ByteBuffer byteBuffer, int n, CharBuffer charBuffer, int n2, int n3) {
        byteBuffer.position(n - byteBuffer.arrayOffset());
        CoderResult coderResult = UTF8Decoder.malformedN(byteBuffer, n3);
        byteBuffer.position(n);
        charBuffer.position(n2);
        return coderResult;
    }

    private static CoderResult xflow(Buffer buffer, int n, int n2, Buffer buffer2, int n3, int n4) {
        buffer.position(n);
        buffer2.position(n3);
        return n4 == 0 || n2 - n < n4 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = n3 + Math.min(n2 - n, n4 - n3);
        while (n3 < n5 && byArray[n] >= 0) {
            cArray[n3++] = (char)byArray[n++];
        }
        while (n < n2) {
            byte by;
            byte by2;
            byte by3 = byArray[n];
            if (by3 >= 0) {
                if (n3 >= n4) {
                    return UTF8Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 1);
                }
                cArray[n3++] = (char)by3;
                ++n;
                continue;
            }
            if (by3 >> 5 == -2) {
                if (n2 - n < 2 || n3 >= n4) {
                    return UTF8Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 2);
                }
                by2 = byArray[n + 1];
                if (UTF8Decoder.isMalformed2(by3, by2)) {
                    return UTF8Decoder.malformed(byteBuffer, n, charBuffer, n3, 2);
                }
                cArray[n3++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                n += 2;
                continue;
            }
            if (by3 >> 4 == -2) {
                if (n2 - n < 3 || n3 >= n4) {
                    return UTF8Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 3);
                }
                by2 = byArray[n + 1];
                by = byArray[n + 2];
                if (UTF8Decoder.isMalformed3(by3, by2, by)) {
                    return UTF8Decoder.malformed(byteBuffer, n, charBuffer, n3, 3);
                }
                cArray[n3++] = (char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80);
                n += 3;
                continue;
            }
            if (by3 >> 3 == -2) {
                if (n2 - n < 4 || n4 - n3 < 2) {
                    return UTF8Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 4);
                }
                by2 = byArray[n + 1];
                by = byArray[n + 2];
                byte by4 = byArray[n + 3];
                int n6 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                if (UTF8Decoder.isMalformed4(by2, by, by4) || n6 < 65536 || n6 > 0x10FFFF) {
                    return UTF8Decoder.malformed(byteBuffer, n, charBuffer, n3, 4);
                }
                cArray[n3++] = (char)(0xD800 | n6 - 65536 >> 10 & 0x3FF);
                cArray[n3++] = (char)(0xDC00 | n6 - 65536 & 0x3FF);
                n += 4;
                continue;
            }
            return UTF8Decoder.malformed(byteBuffer, n, charBuffer, n3, 1);
        }
        return UTF8Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 0);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        return this.decodeArrayLoop(byteBuffer, charBuffer);
    }
}

