/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.internal.util.fastjson;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.ParserConfig;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.TypeReference;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONObject
extends JSON
implements Serializable,
Cloneable,
InvocationHandler,
Map<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
    }

    public JSONObject(boolean bl) {
        this(16, bl);
    }

    public JSONObject(int n) {
        this(n, false);
    }

    public JSONObject(int n, boolean bl) {
        this.map = bl ? new LinkedHashMap<String, Object>(n) : new HashMap<String, Object>(n);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl = this.map.containsKey(object);
        if (!bl && object instanceof Number) {
            bl = this.map.containsKey(object.toString());
        }
        return bl;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        Object object2 = this.map.get(object);
        if (object2 == null && object instanceof Number) {
            object2 = this.map.get(object.toString());
        }
        return object2;
    }

    public JSONObject getJSONObject(String string) {
        Object object = this.map.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object);
        }
        if (object instanceof String) {
            return JSON.parseObject((String)object);
        }
        return (JSONObject)JSONObject.toJSON(object);
    }

    public JSONArray getJSONArray(String string) {
        Object object = this.map.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        if (object instanceof String) {
            return (JSONArray)JSON.parse((String)object);
        }
        return (JSONArray)JSONObject.toJSON(object);
    }

    public <T> T getObject(String string, Class<T> clazz) {
        Object object = this.map.get(string);
        return TypeUtils.castToJavaBean(object, clazz);
    }

    public <T> T getObject(String string, Type type) {
        Object object = this.map.get(string);
        return TypeUtils.cast(object, type, ParserConfig.getGlobalInstance());
    }

    public <T> T getObject(String string, TypeReference typeReference) {
        Object object = this.map.get(string);
        if (typeReference == null) {
            return (T)object;
        }
        return TypeUtils.cast(object, typeReference.getType(), ParserConfig.getGlobalInstance());
    }

    public Boolean getBoolean(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return TypeUtils.castToBoolean(object);
    }

    public byte[] getBytes(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return TypeUtils.castToBytes(object);
    }

    public boolean getBooleanValue(String string) {
        Object object = this.get(string);
        Boolean bl = TypeUtils.castToBoolean(object);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public Byte getByte(String string) {
        Object object = this.get(string);
        return TypeUtils.castToByte(object);
    }

    public byte getByteValue(String string) {
        Object object = this.get(string);
        Byte by = TypeUtils.castToByte(object);
        if (by == null) {
            return 0;
        }
        return by;
    }

    public Short getShort(String string) {
        Object object = this.get(string);
        return TypeUtils.castToShort(object);
    }

    public short getShortValue(String string) {
        Object object = this.get(string);
        Short s = TypeUtils.castToShort(object);
        if (s == null) {
            return 0;
        }
        return s;
    }

    public Integer getInteger(String string) {
        Object object = this.get(string);
        return TypeUtils.castToInt(object);
    }

    public int getIntValue(String string) {
        Object object = this.get(string);
        Integer n = TypeUtils.castToInt(object);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public Long getLong(String string) {
        Object object = this.get(string);
        return TypeUtils.castToLong(object);
    }

    public long getLongValue(String string) {
        Object object = this.get(string);
        Long l = TypeUtils.castToLong(object);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public Float getFloat(String string) {
        Object object = this.get(string);
        return TypeUtils.castToFloat(object);
    }

    public float getFloatValue(String string) {
        Object object = this.get(string);
        Float f = TypeUtils.castToFloat(object);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public Double getDouble(String string) {
        Object object = this.get(string);
        return TypeUtils.castToDouble(object);
    }

    public double getDoubleValue(String string) {
        Object object = this.get(string);
        Double d2 = TypeUtils.castToDouble(object);
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    public BigDecimal getBigDecimal(String string) {
        Object object = this.get(string);
        return TypeUtils.castToBigDecimal(object);
    }

    public BigInteger getBigInteger(String string) {
        Object object = this.get(string);
        return TypeUtils.castToBigInteger(object);
    }

    public String getString(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public java.util.Date getDate(String string) {
        Object object = this.get(string);
        return TypeUtils.castToDate(object);
    }

    public Date getSqlDate(String string) {
        Object object = this.get(string);
        return TypeUtils.castToSqlDate(object);
    }

    public Timestamp getTimestamp(String string) {
        Object object = this.get(string);
        return TypeUtils.castToTimestamp(object);
    }

    @Override
    public Object put(String string, Object object) {
        return this.map.put(string, object);
    }

    public JSONObject fluentPut(String string, Object object) {
        this.map.put(string, object);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.map.putAll(map);
    }

    public JSONObject fluentPutAll(Map<? extends String, ? extends Object> map) {
        this.map.putAll(map);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public JSONObject fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public JSONObject fluentRemove(Object object) {
        this.map.remove(object);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new JSONObject(this.map instanceof LinkedHashMap ? new LinkedHashMap<String, Object>(this.map) : new HashMap<String, Object>(this.map));
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1) {
            if (method.getName().equals("equals")) {
                return this.equals(objectArray[0]);
            }
            Class<?> clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                throw new JSONException("illegal setter");
            }
            String string = null;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                string = jSONField.name();
            }
            if (string == null) {
                string = method.getName();
                if (!string.startsWith("set")) {
                    throw new JSONException("illegal setter");
                }
                if ((string = string.substring(3)).length() == 0) {
                    throw new JSONException("illegal setter");
                }
                string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
            }
            this.map.put(string, objectArray[0]);
            return null;
        }
        if (classArray.length == 0) {
            Class<?> clazz = method.getReturnType();
            if (clazz == Void.TYPE) {
                throw new JSONException("illegal getter");
            }
            String string = null;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                string = jSONField.name();
            }
            if (string == null) {
                string = method.getName();
                if (string.startsWith("get")) {
                    if ((string = string.substring(3)).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
                } else if (string.startsWith("is")) {
                    if ((string = string.substring(2)).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
                } else {
                    if (string.startsWith("hashCode")) {
                        return this.hashCode();
                    }
                    if (string.startsWith("toString")) {
                        return this.toString();
                    }
                    throw new JSONException("illegal getter");
                }
            }
            Object object2 = this.map.get(string);
            return TypeUtils.cast(object2, method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        }
        throw new UnsupportedOperationException(method.toGenericString());
    }

    public Map<String, Object> getInnerMap() {
        return this.map;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SecureObjectInputStream.ensureFields();
        if (SecureObjectInputStream.fields != null && !SecureObjectInputStream.fields_error) {
            SecureObjectInputStream secureObjectInputStream = new SecureObjectInputStream(objectInputStream);
            try {
                secureObjectInputStream.defaultReadObject();
                return;
            }
            catch (NotActiveException notActiveException) {
                // empty catch block
            }
        }
        objectInputStream.defaultReadObject();
        for (Map.Entry entry : this.map.entrySet()) {
            Object v;
            Object k = entry.getKey();
            if (k != null) {
                ParserConfig.global.checkAutoType(k.getClass());
            }
            if ((v = entry.getValue()) == null) continue;
            ParserConfig.global.checkAutoType(v.getClass());
        }
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz == Map.class || clazz == JSONObject.class || clazz == JSON.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(Class<T> clazz, ParserConfig parserConfig, int n) {
        if (clazz == Map.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, parserConfig);
    }

    static class SecureObjectInputStream
    extends ObjectInputStream {
        static Field[] fields;
        static volatile boolean fields_error;

        static void ensureFields() {
            if (fields == null && !fields_error) {
                try {
                    Field[] fieldArray = ObjectInputStream.class.getDeclaredFields();
                    String[] stringArray = new String[]{"bin", "passHandle", "handles", "curContext"};
                    Field[] fieldArray2 = new Field[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        Field field = TypeUtils.getField(ObjectInputStream.class, stringArray[i], fieldArray);
                        field.setAccessible(true);
                        fieldArray2[i] = field;
                    }
                    fields = fieldArray2;
                }
                catch (Throwable throwable) {
                    fields_error = true;
                }
            }
        }

        public SecureObjectInputStream(ObjectInputStream objectInputStream) throws IOException {
            super(objectInputStream);
            try {
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    Object object = field.get(objectInputStream);
                    field.set(this, object);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                fields_error = true;
            }
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String string = objectStreamClass.getName();
            if (string.length() > 2) {
                int n = string.lastIndexOf(91);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                if (string.length() > 2 && string.charAt(0) == 'L' && string.charAt(string.length() - 1) == ';') {
                    string = string.substring(1, string.length() - 1);
                }
                ParserConfig.global.checkAutoType(string, null, Feature.SupportAutoType.mask);
            }
            return super.resolveClass(objectStreamClass);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
            for (String string : stringArray) {
                ParserConfig.global.checkAutoType(string, null);
            }
            return super.resolveProxyClass(stringArray);
        }

        @Override
        protected void readStreamHeader() throws IOException, StreamCorruptedException {
        }
    }
}

