/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.internal.util.fastjson;

import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONStreamContext;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

public class JSONWriter
implements Closeable,
Flushable {
    private SerializeWriter writer;
    private JSONSerializer serializer;
    private JSONStreamContext context;

    public JSONWriter(Writer writer) {
        this.writer = new SerializeWriter(writer);
        this.serializer = new JSONSerializer(this.writer);
    }

    public void config(SerializerFeature serializerFeature, boolean bl) {
        this.writer.config(serializerFeature, bl);
    }

    public void startObject() {
        if (this.context != null) {
            this.beginStructure();
        }
        this.context = new JSONStreamContext(this.context, 1001);
        this.writer.write(123);
    }

    public void endObject() {
        this.writer.write(125);
        this.endStructure();
    }

    public void writeKey(String string) {
        this.writeObject(string);
    }

    public void writeValue(Object object) {
        this.writeObject(object);
    }

    public void writeObject(String string) {
        this.beforeWrite();
        this.serializer.write(string);
        this.afterWriter();
    }

    public void writeObject(Object object) {
        this.beforeWrite();
        this.serializer.write(object);
        this.afterWriter();
    }

    public void startArray() {
        if (this.context != null) {
            this.beginStructure();
        }
        this.context = new JSONStreamContext(this.context, 1004);
        this.writer.write(91);
    }

    private void beginStructure() {
        int n = this.context.state;
        switch (this.context.state) {
            case 1002: {
                this.writer.write(58);
                break;
            }
            case 1005: {
                this.writer.write(44);
                break;
            }
            case 1001: {
                break;
            }
            case 1004: {
                break;
            }
            default: {
                throw new JSONException("illegal state : " + n);
            }
        }
    }

    public void endArray() {
        this.writer.write(93);
        this.endStructure();
    }

    private void endStructure() {
        this.context = this.context.parent;
        if (this.context == null) {
            return;
        }
        int n = -1;
        switch (this.context.state) {
            case 1002: {
                n = 1003;
                break;
            }
            case 1004: {
                n = 1005;
                break;
            }
            case 1005: {
                break;
            }
            case 1001: {
                n = 1002;
                break;
            }
        }
        if (n != -1) {
            this.context.state = n;
        }
    }

    private void beforeWrite() {
        if (this.context == null) {
            return;
        }
        switch (this.context.state) {
            case 1001: 
            case 1004: {
                break;
            }
            case 1002: {
                this.writer.write(58);
                break;
            }
            case 1003: {
                this.writer.write(44);
                break;
            }
            case 1005: {
                this.writer.write(44);
                break;
            }
        }
    }

    private void afterWriter() {
        if (this.context == null) {
            return;
        }
        int n = this.context.state;
        int n2 = -1;
        switch (n) {
            case 1002: {
                n2 = 1003;
                break;
            }
            case 1001: 
            case 1003: {
                n2 = 1002;
                break;
            }
            case 1004: {
                n2 = 1005;
                break;
            }
            case 1005: {
                break;
            }
        }
        if (n2 != -1) {
            this.context.state = n2;
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Deprecated
    public void writeStartObject() {
        this.startObject();
    }

    @Deprecated
    public void writeEndObject() {
        this.endObject();
    }

    @Deprecated
    public void writeStartArray() {
        this.startArray();
    }

    @Deprecated
    public void writeEndArray() {
        this.endArray();
    }
}

