/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.utils;

import com.icbc.api.internal.util.StringUtils;
import com.icbc.api.utils.IcbcHashMap;
import com.icbc.api.utils.WebUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpRequestParamsUtils {
    private static final List<String> apiParamNames = new ArrayList<String>();

    public static IcbcHashMap parseParams(HttpServletRequest httpServletRequest) throws IOException {
        String string;
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        if (httpServletRequest.getMethod().equals("POST") && !StringUtils.isEmpty(string = HttpRequestParamsUtils.getRequestBodyString(httpServletRequest))) {
            icbcHashMap.putAll(HttpRequestParamsUtils.parseParams(string));
        }
        if (!StringUtils.isEmpty(string = httpServletRequest.getQueryString())) {
            icbcHashMap.putAll(HttpRequestParamsUtils.parseParams(string));
        }
        return icbcHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRequestBodyString(HttpServletRequest httpServletRequest) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)servletInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            servletInputStream.close();
            inputStreamReader.close();
            bufferedReader.close();
        }
    }

    public static String parseReqPath(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getContextPath();
        String string2 = httpServletRequest.getServletPath();
        string = string == null ? "" : string;
        string = string.endsWith("/") ? string.substring(0, string.length()) : string;
        return string + string2;
    }

    public static String getRequestStrToSign(String string, IcbcHashMap icbcHashMap) {
        HashMap<String, String> hashMap = new HashMap<String, String>(icbcHashMap);
        hashMap.remove("sign");
        return WebUtils.buildOrderedSignStr(string, hashMap);
    }

    public static Map<String, String> parseParams(String string) throws IOException {
        Map<String, String> map = HttpRequestParamsUtils.parseRawParams(string);
        String string2 = map.get("charset");
        string2 = string2 == null ? "UTF-8" : string2;
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            icbcHashMap.put(entry.getKey(), URLDecoder.decode(entry.getValue(), string2));
        }
        return icbcHashMap;
    }

    public static Map<String, String> parseRawParams(String string) {
        String[] stringArray = string.split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            int n = string2.indexOf(61);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public static boolean isApiParam(String string) {
        return apiParamNames.contains(string);
    }

    static {
        apiParamNames.add("sign");
        apiParamNames.add("app_id");
        apiParamNames.add("sign_type");
        apiParamNames.add("charset");
        apiParamNames.add("format");
        apiParamNames.add("encrypt_type");
        apiParamNames.add("timestamp");
        apiParamNames.add("msg_id");
        apiParamNames.add("origin_app_id");
        apiParamNames.add("api_id");
        apiParamNames.add("api_trace_id");
    }
}

