/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.utils;

import com.icbc.api.IcbcApiException;
import com.icbc.api.crypt.IcbcCa;
import com.icbc.api.crypt.RSA;
import com.icbc.bcprov.org.bouncycastle.util.encoders.Base64;
import com.icbc.hsm.software.apiLib.Signature;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.external.ClearKeyFunction;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IcbcSignature {
    private static final Log logger = LogFactory.getLog(IcbcSignature.class);

    public static String sign(String string, String string2, String string3, String string4) throws IcbcApiException {
        return IcbcSignature.sign(string, string2, string3, string4, null);
    }

    public static String sign(String string, String string2, String string3, String string4, String string5) throws IcbcApiException {
        try {
            byte[] byArray = string.getBytes(string4);
            if (string2.equals("CA")) {
                return IcbcCa.sign(byArray, string3, string5);
            }
            if (string2.equals("RSA")) {
                return RSA.sign(byArray, com.icbc.api.internal.util.codec.Base64.decodeBase64(string3), "SHA1WithRSA");
            }
            if (string2.equals("RSA2")) {
                return RSA.sign(byArray, com.icbc.api.internal.util.codec.Base64.decodeBase64(string3), "SHA256WithRSA");
            }
            if (string2.equals("SM2") || string2.equals("CA-SM-TP") || string2.equals("CA-SM-ICBC")) {
                ClearKeyParameter clearKeyParameter = ClearKeyFunction.loadClear((String)string3, (String)"SM2private");
                byte[] byArray2 = string.getBytes(string4);
                Signature signature = Signature.getInstance((String)"SM3WITHSM2");
                byte[] byArray3 = signature.sign((HsmKeyParameter)clearKeyParameter, byArray2);
                return com.icbc.hsm.utils.encoders.Base64.toBase64String((byte[])byArray3);
            }
            logger.error((Object)"not support signType.");
            throw new IcbcApiException("not support signType.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)("get content charset exception. content: " + string + " charset: " + string4), (Throwable)unsupportedEncodingException);
            throw new IcbcApiException("get content charset exception. content: " + string + " charset: " + string4, unsupportedEncodingException);
        }
        catch (Exception exception) {
            logger.error((Object)"sign exception, please check the privateKey and signType are correct.", (Throwable)exception);
            throw new IcbcApiException("sign exception, please check the privateKey and signType are correct.", exception);
        }
    }

    public static boolean verify(String string, String string2, String string3, String string4, String string5, String string6) throws IcbcApiException {
        try {
            byte[] byArray = string.getBytes(string4);
            if (string2.equals("CA")) {
                return IcbcCa.verify(byArray, string3, string5);
            }
            if (string2.equals("RSA")) {
                return RSA.verify(byArray, com.icbc.api.internal.util.codec.Base64.decodeBase64(string3), string5, "SHA1WithRSA");
            }
            if (string2.equals("RSA2")) {
                return RSA.verify(byArray, com.icbc.api.internal.util.codec.Base64.decodeBase64(string3), string5, "SHA256WithRSA");
            }
            if (string2.equals("SM2")) {
                byte[] byArray2 = com.icbc.hsm.utils.encoders.Base64.decode((String)string5);
                ClearKeyParameter clearKeyParameter = ClearKeyFunction.loadClear((String)string3, (String)"SM2public");
                Signature signature = Signature.getInstance((String)"SM3WITHSM2");
                return signature.verify((HsmKeyParameter)clearKeyParameter, string.getBytes(string4), byArray2);
            }
            if (string2.equals("CA-SM-ICBC") || string2.equals("CA-SM-TP")) {
                Signature signature = Signature.getInstance((String)"SM3withSM2");
                if (string6 == null || "".equals(string6)) {
                    throw new IcbcApiException("ICBC Certificate configuration should be set when sign type is CA-SM-ICBC or CA-SM-TP.");
                }
                byte[] byArray3 = com.icbc.hsm.utils.encoders.Base64.decode((String)string6);
                byte[] byArray4 = com.icbc.hsm.utils.encoders.Base64.decode((String)string5);
                return signature.verifyWithCert(byArray3, byArray, byArray4);
            }
            logger.error((Object)"not support signType.");
            throw new IcbcApiException("not support signType.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)("get content charset exception. content: " + string + " charset: " + string4), (Throwable)unsupportedEncodingException);
            throw new IcbcApiException("get content charset exception. content: " + string + " charset: " + string4, unsupportedEncodingException);
        }
        catch (Exception exception) {
            logger.error((Object)"sign verify exception.", (Throwable)exception);
            throw new IcbcApiException("sign verify exception.", exception);
        }
    }

    public static boolean verify(String string, String string2, String string3, String string4, String string5) throws IcbcApiException {
        return IcbcSignature.verify(string, string2, string3, string4, string5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCAInfoStr(String string) {
        File file = null;
        FileInputStream fileInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            file = new File(string);
            fileInputStream = new FileInputStream(file);
            filterInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[(int)file.length()];
            ((DataInputStream)filterInputStream).read(byArray);
            if (IcbcSignature.isStringModeCert(byArray)) {
                String string2 = IcbcSignature.getStringModeCertInfo(byArray);
                return string2;
            }
            String string3 = new String(Base64.encode((byte[])byArray));
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                fileInputStream.close();
                filterInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private static boolean isStringModeCert(byte[] byArray) {
        String string = new String(byArray);
        return string != null && string.contains("-----BEGIN CERTIFICATE-----");
    }

    private static String getStringModeCertInfo(byte[] byArray) {
        String string = new String(byArray);
        return string.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replace("\n", "").replace("\r", "");
    }
}

