/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class StreamUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static void io(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtil.io(inputStream, outputStream, -1);
    }

    public static void io(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (n == -1) {
            n = 8192;
        }
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void io(Reader reader, Writer writer) throws IOException {
        StreamUtil.io(reader, writer, -1);
    }

    public static void io(Reader reader, Writer writer, int n) throws IOException {
        int n2;
        if (n == -1) {
            n = 4096;
        }
        char[] cArray = new char[n];
        while ((n2 = reader.read(cArray)) >= 0) {
            writer.write(cArray, 0, n2);
        }
    }

    public static OutputStream synchronizedOutputStream(OutputStream outputStream) {
        return new SynchronizedOutputStream(outputStream);
    }

    public static OutputStream synchronizedOutputStream(OutputStream outputStream, Object object) {
        return new SynchronizedOutputStream(outputStream, object);
    }

    public static String readText(InputStream inputStream) throws IOException {
        return StreamUtil.readText(inputStream, null, -1);
    }

    public static String readText(InputStream inputStream, String string) throws IOException {
        return StreamUtil.readText(inputStream, string, -1);
    }

    public static String readText(InputStream inputStream, String string, int n) throws IOException {
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        return StreamUtil.readText(inputStreamReader, n);
    }

    public static String readText(Reader reader) throws IOException {
        return StreamUtil.readText(reader, -1);
    }

    public static String readText(Reader reader, int n) throws IOException {
        StringWriter stringWriter = new StringWriter();
        StreamUtil.io(reader, stringWriter, n);
        return stringWriter.toString();
    }

    private static class SynchronizedOutputStream
    extends OutputStream {
        private OutputStream out;
        private Object lock;

        SynchronizedOutputStream(OutputStream outputStream) {
            this(outputStream, outputStream);
        }

        SynchronizedOutputStream(OutputStream outputStream, Object object) {
            this.out = outputStream;
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int n) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(byArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.write(byArray, n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.out.close();
            }
        }
    }
}

