/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cms;

import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSReadable;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSTypedData;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSProcessableFile
implements CMSTypedData,
CMSReadable {
    private static final int DEFAULT_BUF_SIZE = 32768;
    private final ASN1ObjectIdentifier type;
    private final File file;
    private final byte[] buf;

    public CMSProcessableFile(File file) {
        this(file, 32768);
    }

    public CMSProcessableFile(File file, int n) {
        this(CMSObjectIdentifiers.data, file, n);
    }

    public CMSProcessableFile(ASN1ObjectIdentifier aSN1ObjectIdentifier, File file, int n) {
        this.type = aSN1ObjectIdentifier;
        this.file = file;
        this.buf = new byte[n];
    }

    @Override
    public InputStream getInputStream() throws IOException, CMSException {
        return new BufferedInputStream(new FileInputStream(this.file), 32768);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, CMSException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        while ((n = fileInputStream.read(this.buf, 0, this.buf.length)) > 0) {
            outputStream.write(this.buf, 0, n);
        }
        fileInputStream.close();
    }

    @Override
    public Object getContent() {
        return this.file;
    }

    @Override
    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

