/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.asn1;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Encodable;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1ParsingException;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1StreamParser;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1TaggedObjectParser;
import java.io.IOException;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private boolean _constructed;
    private int _tagNumber;
    private ASN1StreamParser _parser;

    BERTaggedObjectParser(boolean bl, int n, ASN1StreamParser aSN1StreamParser) {
        this._constructed = bl;
        this._tagNumber = n;
        this._parser = aSN1StreamParser;
    }

    public boolean isConstructed() {
        return this._constructed;
    }

    @Override
    public int getTagNo() {
        return this._tagNumber;
    }

    @Override
    public ASN1Encodable getObjectParser(int n, boolean bl) throws IOException {
        if (bl) {
            if (!this._constructed) {
                throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
            }
            return this._parser.readObject();
        }
        return this._parser.readImplicit(this._constructed, n);
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        return this._parser.readTaggedObject(this._constructed, this._tagNumber);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException(iOException.getMessage());
        }
    }
}

