/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.edec;

import com.icbc.bcprov.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import com.icbc.bcprov.org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import com.icbc.bcprov.org.bouncycastle.jcajce.spec.XDHParameterSpec;
import com.icbc.bcprov.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;

public class KeyPairGeneratorSpi
extends java.security.KeyPairGeneratorSpi {
    private static final int EdDSA = -1;
    private static final int XDH = -2;
    private static final int Ed448 = 0;
    private static final int Ed25519 = 1;
    private static final int X448 = 2;
    private static final int X25519 = 3;
    private int algorithm;
    private AsymmetricCipherKeyPairGenerator generator;
    private boolean initialised;
    private SecureRandom secureRandom;

    KeyPairGeneratorSpi(int n, AsymmetricCipherKeyPairGenerator asymmetricCipherKeyPairGenerator) {
        this.algorithm = n;
        this.generator = asymmetricCipherKeyPairGenerator;
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        block0 : switch (n) {
            case 255: 
            case 256: {
                switch (this.algorithm) {
                    case -1: 
                    case 1: {
                        this.setupGenerator(1);
                        break block0;
                    }
                    case -2: 
                    case 3: {
                        this.setupGenerator(3);
                        break block0;
                    }
                }
                throw new InvalidParameterException("key size not configurable");
            }
            case 448: {
                switch (this.algorithm) {
                    case -1: 
                    case 0: {
                        this.setupGenerator(0);
                        break block0;
                    }
                    case -2: 
                    case 2: {
                        this.setupGenerator(2);
                        break block0;
                    }
                }
                throw new InvalidParameterException("key size not configurable");
            }
            default: {
                throw new InvalidParameterException("unknown key size");
            }
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.secureRandom = secureRandom;
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            this.initializeGenerator(((ECGenParameterSpec)algorithmParameterSpec).getName());
        } else if (algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            this.initializeGenerator(((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName());
        } else if (algorithmParameterSpec instanceof EdDSAParameterSpec) {
            this.initializeGenerator(((EdDSAParameterSpec)algorithmParameterSpec).getCurveName());
        } else if (algorithmParameterSpec instanceof XDHParameterSpec) {
            this.initializeGenerator(((XDHParameterSpec)algorithmParameterSpec).getCurveName());
        } else {
            throw new InvalidAlgorithmParameterException("invalid parameterSpec: " + algorithmParameterSpec);
        }
    }

    private void algorithmCheck(int n) throws InvalidAlgorithmParameterException {
        if (this.algorithm != n) {
            if (this.algorithm == 1 || this.algorithm == 0) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == -1 && n != 1 && n != 0) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == 3 || this.algorithm == 2) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == -2 && n != 3 && n != 2) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            this.algorithm = n;
        }
    }

    private void initializeGenerator(String string) throws InvalidAlgorithmParameterException {
        if (string.equalsIgnoreCase("Ed448") || string.equals(EdECObjectIdentifiers.id_Ed448.getId())) {
            this.algorithmCheck(0);
            this.generator = new Ed448KeyPairGenerator();
            this.setupGenerator(0);
        } else if (string.equalsIgnoreCase("Ed25519") || string.equals(EdECObjectIdentifiers.id_Ed25519.getId())) {
            this.algorithmCheck(1);
            this.generator = new Ed25519KeyPairGenerator();
            this.setupGenerator(1);
        } else if (string.equalsIgnoreCase("X448") || string.equals(EdECObjectIdentifiers.id_X448.getId())) {
            this.algorithmCheck(2);
            this.generator = new X448KeyPairGenerator();
            this.setupGenerator(2);
        } else if (string.equalsIgnoreCase("X25519") || string.equals(EdECObjectIdentifiers.id_X25519.getId())) {
            this.algorithmCheck(3);
            this.generator = new X25519KeyPairGenerator();
            this.setupGenerator(3);
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.generator == null) {
            throw new IllegalStateException("generator not correctly initialized");
        }
        if (!this.initialised) {
            this.setupGenerator(this.algorithm);
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.generator.generateKeyPair();
        switch (this.algorithm) {
            case 0: {
                return new KeyPair(new BCEdDSAPublicKey(asymmetricCipherKeyPair.getPublic()), new BCEdDSAPrivateKey(asymmetricCipherKeyPair.getPrivate()));
            }
            case 1: {
                return new KeyPair(new BCEdDSAPublicKey(asymmetricCipherKeyPair.getPublic()), new BCEdDSAPrivateKey(asymmetricCipherKeyPair.getPrivate()));
            }
            case 2: {
                return new KeyPair(new BCXDHPublicKey(asymmetricCipherKeyPair.getPublic()), new BCXDHPrivateKey(asymmetricCipherKeyPair.getPrivate()));
            }
            case 3: {
                return new KeyPair(new BCXDHPublicKey(asymmetricCipherKeyPair.getPublic()), new BCXDHPrivateKey(asymmetricCipherKeyPair.getPrivate()));
            }
        }
        throw new IllegalStateException("generator not correctly initialized");
    }

    private void setupGenerator(int n) {
        this.initialised = true;
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        switch (n) {
            case 0: {
                this.generator.init(new Ed448KeyGenerationParameters(this.secureRandom));
                break;
            }
            case -1: 
            case 1: {
                this.generator.init(new Ed25519KeyGenerationParameters(this.secureRandom));
                break;
            }
            case 2: {
                this.generator.init(new X448KeyGenerationParameters(this.secureRandom));
                break;
            }
            case -2: 
            case 3: {
                this.generator.init(new X25519KeyGenerationParameters(this.secureRandom));
            }
        }
    }

    public static final class X25519
    extends KeyPairGeneratorSpi {
        public X25519() {
            super(3, new X25519KeyPairGenerator());
        }
    }

    public static final class X448
    extends KeyPairGeneratorSpi {
        public X448() {
            super(2, new X448KeyPairGenerator());
        }
    }

    public static final class XDH
    extends KeyPairGeneratorSpi {
        public XDH() {
            super(-2, null);
        }
    }

    public static final class Ed25519
    extends KeyPairGeneratorSpi {
        public Ed25519() {
            super(1, new Ed25519KeyPairGenerator());
        }
    }

    public static final class Ed448
    extends KeyPairGeneratorSpi {
        public Ed448() {
            super(0, new Ed448KeyPairGenerator());
        }
    }

    public static final class EdDSA
    extends KeyPairGeneratorSpi {
        public EdDSA() {
            super(-1, null);
        }
    }
}

