/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric;

import com.icbc.bcprov.org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherKeyGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.BlowfishEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.macs.CMac;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Blowfish {
    private Blowfish() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Blowfish.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Mac.BLOWFISHCMAC", PREFIX + "$CMAC");
            configurableProvider.addAlgorithm("Cipher.BLOWFISH", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, PREFIX + "$CBC");
            configurableProvider.addAlgorithm("KeyGenerator.BLOWFISH", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
            configurableProvider.addAlgorithm("AlgorithmParameters.BLOWFISH", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Blowfish IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Blowfish", 128, new CipherKeyGenerator());
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new BlowfishEngine()));
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new BlowfishEngine()), 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlowfishEngine());
        }
    }
}

