/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import com.icbc.hsm.software.basic.AsymmetricCipher;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.basic.PBEkeyGenerate;
import com.icbc.hsm.software.basic.Rules;
import com.icbc.hsm.software.basic.SymmetricCipher;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.software.parms.icbc.TempKeyBuilder;
import com.icbc.hsm.utils.Util;
import com.icbc.hsm.utils.encoders.Base64;
import com.icbc.hsm.utils.encoders.Hex;
import java.security.SecureRandom;

public class Pinblock {
    private static final String apiName = "pin";
    private String pinAlgorithm = null;

    private Pinblock(String string) {
        this.pinAlgorithm = string;
    }

    public static Pinblock getInstance() {
        Pinblock pinblock = new Pinblock("ICBC");
        return pinblock;
    }

    public static Pinblock getInstance(String string) {
        Pinblock pinblock = new Pinblock(string);
        return pinblock;
    }

    String encipherPin(String string, String string2, String string3) throws Exception {
        String string4 = null;
        string4 = string3 != null && string3.length() == 12 ? string3 : string3.substring(string3.length() - 1 - 12, string3.length() - 1);
        byte[] byArray = Pinblock.buildCUPPinblock(string2, string4);
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray2 = new byte[20];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = new byte[32];
        secureRandom.nextBytes(byArray3);
        byte[] byArray4 = PBEkeyGenerate.generatePBEKey("PBKDF2", "SM3", null, 16, byArray2, byArray3, 16);
        ClearKeyParameter clearKeyParameter = null;
        clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"SM4", (boolean)false, (byte[])byArray4) : ClearKeyParameter.getInstance("SM4", false, byArray4);
        ClearKeyParameter clearKeyParameter2 = null;
        clearKeyParameter2 = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"SM2", (boolean)false, (byte[])Hex.decode(string)) : ClearKeyParameter.getInstance("SM2", false, Hex.decode(string));
        byte[] byArray5 = AsymmetricCipher.encipher("SM2", true, clearKeyParameter2, byArray4);
        Arrays.fill(byArray4, (byte)0);
        byte[] byArray6 = SymmetricCipher.blockCipher("SM4", "ECB", "NOPadding", true, clearKeyParameter, null, byArray);
        Arrays.fill(byArray, (byte)0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SM2#");
        stringBuilder.append(Base64.toBase64String(Hex.decode(string))).append("#");
        stringBuilder.append(Base64.toBase64String(byArray5)).append("#");
        stringBuilder.append(Hex.toHexString(byArray6)).append("#");
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    public String encipherPin(HsmKeyParameter hsmKeyParameter, String string, String string2) throws Exception {
        String string3 = null;
        if ("ISO".equalsIgnoreCase(this.pinAlgorithm)) {
            string3 = "DES";
        } else if ("CUP".equalsIgnoreCase(this.pinAlgorithm)) {
            string3 = "SM4";
        } else if ("ICBC".equalsIgnoreCase(this.pinAlgorithm)) {
            string3 = "SM4";
        }
        if (IcbcEnvironment.isICBCEnvironment() && hsmKeyParameter instanceof IcbcAsymmetricKeyParameter) {
            IcbcAsymmetricKeyParameter icbcAsymmetricKeyParameter = (IcbcAsymmetricKeyParameter)hsmKeyParameter;
            if ("SM2public".equalsIgnoreCase(icbcAsymmetricKeyParameter.getKeyType())) {
                String string4 = icbcAsymmetricKeyParameter.getPublicKey();
                return this.encipherPin(string4, string, string2);
            }
            throw new ParmErrorException("key type error!");
        }
        if (hsmKeyParameter instanceof ClearKeyParameter) {
            ClearKeyParameter clearKeyParameter = (ClearKeyParameter)hsmKeyParameter;
            if ("SM2public".equalsIgnoreCase(clearKeyParameter.getKeyType())) {
                String string5 = clearKeyParameter.getPublicKey();
                return this.encipherPin(string5, string, string2);
            }
            throw new ParmErrorException("key type error!");
        }
        if (!Rules.parmCheck(string3, hsmKeyParameter, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        String string6 = hsmKeyParameter.getAlgorithm();
        byte[] byArray = null;
        byte[] byArray2 = null;
        if ("SM4".equalsIgnoreCase(string6)) {
            byArray = Pinblock.buildCUPPinblock(string, string2);
            byArray2 = SymmetricCipher.blockCipher("SM4", "ECB", "NOPadding", true, hsmKeyParameter, null, byArray);
            Arrays.fill(byArray, (byte)0);
        } else if ("DESede".equalsIgnoreCase(string6)) {
            byArray = Pinblock.buildISOPinblock(string, string2);
            byArray2 = SymmetricCipher.blockCipher("DESede", "ECB", "NOPadding", true, hsmKeyParameter, null, byArray);
            Arrays.fill(byArray, (byte)0);
        } else if ("DES".equalsIgnoreCase(string6)) {
            byArray = Pinblock.buildISOPinblock(string, string2);
            byArray2 = SymmetricCipher.blockCipher("DES", "ECB", "NOPadding", true, hsmKeyParameter, null, byArray);
            Arrays.fill(byArray, (byte)0);
        }
        return Hex.toHexString(byArray2);
    }

    public String translatePin(HsmKeyParameter hsmKeyParameter, HsmKeyParameter hsmKeyParameter2, String string, String string2) throws Exception {
        String string3 = null;
        String string4 = null;
        if (string == null) {
            throw new ParmErrorException("pinblock error!");
        }
        if (string.length() == 16) {
            string4 = "DESede";
        } else if (string.length() == 32) {
            string4 = "SM4";
        } else {
            throw new ParmErrorException("pinblock error!");
        }
        if (!Rules.parmCheck(string4, hsmKeyParameter, apiName)) {
            throw new ParmErrorException("key type error!");
        }
        byte[] byArray = null;
        String string5 = null;
        if ("SM4".equalsIgnoreCase(string4)) {
            byArray = SymmetricCipher.blockCipher("SM4", "ECB", "NOPadding", false, hsmKeyParameter, null, Hex.decode(string));
            string5 = Pinblock.extractCUPPinblock(byArray, string2);
        } else if ("DESede".equalsIgnoreCase(string4)) {
            byArray = SymmetricCipher.blockCipher("DESede", "ECB", "NOPadding", false, hsmKeyParameter, null, Hex.decode(string));
            string5 = Pinblock.extractISOPinblock(byArray, string2);
        } else if ("DES".equalsIgnoreCase(string4)) {
            byArray = SymmetricCipher.blockCipher("DES", "ECB", "NOPadding", false, hsmKeyParameter, null, Hex.decode(string));
            string5 = Pinblock.extractISOPinblock(byArray, string2);
        }
        string3 = this.encipherPin(hsmKeyParameter2, string5, string2);
        return string3;
    }

    private static byte[] buildCUPPinblock(String string, String string2) throws Exception {
        if (string == null || !string.matches("\\p{Digit}{4,12}")) {
            throw new Exception("pin error!");
        }
        if (string2 != null && !string2.matches("\\p{Digit}+")) {
            throw new Exception("pan error!");
        }
        String string3 = ("0" + String.format("%1$01X", string.length()) + string + "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF").substring(0, 32);
        String string4 = null;
        if (string2 == null) {
            string4 = "00000000000000000000000000000000";
        } else if (string2.length() == 12) {
            string4 = "0000" + "0000000000000000" + string2;
        } else if (string2.length() > 12) {
            string2 = string2.substring(string2.length() - 1 - 12, string2.length() - 1);
            string4 = "0000" + "0000000000000000" + string2;
        } else {
            throw new Exception("pan data error!");
        }
        byte[] byArray = Util.Xor(Hex.decode(string3), Hex.decode(string4));
        return byArray;
    }

    private static String extractCUPPinblock(byte[] byArray, String string) throws Exception {
        if (byArray == null || byArray.length != 16) {
            throw new Exception("pinblock error!");
        }
        if (string != null && !string.matches("\\p{Digit}+")) {
            throw new Exception("pan error!");
        }
        String string2 = null;
        if (string == null) {
            string2 = "00000000000000000000000000000000";
        } else if (string.length() == 12) {
            string2 = "0000" + "0000000000000000" + string;
        } else if (string.length() > 12) {
            string = string.substring(string.length() - 1 - 12, string.length() - 1);
            string2 = "0000" + "0000000000000000" + string;
        } else {
            throw new Exception("pan data error!");
        }
        byte[] byArray2 = Util.Xor(byArray, Hex.decode(string2));
        String string3 = Hex.toHexString(byArray2);
        int n = Integer.parseInt(string3.substring(0, 2));
        if (n > 12 || n < 4) {
            throw new Exception("pin length error");
        }
        String string4 = string3.substring(n + 2).toUpperCase();
        if (!string4.matches("F+")) {
            throw new Exception("pinblock format error");
        }
        String string5 = string3.substring(2, 2 + n);
        return string5;
    }

    private static byte[] buildISOPinblock(String string, String string2) throws Exception {
        if (string == null || !string.matches("\\p{Digit}{4,12}")) {
            throw new Exception("pin error!");
        }
        if (string2 == null || !string2.matches("\\p{Digit}{12,}")) {
            throw new Exception("pan error!");
        }
        String string3 = ("0" + String.format("%1$01X", string.length()) + string + "FFFFFFFFFF").substring(0, 16);
        String string4 = null;
        if (string2.length() == 12) {
            string4 = "0000" + string2;
        } else if (string2.length() > 12) {
            string2 = string2.substring(string2.length() - 1 - 12, string2.length() - 1);
            string4 = "0000" + string2;
        }
        byte[] byArray = Util.Xor(Hex.decode(string3), Hex.decode(string4));
        return byArray;
    }

    private static String extractISOPinblock(byte[] byArray, String string) throws Exception {
        if (byArray == null || byArray.length != 8) {
            throw new Exception("pinblock error!");
        }
        if (string != null && !string.matches("\\p{Digit}+")) {
            throw new Exception("pan error!");
        }
        String string2 = null;
        if (string.length() == 12) {
            string2 = "0000" + string;
        } else if (string.length() > 12) {
            string = string.substring(string.length() - 1 - 12, string.length() - 1);
            string2 = "0000" + string;
        } else {
            throw new Exception("pan data error!");
        }
        byte[] byArray2 = Util.Xor(byArray, Hex.decode(string2));
        String string3 = Hex.toHexString(byArray2);
        int n = Integer.parseInt(string3.substring(0, 2));
        if (n > 12 || n < 4) {
            throw new Exception("pin length error");
        }
        String string4 = string3.substring(n + 2).toUpperCase();
        if (!string4.matches("F*")) {
            throw new Exception("pinblock format error");
        }
        String string5 = string3.substring(2, 2 + n);
        return string5;
    }
}

