/*
 * Decompiled with CFR 0.152.
 */
package cfca.asn1.parser;

import cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.org.bouncycastle.crypto.BlockCipher;
import cfca.org.bouncycastle.crypto.CipherParameters;
import cfca.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GlobalVariable;
import java.io.File;
import java.io.FileInputStream;

public class BigFileEncrypt {
    public static void bigFileBlockEncrypt(byte[] key, BlockCipher engine, CBCParam param, File f, ASN1OutputStream out) throws Exception {
        FileInputStream fis = null;
        try {
            CipherParameters params;
            PaddedBufferedBlockCipher cipher = null;
            if (param == null) {
                cipher = new PaddedBufferedBlockCipher(engine, new PKCS7Padding());
                params = new KeyParameter(key);
                cipher.init(true, params);
            } else {
                cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
                params = new ParametersWithIV(new KeyParameter(key), param.getIv());
                cipher.init(true, params);
            }
            int readLen = 0;
            byte[] buffer = new byte[GlobalVariable.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER + 100];
            long readTotalLen = 0L;
            long fileLen = f.length();
            int processLen = 0;
            fis = new FileInputStream(f);
            while ((readLen = fis.read(buffer)) > 0) {
                if (readLen == GlobalVariable.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    out.write(outBytes, 0, processLen);
                    continue;
                }
                int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                int len2 = cipher.doFinal(outBytes, len1);
                out.write(outBytes, 0, len1 + len2);
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void bigFileRC4Encrypt(byte[] key, File f, ASN1OutputStream out) throws Exception {
        FileInputStream fis = null;
        try {
            RC4Engine rc4 = new RC4Engine();
            KeyParameter param = new KeyParameter(key);
            rc4.init(true, param);
            int readLen = 0;
            byte[] buffer = new byte[GlobalVariable.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER];
            fis = new FileInputStream(f);
            while ((readLen = fis.read(buffer)) > 0) {
                rc4.processBytes(buffer, 0, readLen, outBytes, 0);
                out.write(outBytes, 0, readLen);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

