/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms;

import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import cfca.org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import cfca.org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import cfca.org.bouncycastle.asn1.cms.OriginatorPublicKey;
import cfca.org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import cfca.org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.cms.AuthAttributesProvider;
import cfca.org.bouncycastle.cms.CMSEnvelopedHelper;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.CMSSecureReadable;
import cfca.org.bouncycastle.cms.CMSTypedStream;
import cfca.org.bouncycastle.cms.CMSUtils;
import cfca.org.bouncycastle.cms.KeyAgreeRecipient;
import cfca.org.bouncycastle.cms.KeyAgreeRecipientId;
import cfca.org.bouncycastle.cms.OriginatorId;
import cfca.org.bouncycastle.cms.Recipient;
import cfca.org.bouncycastle.cms.RecipientId;
import cfca.org.bouncycastle.cms.RecipientInformation;
import cfca.org.bouncycastle.cms.RecipientOperator;
import cfca.org.bouncycastle.cms.jcajce.JceKeyAgreeAuthenticatedRecipient;
import cfca.org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import cfca.org.bouncycastle.cms.jcajce.JceKeyAgreeRecipient;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.List;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString encryptedKey;

    static void readRecipientInfo(List infos, KeyAgreeRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ASN1Sequence s = info.getRecipientEncryptedKeys();
        for (int i = 0; i < s.size(); ++i) {
            KeyAgreeRecipientId rid;
            RecipientEncryptedKey id = RecipientEncryptedKey.getInstance(s.getObjectAt(i));
            KeyAgreeRecipientIdentifier karid = id.getIdentifier();
            IssuerAndSerialNumber iAndSN = karid.getIssuerAndSerialNumber();
            if (iAndSN != null) {
                rid = new KeyAgreeRecipientId(iAndSN.getName(), iAndSN.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier rKeyID = karid.getRKeyID();
                rid = new KeyAgreeRecipientId(rKeyID.getSubjectKeyIdentifier().getOctets());
            }
            infos.add(new KeyAgreeRecipientInformation(info, rid, id.getEncryptedKey(), messageAlgorithm, secureReadable, additionalData));
        }
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo info, RecipientId rid, ASN1OctetString encryptedKey, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        this.rid = rid;
        this.encryptedKey = encryptedKey;
    }

    private SubjectPublicKeyInfo getSenderPublicKeyInfo(AlgorithmIdentifier recKeyAlgId, OriginatorIdentifierOrKey originator) throws CMSException, IOException {
        OriginatorId origID;
        OriginatorPublicKey opk = originator.getOriginatorKey();
        if (opk != null) {
            return this.getPublicKeyInfoFromOriginatorPublicKey(recKeyAlgId, opk);
        }
        IssuerAndSerialNumber iAndSN = originator.getIssuerAndSerialNumber();
        if (iAndSN != null) {
            origID = new OriginatorId(iAndSN.getName(), iAndSN.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier ski = originator.getSubjectKeyIdentifier();
            origID = new OriginatorId(ski.getKeyIdentifier());
        }
        return this.getPublicKeyInfoFromOriginatorId(origID);
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorPublicKey(AlgorithmIdentifier recKeyAlgId, OriginatorPublicKey originatorPublicKey) {
        SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(recKeyAlgId, originatorPublicKey.getPublicKey().getBytes());
        return pubInfo;
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorId(OriginatorId origID) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            JceKeyAgreeRecipient recipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKeyAgreeEnvelopedRecipient((PrivateKey)key) : new JceKeyAgreeAuthenticatedRecipient((PrivateKey)key);
            if (prov != null) {
                recipient.setProvider(prov);
                if (prov.getName().equalsIgnoreCase("SunJCE")) {
                    recipient.setContentProvider((String)null);
                }
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e) {
            throw new CMSException("encoding error: " + e.getMessage(), e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        KeyAgreeRecipient agreeRecipient = (KeyAgreeRecipient)recipient;
        AlgorithmIdentifier recKeyAlgId = agreeRecipient.getPrivateKeyAlgorithmIdentifier();
        return ((KeyAgreeRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.getSenderPublicKeyInfo(recKeyAlgId, this.info.getOriginator()), this.info.getUserKeyingMaterial(), this.encryptedKey.getOctets());
    }
}

