/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.crypto.tls;

import cfca.org.bouncycastle.crypto.BlockCipher;
import cfca.org.bouncycastle.crypto.Digest;
import cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA384Digest;
import cfca.org.bouncycastle.crypto.engines.AESFastEngine;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.tls.TlsBlockCipher;
import cfca.org.bouncycastle.crypto.tls.TlsCipher;
import cfca.org.bouncycastle.crypto.tls.TlsCipherFactory;
import cfca.org.bouncycastle.crypto.tls.TlsClientContext;
import cfca.org.bouncycastle.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class DefaultTlsCipherFactory
implements TlsCipherFactory {
    public TlsCipher createCipher(TlsClientContext context, int encryptionAlgorithm, int digestAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(context, 24, digestAlgorithm);
            }
            case 8: {
                return this.createAESCipher(context, 16, digestAlgorithm);
            }
            case 9: {
                return this.createAESCipher(context, 32, digestAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsCipher createAESCipher(TlsClientContext context, int cipherKeySize, int digestAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createDigest(digestAlgorithm), this.createDigest(digestAlgorithm), cipherKeySize);
    }

    protected TlsCipher createDESedeCipher(TlsClientContext context, int cipherKeySize, int digestAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createDigest(digestAlgorithm), this.createDigest(digestAlgorithm), cipherKeySize);
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected Digest createDigest(int digestAlgorithm) throws IOException {
        switch (digestAlgorithm) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

